clearvars 
close all
date_string = '20210807';

path_read = '.\data_raw\';
path_write = '.\data_temp\';
n_states = 49;
MA_window = 7;
gamma = 1/14;

fname_read = [path_read,'cases_states_',num2str(date_string),'.csv'];
data = readtable(fname_read);
T = size(data,1)/n_states;
date = data.date(1:T);
date = datetime(date,'InputFormat','ddMMMyyyy');


%%
Cmtx = reshape(data.C, T, n_states);
C_agg = sum(Cmtx,2);
Imtx = fn_est_IT(Cmtx,gamma);
I_agg = sum(Imtx,2);

pop_mtx = reshape(data.pop_state, T, n_states);
pop_agg = sum(pop_mtx(1,:),2);
pop_agg_mtx = repmat(pop_agg, T, 1);

ST_string = reshape(data.ST, T, n_states);
ST_string = ST_string(1,:);
state_string = reshape(data.state, T, n_states);
state_string = state_string(1,:);

colnames_Cmtx = cell(1,n_states);
colnames_Imtx = cell(1,n_states);
colnames_pop_mtx = cell(1,n_states);
for j = 1:n_states
    colnames_Cmtx(j) = cellstr(['C_', char(ST_string(j)),' cases in ', char(state_string(j))]);
    colnames_Imtx(j) = cellstr(['I_', char(ST_string(j)),' active cases in ', char(state_string(j))]);
    colnames_pop_mtx(j) = cellstr(['n_',char(ST_string(j)),' population in ', char(state_string(j))]);
end
colnames_Cagg = {'C_US49 cases in contiguous US'};
colnames_Iagg = {'I_US49 active cases in contiguous US'};
colnames_pop_agg = {'n_US49 population in contiguous US'};

colnames = ['date', colnames_Cmtx, colnames_Cagg, colnames_Imtx, colnames_Iagg, colnames_pop_mtx, colnames_pop_agg];

tab = table(date, Cmtx, C_agg, Imtx, I_agg, pop_mtx, pop_agg_mtx);
tab = splitvars(tab, 'Cmtx');
tab = splitvars(tab, 'Imtx');
tab = splitvars(tab, 'pop_mtx');
tab.Properties.VariableNames = colnames;

% fname_write_data = [path_write,'covid_US_states_',num2str(date_string),'.csv'];
% writetable(tab, fname_write_data,'WriteVariableNames',true)  % only for record, not used in estimation

%%
cmtx = Cmtx./pop_mtx;
imtx = Imtx./pop_mtx;
c_agg = C_agg./pop_agg;
i_agg = I_agg./pop_agg;

cmtx_MA = fn_MA(cmtx, MA_window);
imtx_MA = fn_MA(imtx, MA_window);
c_agg_MA = fn_MA(c_agg, MA_window);
i_agg_MA = fn_MA(i_agg, MA_window);

%% save mat file for estimation
fname_write_mat = [path_write,'cases_states_',num2str(date_string)];
save(fname_write_mat,'cmtx_MA','imtx_MA','c_agg_MA','i_agg_MA','ST_string');
