library(urca)
library(XLConnect)

# Loading the data

# setwd("put the path for the directory where you have the .xlsx files")

# COICOP unique sectors
wb.wnl <- loadWorkbook("sectors.xlsx")
sectors <- readWorksheet(wb.wnl, sheet = 1)
sectors <- sectors[[1]]

# Belgium
wb.be <- loadWorkbook("be.xlsx")
prices.be <- readWorksheet(wb.be, sheet = 1)
rownames(prices.be) <- prices.be$DATE
prices.be <- prices.be[,sectors]

wb.wbe <- loadWorkbook("wbe.xlsx")
weights.be <- readWorksheet(wb.wbe, sheet = 1)
rownames(weights.be) <- weights.be$YEAR
weights.be <- weights.be[,sectors]

# Deutschland
wb.de <- loadWorkbook("de.xlsx")
prices.de <- readWorksheet(wb.de, sheet = 1)
rownames(prices.de) <- prices.de$DATE
prices.de <- prices.de[,sectors]

wb.wde <- loadWorkbook("wde.xlsx")
weights.de <- readWorksheet(wb.wde, sheet = 1)
rownames(weights.de) <- weights.de$YEAR
weights.de <- weights.de[,sectors]

# France
wb.fr <- loadWorkbook("fr.xlsx")
prices.fr <- readWorksheet(wb.fr, sheet = 1)
rownames(prices.fr) <- prices.fr$DATE
prices.fr <- prices.fr[,sectors]

wb.wfr <- loadWorkbook("wfr.xlsx")
weights.fr <- readWorksheet(wb.wfr, sheet = 1)
rownames(weights.fr) <- weights.fr$YEAR
weights.fr <- weights.fr[,sectors]

# Luxemburg
wb.lu <- loadWorkbook("lu.xlsx")
prices.lu <- readWorksheet(wb.lu, sheet = 1)
rownames(prices.lu) <- prices.lu$DATE
prices.lu <- prices.lu[,sectors]

wb.wlu <- loadWorkbook("wlu.xlsx")
weights.lu <- readWorksheet(wb.wlu, sheet = 1)
rownames(weights.lu) <- weights.lu$YEAR
weights.lu <- weights.lu[,sectors]

# Netherlands
wb.nl <- loadWorkbook("nl.xlsx")
prices.nl <- readWorksheet(wb.nl, sheet = 1)
rownames(prices.nl) <- prices.nl$DATE
prices.nl <- prices.nl[,sectors]

wb.wnl <- loadWorkbook("wnl.xlsx")
weights.nl <- readWorksheet(wb.wnl, sheet = 1)
rownames(weights.nl) <- weights.nl$YEAR
weights.nl <- weights.nl[,sectors]


# put everything in lists
prices <- list(be=prices.be,de=prices.de,fr=prices.fr,lu=prices.lu,nl=prices.nl)
weights<- list(be=weights.be,de=weights.de,fr=weights.fr,lu=weights.lu,nl=weights.nl)

# Country1 vs Country2
mOut <- NULL
nSeries <- NULL
for (j in 1:(length(prices)-1))
{
  for (k in (j+1):length(prices))
  {
    out.df <- rep(NA,length(prices$be))
    out.kp <- out.df
    p1 <- prices[[j]]
    p2 <- prices[[k]]
    w1 <- weights[[j]]
    w2 <- weights[[k]]
    for (i in 1:length(out.df))
    {
      x <- ts(log(p1[[i]])-log(p2[[i]]))
      if (any(is.na(x))) next
      df <- ur.df(x,"drift",lags=12,"BIC")
      out.df[i] <- df@teststat[1]
      kp <- ur.kpss(x,type="mu",use.lag=20)
      out.kp[i] <- kp@teststat[1]
    }
    
    # percentage of ADF rejections and indexes of sectors where LOP holds
    mean(out.df < -2.88, na.rm=T)
    df.rej <- which(out.df < -2.89)
    
    # percentage of KPSS acceptance and indexes of sectors where LOP holds
    mean(out.kp < .463, na.rm=T)
    kp.acc <- which(out.kp < .463)
    
    # indexes of sectors where LOP holds both for KPSS and ADF
    stat <- intersect(df.rej,kp.acc)
    
    # --- ADF-BASED ---
    # CPI based RER (actual weights)
    cpi.w1 <- as.vector(w1["2005",df.rej]) # select weights of LOP sectors
    cpi.w1 <- cpi.w1/sum(cpi.w1)           # normalize weights
    cpi.w2 <- as.vector(w2["2005",df.rej]) # select weights of LOP sectors
    cpi.w2 <- cpi.w2/sum(cpi.w2)           # normalize weights
    cpi.rer <- log( as.matrix(p1[,df.rej])%*%t(cpi.w1) )-
               log( as.matrix(p2[,df.rej])%*%t(cpi.w2) )  # log-rer
    
    # CPI based RER (same weights)
    cpi.same.rer <- log( as.matrix(p1[,df.rej])%*%t(cpi.w1) )-
                    log( as.matrix(p2[,df.rej])%*%t(cpi.w1) )
    
    
    # PPP preserving RER
    our.w <- (cpi.w1+cpi.w2)/2 # mean weights
    our.rer <- log( (as.matrix(p1[,df.rej])/as.matrix(p2[,df.rej]))%*%t(our.w) )
    
    adf.rer <- data.frame(ADF.CPI =ur.df(cpi.rer,"drift",lags=12,"BIC")@teststat[1],
                          ADF.SAME=ur.df(cpi.same.rer,"drift",lags=12,"BIC")@teststat[1],
                          ADF.OUR =ur.df(our.rer,"drift",lags=12,"BIC")@teststat[1])
    
    
    # --- KPSS-BASED ---
    # CPI based RER (actual weights)
    cpi.w1 <- as.vector(w1["2005",kp.acc]) # select weights of LOP sectors
    cpi.w1 <- cpi.w1/sum(cpi.w1)           # normalize weights
    cpi.w2 <- as.vector(w2["2005",kp.acc]) # select weights of LOP sectors
    cpi.w2 <- cpi.w2/sum(cpi.w2)           # normalize weights
    cpi.rer <- log( as.matrix(p1[,kp.acc])%*%t(cpi.w1) )-
      log( as.matrix(p2[,kp.acc])%*%t(cpi.w2) )  # log-rer
    
    # CPI based RER (same weights)
    cpi.same.rer <- log( as.matrix(p1[,kp.acc])%*%t(cpi.w1) )-
      log( as.matrix(p2[,kp.acc])%*%t(cpi.w1) )
    
    
    # PPP preserving RER
    our.w <- (cpi.w1+cpi.w2)/2 # mean weights
    our.rer <- log( (as.matrix(p1[,kp.acc])/as.matrix(p2[,kp.acc]))%*%t(our.w) )
    
    kpss.rer <- data.frame(KPSS.CPI =ur.kpss(cpi.rer,"mu",use.lag=20)@teststat[1],
                           KPSS.SAME=ur.kpss(cpi.same.rer,"mu",use.lag=20)@teststat[1],
                           KPSS.OUR =ur.kpss(our.rer,"mu",use.lag=20)@teststat[1])
    cat(names(prices)[j],"vs",names(prices)[k])
    cat("\nADF\n")
    print(adf.rer)
    cat("\nKPSS\n")
    print(kpss.rer)
    temp <- cbind(adf.rer,kpss.rer)
    rownames(temp) <- toupper(paste(names(prices)[j],names(prices)[k],sep="-"))
    mOut <- rbind(mOut,temp)
    nSeries <- rbind(nSeries,c(length(df.rej),length(kp.acc)))
  }
}