/* zdistc.prg */
/* output critical values for Table 1 in
   "Evaluating Asset-Pricing Models Using the Hansen-Jagannathan 
        Bound: A Monte Carlo Investigation"
    by C. Otrok, B. Ravikumar and C.H. Whiteman
    Journal of Applied Econometrics
*/


new;
load z1f=c:\projects\hjmc\table1\z1f.fmt;
load z1=c:\projects\hjmc\table1\z1.fmt;

z1fs1=sortc(z1f[.,1],1);
z1fs2=sortc(z1f[.,2],1);
z1fs3=sortc(z1f[.,3],1);
z1fs5=sortc(z1f[.,4],1);

z1s1=sortc(z1[.,1],1);
z1s2=sortc(z1[.,2],1);
z1s3=sortc(z1[.,3],1);
z1s5=sortc(z1[.,4],1);

n=rows(z1);
ind=(100|250|500|1000|2500|5000|7500|9000|9500|9750|9900)*3;
ncrit=rows(ind);

z1s1l=zeros(ncrit,1);
z1s2l=zeros(ncrit,1);
z1s3l=zeros(ncrit,1);
z1s5l=zeros(ncrit,1);

z1fs1l=zeros(ncrit,1);
z1fs2l=zeros(ncrit,1);
z1fs3l=zeros(ncrit,1);
z1fs5l=zeros(ncrit,1);

i=1;
do while i le ncrit;
   z1s1l[i]=z1s1[ind[i]];
   z1s2l[i]=z1s2[ind[i]];
   z1s3l[i]=z1s3[ind[i]];
   z1s5l[i]=z1s5[ind[i]];

   z1fs1l[i]=z1fs1[ind[i]];
   z1fs2l[i]=z1fs2[ind[i]];
   z1fs3l[i]=z1fs3[ind[i]];
   z1fs5l[i]=z1fs5[ind[i]];

   i=i+1;
endo;

format 10,6;
screen on;
output file = c:\projects\hjmc\table1\zdistC.asc reset;
print("Critical Values");
print("Quarterly");
print("Crit, Risky (100,200,300,500) ");
(ind/n)~z1s1l~z1s2l~z1s3l~z1s5l;
print("Crit, Riskless (100,200,300,500)");
(ind/n)~z1fs1l~z1fs2l~z1fs3l~z1fs5l;
screen off;
output off;



end;
