/* Tauchen4.prg */
/* quarterly consumption */
/* Implements: George Tauchen, "Finite State Markov-Chain Approximations
               to Univariate and Vector Autoregressions",
               Economics Letters, vol 20, 1986, p177-181 */
/* calculate a finite state Markov aproximation to a continuous
   VAR(1) time series process */
/* program: 1) caclulates values for states
            2) transition probabilities
            3) simulates the continuous and markov approximation
               and compares Moments of the two

  This version takes a univariate AR(p) process, writes it as
  a VAR(1) and then approximates this process, with suitable adjustment to 
  the transition probabilities */
/* program to calculate Table 1 in
   "Evaluating Asset-Pricing Models Using the Hansen-Jagannathan 
        Bound: A Monte Carlo Investigation"
    by C. Otrok, B. Ravikumar and C.H. Whiteman
    Journal of Applied Econometrics
*/


new;
/* the continuous function we want to approximate:
   y(t) = A(L)*y(t-1)+ e(t)
    where the dimension of A(L) is l
   Y(t) = A*Y(t-1) + E(t)
   where Y(t) is lx1 vector, A is LxL, E(t) iid N(0,Sige),
       with diagonal covariance matrix  Sige, and zeros for all elements
       except the first  */

/* load consumption growth data */
load actual[203,3]=c:\projects\hjmc\qdatap.txt;
consu=actual[1:203,1]/100;
consu=consu+1;

nlag=3;
y=consu[nlag+1:203,1];
x=ones(203-nlag,1);

i=nlag;
do while i ge 1;
x=x~consu[i:203-nlag+(i-1),1];
i=i-1;
endo;

coeff=inv(x'x)*x'y;
e=y-x*coeff;
ves=(e'e)/(rows(e));

Avec=coeff[2:rows(coeff)]';
Sigle=ves;
A=Avec|(eye(cols(Avec)-1)~zeros(cols(Avec)-1,1));
Sige=zeros(rows(Avec),rows(Avec));   /* residual covariance matrix */
Sige[1,1]=sigle;
Sigvec=sqrt(diag(Sige));
concorr= meanc(consu)*(1-sumc(avec'));    /* correction for constant term */

/* calculate discrete grid */
rowA=rows(A);
Sigy=reshape(inv(eye(rowA^2)-(A.*.A))*vec(Sige),rowA,rowA);
               /* unconditional Var-Cov Mat of Y(t) */
m=3;   /* determines grid width, upper/lower values of y are multiplies of m */
N=9;   /* number of grid points */
ybarN=m*(sqrt((Sigy[1,1])));   /* upper grid value for y */
ybar1=-ybarN;   /* lower grid value for y */

ygrid=zeros(rowA,N);    /* discrete values for Y(t) approx */
w=zeros(rowA,1);        /* grid width */
i=1;
do while i le rowA;
   ygrid[i,.]=seqa(ybar1,(ybarN-ybar1)/(N-1),N)';
   w[i]=ygrid[i,2]-ygrid[i,1];
   i=i+1;
endo;
ygrid=ygrid+meanc(consu);

/* setup matrix of all possible states: e.g. in the 2 variable case, for each
   discrete value of variable 1, variable 2 can take any of N values */

Nstar=N^(rowA);   /* total possible states */
Yhat=zeros(rowA,Nstar);
lhat=zeros(rowA,Nstar);

ii=1;
do while ii le rowA-1;
   i=1;
   iii=1;
   do while i le N^ii;
      Yhat[ii,((i-1)*(N^(rowA-ii)))+1:(i*(N^(rowA-ii)))]=
                              ones(1,N^(rowA-ii))*ygrid[ii,iii];
      lhat[ii,((i-1)*(N^(rowA-ii)))+1:(i*(N^(rowA-ii)))]=
                              ones(1,N^(rowA-ii))*iii;
      iii=iii+1;
      if iii==(N+1); iii=1; endif;
      i=i+1;
   endo;
   ii=ii+1;
endo;

j=1;
do while j le N^(rowA-1);
   Yhat[ii,((j-1)*N)+1:(j*n)]=ygrid[ii,1:N];
   lhat[ii,((j-1)*N)+1:(j*n)]=seqa(1,1,N)';
   j=j+1;
endo;

/* calculate intermediate transition probabilities */
hmat=zeros(Nstar,N);   /* probability of transiting from state j to state k */

j=1;
do while j le Nstar;
   mu=A*yhat[.,j];
   hmat[j,1]=cdfn( (ygrid[1,1]-(mu[1])-concorr+(w[1]/2))/sigvec[1] );

   k=2;    /* k indexes next periods state: e.g. the column of tmat */
   do while k le N-1;
      hmat[j,k]=cdfn( (ygrid[1,k]-(mu[1])-concorr+(w[1]/2))/sigvec[1] )-
             cdfn( (ygrid[1,k]-(mu[1])-concorr-(w[1]/2))/sigvec[1] );
      k=k+1;
   endo;
   hmat[j,N]=1-cdfn( (ygrid[1,N]-(mu[1])-concorr-(w[1]/2))/sigvec[1] );

   j=j+1;
endo;

i=2;
do while i le rowA;
   hmatT=zeros(Nstar,N);
   j=1;
   do while j le Nstar;
      hmatT[j,lhat[i-1,j]]=1;
      j=j+1;
   endo;
   hmat=hmat|hmatT;
   i=i+1;
endo;

/* calculate transition probabilities for expanded state space Nstar x Nstar */
tmat=ones(Nstar,Nstar);

j=1; /* current state */
do while j le Nstar;
   k=1; /* next state */
   do while k le Nstar;
      i=1;
      do while i le rowA;
         tmat[j,k]=tmat[j,k]*hmat[((i-1)*Nstar)+j,lhat[i,k]];
         i=i+1;
      endo;
      k=k+1;
   endo;
   j=j+1;
endo;

save path=c:\projects\hjmc\table1 tmat;
save path=c:\projects\hjmc\table1 yhat;

/* now simulate continuous process and discrete process and compare
   unconditional distributions and autocorrelation function */

end;

/* This section illustrates the accuracy of the approximation */

T=200;       /* length of time-series  */
N=10000;        /* number of simulations */
burnin=100;
cmtmat=cumsumc(tmat')';   /* cumulative transition probabilities */

mom1=zeros(N,2);   /* first moments  */
mom2=zeros(N,2);   /* second moments */
mom3=zeros(N,2);   /* third moments */
mom4=zeros(N,2);   /* fourth moments */
Auto1=zeros(N,2);  /* first autocorrelation */
Auto2=zeros(N,2);  /* second autocorrelation */
Auto3=zeros(N,2);  /* third autocorrelation */
Auto4=zeros(N,2);  /* fourth autocorrelation */
Auto5=zeros(N,2);  /* fifth autocorrelation */
Auto6=zeros(N,2);  /* Sixth autocorrelation */

nsim=1;
do while nsim le N;

/* simulate continuous process */
Yc=zeros(T+burnin,rowA);
i=2;
do while i le T+burnin;
   Yc[i,.]=(concorr|zeros(rowA-1,1))'+(A*Yc[i-1,.]')'+
            ((rndn(1,1)*sigvec)|zeros(rowA-1,1))';
   i=i+1;
endo;

/* simulate Markov Process */
Ym=zeros(T+burnin,rowA);
lstate=trunc((rndu(1,1)*Nstar)+1);
i=1;
do while i le T+burnin;
   state=maxindc( counts(rndu(1,1),cmtmat[lstate,.]') );
   Ym[i,.]=Yhat[.,state]';
   lstate=state;
   i=i+1;
endo;

Yc=Yc[burnin+1:burnin+T,.];
Ym=Ym[burnin+1:burnin+T,.];

/* calculate moments of both processes */
mom1[nsim,.]=meanc(Yc[.,1])~meanc(Ym[.,1]);
mom2[nsim,.]=(stdc(Yc[.,1]))~(stdc(Ym[.,1]));
mom3[nsim,.]=meanc((Yc[.,1]-meanc(Yc[.,1]))^3)~meanc((Ym[.,1]-
            meanc(Ym[.,1]))^3);
mom4[nsim,.]=meanc((Yc[.,1]-meanc(Yc[.,1]))^4)~meanc((Ym[.,1]-
                meanc(Ym[.,1]))^4);
temp1=corrx(Yc[1:T-1,1]~Yc[2:T,1]);
temp2=corrx(Ym[1:T-1,1]~Ym[2:T,1]);
auto1[nsim,.]=temp1[1,2]~temp2[1,2];

temp1=corrx(Yc[1:T-2,1]~Yc[3:T,1]);
temp2=corrx(Ym[1:T-2,1]~Ym[3:T,1]);
auto2[nsim,.]=temp1[1,2]~temp2[1,2];

temp1=corrx(Yc[1:T-3,1]~Yc[4:T,1]);
temp2=corrx(Ym[1:T-3,1]~Ym[4:T,1]);
auto3[nsim,.]=temp1[1,2]~temp2[1,2];

temp1=corrx(Yc[1:T-4,1]~Yc[5:T,1]);
temp2=corrx(Ym[1:T-4,1]~Ym[5:T,1]);
auto4[nsim,.]=temp1[1,2]~temp2[1,2];

temp1=corrx(Yc[1:T-5,1]~Yc[6:T,1]);
temp2=corrx(Ym[1:T-5,1]~Ym[6:T,1]);
auto5[nsim,.]=temp1[1,2]~temp2[1,2];

temp1=corrx(Yc[1:T-6,1]~Yc[7:T,1]);
temp2=corrx(Ym[1:T-6,1]~Ym[7:T,1]);
auto6[nsim,.]=temp1[1,2]~temp2[1,2];

screen on; nsim; screen off;
nsim=nsim+1;
endo;

/* moments of data */
moma1=meanc(consu[.,1]);
moma2=(stdc(consu[.,1]));
moma3=meanc((consu[.,1]-meanc(consu[.,1]))^3);
moma4=meanc((consu[.,1]-meanc(consu[.,1]))^4);

temp1=corrx(consu[1:203-1,1]~consu[2:203,1]);
autoa1=temp1[1,2];

temp1=corrx(consu[1:203-2,1]~consu[3:203,1]);
autoa2=temp1[1,2];

temp1=corrx(consu[1:203-3,1]~consu[4:203,1]);
autoa3=temp1[1,2];

temp1=corrx(consu[1:203-4,1]~consu[5:203,1]);
autoa4=temp1[1,2];

temp1=corrx(consu[1:203-5,1]~consu[6:203,1]);
autoa5=temp1[1,2];

temp1=corrx(consu[1:203-6,1]~consu[7:203,1]);
autoa6=temp1[1,2];

/* output some info from the simulations */
m=N/200;  /* number of categories for histogram */
mgrid1=seqa(minc(minc(mom1)),( maxc(maxc(mom1))-minc(minc(mom1)) )/(m-1),m);
mc1=counts(mom1[.,1],mgrid1)~counts(mom1[.,2],mgrid1);
temp=maxindc(counts(moma1,mgrid1));
amc1=zeros(m,1); amc1[temp]=maxc(mc1[.,1]);

mgrid2=seqa(minc(minc(mom2)),( maxc(maxc(mom2))-minc(minc(mom2)) )/(m-1),m);
mc2=counts(mom2[.,1],mgrid2)~counts(mom2[.,2],mgrid2);
temp=maxindc(counts(moma2,mgrid2));
amc2=zeros(m,1); amc2[temp]=maxc(mc2[.,1]);

mgrid3=seqa(minc(minc(mom3)),( maxc(maxc(mom3))-minc(minc(mom3)) )/(m-1),m);
mc3=counts(mom3[.,1],mgrid3)~counts(mom3[.,2],mgrid3);
temp=maxindc(counts(moma3,mgrid3));
amc3=zeros(m,1); amc3[temp]=maxc(mc3[.,1]);

mgrid4=seqa(minc(minc(mom4)),( maxc(maxc(mom4))-minc(minc(mom4)) )/(m-1),m);
mc4=counts(mom4[.,1],mgrid4)~counts(mom4[.,2],mgrid4);
temp=maxindc(counts(moma4,mgrid4));
amc4=zeros(m,1); amc4[temp]=maxc(mc4[.,1]);

mgridA1=seqa(minc(minc(auto1)),( maxc(maxc(auto1))-minc(minc(auto1)) )/(m-1),m);
mcA1=counts(auto1[.,1],mgridA1)~counts(auto1[.,2],mgridA1);
temp=maxindc(counts(autoa1,mgridA1));
amcA1=zeros(m,1); amcA1[temp]=maxc(mcA1[.,1]);

mgridA2=seqa(minc(minc(auto2)),( maxc(maxc(auto2))-minc(minc(auto2)) )/(m-1),m);
mcA2=counts(auto2[.,1],mgridA2)~counts(auto2[.,2],mgridA2);
temp=maxindc(counts(autoa2,mgridA2));
amcA2=zeros(m,1); amcA2[temp]=maxc(mcA2[.,1]);

mgridA3=seqa(minc(minc(auto3)),( maxc(maxc(auto3))-minc(minc(auto3)) )/(m-1),m);
mcA3=counts(auto3[.,1],mgridA3)~counts(auto3[.,2],mgridA3);
temp=maxindc(counts(autoa3,mgridA3));
amcA3=zeros(m,1); amcA3[temp]=maxc(mcA3[.,1]);

mgridA4=seqa(minc(minc(auto4)),( maxc(maxc(auto4))-minc(minc(auto4)) )/(m-1),m);
mcA4=counts(auto4[.,1],mgridA4)~counts(auto4[.,2],mgridA4);
temp=maxindc(counts(autoa4,mgridA4));
amcA4=zeros(m,1); amcA4[temp]=maxc(mcA4[.,1]);

mgridA5=seqa(minc(minc(auto5)),( maxc(maxc(auto5))-minc(minc(auto5)) )/(m-1),m);
mcA5=counts(auto5[.,1],mgridA5)~counts(auto5[.,2],mgridA5);
temp=maxindc(counts(autoa5,mgridA5));
amcA5=zeros(m,1); amcA5[temp]=maxc(mcA5[.,1]);

mgridA6=seqa(minc(minc(auto6)),( maxc(maxc(auto6))-minc(minc(auto6)) )/(m-1),m);
mcA6=counts(auto6[.,1],mgridA6)~counts(auto6[.,2],mgridA6);
temp=maxindc(counts(autoa6,mgridA6));
amcA6=zeros(m,1); amcA6[temp]=maxc(mcA6[.,1]);

library pgraph;
_pltype= {6,1,6};
_protate=1;
begwind;
window(5,2,0);
setwind(1);
title("Mean");
xy(mgrid1,mc1~amc1);
nextwind;
title("Standard Deviation");
xy(mgrid2,mc2~amc2);
nextwind;
title("3rd Moments");
xy(mgrid3,mc3~amc3);
nextwind;
title("4th Moments");
xy(mgrid4,mc4~amc4);
nextwind;
title("1st Autocorrelation");
xy(mgridA1,mcA1~amcA1);
nextwind;
title("2nd Autocorrelation");
xy(mgridA2,mcA2~amcA2);
nextwind;
title("3rd Autocorrelation");
xy(mgridA3,mcA3~amcA3);
nextwind;
title("4th Autocorrelation");
xy(mgridA4,mcA4~amcA4);
nextwind;
title("5th Autocorrelation");
xy(mgridA5,mcA5~amcA5);
nextwind;
title("6th Autocorrelation");
xy(mgridA6,mcA6~amcA6);
endwind;

screen on;
print("First Moments: Pop, Continuous, Markov");
moma1~meanc(mom1)';
print("Standard Deviation: Pop, Continuous, Markov");
moma2~meanc(mom2)';
print("Third Moments: Pop, Continuous, Markov");
moma3~meanc(mom3)';
print("Fourth Moments: Pop, Continuous, Markov");
moma4~meanc(mom4)';
print("1st Autocorrelation: Pop, Continuous, Markov");
autoa1~meanc(auto1)';
print("2nd Autocorrelation: Pop, Continuous, Markov");
autoa2~meanc(auto2)';
print("3rd Autocorrelation: Pop, Continuous, Markov");
autoa3~meanc(auto3)';
print("4th Autocorrelation: Pop, Continuous, Markov");
autoa4~meanc(auto4)';
print("5th Autocorrelation: Pop, Continuous, Markov");
autoa5~meanc(auto5)';
print("6th Autocorrelation: Pop, Continuous, Markov");
autoa6~meanc(auto6)';


screen off;

end;


