/* hjtsGMM.prg  */
/* small sample properties of GMM estimator */
/* Time-Separable Model */
/* Use general markov process */
/* program to calculate Table 1 in
   "Evaluating Asset-Pricing Models Using the Hansen-Jagannathan 
        Bound: A Monte Carlo Investigation"
    by C. Otrok, B. Ravikumar and C.H. Whiteman
    Journal of Applied Econometrics
*/

new;

nlag=6;   @for GMM estimate@
np=100~200~300~500;  @time series length@

nexp=cols(np);

burnin=100;
beta=.99;

malpha=-0.005;
nsim=30000;

Z1=zeros(nsim,nexp);
Z1F=zeros(nsim,nexp);

nper=maxc(np');

/* load risky asset returns, riskless prices and consumption growth */
load cgrow=c:\projects\hjmc\table1\cgrowQ.fmt;
load pf=c:\projects\hjmc\table1\pfQ.fmt; 
load Rret=c:\projects\hjmc\table1\rretQ.fmt; 
load tmat=c:\projects\hjmc\table1\tmat.fmt; 
cmtmat=cumsumc(tmat')';   /* cumulative transition probabilities */
clear tmat;
RRet=Rret-1;

nn=1;
do while nn le nsim;

eqTS=zeros(burnin+nper,1);
pfTS=zeros(burnin+nper,1);
IMRSTS=zeros(burnin+nper,1);

Nstar=rows(cgrow);
lstate=trunc((rndu(1,1)*Nstar)+1);
t=1;
do while t le nper+burnin;

   state=maxindc( counts(rndu(1,1),cmtmat[lstate,.]') );

   eqTS[t,1]=Rret[lstate,state];
   pfTS[t,1]=pf[state,1];
   IMRSTS[t,1]=beta*(cgrow[state]^malpha);

   lstate=state;
   t=t+1;
endo;

eqTS=eqTS[burnin+1:nper+burnin];
pfTS=pfTS[burnin+1:nper+burnin];
IMRSTS=IMRSTS[burnin+1:nper+burnin];

i=1;
do while i le nexp;

  slen=np[i];

  eqTS1=eqTS[1:slen];
  pfTS1=pfTS[1:slen];
  IMRSTS1=IMRSTS[1:slen];

  eqts1=eqts1+1;

/* GMM estimation of Variance of Vertical Distance to HJ Bound:
       1 Risky Asset, 1 Riskless Asset */
alph1=meanc(pfts1);
alph2=meanc(imrsts1);
alph3=meanc((imrsts1-alph2).*(imrsts1-alph2));
alph4=meanc(eqts1);
alph5=meanc((eqts1-alph4).*(eqts1-alph4));

fxalT=zeros(slen,5);  @ store f(Xt,alpha) at each date (the moment conditions@
pfxalT=zeros(slen,5^2);  @derivative of f(Xt,alpha) wrt alpha, store for
                            each date by vec' ing matrix@

fxalT[1:slen,.]=( pfts1-alph1 )~( imrsts1-alph2)~
                (((imrsts1-alph2).^2)-alph3)~( eqts1 - alph4)~
                (((eqts1-alph4  ).^2)-alph5);


St1=zeros(5,5);          @ store  f(Xt,alpha)*f(Xt,alpha)'  @
St2=zeros(nlag,5^2);  @ store  f(Xt,alpha)*f(Xt-i,alpha)'  for i=1,nlag @
St3=zeros(nlag,5^2);  @ store  f(Xt,alpha)*f(Xt+i,alpha)'  for i=1,nlag @
ttt=1;
do while ttt le slen;
     pfxal=zeros(5,5);   @derivative of f(Xt,alpha) wrt alpha at a particular
                             date@
     pfxal[1,1]=-1;
     pfxal[2,2]=-1;
     pfxal[3,2]=-2*(imrsts1[ttt]-alph2);
     pfxal[3,3]=-1;
     pfxal[4,4]=-1;
     pfxal[5,4]=-2*(eqts1[ttt]-alph4);
     pfxal[5,5]=-1;
     pfxalT[ttt,.]=vec(pfxal)';

     St1=St1+fxalT[ttt,.]'fxalT[ttt,.];

     kk=1;
     do while kk le nlag;
           if ttt ge kk+1;    St2[kk,.]=St2[kk,.]+
                                vec(fxalT[ttt,.]'fxalT[ttt-kk,.])'; endif;
           if ttt le slen-kk; St3[kk,.]=St3[kk,.]+
                                vec(fxalT[ttt,.]'fxalT[ttt+kk,.])'; endif;
           kk=kk+1;
     endo;
    ttt=ttt+1;
endo;

St1=St1/slen;
St2=St2/slen;
St3=St3/slen;

St=St1;

kk=1;
do while kk le nlag;
  St2[kk,.]=St2[kk,.]*(1-(kk/(nlag+1)));
  St3[kk,.]=St3[kk,.]*(1-(kk/(nlag+1)));
  St=St+(reshape(St2[kk,.]',5,5)')+(reshape(St3[kk,.]',5,5)');
  kk=kk+1;
endo;

Dt=reshape(meanc(pfxalT)',5,5)';


phal=( alph4*(alph5^(-.5)) )|
      0|
      (.5*(alph3^(-.5)))|
      ( alph1*(alph5^(-.5)) )|
      (.5*sqrt((1-alph1*alph4)^2)*(alph5^(-3/2)));

Valph=inv(Dt'*inv(St)*Dt);
sigq=sqrt(phal'*Valph*phal);
qhatF=sqrt(alph3)- sqrt(((1-alph1*alph4)^2)/alph5);

Z1F[nn,i]=sqrt(slen)*(qhatF/sigq);


/* GMM estimator for 1 asset case */
alph1=meanc(imrsts1);
alph2=stdc(imrsts1)^2;
alph3=meanc(eqts1);
alph4=(stdc(eqts1))^2;


pfxalT=zeros(slen,4^2);
fxalT=zeros(slen,4);
fxalT[1:slen,.]=( imrsts1-alph1 )~
        ( ((imrsts1-alph1).^2)-alph2 )~
        ( eqts1-alph3 )~
        ( ((eqts1-alph3).^2)-alph4);



St1=zeros(4,4);          @ store  f(Xt,alpha)*f(Xt,alpha)'  @
St2=zeros(nlag,4^2);  @ store  f(Xt,alpha)*f(Xt-i,alpha)'  for i=1,nlag @
St3=zeros(nlag,4^2);  @ store  f(Xt,alpha)*f(Xt+i,alpha)'  for i=1,nlag @
ttt=1;
do while ttt le slen;
pfxal=zeros(4,4);
pfxal[1,1]=-1;
pfxal[2,1]=-2*(imrsts1[ttt]-alph1);
pfxal[2,2]=-1;
pfxal[3,3]=-1;
pfxal[4,3]=-2*eqts1[ttt]+(2*alph3);
pfxal[4,4]=-1;
pfxalT[ttt,.]=vec(pfxal)';


     St1=St1+fxalT[ttt,.]'fxalT[ttt,.];

     kk=1;
     do while kk le nlag;
           if ttt ge kk+1;    St2[kk,.]=St2[kk,.]+
                                vec(fxalT[ttt,.]'fxalT[ttt-kk,.])'; endif;
           if ttt le slen-kk; St3[kk,.]=St3[kk,.]+
                                vec(fxalT[ttt,.]'fxalT[ttt+kk,.])'; endif;
           kk=kk+1;
     endo;
    ttt=ttt+1;
endo;

St1=St1/slen;
St2=St2/slen;
St3=St3/slen;

St=St1;

kk=1;
do while kk le nlag;
  St2[kk,.]=St2[kk,.]*(1-(kk/(nlag+1)));
  St3[kk,.]=St3[kk,.]*(1-(kk/(nlag+1)));
  St=St+(reshape(St2[kk,.]',4,4)')+(reshape(St3[kk,.]',4,4)');
  kk=kk+1;
endo;

Dt=reshape(meanc(pfxalT)',4,4)';

phal= (alph3*(alph4^(-.5)))|
          ( .5*sqrt(1/alph2) )|
          (alph1*(alph4^(-.5)))|
          (.5*(1-alph1*alph3)*(alph4^(-3/2)));

Valph=inv(Dt'*inv(St)*Dt);
sigq=sqrt(phal'*Valph*phal);
qhat=sqrt(alph2)- sqrt(((1-alph1*alph3)^2)*(alph4^(-1)));

Z1[nn,i]=sqrt(slen)*(qhat/sigq);

i=i+1;
endo;

screen on; nn; screen off;
nn=nn+1;
endo;

save path=c:\projects\hjmc\table1 z1;
save path=c:\projects\hjmc\table1 z1f;

end;
