/* hjtsGMM.prg  */
/*  small sample properties of GMM estimator */
/* vary sigma, fixed time series length */
/* Time-Separable Model */
/* program to replicate Figures 1-4 in
   "Evaluating Asset-Pricing Models Using the Hansen-Jagannathan 
        Bound: A Monte Carlo Investigation"
    by C. Otrok, B. Ravikumar and C.H. Whiteman
    Journal of Applied Econometrics
*/

new;

nlag=6;   @for GMM estimate@
np=200;  @length of time series@
nalpha=4;  @number of sigmas@
nsim=1000;  @number of simulations@
alvec=0.005~2~50~100;  @different sigmas@

Z1=zeros(nsim,nalpha); @store z1 stats@
Z1F=zeros(nsim,nalpha);

jjj=1;
do while jjj le nalpha;

alphats=alvec[jjj];
malphats=-alphats;
beta=.99;       @time discount@

phi=.61;
delta=.0053641;
phi11=phi; phi22=phi; phi12=(1.0-phi); phi21=(1.0-phi);
mu=.009753;

lambda1=1.0+mu+delta;
lambda2=1.0+mu-delta;
pi1=.5;    @stationary probability of a state@
pi2=.5;

               /* Time-Separable Model Asset Prices*/
alpha=alphats;
malpha=-alphats;
/*first calculate weights for equity return expectation (MP equation 9)*/

A=((beta*phi11*(lambda1^(1.0-alpha)))+(beta*phi12*(lambda2^(1.0-alpha))))/
  (1.0-(beta*phi11*(lambda1^(1.0-alpha))));
B=(beta*phi12*(lambda2^(1.0-alpha)))/(1.0-(beta*phi11*(lambda1^(1.0-alpha))));
C=((beta*phi21*(lambda1^(1.0-alpha)))+(beta*phi22*(lambda2^(1.0-alpha))))/
  (1.0-(beta*phi22*(lambda2^(1.0-alpha))));
D=(beta*phi21*(lambda1^(1.0-alpha)))/(1.0-(beta*phi22*(lambda2^(1.0-alpha))));
W1=(A+(B*C))/(1.0-(B*D));
W2=C+(D*W1);


/*calculate equity return in state i if j is next periods state*/
rijTS=zeros(2,2);
rijTS[1,1]=((lambda1*(W1+1.0))/W1)-1.0;
rijTS[1,2]=((lambda2*(W2+1.0))/W1)-1.0;
rijTS[2,1]=((lambda1*(W1+1.0))/W2)-1.0;
rijTS[2,2]=((lambda2*(W2+1.0))/W2)-1.0;

/*expected return on risk free security*/
/*calculate prices in each state first */
pfiTS=zeros(2,1);
pfiTS[1,1]=beta*((phi11*(lambda1^(-alpha)))+(phi12*(lambda2^(-alpha))));
pfiTS[2,1]=beta*((phi21*(lambda1^(-alpha)))+(phi22*(lambda2^(-alpha))));

/*calculate risk free return in each state*/
RfiTS=zeros(2,1);
RfiTS[1,1]=(1.0/pfiTS[1,1])-1.0;
RfiTS[2,1]=(1.0/pfiTS[2,1])-1.0;

nexp=cols(np);
nper=maxc(np');

nn=1;
do while nn le nsim;

rnum=rndu(1,1);
if rnum le .5;
  lstate=1;
else;
  lstate=2;
endif;

eqTS=zeros(nper,1);
frTS=zeros(nper,1);
pfTS=zeros(nper,1);
IMRSTS=zeros(nper,1);

t=1;
do while t le nper;
   rnum=rndu(1,1);
   if lstate==1;
       if rnum le phi11;
          state=1;
       else;
          state=2;
       endif;
   else;
       if rnum le phi22;
          state=2;
       else;
          state=1;
       endif;
   endif;

   eqTS[t,1]=rijTS[lstate,state];
   pfTS[t,1]=pfiTS[state,1];
   frTS[t,1]=rfiTS[lstate,1];

   if state==1;
      congro=lambda1;
   else; congro=lambda2; endif;

   IMRSTS[t,1]=beta*(congro^malphats);

   lstate=state;
   t=t+1;
endo;


  slen=np[nexp];
  eqTS1=eqTS[1:slen];
  pfTS1=pfTS[1:slen];
  IMRSTS1=IMRSTS[1:slen];

  eqts1=eqts1+1;

/* GMM estimation of Variance of Vertical Distance to HJ Bound:
       1 Risky Asset, 1 Riskless Asset */
alph1=meanc(pfts1); @leave this@
alph2=meanc(imrsts1); @leave this@
alph3=meanc((imrsts1-alph2).*(imrsts1-alph2));  @variance of IMRS-sub Spectra@
alph4=meanc(eqts1);
alph5=meanc((eqts1-alph4).*(eqts1-alph4)); @variance of Returns-sub spectra@

fxalT=zeros(slen,5);  @ store f(Xt,alpha) at each date (the moment conditions@
pfxalT=zeros(slen,5^2);  @derivative of f(Xt,alpha) wrt alpha, store for
                            each date by vec' ing matrix@

fxalT[1:slen,.]=( pfts1-alph1 )~( imrsts1-alph2)~
                (((imrsts1-alph2).^2)-alph3)~( eqts1 - alph4)~
                (((eqts1-alph4  ).^2)-alph5);


St1=zeros(5,5);          @ store  f(Xt,alpha)*f(Xt,alpha)'  @
St2=zeros(nlag,5^2);  @ store  f(Xt,alpha)*f(Xt-i,alpha)'  for i=1,nlag @
St3=zeros(nlag,5^2);  @ store  f(Xt,alpha)*f(Xt+i,alpha)'  for i=1,nlag @
ttt=1;
do while ttt le slen;
     pfxal=zeros(5,5);   @derivative of f(Xt,alpha) wrt alpha at a particular
                             date@
     pfxal[1,1]=-1;
     pfxal[2,2]=-1;
     pfxal[3,2]=-2*(imrsts1[ttt]-alph2);
     pfxal[3,3]=-1;
     pfxal[4,4]=-1;
     pfxal[5,4]=-2*(eqts1[ttt]-alph4);
     pfxal[5,5]=-1;
     pfxalT[ttt,.]=vec(pfxal)';

     St1=St1+fxalT[ttt,.]'fxalT[ttt,.];

     kk=1;
     do while kk le nlag;
           if ttt ge kk+1;    St2[kk,.]=St2[kk,.]+
                                vec(fxalT[ttt,.]'fxalT[ttt-kk,.])'; endif;
           if ttt le slen-kk; St3[kk,.]=St3[kk,.]+
                                vec(fxalT[ttt,.]'fxalT[ttt+kk,.])'; endif;
           kk=kk+1;
     endo;
    ttt=ttt+1;
endo;

St1=St1/slen;
St2=St2/slen;
St3=St3/slen;

St=St1;

kk=1;
do while kk le nlag;
  St2[kk,.]=St2[kk,.]*(1-(kk/(nlag+1)));
  St3[kk,.]=St3[kk,.]*(1-(kk/(nlag+1)));
  St=St+(reshape(St2[kk,.]',5,5)')+(reshape(St3[kk,.]',5,5)');
  kk=kk+1;
endo;

Dt=reshape(meanc(pfxalT)',5,5)';


phal=( alph4*(alph5^(-.5)) )|
      0|
      (.5*(alph3^(-.5)))|
      ( alph1*(alph5^(-.5)) )|
      (.5*sqrt((1-alph1*alph4)^2)*(alph5^(-3/2)));

Valph=inv(Dt'*inv(St)*Dt);
sigq=sqrt(phal'*Valph*phal);
qhatF=sqrt(alph3)- sqrt(((1-alph1*alph4)^2)/alph5);

Z1F[nn,jjj]=sqrt(slen)*(qhatF/sigq);

/* GMM estimator for 1 asset case */
alph1=meanc(imrsts1);
alph2=stdc(imrsts1)^2;   @variance of IMRS@
alph3=meanc(eqts1);
alph4=(stdc(eqts1))^2;  @variance of returns@


pfxalT=zeros(slen,4^2);
fxalT=zeros(slen,4);
fxalT[1:slen,.]=( imrsts1-alph1 )~
        ( ((imrsts1-alph1).^2)-alph2 )~
        ( eqts1-alph3 )~
        ( ((eqts1-alph3).^2)-alph4);


St1=zeros(4,4);       @ store  f(Xt,alpha)*f(Xt,alpha)'  @
St2=zeros(nlag,4^2);  @ store  f(Xt,alpha)*f(Xt-i,alpha)'  for i=1,nlag @
St3=zeros(nlag,4^2);  @ store  f(Xt,alpha)*f(Xt+i,alpha)'  for i=1,nlag @
ttt=1;
do while ttt le slen;
pfxal=zeros(4,4);
pfxal[1,1]=-1;
pfxal[2,1]=-2*(imrsts1[ttt]-alph1);
pfxal[2,2]=-1;
pfxal[3,3]=-1;
pfxal[4,3]=-2*eqts1[ttt]+(2*alph3);
pfxal[4,4]=-1;
pfxalT[ttt,.]=vec(pfxal)';


     St1=St1+fxalT[ttt,.]'fxalT[ttt,.];

     kk=1;
     do while kk le nlag;
           if ttt ge kk+1;    St2[kk,.]=St2[kk,.]+
                                vec(fxalT[ttt,.]'fxalT[ttt-kk,.])'; endif;
           if ttt le slen-kk; St3[kk,.]=St3[kk,.]+
                                vec(fxalT[ttt,.]'fxalT[ttt+kk,.])'; endif;
           kk=kk+1;
     endo;
    ttt=ttt+1;
endo;

St1=St1/slen;
St2=St2/slen;
St3=St3/slen;

St=St1;

kk=1;
do while kk le nlag;
  St2[kk,.]=St2[kk,.]*(1-(kk/(nlag+1)));
  St3[kk,.]=St3[kk,.]*(1-(kk/(nlag+1)));
  St=St+(reshape(St2[kk,.]',4,4)')+(reshape(St3[kk,.]',4,4)');
  kk=kk+1;
endo;

Dt=reshape(meanc(pfxalT)',4,4)';

phal= (alph3*(alph4^(-.5)))|
          ( .5*sqrt(1/alph2) )|
          (alph1*(alph4^(-.5)))|
          (.5*(1-alph1*alph3)*(alph4^(-3/2)));

Valph=inv(Dt'*inv(St)*Dt);
sigq=sqrt(phal'*Valph*phal);
qhat=sqrt(alph2)- sqrt(((1-alph1*alph3)^2)*(alph4^(-1)));

Z1[nn,jjj]=sqrt(slen)*(qhat/sigq);


screen on; jjj~nn; screen off;


nn=nn+1;
endo;


jjj=jjj+1;
endo;

save z1f;
save z1;

end;
