/* hbtspwr.prg  */
/* program to calculate Figures 9 and 11 in
   "Evaluating Asset-Pricing Models Using the Hansen-Jagannathan 
        Bound: A Monte Carlo Investigation"
    by C. Otrok, B. Ravikumar and C.H. Whiteman
    Journal of Applied Econometrics
*/
new;

nlag=6;   @for GMM estimate@
nper=200;   @length of time series@
nsim=1000;   @number of simulations @

/* parameters to use to generate data under alternative */
naalt=10;
alvec=seqa(.5,.5,naalt);  @'true' risk aversion parameter under alternative@
h=0.65;  @set equal to 0 for time-separable@

/* parameters under the null */
h0=.0;
al0=2;
malpha0=-al0;

rcz1=zeros(1,naalt);
rcz1f=zeros(1,naalt);

aaa=1;
do while aaa le naalt;
alphats=alvec[aaa];

malphats=-alphats;
beta=.99;       @time discount@

phi=.61;
delta=.0053641;
phi11=phi; phi22=phi; phi12=(1.0-phi); phi21=(1.0-phi);
mu=.009753;

lambda1=1.0+mu+delta;
lambda2=1.0+mu-delta;
pi1=.5;    @stationary probability of a state@
pi2=.5;

  /* Model Asset Prices */
alpha=alphats;
malpha=-alphats;
/*calculate the possible marginal rates to keep notation simple*/
M1111=( ((lambda1-h)^malpha)-(beta*h*((lambda1*lambda1-h*lambda1)^malpha)) )
       /( ((1-(h/lambda1))^malpha)-(beta*h*((lambda1-h)^malpha)) );
M1112=( ((lambda1-h)^malpha)-(beta*h*((lambda2*lambda1-h*lambda1)^malpha)) )
       /( ((1-(h/lambda1))^malpha)-(beta*h*((lambda1-h)^malpha)) );
M1221=( ((lambda2-h)^malpha)-(beta*h*((lambda1*lambda2-h*lambda2)^malpha)) )
       /( ((1-(h/lambda1))^malpha)-(beta*h*((lambda2-h)^malpha)) );
M1222=( ((lambda2-h)^malpha)-(beta*h*((lambda2*lambda2-h*lambda2)^malpha)) )
       /( ((1-(h/lambda1))^malpha)-(beta*h*((lambda2-h)^malpha)) );
M2111=( ((lambda1-h)^malpha)-(beta*h*((lambda1*lambda1-h*lambda1)^malpha)) )
       /( ((1-(h/lambda2))^malpha)-(beta*h*((lambda1-h)^malpha)) );
M2112=( ((lambda1-h)^malpha)-(beta*h*((lambda2*lambda1-h*lambda1)^malpha)) )
       /( ((1-(h/lambda2))^malpha)-(beta*h*((lambda1-h)^malpha)) );
M2221=( ((lambda2-h)^malpha)-(beta*h*((lambda1*lambda2-h*lambda2)^malpha)) )
       /( ((1-(h/lambda2))^malpha)-(beta*h*((lambda2-h)^malpha)) );
M2222=( ((lambda2-h)^malpha)-(beta*h*((lambda2*lambda2-h*lambda2)^malpha)) )
       /( ((1-(h/lambda2))^malpha)-(beta*h*((lambda2-h)^malpha)) );
check=M1111|M1112|M1221|M1222|M2111|M2112|M2221|M2222;
screen on; minc(check); screen off;


A=(beta*phi11*phi11*M1111*lambda1)+(beta*phi11*phi12*M1112*lambda1);
B=(beta*phi12*phi21*M1221*lambda2)+(beta*phi12*phi22*M1222*lambda2);
C=A+B;
D=(beta*phi21*phi11*M2111*lambda1)+(beta*phi21*phi12*M2112*lambda1);
E=(beta*phi22*phi21*M2221*lambda2)+(beta*phi22*phi22*M2222*lambda2);
F=D+E;
W1=( ((F/(1-E))*(B/(1-A)))+(C/(1-A)) )/( 1-((B/(1-A))*(D/(1-E))) );
W2=( (D/(1-E))*W1 )+(F/(1-E));

mrsmat=zeros(2,2);
mrsmat[1,1]=(phi11*M1111)+(phi12*M1112);
mrsmat[1,2]=(phi21*M1221)+(phi22*M1222);
mrsmat[2,1]=(phi11*M2111)+(phi12*M2112);
mrsmat[2,2]=(phi21*M2221)+(phi22*M2222);
mrsmat=mrsmat*beta;

/*calculate equity return in state i if j is next periods state*/
rijhb=zeros(2,2);
rijhb[1,1]=((lambda1*(W1+1.0))/W1)-1.0;
rijhb[1,2]=((lambda2*(W2+1.0))/W1)-1.0;
rijhb[2,1]=((lambda1*(W1+1.0))/W2)-1.0;
rijhb[2,2]=((lambda2*(W2+1.0))/W2)-1.0;

/*expected return on risk free security*/
/*calculate prices in each state first */
pfihb=zeros(2,1);
pfihb[1,1]=(beta*phi11*phi11*M1111)+(Beta*phi11*phi12*M1112)+
           (beta*phi12*phi21*M1221)+(beta*phi12*phi22*M1222);
pfihb[2,1]=(beta*phi21*phi11*M2111)+(Beta*phi21*phi12*M2112)+
           (beta*phi22*phi21*M2221)+(beta*phi22*phi22*M2222);

/*calculate risk free return in each state*/
Rfihb=zeros(2,1);
Rfihb[1,1]=(1.0/pfihb[1,1])-1.0;
Rfihb[2,1]=(1.0/pfihb[2,1])-1.0;

nn=1;
do while nn le nsim;

rnum=rndu(1,1);
if rnum le .5;
  lstate=1;
else;
  lstate=2;
endif;

eqTS=zeros(nper,1);
pfTS=zeros(nper,1);
IMRS0=zeros(nper,1);

t=1;
do while t le nper;
   rnum=rndu(1,1);
   if lstate==1;
       if rnum le phi11;
          state=1;
       else;
          state=2;
       endif;
   else;
       if rnum le phi22;
          state=2;
       else;
          state=1;
       endif;
   endif;

   eqTS[t,1]=rijhb[lstate,state];
   pfTS[t,1]=pfihb[state,1];

 /* IMRS under the (false) null */

       M1111=( ((lambda1-h0)^malpha0)-(beta*h0*((lambda1*lambda1-h0*lambda1)^malpha0)) )
            /( ((1-(h0/lambda1))^malpha0)-(beta*h0*((lambda1-h0)^malpha0)) );
       M1112=( ((lambda1-h0)^malpha0)-(beta*h0*((lambda2*lambda1-h0*lambda1)^malpha0)) )
            /( ((1-(h0/lambda1))^malpha0)-(beta*h0*((lambda1-h0)^malpha0)) );
       M1221=( ((lambda2-h0)^malpha0)-(beta*h0*((lambda1*lambda2-h0*lambda2)^malpha0)) )
            /( ((1-(h0/lambda1))^malpha0)-(beta*h0*((lambda2-h0)^malpha0)) );
       M1222=( ((lambda2-h0)^malpha0)-(beta*h0*((lambda2*lambda2-h0*lambda2)^malpha0)) )
            /( ((1-(h0/lambda1))^malpha0)-(beta*h0*((lambda2-h0)^malpha0)) );
       M2111=( ((lambda1-h0)^malpha0)-(beta*h0*((lambda1*lambda1-h0*lambda1)^malpha0)) )
           /( ((1-(h0/lambda2))^malpha0)-(beta*h0*((lambda1-h0)^malpha0)) );
      M2112=( ((lambda1-h0)^malpha0)-(beta*h0*((lambda2*lambda1-h0*lambda1)^malpha0)) )
           /( ((1-(h0/lambda2))^malpha0)-(beta*h0*((lambda1-h0)^malpha0)) );
      M2221=( ((lambda2-h0)^malpha0)-(beta*h0*((lambda1*lambda2-h0*lambda2)^malpha0)) )
           /( ((1-(h0/lambda2))^malpha0)-(beta*h0*((lambda2-h0)^malpha0)) );
      M2222=( ((lambda2-h0)^malpha0)-(beta*h0*((lambda2*lambda2-h0*lambda2)^malpha0)) )
          /( ((1-(h0/lambda2))^malpha0)-(beta*h0*((lambda2-h0)^malpha0)) );
      mrsmat0=zeros(2,2);
     mrsmat0[1,1]=(phi11*M1111)+(phi12*M1112);
     mrsmat0[1,2]=(phi21*M1221)+(phi22*M1222);
     mrsmat0[2,1]=(phi11*M2111)+(phi12*M2112);
     mrsmat0[2,2]=(phi21*M2221)+(phi22*M2222);
     mrsmat0=mrsmat0*beta;
     IMRS0[t,1]=mrsmat0[lstate,state];

   lstate=state;
   t=t+1;
endo;

  slen=nper;
  eqTS1=eqTS[1:slen]+1;
  pfTS1=pfTS[1:slen];
  IMRSTS1=imrs0;
screen on; meanc(imrs0)~stdc(imrs0); screen off;  

/* GMM estimator for 1 asset case */
alph1=meanc(imrsts1);
alph2=stdc(imrsts1)^2;
alph3=meanc(eqts1);
alph4=(stdc(eqts1))^2;

pfxalT=zeros(slen,4^2);
fxalT=zeros(slen,4);
fxalT[1:slen,.]=( imrsts1-alph1 )~
        ( ((imrsts1-alph1).^2)-alph2 )~
        ( eqts1-alph3 )~
        ( ((eqts1-alph3).^2)-alph4);

St1=zeros(4,4);       @ store  f(Xt,alpha)*f(Xt,alpha)'  @
St2=zeros(nlag,4^2);  @ store  f(Xt,alpha)*f(Xt-i,alpha)'  for i=1,nlag @
St3=zeros(nlag,4^2);  @ store  f(Xt,alpha)*f(Xt+i,alpha)'  for i=1,nlag @
ttt=1;
do while ttt le slen;
pfxal=zeros(4,4);
pfxal[1,1]=-1;
pfxal[2,1]=-2*(imrsts1[ttt]-alph1);
pfxal[2,2]=-1;
pfxal[3,3]=-1;
pfxal[4,3]=-2*eqts1[ttt]+(2*alph3);
pfxal[4,4]=-1;
pfxalT[ttt,.]=vec(pfxal)';

     St1=St1+fxalT[ttt,.]'fxalT[ttt,.];

     kk=1;
     do while kk le nlag;
           if ttt ge kk+1;    St2[kk,.]=St2[kk,.]+
                                vec(fxalT[ttt,.]'fxalT[ttt-kk,.])'; endif;
           if ttt le slen-kk; St3[kk,.]=St3[kk,.]+
                                vec(fxalT[ttt,.]'fxalT[ttt+kk,.])'; endif;
           kk=kk+1;
     endo;
    ttt=ttt+1;
endo;

St1=St1/slen;
St2=St2/slen;
St3=St3/slen;

St=St1;

kk=1;
do while kk le nlag;
  St2[kk,.]=St2[kk,.]*(1-(kk/(nlag+1)));
  St3[kk,.]=St3[kk,.]*(1-(kk/(nlag+1)));
  St=St+(reshape(St2[kk,.]',4,4)')+(reshape(St3[kk,.]',4,4)');
  kk=kk+1;
endo;

Dt=reshape(meanc(pfxalT)',4,4)';

phal= (alph3*(alph4^(-.5)))|
          ( .5*sqrt(1/alph2) )|
          (alph1*(alph4^(-.5)))|
          (.5*(1-alph1*alph3)*(alph4^(-3/2)));

Valph=inv(Dt'*inv(St)*Dt);
sigq=sqrt(phal'*Valph*phal);
qhat=sqrt(alph2)- sqrt(((1-alph1*alph3)^2)*(alph4^(-1)));
Z1=sqrt(slen)*(qhat/sigq);

if z1 le -2.035; rcz1[1,aaa]=rcz1[1,aaa]+1; endif;
if z1f le -2.040; rcz1f[1,aaa]=rcz1f[1,aaa]+1; endif;

screen on; aaa~nn; screen off;
nn=nn+1;
endo;

aaa=aaa+1;
endo;

rcz1=rcz1/nsim;
rcz1f=rcz1f/nsim;
output file = c:\projects\hjmc\power2\rejhb65.asc reset;
print("rcz1~rcz1f");
alvec~rcz1'~rcz1f';
output off;

end;