/* aprices.prg */
/* solve for asset prices of Markov economy with time separable
   preferences 
   transition matrix and discrete consumption growth values are
   calculated in tauchen4.prg */
/* program to calculate Table 1 in
   "Evaluating Asset-Pricing Models Using the Hansen-Jagannathan 
        Bound: A Monte Carlo Investigation"
    by C. Otrok, B. Ravikumar and C.H. Whiteman
    Journal of Applied Econometrics
*/


new;
beta=0.99;
alpha=.005;

load tmat=c:\projects\hjmc\table1\tmat.fmt;         /* transition probabilities */
load yhat=c:\projects\hjmc\table1\yhat.fmt;         /* state values (consumption growth) */
yhat=yhat[1,.];    /* just need for row */
Nstar=rows(tmat);

/* Solve for Risky Asset Prices */
lmat=(( yhat^(1-alpha) )).*ones(Nstar,Nstar);
cn=beta*sumc((tmat.*lmat)');
coeff=beta*(tmat.*lmat);
A=eye(nstar)-coeff;

W=inv(A)*cn;

/* Check to make sure solution is correct */
Wcheck=zeros(Nstar,1);
i=1;
do while i le Nstar;
   j=1;
   do while j le Nstar;
      Wcheck[i]=wcheck[i]+(beta*(tmat[i,j]*(yhat[1,j]^(1-alpha)))*(w[j]+1));
      j=j+1;
   endo;
   i=i+1;
endo;
rycheck=maxc(abs(w-wcheck));

/* Risky Returns: State i to State j */
Rret=zeros(Nstar,Nstar);
i=1;
do while i le Nstar;
   j=1;
   do while j le Nstar;
      Rret[i,j]=(yhat[1,j]*(w[j]+1))/w[i];
      j=j+1;
   endo;
   i=i+1;
endo;

/* expected risky return */
Retj=zeros(Nstar,1);
i=1;
do while i le Nstar;
   j=1;
   do while j le Nstar;
      Retj[i]=Retj[i]+tmat[i,j]*Rret[i,j];
      j=j+1;
   endo;
   i=i+1;
endo;

/* Solve for Riskless Asset Prices */
pf=zeros(nstar,1);
i=1;
do while i le Nstar;
   j=1;
   do while j le nstar;
      pf[i]=pf[i]+beta*(tmat[i,j]*(yhat[1,j]^(-alpha)));
      j=j+1;
   endo;
   i=i+1;
endo;

/* Riskless Returns */
rfree=ones(Nstar,1)./pf;

cgrowQ=yhat';
pfQ=pf;
rretQ=rret;

save path=c:\projects\hjmc\table1 pfQ;
save path=c:\projects\hjmc\table1 rretQ;
save path=c:\projects\hjmc\table1 cgrowQ;

end;
