% First, run abcd_minimal and variance-matrix
A=AAAA;B=BBBB;C=CCCC;D=DDDD;
h=12;%horizon
variance_autocov
Vfinal=Variance;
vout=Vfinal(124,124);
vinf=Vfinal(end,end);
vjoin=Vfinal([124,156],[124,156]);
[na,ma]=size(A);
VX=dlyap(A,B*B');
%Compute autocovariances matrices
Vlong=Vfinal/2+Vfinal'/2;
M=eye(na);
Q=A*VX*C'+B*D';
for j=1:24
    Vlong=[Vlong C*M*Q];
    M=M*A;
end
voutd=2*(vout-Vlong(124,124+156));
% Prediction accuracy when the entire observation history is available
disp('observation history')
%In our model, this is equivalent to having the latest set of all generated variables
V1out(1,1)=D(124,:)*D(124,:)';
V1inf(1,1)=D(156,:)*D(156,:)';
V1outd(1,1)=V1out(1,1);

for i=2:h
    G=C([124,156],:)*A^(i-2)*B;
    if i==2
        Gd=G(1,:)-D(124,:);
    else
        Gd=C(124,:)*A^(i-3)*(A-eye(na))*B;
    end
    V1out(i,1)=G(1,:)*G(1,:)';
    V1inf(i,1)=G(2,:)*G(2,:)';
    V1outd(i,1)=Gd*Gd';
end
V1out=cumsum(V1out)/vout;
V1inf=cumsum(V1inf)/vinf;
V1outd=cumsum(V1outd)/voutd;
% Prediction accuracy when entire history of output and inflation is available
disp('inflation and output history')
%sys=ss(A,B,C([124,156],:),D([124,156],:),-1);
%sysreal=minreal(sys);
%[AA,BB,CC,DD,TS]=ssdata(sysreal);
%[naa,maa]=size(AA);
I156=eye(156);
AA=A;
BB=B;
CC=C([124,156],:);
DD=D([124,156],:);
naa=naaaa;
[X,L,G,rr] = dare(AA',CC',BB*BB',DD*DD',BB*DD',eye(naa));
K=G';
V2=CC*X*CC'+DD*DD';
V2out=V2(1,1);
V2inf=V2(2,2);
V2outd=V2out;
for i=2:h
    G=CC*AA^(i-2)*K;
    if i==2
        V2outd(i,1)=CC(1,:)*K*V2*K'*CC(1,:)'-2*CC(1,:)*K*V2(:,1)+V2(1,1);
    else
        V2outd(i,1)=CC(1,:)*AA^(i-3)*(AA-eye(na))*K*V2*K'*(AA-eye(na))'*AA^(i-3)'*CC(1,:)';
    end
    V2out(i,1)=G(1,:)*V2*G(1,:)';
    V2inf(i,1)=G(2,:)*V2*G(2,:)';
end
V2out=cumsum(V2out)/vout;
V2inf=cumsum(V2inf)/vinf;
V2outd=cumsum(V2outd)/voutd;
% prediction accuracy when entire own history is available
disp('inflation OR output history')
%sys=ss(A,B,C(124,:),D(124,:),-1);
%sysreal=minreal(sys);
%[AA,BB,CC,DD,TS]=ssdata(sysreal);
%[naa,maa]=size(AA);
AA=A;
BB=B;
CC=C(124,:);
DD=D(124,:);
naa=naaaa;
[X,L,G,rr] = dare(AA',CC',BB*BB',DD*DD',BB*DD',eye(naa));
K=G';
V3out=CC*X*CC'+DD*DD';
V3outd=V3out;
for i=2:h
    G=CC*AA^(i-2)*K;
    V3out(i,1)=G*V3out(1,1)*G';
    if i==2
        V3outd(i,1)=CC*K*V3out(1,1)*K'*CC'-2*CC*K*V3out(1,1)+V3out(1,1);
    else
        V3outd(i,1)=CC*AA^(i-3)*(AA-eye(na))*K*V3out(1,1)*K'*(AA-eye(na))'*AA^(i-3)'*CC';
    end
end
V3out=cumsum(V3out)/vout;
V3outd=cumsum(V3outd)/voutd;
%
%sys=ss(A,B,C(156,:),D(156,:),-1);
%sysreal=minreal(sys);
%[AA,BB,CC,DD,TS]=ssdata(sysreal);
%[naa,maa]=size(AA);
AA=A;
BB=B;
CC=C(156,:);
DD=D(156,:);
naa=naaaa;
[X,L,G,rr] = dare(AA',CC',BB*BB',DD*DD',BB*DD',eye(naa));
K=G';
V3inf=CC*X*CC'+DD*DD';
for i=2:h
    G=CC*AA^(i-2)*K;
    V3inf(i,1)=G*V3inf(1,1)*G';
end
V3inf=cumsum(V3inf)/vinf;
% prediction accuracy when entire history of economy-wide innovations is available
disp('innovation history')
X=dlyap(A,B(:,1:30)*B(:,1:30)');
CC=C([124,156],:);
DD=D([124,156],:);
V4out_shock=DD(1,:)*DD(1,:)';
V4out_state=CC(1,:)*X*CC(1,:)';
V4inf_shock=DD(2,:)*DD(2,:)';
V4inf_state=CC(2,:)*X*CC(2,:)';
V4outd_shock=DD(1,:)*DD(1,:)'+(CC(1,:)*B(:,1:30)-DD(1,1:30))*(CC(1,:)*B(:,1:30)-DD(1,1:30))';
V4outd_state=CC(1,:)*(A-eye(na))*X*(A-eye(na))'*CC(1,:)';
for i=2:h
    if i==2
        V4outd_shock(i,1)=(CC(1,:)*B(:,31:33)-DD(1,31:33))*(CC(1,:)*B(:,31:33)-DD(1,31:33))';
    else
        Gd_shock=CC(1,:)*A^(i-3)*(A-eye(na))*B;
        V4outd_shock(i,1)=Gd_shock*Gd_shock';
    end
    Gd_state=CC(1,:)*A^(i-2)*(A-eye(na));
    V4outd_state(i,1)=Gd_state*X*Gd_state';
    G_shock=CC*A^(i-2)*B;
    G_state=CC*A^(i-1);
    V4out_shock(i,1)=G_shock(1,:)*G_shock(1,:)';
    V4out_state(i,1)=G_state(1,:)*X*G_state(1,:)';
    V4inf_shock(i,1)=G_shock(2,:)*G_shock(2,:)';
    V4inf_state(i,1)=G_state(2,:)*X*G_state(2,:)';
end
V4out=(V4out_state+cumsum(V4out_shock))/vout;
V4inf=(V4inf_state+cumsum(V4inf_shock))/vinf;
V4outd=(V4outd_state+cumsum(V4outd_shock))/voutd;
% prediction accuracy when entire history of the first 10 PC are available
disp('PC history')
[V,Deig]=eig((Vfinal+Vfinal')/2);
[d,norder]=sort(diag(Deig));
d=flipdim(d,1);
V=flipdim(V(:,norder),2);
for ii=1:10
    CC=V(:,1:ii)'*C;
    DD=V(:,1:ii)'*D;
    [X,L,G,rr] = dare(A',CC',B*B',DD*DD',B*DD',eye(naaaa));
    CC=C([124,156],:);
    DD=D([124,156],:);
    V5out_state(1,ii)=CC(1,:)*X*CC(1,:)';
    V5out_shock(1,ii)=DD(1,:)*DD(1,:)';
    V5inf_state(1,ii)=CC(2,:)*X*CC(2,:)';
    V5inf_shock(1,ii)=DD(2,:)*DD(2,:)';
    V5outd_state(1,ii)=999;%complicated formula. skip for now. Not essential for horizons larger than 1
    V5outd_shock(1,ii)=DD(1,:)*DD(1,:)';
    for i=2:h
        G_shock=CC*A^(i-2)*B;
        G_state=CC*A^(i-1);
        V5out_shock(i,ii)=G_shock(1,:)*G_shock(1,:)';
        V5out_state(i,ii)=G_state(1,:)*X*G_state(1,:)';
        V5inf_shock(i,ii)=G_shock(2,:)*G_shock(2,:)';
        V5inf_state(i,ii)=G_state(2,:)*X*G_state(2,:)';
        Gd_state=CC(1,:)*A^(i-2)*(A-eye(na));
        V5outd_state(i,ii)=Gd_state*X*Gd_state';
        if i==2
            V5outd_shock(i,ii)=(CC(1,:)*B-DD(1,:))*(CC(1,:)*B-DD(1,:))';
        else
            Gd_shock=CC(1,:)*A^(i-3)*(A-eye(na))*B;
            V5outd_shock(i,ii)=Gd_shock*Gd_shock';
        end
    end
end
V5out=(V5out_state+cumsum(V5out_shock))/vout;
V5inf=(V5inf_state+cumsum(V5inf_shock))/vinf;
V5outd=(V5outd_state+cumsum(V5outd_shock))/voutd;
% prediction accuracy when entire history of the first 10 PC based
% on correlation matrix are available
disp('PC correlation history')
[Vc,Deig]=eig((Cfinal+Cfinal')/2);
[d,norder]=sort(diag(Deig));
d=flipdim(d,1);
Vc=flipdim(Vc(:,norder),2);
for ii=1:10
    CC=Vc(:,1:ii)'*weight*C;
    DD=Vc(:,1:ii)'*weight*D;
    [X,L,G,rr] = dare(A',CC',B*B',DD*DD',B*DD',eye(naaaa));
    CC=C([124,156],:);
    DD=D([124,156],:);
    V6out_state(1,ii)=CC(1,:)*X*CC(1,:)';
    V6out_shock(1,ii)=DD(1,:)*DD(1,:)';
    V6inf_state(1,ii)=CC(2,:)*X*CC(2,:)';
    V6inf_shock(1,ii)=DD(2,:)*DD(2,:)';
    V6outd_state(1,ii)=999;%complicated formula. skip for now. Not essential for horizons larger than 1
    V6outd_shock(1,ii)=DD(1,:)*DD(1,:)';

    for i=2:h
        G_shock=CC*A^(i-2)*B;
        G_state=CC*A^(i-1);
        V6out_shock(i,ii)=G_shock(1,:)*G_shock(1,:)';
        V6out_state(i,ii)=G_state(1,:)*X*G_state(1,:)';
        V6inf_shock(i,ii)=G_shock(2,:)*G_shock(2,:)';
        V6inf_state(i,ii)=G_state(2,:)*X*G_state(2,:)';
        Gd_state=CC(1,:)*A^(i-2)*(A-eye(na));
        V6outd_state(i,ii)=Gd_state*X*Gd_state';
        if i==2
            V6outd_shock(i,ii)=(CC(1,:)*B-DD(1,:))*(CC(1,:)*B-DD(1,:))';
        else
            Gd_shock=CC(1,:)*A^(i-3)*(A-eye(na))*B;
            V6outd_shock(i,ii)=Gd_shock*Gd_shock';
        end
    end
end
V6out=(V6out_state+cumsum(V6out_shock))/vout;
V6inf=(V6inf_state+cumsum(V6inf_shock))/vinf;
V6outd=(V6outd_state+cumsum(V6outd_shock))/voutd;
% prediction accuracy when entire history of the first 10 PC and
% own history of output or inflation are available
disp('PC and own history')
for ii=1:10
%sys=ss(A,B,[C(124,:);V(:,1:ii)'*C],[D(124,:);V(:,1:ii)'*D],-1);
%sysreal=minreal(sys);
%[AA,BB,CC,DD,TS]=ssdata(sysreal);
%[naa,maa]=size(AA);
AA=A;
BB=B;
CC=[C(124,:);V(:,1:ii)'*C];
DD=[D(124,:);V(:,1:ii)'*D];
naa=naaaa;
[X,L,G,rr] = dare(AA',CC',BB*BB',DD*DD',BB*DD',eye(naa));
K=G';
V7=CC*X*CC'+DD*DD';
V7out(1,ii)=V7(1,1);
V7outd(1,ii)=V7(1,1);
for i=2:h
    G=CC(1,:)*AA^(i-2)*K;
    V7out(i,ii)=G*V7*G';
    if i==2
    Gd=CC(1,:)*K-[1 zeros(1,ii)];
    V7outd(i,ii)=Gd*V7*Gd';
    else
        Gd=CC(1,:)*A^(i-3)*(A-eye(na))*K;
        V7outd(i,ii)=Gd*V7*Gd';
    end
end
%
%sys=ss(A,B,[C(156,:);V(:,1:ii)'*C],[D(156,:);V(:,1:ii)'*D],-1);
%sysreal=minreal(sys);
%[AA,BB,CC,DD,TS]=ssdata(sysreal);
%[naa,maa]=size(AA);
AA=A;
BB=B;
CC=[C(156,:);V(:,1:ii)'*C];
DD=[D(156,:);V(:,1:ii)'*D];
naa=naaaa;
[X,L,G,rr] = dare(AA',CC',BB*BB',DD*DD',BB*DD',eye(naa));
K=G';
V7=CC*X*CC'+DD*DD';
V7inf(1,ii)=V7(1,1);
for i=2:h
    G=CC(1,:)*AA^(i-2)*K;
    V7inf(i,ii)=G*V7*G';
end
end
V7inf=cumsum(V7inf)/vinf;
V7out=cumsum(V7out)/vout;
V7outd=cumsum(V7outd)/voutd;
% prediction accuracy when entire history of the first 10 PC 
% based on correlation matrix and
% own history of output or inflation are available
disp('PC correlation and own history')
for ii=1:10
%sys=ss(A,B,[C(124,:);Vc(:,1:ii)'*weight*C],[D(124,:);Vc(:,1:ii)'*weight*D],-1);
%sysreal=minreal(sys);
%[AA,BB,CC,DD,TS]=ssdata(sysreal);
%[naa,maa]=size(AA);
AA=A;
BB=B;
CC=[C(124,:);Vc(:,1:ii)'*weight*C];
DD=[D(124,:);Vc(:,1:ii)'*weight*D];
naa=naaaa;
[X,L,G,rr] = dare(AA',CC',BB*BB',DD*DD',BB*DD',eye(naa));
K=G';
V8=CC*X*CC'+DD*DD';
V8out(1,ii)=V8(1,1);
V8outd(1,ii)=V8(1,1);
for i=2:h
    G=CC(1,:)*AA^(i-2)*K;
    V8out(i,ii)=G*V8*G';
    if i==2
    Gd=CC(1,:)*K-[1 zeros(1,ii)];
    V8outd(i,ii)=Gd*V8*Gd';
    else
        Gd=CC(1,:)*A^(i-3)*(A-eye(na))*K;
        V8outd(i,ii)=Gd*V8*Gd';
    end
end
%
%sys=ss(A,B,[C(156,:);Vc(:,1:ii)'*weight*C],[D(156,:);Vc(:,1:ii)'*weight*D],-1);
%sysreal=minreal(sys);
%[AA,BB,CC,DD,TS]=ssdata(sysreal);
%[naa,maa]=size(AA);
AA=A;
BB=B;
CC=[C(156,:);Vc(:,1:ii)'*weight*C];
DD=[D(156,:);Vc(:,1:ii)'*weight*D];
naa=naaaa;
[X,L,G,rr] = dare(AA',CC',BB*BB',DD*DD',BB*DD',eye(naa));
K=G';
V8=CC*X*CC'+DD*DD';
V8inf(1,ii)=V8(1,1);
for i=2:h
    G=CC(1,:)*AA^(i-2)*K;
    V8inf(i,ii)=G*V8*G';
end
end
V8inf=cumsum(V8inf)/vinf;
V8out=cumsum(V8out)/vout;
V8outd=cumsum(V8outd)/voutd;
% prediction accuracy when entire history of separate economy-wide innovations is available
disp('separate innovation history')
inde=[[1:30 32 33];[1:30 31 33];[1:30 31 32]];
for ii=1:3
X=dlyap(A,B*B'-B(:,30+ii)*B(:,30+ii)');
CC=C([124,156],:);
DD=D([124,156],:);
V9out_shock(1,ii)=DD(1,:)*DD(1,:)';
V9out_state(1,ii)=CC(1,:)*X*CC(1,:)';
V9inf_shock(1,ii)=DD(2,:)*DD(2,:)';
V9inf_state(1,ii)=CC(2,:)*X*CC(2,:)';
V9outd_shock(1,ii)=DD(1,:)*DD(1,:)'+(CC(1,:)*B(:,inde(ii,:))-DD(1,inde(ii,:)))*(CC(1,:)*B(:,inde(ii,:))-DD(1,inde(ii,:)))';
V9outd_state(1,ii)=CC(1,:)*(A-eye(na))*X*(A-eye(na))'*CC(1,:)';
for i=2:h
    if i==2
        V9outd_shock(i,ii)=(CC(1,:)*B(:,30+ii)-DD(1,30+ii))*(CC(1,:)*B(:,30+ii)-DD(1,30+ii))';
    else
        Gd_shock=CC(1,:)*A^(i-3)*(A-eye(na))*B;
        V9outd_shock(i,ii)=Gd_shock*Gd_shock';
    end
    Gd_state=CC(1,:)*A^(i-2)*(A-eye(na));
    V9outd_state(i,ii)=Gd_state*X*Gd_state';
    G_shock=CC*A^(i-2)*B;
    G_state=CC*A^(i-1);
    V9out_shock(i,ii)=G_shock(1,:)*G_shock(1,:)';
    V9out_state(i,ii)=G_state(1,:)*X*G_state(1,:)';
    V9inf_shock(i,ii)=G_shock(2,:)*G_shock(2,:)';
    V9inf_state(i,ii)=G_state(2,:)*X*G_state(2,:)';
end
end
V9out=(V9out_state+cumsum(V9out_shock))/vout;
V9inf=(V9inf_state+cumsum(V9inf_shock))/vinf;
V9outd=(V9outd_state+cumsum(V9outd_shock))/voutd;

% prediction accuracy when entire history of the economy-wide innovations 
% and own history are available
disp('innovation and own history')
[nc,mc]=size(C);
[nd,md]=size(D);
%sys=ss(A,B,[C(124,:);zeros(3,mc)],[D(124,:);[zeros(3,md-3) eye(3)]],-1);
%sysreal=minreal(sys);
%[AA,BB,CC,DD,TS]=ssdata(sysreal);
%[naa,maa]=size(AA);
AA=A;
BB=B;
CC=[C(124,:);zeros(3,mc)];
DD=[D(124,:);[zeros(3,md-3) eye(3)]];
naa=naaaa;
[X,L,G,rr] = dare(AA',CC',BB*BB',DD*DD',BB*DD',eye(naa));
K=G';
V10=CC*X*CC'+DD*DD';
V10out(1,1)=V10(1,1);
V10outd(1,1)=V10(1,1);
for i=2:h
    G=CC(1,:)*AA^(i-2)*K;
    V10out(i,1)=G*V10*G';
    if i==2
    Gd=CC(1,:)*K-[1 zeros(1,3)];
    V10outd(i,1)=Gd*V10*Gd';
    else
        Gd=CC(1,:)*A^(i-3)*(A-eye(na))*K;
        V10outd(i,1)=Gd*V10*Gd';
    end
end

AA=A;
BB=B(:,1:30);
CC=C(124,:);
DD=D(124,1:30);
naa=naaaa;
[X,L,G,rr] = dare(AA',CC',BB*BB',DD*DD',BB*DD',eye(naa));
K=G';
V10out_state1=CC*X*CC';
V10out_shock1=D(124,:)*D(124,:)';
V10outd_state1=CC*X*CC';
V10outd_shock1=D(124,:)*D(124,:)';
for i=2:h
    G_shock=CC*A^(i-2)*B;
    G_state=CC*A^(i-1);
    V10out_shock1(i,1)=G_shock*G_shock';
    V10out_state1(i,1)=G_state*X*G_state';
    if i==2
        Gd_shock=CC*B-D(124,:);
        V10outd_shock1(i,1)=Gd_shock*Gd_shock';
    else
        Gd_shock=CC*A^(i-3)*(A-eye(na))*B;
        V10outd_shock1(i,1)=Gd_shock*Gd_shock';
    end
    Gd_state=CC*A^(i-2)*(A-eye(na));
    V10outd_state1(i,1)=Gd_state*X*Gd_state';
end

%
%sys=ss(A,B,[C(156,:);zeros(3,mc)],[D(156,:);[zeros(3,md-3) eye(3)]],-1);
%sysreal=minreal(sys);
%[AA,BB,CC,DD,TS]=ssdata(sysreal);
%[naa,maa]=size(AA);
AA=A;
BB=[B(:,1:30) zeros(naaaa,1)];
CC=C(156,:);
DD=[D(156,1:30) 0.0000000001];
naa=naaaa;
[X,L,G,rr] = dare(AA',CC',BB*BB',DD*DD',BB*DD',eye(naa));
K=G';
V10inf_state=CC*X*CC';
V10inf_shock=D(156,:)*D(156,:)';
for i=2:h
    G_shock=CC*A^(i-2)*B;
    G_state=CC*A^(i-1);
    V10inf_shock(i,1)=G_shock*G_shock';
    V10inf_state(i,1)=G_state*X*G_state';
end
V10inf=(V10inf_state+cumsum(V10inf_shock))/vinf;
V10out=cumsum(V10out)/vout;
V10outd=cumsum(V10outd)/voutd;
V10out1=(V10out_state1+cumsum(V10out_shock1))/vout;
V10outd1=(V10outd_state1+cumsum(V10outd_shock1))/voutd;


save V1outnew.dat V1out -ascii
save V1infnew.dat V1inf -ascii
save V1outdnew.dat V1outd -ascii
save V2outnew.dat V2out -ascii
save V2infnew.dat V2inf -ascii
save V2outdnew.dat V2outd -ascii
save V3outnew.dat V3out -ascii
save V3infnew.dat V3inf -ascii
save V3outdnew.dat V3outd -ascii
save V4outnew.dat V4out -ascii
save V4infnew.dat V4inf -ascii
save V4outdnew.dat V4outd -ascii
save V5outnew.dat V5out -ascii
save V5infnew.dat V5inf -ascii
save V5outdnew.dat V5outd -ascii
save V6outnew.dat V6out -ascii
save V6infnew.dat V6inf -ascii
save V6outdnew.dat V6outd -ascii
save V7outnew.dat V7out -ascii
save V7infnew.dat V7inf -ascii
save V7outdnew.dat V7outd -ascii
save V8outnew.dat V8out -ascii
save V8infnew.dat V8inf -ascii
save V8outdnew.dat V8outd -ascii
save V9outnew.dat V9out -ascii
save V9infnew.dat V9inf -ascii
save V9outdnew.dat V9outd -ascii
save V10outnew.dat V10out -ascii
save V10infnew.dat V10inf -ascii
save V10outdnew.dat V10outd -ascii
save V10out1new.dat V10out1 -ascii
save V10outd1dnew.dat V10outd1 -ascii

