for mc=1:1000
    mc
data_generator1
Francisco=DATA';
Francisco_money=aZ(31,2:201)';
% number of latent factors
nfactors=5;

% Standardize data
sdFrancisco=std(Francisco);
sdFrancisco_money=std(Francisco_money);
[T,n]=size(Francisco);
data=(Francisco-repmat(mean(Francisco),T,1))./repmat(sdFrancisco,T,1);
moneyg=(Francisco_money-mean(Francisco_money))/sdFrancisco_money;

% Estimate factors using BGM method
[V,S,U]=svds(data,nfactors);
for i=1:20
X=[ones(T,1) V moneyg];
beta=inv(X'*X)*X'*data;
data_nomoney=data-moneyg*beta(end,:);
[V,S,U]=svds(data_nomoney,nfactors);
end
Factors=X(:,2:end);
Loadings=beta(2:end,:);
systematic=Factors*Loadings;
idiosyncratic=data-systematic;

% Estimated impulse responses of all the variables
lags=5;
Y=[Factors(lags+1:end,end) Factors(lags+1:end,1:nfactors)];% order money growth first
% so that it is not affacted by other variables contemporaneously
% Note that in the model, the money growth is exogenous so such an ordering
% is consistent with the model
X=ones(T-lags,1);
for i=1:lags
    X=[X Factors(lags-i+1:end-i,end) Factors(lags-i+1:end-i,1:nfactors)];
end
beta=inv(X'*X)*X'*Y;% VAR  
e0=Y-X*beta;
Sige=e0'*e0/(size(e0,1)-size(X,2));
smat=chol(Sige)';
%d=diag(diag(smat));
%smat=smat*inv(d);
shock=[1; zeros(nfactors,1)]; % Shock of 1 stdev to money growth
nimp=20;%number of periods for the impulse responses
beta=beta(2:end,:);
imp=(smat*shock)';%first impulse
k=size(smat,1);
ly=[imp zeros(1,(lags-1)*k)];%values of rhs in VAR equation at t
%subsequent periods impulse 
for i=1:nimp
   impt=ly*beta;
   ly=[impt ly(:,1:(lags-1)*k)];
   imp=cat(1,imp,impt);
end
Factors_impresp=[imp(:,2:end) imp(:,1)];
data_impresp(21*(mc-1)+1:21*mc,:)=Factors_impresp*(Loadings.*kron(ones(nfactors+1,1),sdFrancisco));
end
save data_impresp.dat data_impresp -ascii