%cd 'Francisco'
% This program computes estimates of the number of factors according
% to Bai-Ng criterion

% First, get the data. 

for z=1:1000
data_generator
Francisco=DATA';
sdFrancisco=std(Francisco);
[T,n]=size(Francisco);
data=(Francisco-repmat(mean(Francisco),T,1))./repmat(sdFrancisco,T,1);
dataclean=data';

% Now the data is in the n by T matrix called dataclean
z
%z=1;
[nn,TT]=size(dataclean);
dataclean=dataclean(randperm(nn),:);

% Set the maximum number of static factors at 10
rmax=10;
%RO=[0.4;0.6;0.8];
mpar1=2;
mpar2=1;
mpar3=.5;

% use Bai and Ng with rmax=10 to determine the number of static factors
[V,D]=eig(dataclean*dataclean'/TT);
[d,nd]=sort(diag(D));
d=flipdim(d,1);
nd=flipdim(nd,1);
V=V(:,nd);
Vhat=V(:,1:rmax);%first kmax eigenvectors
dhat=d(1:rmax,1);%first kmax eigenvalues
LAMBDA=Vhat*sqrt(nn);
FACTORS=LAMBDA'*dataclean/nn;
ER=dataclean-LAMBDA*FACTORS;
sum1=sum(ER.^2);
sighat=sum(sum1')/(nn*TT);
IC2=0;
for k=1:(rmax+1)
    if k==1
        sum1=sum((dataclean).^2);
    else
        sum1=sum((dataclean-LAMBDA(:,1:(k-1))*FACTORS(1:(k-1),:)).^2);
    end
    sum2=sum(sum1')/(nn*TT);
    IC2(k,1)=log(sum2)+(k-1)*((nn+TT)/(nn*TT))*log(min(nn,TT));
end
[waste,IC2nt]=min(IC2);
ic2=IC2nt-1;
if ic2==0
    Q(1:12,z)=zeros(12,1);
else
% next get residuals from VAR(4) for factors and estimate 
% their covariance and correlation matrices
F=FACTORS(1:ic2,:);
Y=F(:,5:end)';
X=[ones(TT-4,1) F(:,1:end-4)' F(:,2:end-3)' F(:,3:end-2)' F(:,4:end-1)'];
beta=inv(X'*X)*X'*Y;
u=Y-X*beta;
sigmau=u'*u/(TT-4);
stanu=std(u);
standard_u=u./kron(ones(TT-4,1),stanu);
corru=standard_u'*standard_u/(TT-4);
% Form statistics D1 and D2 and estimate the number of dynamic factors
[v,d]=eig(sigmau);
dcov=flipdim(sort(diag(d)),1);
[v,d]=eig(corru);
dcor=flipdim(sort(diag(d)),1);
D1cov=sqrt(dcov.^2/(dcov'*dcov));
D1cor=sqrt(dcor.^2/(dcor'*dcor));
D2cov=[1;sqrt(1-(cumsum(dcov(1:end-1,1).^2))/(dcov'*dcov))];
D2cor=[1;sqrt(1-(cumsum(dcor(1:end-1,1).^2))/(dcor'*dcor))];
[ww,ww1]=size(D1cov);
Q(1,z)=ww-sum(D1cov<mpar1/min(nn^(2/5),TT^(2/5)));
Q(2,z)=ww-sum(D1cov<mpar2/min(nn^(2/5),TT^(2/5)));
Q(3,z)=ww-sum(D1cov<mpar3/min(nn^(2/5),TT^(2/5)));
Q(4,z)=ww-sum(D2cov<mpar1/min(nn^(2/5),TT^(2/5)));
Q(5,z)=ww-sum(D2cov<mpar2/min(nn^(2/5),TT^(2/5)));
Q(6,z)=ww-sum(D2cov<mpar3/min(nn^(2/5),TT^(2/5)));
   
Q(7,z)=ww-sum(D1cor<mpar1/min(nn^(2/5),TT^(2/5)));
Q(8,z)=ww-sum(D1cor<mpar2/min(nn^(2/5),TT^(2/5)));
Q(9,z)=ww-sum(D1cor<mpar3/min(nn^(2/5),TT^(2/5)));
Q(10,z)=ww-sum(D2cor<mpar1/min(nn^(2/5),TT^(2/5)));
Q(11,z)=ww-sum(D2cor<mpar2/min(nn^(2/5),TT^(2/5)));
Q(12,z)=ww-sum(D2cor<mpar3/min(nn^(2/5),TT^(2/5)));
end
end
save BNestimate.dat Q -ascii