/*
This is to replicate the OCMT results in Chudik, Kapetanios & Pesaran (2018, Econometrica), henceforth CKP
Please make sure that you already have installed the new Stata commands "baing" and "ocmt"
You must also have installed the user-written Stata command "regsave". If you do not have it, please use "ssc install"
*/

clear all
set more off

* Please change root directory as required
* cd "C:\Users\hecto\Dropbox (CIDE A.C.)\OCMT"
cd "D:\JESUS\Jgo\OCMT\Replication"


/*
Data management for the monthly variables
Sample period 1960M2:2008M11
Data are organised in columns (74 variables), with the first being the transformation code. 
The first monthly observation is in the second row. (586 monthly time periods)
Data first sequentially sample the monthly variables into quarterly frequency (second month of each quarter)   
The transformation codes are (Stock & Watson 2002; Appendix B):
1 = no transformation
2 = first difference
3 = second differences
4 = logarithm
5 = first difference of logarithms
6 = second difference of logarithms
*/
	
import delimited "empir_m.txt", clear

rename v* mv*

foreach x of varlist mv* {
gen trans_`x' = `x'[1] 
}

egen year = seq(), from(1960) to(2008) block(12)
egen month = seq(), to(12)

gen quarter = .
replace quarter = 1 if month == 2
replace quarter = 2 if month == 5
replace quarter = 3 if month == 8 
replace quarter = 4 if month == 11  

drop if mi(quarter)
gen dateq = yq(year, quarter)
format dateq %tq
drop year month quarter

order dateq

save empir_m.dta, replace


import delimited "cpi.txt", clear

rename v1 cpi

foreach x of varlist cpi {
gen trans_`x' = `x'[1] 
}

egen year = seq(), from(1960) to(2008) block(12)
egen month = seq(), to(12)

gen quarter = .
replace quarter = 1 if month == 2
replace quarter = 2 if month == 5
replace quarter = 3 if month == 8 
replace quarter = 4 if month == 11  

drop if mi(quarter)
gen dateq = yq(year, quarter)
format dateq %tq
drop year month quarter

order dateq

save cpi.dta, replace


/*
Data management for the quarterly variables
Sample period 1960Q1 to 2008Q4
Data are organized in columns (34 variables), with the first being the transformation code.
The first quarterly observation is in the second row. (196 quarterly time periods)
The transformation codes are (Stock & Watson 2002; Appendix B):
1 = no transformation
2 = first difference
3 = second differences
4 = logarithm
5 = first difference of logarithms
6 = second difference of logarithms
*/
	
	
import delimited "empir_q.txt", clear

rename v* qv*

foreach x of varlist qv* {
gen trans_`x' = `x'[1] 
}

drop if _n==1

egen year = seq(), from(1960) to(2008) block(4)
egen quarter = seq(), to(4)
gen dateq = yq(year, quarter)
drop year quarter
format dateq %tq

order dateq

save empir_q.dta, replace


import delimited "gdp.txt", clear

rename v1 gdp

foreach x of varlist gdp {
gen trans_`x' = `x'[1] 
}

drop if _n==1

egen year = seq(), from(1960) to(2008) block(4)
egen quarter = seq(), to(4)
gen dateq = yq(year, quarter)
drop year quarter
format dateq %tq

order dateq

save gdp.dta, replace


// Merge the four quarterly datasets

use empir_q.dta, clear
merge 1:1 dateq using empir_m
drop _merge

merge 1:1 dateq using cpi
drop _merge

merge 1:1 dateq using gdp
drop _merge

order dateq

// This is to apply the data transformation codes used by Stock & Watson (2002, JBES)

tsset dateq

foreach x of varlist qv* mv* cpi gdp {

if trans_`x'[1] == 1 {
	qui gen double z`x' = `x'  
}
else if trans_`x'[1] == 2 {
	qui gen double z`x' = `x' - l.`x'
}
else if trans_`x'[1] == 3 {
	qui gen double z`x' = `x' - 2*(l.`x') + (l2.`x')
}
else if trans_`x'[1] == 4 {
	qui gen double z`x' = log(`x')   
}
else if trans_`x'[1] == 5 {
	qui gen double z`x' = log(`x') - log(l.`x')
}
else if trans_`x'[1] == 6 {
	qui gen double z`x' = log(`x') - 2*log(l.`x') + log(l2.`x')
}
}

keep dateq z*

rename z* *

order dateq gdp cpi 

keep if dateq>=tq(1960q3) & dateq<=tq(2008q3)

save database, replace

// This imports the names of the series used by Stock & Watson (2002, JBES)
clear all
import delimited SWnames.txt, varnames(1) 
save SWnames , replace

