/*
This is to replicate the OCMT results in Chudik, Kapetanios & Pesaran (2018, Econometrica), henceforth CKP
Please make sure that you already have installed the new Stata commands "baing" and "ocmt"
You must also have installed the user-written Stata command "regsave". If you do not have it, please use "ssc install"
*/

clear all
set more off

* Please change root directory as required
* cd "C:\Users\hecto\Dropbox (CIDE A.C.)\OCMT"
cd "D:\JESUS\Jgo\OCMT\Replication"


use database, clear

// This is to drop the first 3 observation which are not used by CKP (2018)
local obsadj = 3

// This is to determine the number of common factors using the information criteria advocated by Bai & Ng (2002, Econometrica)
// Must be either 1, 2 or 3 for IC1, IC2 and IC3, respectively

local mycrit = 1

// This is the first sub-sample in the rolling estimation
local ini = `=q(1960q3)' - 1
local end = `=q(1990q2)' - 1

tempfile tmpfile

local replace "replace"

foreach j of varlist cpi gdp{
// This is to set the number of rolling windows over the full sample	
forvalues ssample = 1/74 {
	
	display `ssample' " out of 74 for target variable `j' (IC`mycrit')"

	preserve
	qui keep if dateq >= `ini'+`ssample' & dateq<=`end'+`ssample'
	qui keep dateq `j' qv* mv*
	qui tsset dateq

	qui gen t = _n
	
	// This is to determine the number of factors following Bai & Ng (2002, Econometrica)
	// All variables are standardised, hence "baing" command with option "stand"
	qui baing `j' qv* mv* if t> `obsadj' , max(5) stand prefix(myfactors) crit(`mycrit')
	local numfactors = r(baing_ic)
	
    forvalues i=1/`numfactors' {
	 qui gen factors`i' = l`obsadj'.myfactors`i'
    }

    drop myfactors*
	
	// This applies OCMT using the ocmt command
	qui ocmt `j' l1.qv* l1.mv* l(1/4).`j' , delta1(1) delta2(2) zvar(l1.factor*) 
	// This saves ocmt results
    qui regsave using "`tmpfile'", tstat pval detail(scalars) addlabel(subsample,"`ssample'",target,"`j'")  `replace'
    local replace "append"
	
	restore
	
	local ++ssample
}
// This saves ocmt results in one file
preserve
use "`tmpfile'", clear
save CKP_ocmt_IC`mycrit', replace
restore
}


use CKP_ocmt_IC`mycrit', clear
// This builds a table with the frequency with which each variable is selected by OCMT
quietly{
gen factorout = 1 if strmatch(var, "*factor*")
drop if factorout == 1
drop factorout
encode var, generate(varn)
bysort target subsample: egen counter = count(varn)
/// This adjustment is required to compute the average in the models that select 0 variables
replace counter = counter -1 

preserve
// This calculates the average number of selected variables (excluding preselected factors and constant term) 
collapse counter, by(target subsample)
sum counter if target == "gdp"
local av_gdp = r(mean)
sum counter if target == "cpi"
local av_cpi = r(mean)
restore

drop if var =="_cons"
collapse (count) coef, by(var target)
gen select = (coef/74)*100

}
// This adds the names to the series as used by Stock & Watson (2002, JBES)
merge m:1 var using SWnames
drop if _merge == 2
drop _merge

gsort target -select
browse target vlabel select 

keep target vlabel select
encode target, generate(ntarget)
gen bn = ntarget[_n] - ntarget[_n-1]
drop ntarget
qui replace bn = _n if bn == 1
qui sum bn
local bn = r(max)
drop bn
qui insobs 1, before(`bn')
qui insobs 1, after(_N) 
qui replace target = target[_n-1] if target == ""
qui replace vlabel = "Average number of selected variables (excluding preselected factors and constant term)" if vlabel == ""
qui replace select = `av_gdp' if target == "gdp" & select == .
qui replace select = `av_cpi' if target == "cpi" & select == .
qui insobs 1, after(`bn')