%% Housekeeping
close all
clear
clc
%% Run Dynare Mod File
dynare NKShadow;
%% Load Estimation Results
load SignIrfs
NoIRFs=8;
TargetMoms=100*SignIrfs(1:NoIRFs,:,1);
NoIrfs=size(TargetMoms,1);
Wmatrix=diag([ones(NoIrfs,1);
    ones(NoIrfs,1);
    ones(NoIrfs-0,1);
    [1*ones(NoIrfs,1);ones(NoIrfs-NoIrfs,1)];
    [1*ones(NoIrfs,1);ones(NoIrfs-NoIrfs,1)]]);
%% Estimation Info
[PiorInfo,EstimParmA]=xlsread('xls_files/PriorInfo.xlsx');
ParmNames=EstimParmA(2:end,1);
ParmNamesIndex=find_variable_indices(ParmNames,cellstr(M_.param_names));
parm0=M_.params(ParmNamesIndex);
varNames={'y';'pi';'i';'cbassets';'sb'};
varIndex=find_variable_indices(varNames,cellstr(M_.endo_names));
shkIndex=1;
%% Model Estimation
dcx=@(parm0)dynare_bayesian_mde(parm0,varIndex,shkIndex,TargetMoms,Wmatrix,PiorInfo,NoIrfs,ParmNames);
options = optimset;
options = optimset(options,'Display','iter');
options = optimset(options,'MaxFunEvals',1e4);
options = optimset(options,'MaxIter',1e4);
options = optimset(options,'LargeScale' ,'off');
options = optimset(options,'TolX',1e-12);
options = optimset(options,'TolFun',1e-12);
options = optimset(options,'FinDiffType','central');

parmhat=fmincon(dcx,parm0,[],[],[],[],PiorInfo(:,end-1),PiorInfo(:,end),[],options);
%% Model Fit
[ObjFun,IRFs,new_oo_,new_M_]=dynare_bayesian_mde(parmhat,...
    varIndex,shkIndex,TargetMoms,Wmatrix,PiorInfo,NoIrfs,ParmNames);

xxx=1:NoIrfs;
figure
orient landscape
for i = 1 : size(TargetMoms,2)
    subplot(2,3,i)
    plot(xxx,TargetMoms(:,i),'-b',xxx,100*SignIrfs(1:NoIRFs,i,2),'--b',xxx,100*SignIrfs(1:NoIRFs,i,3),'--b',xxx,IRFs(:,i),'-r','LineWidth',2)
    axis tight
    title(varNames{i})
end

%% Save Estimation Results
save IrfMdeResults IRFs parmhat