%% Housekeeping
close all
clear
clc
%% Run Dynare Mod File
dynare NKShadow;
%% Load Estimation Results
load SignIrfs
TargetMoms=100*SignIrfs(:,:,1);
NoIrfs=size(TargetMoms,1);
Wmatrix=diag([ones(NoIrfs,1);
    ones(NoIrfs,1);
    ones(NoIrfs-0,1);
    [1*ones(NoIrfs,1);ones(NoIrfs-NoIrfs,1)];
    [1*ones(NoIrfs,1);ones(NoIrfs-NoIrfs,1)]]);
%% Load IRF Matching Results
load IrfMdeResults
%% Parameters Information
[PiorInfo,EstimParmA]=xlsread('xls_files/PriorInfo.xlsx');
ParmNames=EstimParmA(2:end,1);
ParmNamesIndex=find_variable_indices(ParmNames,cellstr(M_.param_names));
varNames={'y';'pi';'i';'cbassets';'sb'};
varIndex=find_variable_indices(varNames,cellstr(M_.endo_names));
shkIndex=1;
bayestopt_.pshape=PiorInfo(:,1);
bayestopt_.p6=parmhat;%PiorInfo(:,2);
bayestopt_.p7=PiorInfo(:,3);
bayestopt_.p3=PiorInfo(:,4);
bayestopt_.p4=PiorInfo(:,5);
bayestopt_.lb=PiorInfo(:,4);
bayestopt_.ub=PiorInfo(:,5);
%% Simulations
pdraw = prior_draw(1)';
NoIters=1000;
iter=0;
ParmDraws=zeros(size(PiorInfo,1),NoIters);
IRFsDraws=zeros(NoIrfs,size(TargetMoms,2),NoIters);
while iter < NoIters
    
    pdraw = prior_draw(0)';
    
    
    [ObjFun,IRFs]=dynare_bayesian_mde(pdraw,varIndex,shkIndex,TargetMoms,Wmatrix,PiorInfo,NoIrfs,ParmNames);
    if ObjFun < 1000 && IRFs(1,3) < 0 %%&& IRFs(2,3) < 0.5;
        iter=iter+1
        ParmDraws(:,iter)=pdraw;
        IRFsDraws(:,:,iter)=IRFs;
    end
    
end
DistIRFs=quantile(IRFsDraws,[0.5 0.16 0.84],3);
DistParmDraws=quantile(ParmDraws,[0.5 0.16 0.84],2);
%% Plot
NoIrfsPlot=8;
xxx=1:NoIrfsPlot;

figure
orient landscape
for i = 1 : size(TargetMoms,2)
    subplot(2,3,i)
    plot(xxx,TargetMoms(1:NoIrfsPlot,i),'-b',xxx,DistIRFs(1:NoIrfsPlot,i,1),'-r',xxx,DistIRFs(1:NoIrfsPlot,i,2),'--r',xxx,DistIRFs(1:NoIrfsPlot,i,3),'--r','LineWidth',2)
    axis tight
    title(varNames{i})
end
