function [ObjFun,IRFs,new_oo_,new_M_]=dynare_bayesian_mde(estim_values,...
    varIndex,shkIndex,TargetMoms,Wmatrix,parainfo,NoIrfs,ParmNames)

global M_ options_ oo_

% if size(estim_values,1) == 1;
%     estim_values = estim_values';
% end;

for i = 1 : size(ParmNames,1)
    eval(['set_param_value(ParmNames{i},','estim_values(i));'])
end
%% 
ParmNames=cellstr(M_.param_names);
for i = 1 : M_.param_nbr
    TermA=ParmNames{i};
    eval([TermA,'=M_.params(',num2str(i),',:);']);
end


XIb     = ( Nb_Sb + SIGMAb*Rm*(1-Nb_Sb) - SIGMAb*Rk ) / Rk ;
LAMBDAb = ( (Rk-Rm)/Rm )*(1/Nb_Sb) ;
OMEGAb  = (1-SIGMAb)/(1 - SIGMAb*(1+LAMBDAb)*cbeta*Rm ) ;
Vb      = cbeta*OMEGAb*Rm ;
MUb     = cbeta*OMEGAb*(Rk - Rm);
THETAb  = MUb + MUb/LAMBDAb ;
R = cbeta^-1 ;
D_Sc = 1 + Mc_Sc - Nc_Sc ;
XIc = (Nc_Sc + SIGMAc*R*D_Sc - SIGMAc*(Rk + Rm*Mc_Sc)) / (Rk + Rm*Mc_Sc) ;
omega = (Rk - Rm) / (Rk - R) ;
LAMBDAc = ( (Rk-R)/R )*( omega+ (1-omega)*(Nc_Sc + D_Sc))/Nc_Sc ;
OMEGAc = (1-SIGMAc)/(1-SIGMAc*(1+LAMBDAc)) ;
VMc = cbeta*OMEGAc*Rm ;
VDc = cbeta*OMEGAc*R ;
MUc = cbeta*OMEGAc*(Rk-Rm) ;
THETAc = (MUc/omega)*(1 + (1/LAMBDAc)) ;
K_Y = calpha / (Rk - (1-delta)) ;
K = (2/3)*( K_Y^(1/(1-calpha)) ) ;
QM = K*(1 - Nb_Sb) / ( 1 + (1/Mc_Sc)*(1 - Nb_Sb) ) ;
Sc = (1/Mc_Sc)*QM ;
Sb = K - Sc ;
Sc_K = Sc / K ;
c_y = 1 - calpha*delta/(Rk - (1-delta)); 

set_param_value('XIb',XIb);
set_param_value('LAMBDAb',LAMBDAb);
set_param_value('OMEGAb',OMEGAb);
set_param_value('Vb',Vb);
set_param_value('MUb',MUb);
set_param_value('THETAb',THETAb);
set_param_value('R',R);
set_param_value('D_Sc',D_Sc);
set_param_value('XIc',XIc);
set_param_value('omega',omega);
set_param_value('LAMBDAc',LAMBDAc);
set_param_value('OMEGAc',OMEGAc);
set_param_value('VMc',VMc);
set_param_value('VDc',VDc);
set_param_value('MUc',MUc);
set_param_value('THETAc',THETAc);
set_param_value('K_Y',K_Y);
set_param_value('K',K);
set_param_value('QM',QM);
set_param_value('Sc',Sc);
set_param_value('Sb',Sb);
set_param_value('Sc_K',Sc_K);
set_param_value('c_y',c_y);

%% Objective Function
try
    [oo_.dr,info,M_,options_] = resol(0,M_,options_,oo_);
    
    if info(1,1) == 0
        
       logged_prior_density = priordens(estim_values,parainfo(:,1),parainfo(:,2), parainfo(:,3),parainfo(:,4),parainfo(:,5),1);
        
        ex_=zeros(NoIrfs,M_.exo_nbr);
        ex_(1,shkIndex)=-1;
        
        ysimshk=simult_(oo_.dr.ys,oo_.dr,ex_,options_.order);
        IRFs=ysimshk(varIndex,2:end)'-repmat(oo_.dr.ys(varIndex)',NoIrfs,1);
        
        IRFs(:,2)=cumsum(IRFs(:,2)); %CPI
        IRFs(:,3)=4*IRFs(:,3);       %Annual Rate

        DiffVec=IRFs(:)-TargetMoms(:);
        
        ObjFun=DiffVec'*Wmatrix*DiffVec;%-logged_prior_density;
        new_oo_=oo_;
        new_M_=M_;
        
    else
        ObjFun=1e10;
        IRFs=[];
        new_oo_=[];
        new_M_=[];
    end
catch
    ObjFun=1e10;
    IRFs=[];
    new_oo_=[];
    new_M_=[];
end