function [residual, g1, g2, g3] = NKShadow_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [M_.exo_nbr by nperiods] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(49, 1);
T245 = (1-params(30)-params(31))*params(14)*1/params(5);
residual(1) = y(67)-y(18)+y(19)-y(68);
lhs =y(18);
rhs =(-params(2))*(1/(1-params(3))*y(21)-params(3)/(1-params(3))*y(3));
residual(2)= lhs-rhs;
lhs =y(22);
rhs =1/params(4)*y(23)-y(18);
residual(3)= lhs-rhs;
lhs =y(24);
rhs =params(1)*y(4)+y(23)*(1-params(1));
residual(4)= lhs-rhs;
lhs =y(26);
rhs =y(22)-(y(24)-y(23));
residual(5)= lhs-rhs;
lhs =y(26);
rhs =y(31)-(y(24)-y(4));
residual(6)= lhs-rhs;
lhs =params(22)*(y(5)+y(28));
rhs =y(31)*(params(22)-(1-params(8)))+(1-params(8))*y(27);
residual(7)= lhs-rhs;
lhs =y(20)-params(6)*y(2);
rhs =params(5)*(y(68)-y(20)*params(6))+y(26)*params(7);
residual(8)= lhs-rhs;
lhs =y(29);
rhs =1/(1+params(5))*y(6)+params(5)/(1+params(5))*y(70)+y(27)*1/params(12);
residual(9)= lhs-rhs;
lhs =y(25);
rhs =y(4)*(1-params(8))+params(8)*y(29);
residual(10)= lhs-rhs;
lhs =y(24);
rhs =y(21)*params(27)+y(29)*(1-params(27));
residual(11)= lhs-rhs;
lhs =y(19)-y(68);
rhs =y(30);
residual(12)= lhs-rhs;
lhs =y(19);
rhs =params(9)*y(1)+(1-params(9))*(y(20)*params(10)+params(11)*y(43))+y(62);
residual(13)= lhs-rhs;
lhs =y(25);
rhs =params(41)*y(53)+(1-params(41))*y(44);
residual(14)= lhs-rhs;
lhs =y(27)+y(44);
rhs =params(13)*y(45)+(1-params(13))*(y(46)+y(47));
residual(15)= lhs-rhs;
lhs =params(13)*y(45);
rhs =params(22)*(params(14)+params(15))*(y(5)+y(28)+y(12))-(1-params(13))*params(14)*params(16)*(y(48)+y(13)+y(14));
residual(16)= lhs-rhs;
lhs =params(17)*params(18)*y(49)-params(18)*params(19)*(y(49)+y(50));
rhs =params(19)*y(50);
residual(17)= lhs-rhs;
lhs =(y(27)+y(44))*params(17)-params(19)*(y(44)+y(27)+y(50));
rhs =params(13)*params(20)*(y(45)+y(51));
residual(18)= lhs-rhs;
lhs =params(21)*y(52);
rhs =y(51)*params(20)*params(14)*(1+params(18))+y(49)*params(18)*params(14)*params(20);
residual(19)= lhs-rhs;
lhs =y(51);
rhs =y(67)-y(18)+y(75)+y(74);
residual(20)= lhs-rhs;
lhs =params(19)*y(50);
rhs =(y(67)-y(18)+y(75))*params(5)*params(21)*(params(22)-params(16))+params(5)*params(21)*(params(22)*y(69)-params(16)*y(74));
residual(21)= lhs-rhs;
lhs =params(16)*(y(48)+y(13));
rhs =y(31)*(params(16)-(1-params(8)))+(1-params(8))*y(46);
residual(22)= lhs-rhs;
lhs =y(47);
rhs =y(54);
residual(23)= lhs-rhs;
lhs =y(27)+y(53)+params(30)*(y(46)+y(54));
rhs =(1-params(30)-params(31))*y(55)+params(31)*y(56);
residual(24)= lhs-rhs;
lhs =params(31)*y(56);
rhs =(params(14)+params(33))*(params(22)*(y(5)+y(28)+y(15))+params(16)*params(30)*(y(48)+y(13)+y(16)))-T245*(y(7)+y(17));
residual(25)= lhs-rhs;
lhs =params(34)*params(35)*params(36)*y(57)-params(36)*params(37)*(y(57)+y(58));
rhs =params(37)*y(58);
residual(26)= lhs-rhs;
lhs =(y(27)+y(53))*(params(34)*params(35)-params(37))-params(37)*y(58);
rhs =y(56)*params(31)*(params(38)-params(34)*(1-params(35)))+y(55)*(params(38)-params(39)-params(34)*(1-params(35)))*params(32)+params(38)*(params(31)+params(32))*y(59)-params(39)*params(32)*y(60);
residual(27)= lhs-rhs;
lhs =y(57)*params(36)*(params(38)-params(39))+(1+params(36))*(params(38)*y(59)-params(39)*y(60));
rhs =y(57)*params(36)*params(34)*(1-params(35));
residual(28)= lhs-rhs;
lhs =params(40)*y(61);
rhs =y(60)*params(39)*params(14)*(1+params(36))+y(57)*params(39)*params(14)*params(36);
residual(29)= lhs-rhs;
lhs =y(59);
rhs =y(74)+y(67)-y(18)+y(76);
residual(30)= lhs-rhs;
lhs =params(37)*y(58);
rhs =(params(22)*y(69)-params(16)*y(74))*params(5)*params(40)+(y(67)-y(18)+y(76))*(params(22)-params(16))*params(5)*params(40);
residual(31)= lhs-rhs;
lhs =y(60);
rhs =y(30)+y(67)-y(18)+y(76);
residual(32)= lhs-rhs;
lhs =y(43);
rhs =y(24)-y(36);
residual(33)= lhs-rhs;
residual(34) = y(71)-y(32)+y(41);
lhs =y(32);
rhs =(-params(2))*(1/(1-params(3))*y(33)-params(3)/(1-params(3))*y(8));
residual(35)= lhs-rhs;
lhs =y(34);
rhs =1/params(4)*y(35)-y(32);
residual(36)= lhs-rhs;
lhs =y(36);
rhs =params(1)*y(9)+(1-params(1))*y(35);
residual(37)= lhs-rhs;
lhs =0;
rhs =y(34)-(y(36)-y(35));
residual(38)= lhs-rhs;
lhs =0;
rhs =y(42)-(y(36)-y(9));
residual(39)= lhs-rhs;
lhs =params(22)*(y(10)+y(39));
rhs =(params(22)-(1-params(8)))*y(42)+(1-params(8))*y(38);
residual(40)= lhs-rhs;
lhs =y(40);
rhs =1/(1+params(5))*y(11)+params(5)/(1+params(5))*y(73)+1/params(12)*y(38);
residual(41)= lhs-rhs;
lhs =y(37);
rhs =(1-params(8))*y(9)+params(8)*y(40);
residual(42)= lhs-rhs;
lhs =y(36);
rhs =params(27)*y(33)+(1-params(27))*y(40);
residual(43)= lhs-rhs;
lhs =y(72);
rhs =y(41);
residual(44)= lhs-rhs;
lhs =y(62);
rhs =params(42)*x(it_, 1);
residual(45)= lhs-rhs;
lhs =y(63);
rhs =y(69)-y(30);
residual(46)= lhs-rhs;
lhs =y(64);
rhs =y(27)+y(44);
residual(47)= lhs-rhs;
lhs =y(65);
rhs =y(27)+y(53);
residual(48)= lhs-rhs;
lhs =y(66);
rhs =y(53)*1/(1+params(30))+y(54)*params(30)/(1+params(30));
residual(49)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(49, 77);

  %
  % Jacobian matrix
  %

  g1(1,18)=(-1);
  g1(1,67)=1;
  g1(1,19)=1;
  g1(1,68)=(-1);
  g1(2,18)=1;
  g1(2,3)=(-((-params(2))*(-(params(3)/(1-params(3))))));
  g1(2,21)=(-((-params(2))*1/(1-params(3))));
  g1(3,18)=1;
  g1(3,22)=1;
  g1(3,23)=(-(1/params(4)));
  g1(4,23)=(-(1-params(1)));
  g1(4,24)=1;
  g1(4,4)=(-params(1));
  g1(5,22)=(-1);
  g1(5,23)=(-1);
  g1(5,24)=1;
  g1(5,26)=1;
  g1(6,24)=1;
  g1(6,4)=(-1);
  g1(6,26)=1;
  g1(6,31)=(-1);
  g1(7,5)=params(22);
  g1(7,27)=(-(1-params(8)));
  g1(7,28)=params(22);
  g1(7,31)=(-(params(22)-(1-params(8))));
  g1(8,2)=(-params(6));
  g1(8,20)=1-params(5)*(-params(6));
  g1(8,68)=(-params(5));
  g1(8,26)=(-params(7));
  g1(9,27)=(-(1/params(12)));
  g1(9,6)=(-(1/(1+params(5))));
  g1(9,29)=1;
  g1(9,70)=(-(params(5)/(1+params(5))));
  g1(10,4)=(-(1-params(8)));
  g1(10,25)=1;
  g1(10,29)=(-params(8));
  g1(11,21)=(-params(27));
  g1(11,24)=1;
  g1(11,29)=(-(1-params(27)));
  g1(12,19)=1;
  g1(12,68)=(-1);
  g1(12,30)=(-1);
  g1(13,1)=(-params(9));
  g1(13,19)=1;
  g1(13,20)=(-((1-params(9))*params(10)));
  g1(13,43)=(-((1-params(9))*params(11)));
  g1(13,62)=(-1);
  g1(14,25)=1;
  g1(14,44)=(-(1-params(41)));
  g1(14,53)=(-params(41));
  g1(15,27)=1;
  g1(15,44)=1;
  g1(15,45)=(-params(13));
  g1(15,46)=(-(1-params(13)));
  g1(15,47)=(-(1-params(13)));
  g1(16,5)=(-(params(22)*(params(14)+params(15))));
  g1(16,28)=(-(params(22)*(params(14)+params(15))));
  g1(16,12)=(-(params(22)*(params(14)+params(15))));
  g1(16,45)=params(13);
  g1(16,13)=(1-params(13))*params(14)*params(16);
  g1(16,14)=(1-params(13))*params(14)*params(16);
  g1(16,48)=(1-params(13))*params(14)*params(16);
  g1(17,49)=params(17)*params(18)-params(18)*params(19);
  g1(17,50)=(-(params(18)*params(19)))-params(19);
  g1(18,27)=params(17)-params(19);
  g1(18,44)=params(17)-params(19);
  g1(18,45)=(-(params(13)*params(20)));
  g1(18,50)=(-params(19));
  g1(18,51)=(-(params(13)*params(20)));
  g1(19,49)=(-(params(18)*params(14)*params(20)));
  g1(19,51)=(-(params(20)*params(14)*(1+params(18))));
  g1(19,52)=params(21);
  g1(20,18)=1;
  g1(20,67)=(-1);
  g1(20,74)=(-1);
  g1(20,51)=1;
  g1(20,75)=(-1);
  g1(21,18)=params(5)*params(21)*(params(22)-params(16));
  g1(21,67)=(-(params(5)*params(21)*(params(22)-params(16))));
  g1(21,69)=(-(params(22)*params(5)*params(21)));
  g1(21,74)=(-(params(5)*params(21)*(-params(16))));
  g1(21,50)=params(19);
  g1(21,75)=(-(params(5)*params(21)*(params(22)-params(16))));
  g1(22,31)=(-(params(16)-(1-params(8))));
  g1(22,13)=params(16);
  g1(22,46)=(-(1-params(8)));
  g1(22,48)=params(16);
  g1(23,47)=1;
  g1(23,54)=(-1);
  g1(24,27)=1;
  g1(24,46)=params(30);
  g1(24,53)=1;
  g1(24,54)=params(30);
  g1(24,55)=(-(1-params(30)-params(31)));
  g1(24,56)=(-params(31));
  g1(25,5)=(-(params(22)*(params(14)+params(33))));
  g1(25,28)=(-(params(22)*(params(14)+params(33))));
  g1(25,7)=T245;
  g1(25,13)=(-((params(14)+params(33))*params(16)*params(30)));
  g1(25,48)=(-((params(14)+params(33))*params(16)*params(30)));
  g1(25,15)=(-(params(22)*(params(14)+params(33))));
  g1(25,16)=(-((params(14)+params(33))*params(16)*params(30)));
  g1(25,17)=T245;
  g1(25,56)=params(31);
  g1(26,57)=params(34)*params(35)*params(36)-params(36)*params(37);
  g1(26,58)=(-(params(36)*params(37)))-params(37);
  g1(27,27)=params(34)*params(35)-params(37);
  g1(27,53)=params(34)*params(35)-params(37);
  g1(27,55)=(-((params(38)-params(39)-params(34)*(1-params(35)))*params(32)));
  g1(27,56)=(-(params(31)*(params(38)-params(34)*(1-params(35)))));
  g1(27,58)=(-params(37));
  g1(27,59)=(-(params(38)*(params(31)+params(32))));
  g1(27,60)=params(39)*params(32);
  g1(28,57)=params(36)*(params(38)-params(39))-params(36)*params(34)*(1-params(35));
  g1(28,59)=params(38)*(1+params(36));
  g1(28,60)=(1+params(36))*(-params(39));
  g1(29,57)=(-(params(39)*params(14)*params(36)));
  g1(29,60)=(-(params(39)*params(14)*(1+params(36))));
  g1(29,61)=params(40);
  g1(30,18)=1;
  g1(30,67)=(-1);
  g1(30,74)=(-1);
  g1(30,59)=1;
  g1(30,76)=(-1);
  g1(31,18)=(params(22)-params(16))*params(5)*params(40);
  g1(31,67)=(-((params(22)-params(16))*params(5)*params(40)));
  g1(31,69)=(-(params(22)*params(5)*params(40)));
  g1(31,74)=(-(params(5)*params(40)*(-params(16))));
  g1(31,58)=params(37);
  g1(31,76)=(-((params(22)-params(16))*params(5)*params(40)));
  g1(32,18)=1;
  g1(32,67)=(-1);
  g1(32,30)=(-1);
  g1(32,60)=1;
  g1(32,76)=(-1);
  g1(33,24)=(-1);
  g1(33,36)=1;
  g1(33,43)=1;
  g1(34,32)=(-1);
  g1(34,71)=1;
  g1(34,41)=1;
  g1(35,32)=1;
  g1(35,8)=(-((-params(2))*(-(params(3)/(1-params(3))))));
  g1(35,33)=(-((-params(2))*1/(1-params(3))));
  g1(36,32)=1;
  g1(36,34)=1;
  g1(36,35)=(-(1/params(4)));
  g1(37,35)=(-(1-params(1)));
  g1(37,36)=1;
  g1(37,9)=(-params(1));
  g1(38,34)=(-1);
  g1(38,35)=(-1);
  g1(38,36)=1;
  g1(39,36)=1;
  g1(39,9)=(-1);
  g1(39,42)=(-1);
  g1(40,10)=params(22);
  g1(40,38)=(-(1-params(8)));
  g1(40,39)=params(22);
  g1(40,42)=(-(params(22)-(1-params(8))));
  g1(41,38)=(-(1/params(12)));
  g1(41,11)=(-(1/(1+params(5))));
  g1(41,40)=1;
  g1(41,73)=(-(params(5)/(1+params(5))));
  g1(42,9)=(-(1-params(8)));
  g1(42,37)=1;
  g1(42,40)=(-params(8));
  g1(43,33)=(-params(27));
  g1(43,36)=1;
  g1(43,40)=(-(1-params(27)));
  g1(44,72)=1;
  g1(44,41)=(-1);
  g1(45,62)=1;
  g1(45,77)=(-params(42));
  g1(46,69)=(-1);
  g1(46,30)=1;
  g1(46,63)=1;
  g1(47,27)=(-1);
  g1(47,44)=(-1);
  g1(47,64)=1;
  g1(48,27)=(-1);
  g1(48,53)=(-1);
  g1(48,65)=1;
  g1(49,53)=(-(1/(1+params(30))));
  g1(49,54)=(-(params(30)/(1+params(30))));
  g1(49,66)=1;
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],49,5929);
end
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],49,456533);
end
end
