clear
clc
%%%%%benchmark calibration
%%%%%benchmark calibration

thetaFbig=0.0001:0.01:0.9;
yy=[];
yy1=[];
yy11=[];
out1=[];
out2=[];
out3=[];

out1x=[];
out2x=[];
out3x=[];
out1xx=[];
out2xx=[];
out3xx=[];
for k=1:length(thetaFbig);

beta = 0.99;                %discount factor
sigma = 1;  %intertemporal elasticity of substituion
eta =  1.0000001;    %intratemporal elasticity of substituion
phi = 3;    %inverse of frisch elasticity of labour supplu
alpha = 0.4;  %share of foreign goods in cpi basket
thetaH = 0.75;  %domestic output price calvo stickiness
thetaF = thetaFbig(k);  %domestic import price calvo stickiness
% pibar = theta(8);   %inflataion target
rhoR=0.85; %interest smoothing coefficient
rhopi=1.5; %inflation targeting coefficient
rhox=0.5; %output gap targeting coefficient
rhoa=0.9; %AR(1) coefficient for domestic produxtivity
rhoystar=0.86; %AR(1) coefficient for foreign output
sigma_a=0.71;
sigma_ystar=0.78;
sigma_er=0.7;
rho_epsa_epsy=0.3;

theta=[beta;sigma;eta;phi;alpha;thetaH;thetaF;rhoR;rhopi;rhox;rhoa;rhoystar];
[ PP,QQ,PROBLEM ] = model_matrices(theta);

if PROBLEM==0;
    
    
    % Generate data 
t=40;
Sigma=zeros(3,3);
Sigma(1,1)=sigma_er;
Sigma(2,2)=sigma_a;
Sigma(3,3)=sigma_ystar;
Sigma(2,3)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
Sigma(3,2)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
ee=zeros(t,3);
ee(2,1)=1;  %monetary policy shock
ee=ee*chol(Sigma);
ehat=zeros(t,17);
ymat=zeros(t,17);
for i=2:t
    %iid shocks
    ehat(i,:)=(QQ*ee(i,:)')';
    %data
    ymat(i,:)=(PP*ymat(i-1,:)')'+[ehat(i,:)];
end

out1=[out1 ymat(:,9)];  %real exchange rate response
out2=[out2 ymat(:,10)];
out3=[out3 ymat(:,5)];
yy=[yy;thetaFbig(k)];
end

%Foreign output
t=40;
Sigma=zeros(3,3);
Sigma(1,1)=sigma_er;
Sigma(2,2)=sigma_a;
Sigma(3,3)=sigma_ystar;
Sigma(2,3)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
Sigma(3,2)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
ee=zeros(t,3);
ee(2,3)=1;  %foreign output
ee=ee*chol(Sigma);
ehat=zeros(t,17);
ymat=zeros(t,17);
for i=2:t
    %iid shocks
    ehat(i,:)=(QQ*ee(i,:)')';
    %data
    ymat(i,:)=(PP*ymat(i-1,:)')'+[ehat(i,:)];
end

out1x=[out1x ymat(:,9)];  %real exchange rate response
out2x=[out2x ymat(:,10)];
out3x=[out3x ymat(:,5)];
yy1=[yy1;thetaFbig(k)];




%productivity
t=40;
Sigma=zeros(3,3);
Sigma(1,1)=sigma_er;
Sigma(2,2)=sigma_a;
Sigma(3,3)=sigma_ystar;
Sigma(2,3)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
Sigma(3,2)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
ee=zeros(t,3);
ee(2,2)=1;  %foreign output
ee=ee*chol(Sigma);
ehat=zeros(t,17);
ymat=zeros(t,17);
for i=2:t
    %iid shocks
    ehat(i,:)=(QQ*ee(i,:)')';
    %data
    ymat(i,:)=(PP*ymat(i-1,:)')'+[ehat(i,:)];
end

out1xx=[out1xx ymat(:,9)];  %real exchange rate response
out2xx=[out2xx ymat(:,10)];
out3xx=[out3xx ymat(:,5)];
yy11=[yy1;thetaFbig(k)];

end

h=1:39;

subplot(2,3,1)
mesh(h,yy,-1*cumsum(out1(2:end,:))')
xlabel('Horizon');
ylabel('\theta_{f}');
title('Monetary Policy Shock')
axis tight
subplot(2,3,2)
mesh(h,yy,-1*cumsum(out1x(2:end,:))')
xlabel('Horizon');
ylabel('\theta_{f}');
title('Foreign Output Shock')
axis tight
subplot(2,3,3)
mesh(h,yy,-1*cumsum(out1xx(2:end,:))')
xlabel('Horizon');
ylabel('\theta_{f}');
title('Productivity Shock')
axis tight
thetaFbig=0.0001:0.01:0.9;
yy=[];
yy1=[];
out1=[];
out2=[];
out3=[];

out1x=[];
out2x=[];
out3x=[];
out1xx=[];
out2xx=[];
out3xx=[];
yy11=[];
for k=1:length(thetaFbig);

beta = 0.99;                %discount factor
sigma = 1;  %intertemporal elasticity of substituion
eta =  1.0000001;    %intratemporal elasticity of substituion
phi = 3;    %inverse of frisch elasticity of labour supplu
alpha = 0.4;  %share of foreign goods in cpi basket
thetaH = thetaFbig(k);  %domestic output price calvo stickiness
thetaF = 0.75;  %domestic import price calvo stickiness
% pibar = theta(8);   %inflataion target
rhoR=0.85; %interest smoothing coefficient
rhopi=1.5; %inflation targeting coefficient
rhox=0.5; %output gap targeting coefficient
rhoa=0.9; %AR(1) coefficient for domestic produxtivity
rhoystar=0.86; %AR(1) coefficient for foreign output
sigma_a=0.71;
sigma_ystar=0.78;
sigma_er=0.7;
rho_epsa_epsy=0.3;

theta=[beta;sigma;eta;phi;alpha;thetaH;thetaF;rhoR;rhopi;rhox;rhoa;rhoystar];
[ PP,QQ,PROBLEM ] = model_matrices(theta);

if PROBLEM==0;
    
    
    % Generate data 
t=40;
Sigma=zeros(3,3);
Sigma(1,1)=sigma_er;
Sigma(2,2)=sigma_a;
Sigma(3,3)=sigma_ystar;
Sigma(2,3)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
Sigma(3,2)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
ee=zeros(t,3);
ee(2,1)=1;  %monetary policy shock
ee=ee*chol(Sigma);
ehat=zeros(t,17);
ymat=zeros(t,17);
for i=2:t
    %iid shocks
    ehat(i,:)=(QQ*ee(i,:)')';
    %data
    ymat(i,:)=(PP*ymat(i-1,:)')'+[ehat(i,:)];
end

out1=[out1 ymat(:,9)];  %real exchange rate response
out2=[out2 ymat(:,10)];
out3=[out3 ymat(:,5)];
yy=[yy;thetaFbig(k)];
end

%Foreign output
t=40;
Sigma=zeros(3,3);
Sigma(1,1)=sigma_er;
Sigma(2,2)=sigma_a;
Sigma(3,3)=sigma_ystar;
Sigma(2,3)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
Sigma(3,2)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
ee=zeros(t,3);
ee(2,3)=1;  %foreign output
ee=ee*chol(Sigma);
ehat=zeros(t,17);
ymat=zeros(t,17);
for i=2:t
    %iid shocks
    ehat(i,:)=(QQ*ee(i,:)')';
    %data
    ymat(i,:)=(PP*ymat(i-1,:)')'+[ehat(i,:)];
end

out1x=[out1x ymat(:,9)];  %real exchange rate response
out2x=[out2x ymat(:,10)];
out3x=[out3x ymat(:,5)];
yy1=[yy1;thetaFbig(k)];



%productivity
t=40;
Sigma=zeros(3,3);
Sigma(1,1)=sigma_er;
Sigma(2,2)=sigma_a;
Sigma(3,3)=sigma_ystar;
Sigma(2,3)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
Sigma(3,2)=rho_epsa_epsy*sqrt(sigma_ystar*sigma_a);
ee=zeros(t,3);
ee(2,2)=1;  %foreign output
ee=ee*chol(Sigma);
ehat=zeros(t,17);
ymat=zeros(t,17);
for i=2:t
    %iid shocks
    ehat(i,:)=(QQ*ee(i,:)')';
    %data
    ymat(i,:)=(PP*ymat(i-1,:)')'+[ehat(i,:)];
end

out1xx=[out1xx ymat(:,9)];  %real exchange rate response
out2xx=[out2xx ymat(:,10)];
out3xx=[out3xx ymat(:,5)];
yy11=[yy11;thetaFbig(k)];
end

h=1:39;

subplot(2,3,4)
mesh(h,yy,-1*cumsum(out1(2:end,:))')
xlabel('Horizon');
ylabel('\theta_{H}');
title('Monetary Policy Shock')
axis tight
subplot(2,3,5)
mesh(h,yy,-1*cumsum(out1x(2:end,:))')
xlabel('Horizon');
ylabel('\theta_{H}');
title('Foreign Output Shock')
axis tight
subplot(2,3,6)
mesh(h,yy,-1*cumsum(out1xx(2:end,:))')
xlabel('Horizon');
ylabel('\theta_{H}');
title('Productivity Shock')
axis tight

