##-----------------------------------------------##
#-     Replicate Moser/Hofmarcher (JAE 201*)     -#
#-------------------------------------------------#
#-  This file uses an adapted version of the BMS -#
#-   library for R to evaluate the results of    -#
#- Masanjala/Papageorgiou (JAE 2008) for a grid  -#
#-    of priors. Code includes a Weak Heredity   -#
#-   Prior which was not included in the paper   -#
##-----------------------------------------------##

### load original data
download.file("http://qed.econ.queensu.ca/jae/2008-v23.5/masanjala-papageorgiou/mp1-data-programs.zip", destfile="mp1-data-programs.zip")
data <- read.delim(unz("mp1-data-programs.zip", "Interaction-data.txt"))[,-1]
data_cn <- colnames(data)
new.names <- cbind(c('growth','gdp60','yrsopen','protestant_Millions','protestant','catholic','war','primexp70','lifexp60','primsch60','invest','frac','muslim','econorg','mining','british','rerd','A','safrica','area','popgrowth','other.lang','other','rights','absllat','outorient','revcoup','french','civillib'), c('Growth','GDP60','YrsOpen','Protestant','Protestant','Catholic','War','PrimExp70','LifeExp60','PrimSch60','Invest','Frac','Muslim','EconOrg','Mining','British','RERD','SAfrica#','SAfrica','Area','PopGrowth','Other','Other','Rights','AbslLat','OutOrient','RevCoup','French','CivilLib'))
    for (i in 1:length(new.names[,1]))
        data_cn[grep(new.names[i,1],data_cn)] <- gsub(new.names[i,1],new.names[i,2],data_cn[grep(new.names[i,1],data_cn)])
colnames(data) <- data_cn
## end load data

## load methods
library(dilutBMS2) # Source: https://bitbucket.org/matmo/dilutbms2
library(multicore)
library(doMC)
registerDoMC(cores=2)
library(foreach)
## end load methods

## run BMA procedure over grid
# initialize the grid
opt.init <- list(burn=NA, iter=NA, g='UIP', mprior='uniform', mcmc='bd', pen=NA, user.int=FALSE)
pen.init <- c(0.05,0.2,0.4); scenario <- c('nh','sh',paste('wh',pen.init,sep=''),'tess')
opts <- NA; opts <- foreach (i=1:length(scenario), .combine=rbind) %do% assign(scenario[i],opt.init); rownames(opts) <- scenario
opts[,'burn'] <- 2000000
opts[,'iter'] <- 2000000
opts[grep('sh',rownames(opts)),'mcmc'] <- 'bd.int'
opts[grep('wh',rownames(opts)),'mprior'] <- 'uniform.wh'; opts[grep('tess',rownames(opts)),'mcmc'] <- 'tess'
opts[grep('wh',rownames(opts)),'pen'] <- pen.init;
opts[grep('tess',rownames(opts)),'pen'] <- 2;

# run BMA procedure for each scenario
res <- NA
res <- foreach(i=1:length(scenario), .combine=list, .multicombine=TRUE) %do% bms(data, burn=opts[i,]$burn, iter=opts[i,]$iter, g=opts[i,]$g, mprior=opts[i,]$mprior, mcmc=opts[i,]$mcmc, pen=opts[i,]$pen, user.int=opts[i,]$user.int, logfile=paste('bmslog_',i,'.log', sep=''), logstep=1000); names(res) <- scenario

## analyse predictive performance
# set up prediction environment
pred.init <- c('70','50','20','10','5','1')
nsim <- 1000; lps.res <- list(); crps.res <- list()

predictOOS <- function(bmaobj, npred=20, pred=NA) {
    #- Out-of-sample prediction for (lists of) BMS objects
    if (class(bmaobj) == "list")
        nobj <- length(bmaobj)
    else {
        nobj <- 1
        bmaobj[[1]] <- bmaobj
    }
    if (any(is.na(pred)))
        pred<-sample(1:nrow(bmaobj[[1]]$X.data),npred,replace=F)
    predobj <- lapply(bmaobj, pred.density, newdata=bmaobj[[1]]$X.data[pred,-1])
    return(predobj)
}

CRPS <- function(y, yhat.a, yhat.b) {
    #-- Calculate CRPS by evaluating the integral
    #-- as in Reich (2007), or Gneiting/Raftery (2007)
    crps <- 0.5 * abs(yhat.a - yhat.b) - abs(yhat.a - y)
    return(mean(crps))
}

compareLPS <- function(bmaobj=res, npred=20, as.list=FALSE) {
    #- extract LPS from a list of pred.density objects
    predobj <- predictOOS(bmaobj, npred)
    pred <- names(predobj[[1]]$fit)
    data <- bmaobj[[1]]$X.data
    lps <- lapply(predobj, lps.bma, data[pred,1])
    if (as.list == FALSE)
        return(do.call(c, lps))
    else
        return(lps)
}

compareCRPS <- function(bmaobj=res, npred=20, as.list=FALSE) {
    #- calculate CRPS from a list of pred.density objects
    #- two independent copies of predictions
    predobj.a <- predictOOS(bmaobj, npred)
    pred <- names(predobj.a[[1]]$fit)
    predobj.b <- predictOOS(bmaobj, npred, pred)
    y <- bmaobj[[1]]$X.data[pred,1]
    crps <- foreach(i=1:length(bmaobj), .multicombine=TRUE, .combine=c) %do% CRPS(y, predobj.a[[i]]$fit, predobj.b[[i]]$fit)
    names(crps) <- names(bmaobj)
    if (as.list == FALSE)
        return(crps)
    else
        return(as.list(crps))
}

# predict for different amounts of dropped obs
# save LPS and CRPS scores
for (i in 1:length(pred.init)) {
    res.tmp <- foreach(1:nsim, .combine=cbind, .multicombine=TRUE, .packages='dilutBMS2', .export=c('predictOOS', 'compareLPS')) %dopar% compareLPS(res, as.numeric(pred.init[i]))
    lps.res[[i]]<-res.tmp
    res.tmp <- NULL
    res.tmp <- foreach(1:nsim, .combine=cbind, .multicombine=TRUE, .packages='dilutBMS2', .export=c('predictOOS', 'CRPS', 'compareCRPS')) %dopar% compareCRPS(res, as.numeric(pred.init[i]))
    crps.res[[i]] <- res.tmp
}

names(lps.res) <- pred.init; names(crps.res) <- pred.init
save(res, lps.res, crps.res, data, file='replicate_mp.RData')

