#delimit;
capture log close;
set more off;
clear;
set matsize 800;

* toma las superficies no parametricas y corrige las descomposiciones por el factor 
* de la participacion;
 
******************************** Sendas ****************************************;
global output "C:\AAPAPERS\HISPANOS\OUTPUT\salari04.log";
global datain "C:\AAPAPERS\HISPANOS\DATA\";
global temporal "C:\AAPAPERS\HISPANOS\DATA\temporal.dta";
global progra "C:\AAPAPERS\HISPANOS\PROGRAMA\";
********************************************************************************;
capture program drop descom01;
program define descom01;
	version 7.0;
	syntax namelist, [WITH(varlist)] [AND(varlist)];
	tokenize `namelist';
	quietly while "`1'" ~= ""{;
		noi descom02 `1' , with(`with') and(`and');
		macro shift;
	};
end;
capture program drop descom02;
program define descom02;
	version 7.0;
	syntax name, [WITH(varlist)] [AND(varlist)];
quietly {;
	noi dis in g "      Wage Decomposition with " in y "`1'";
	noi dis in g "      Participation: " in y "`with'";
	noi dis in g "      Parametric: " in y "`and'";
	preserve;
* Obtencion de la descomposicion *;
	prepara;
* estructura discriminatoria;
	`1';
	gen codnod=nodo;
	egen nodon=group(codnod);
	qui su nodon;
	local m=r(max);
	local i=1;
	while `i'<=`m' {;
		descompo bxd lan eps,in(`i') with(`with') and(`and');
		local i=`i'+1;
	};
	* excepcion para codnod==37 con salari01;
*$*	 if "`1'"=="salari01" {;
*$*		descom3a;
*$*		};
* estructura si todos blancos;
	replace etnia=1;
	`1';
	gen codnodtb=nodo;
	egen nodontb=group(codnodtb);
	su nodontb;
	local m=r(max);
	local i=1;
	while `i'<=`m' {;
 		descomtb bxdtb lantb epstb,in(`i') with(`with') and(`and');
		local i=`i'+1;
	};
	* excepcion para codnod==37 con salari01;
*$*	if "`1'"=="salari01" {;	
*$*		descom3b;
*$*		};
* estructura si todos mexicanos;
	replace etnia=2;
	`1';
	gen codnodtm=nodo;
	egen nodontm=group(codnodtm);
	su nodontm;
	local m=r(max);
	local i=1;
	while `i'<=`m' {;
		descomtm bxdtm lantm epstm,in(`i') with(`with') and(`and');
		local i=`i'+1;
	};
* obtencion de los alphas y la estrutura no discriminatoria de neumark;
	replace etnia=etniab;
	sort nodontm nodontb;
	by nodontm nodontb: egen alpha=mean(etnia==1);
	replace bxnn=alpha*bxdtb+(1-alpha)*bxdtm;
* calculos de las descomposiciones;
	collapse (mean) salarios bxd bxdtb bxdtm bxnn lan eps, by(etnia muestra);
	blancos;
	mexica;
	neumark;
* presentacion de los resultados;
	use ${temporal},replace;
	rename lan1 Lambda1;
	rename lan2 Lambda2;
	rename dwag Wage;
	rename dwof Offer;
	rename prod Product;
	rename favo Favorit;
	rename disc Discrim;
	rename epsi Error;
	local lista "Wage Lambda1 Lambda2 Offer Product Favorit Discrim Error";
	presenta `lista';
	noi dis in g "                Learning Sample";
	noi l `lista' if muestra==1, noobs;
	noi dis in g "                Test Sample";
	noi l `lista' if muestra==2, noobs;
	};
end;

capture program drop presenta;
program define presenta;
	version 7.0;
	syntax varlist;
	format `varlist' %9.2f;
	tokenize `varlist';
	quietly while "`1'" ~= ""{;
		replace `1'=100*`1';
		macro shift;
	};
end;

* blancos como no-discriminatoria;
capture program drop blancos;
program define blancos;
	preserve;
	gen dwag=salarios*((etnia==1)-(etnia==2));
	gen lan1=lan*(etnia==1);
	gen lan2=-lan*(etnia==2);
	gen dwof=(salarios-lan)*((etnia==1)-(etnia==2));
	gen prod=bxdtb*((etnia==1)-(etnia==2));
	gen favo=0;
	gen disc=(bxd-bxdtb)*((etnia==1)-(etnia==2));
	gen epsi=eps*((etnia==1)-(etnia==2));
	collapse (sum) dwag lan1 lan2 dwof prod favo disc epsi, by(muestra);
	gen str7 desc="White  ";
	save ${temporal},replace;
end;

* mexicanos como no-discriminatoria;
capture program drop mexica;
program define mexica;
	preserve;
	gen dwag=salarios*((etnia==1)-(etnia==2));
	gen lan1=lan*(etnia==1);
	gen lan2=-lan*(etnia==2);
	gen dwof=(salarios-lan)*((etnia==1)-(etnia==2));
	gen prod=bxdtm*((etnia==1)-(etnia==2));
	gen favo=(bxd-bxdtm)*((etnia==1)-(etnia==2));
	gen disc=0;
	gen epsi=eps*((etnia==1)-(etnia==2));
	collapse (sum) dwag lan1 lan2 dwof prod favo disc epsi, by(muestra);
	gen str7 desc="Mexican";
	append using ${temporal};
	save ${temporal},replace;
end;

* neumark como no-discriminatoria;
capture program drop neumark;
program define neumark;
	preserve;
	gen dwag=salarios*((etnia==1)-(etnia==2));
	gen lan1=lan*(etnia==1);
	gen lan2=-lan*(etnia==2);
	gen dwof=(salarios-lan)*((etnia==1)-(etnia==2));
	gen prod=bxnn*((etnia==1)-(etnia==2));
	gen favo=(bxd-bxnn)*(etnia==1);
	gen disc=(bxd-bxnn)*(-(etnia==2));
	gen epsi=eps*((etnia==1)-(etnia==2));
	collapse (sum) dwag lan1 lan2 dwof prod favo disc epsi, by(muestra);
	gen str7 desc="Neumark";
	append using ${temporal};
	save ${temporal},replace;
end;

capture program drop descom3a;
program define descom3a;
	version 7.0;
	tempvar xbcl bxsl;
	noi reg salario beta if nodon==10 & muestra==1,robust ;
	predict `xbcl' if nodon==10;
	replace beta=0;replace beta2=0;replace beta3=0;replace beta4=0;
	predict `bxsl' if nodon==10;
	replace bxd=`bxsl' if nodon==10;
	replace lan=`xbcl'-`bxsl' if nodon==10;
	replace eps=salario - `xbcl' if nodon==10;
	replace beta=betab;replace beta2=betab^2;replace beta3=betab^3;replace beta4=betab^4;
end;

capture program drop descom3b;
program define descom3b;
	version 7.0;
	tempvar xbcl bxsl;
	noi reg salario beta if nodontb==5 & muestra==1 & codnodtb==codnod,robust;
	predict `xbcl' if nodontb==5;
	replace beta=0;replace beta2=0;replace beta3=0;replace beta4=0;
	predict `bxsl' if nodontb==5;
	replace bxdtb=`bxsl' if nodontb==5;
	replace lantb=`xbcl'-`bxsl' if nodontb==5;
	replace epstb=salario - `xbcl' if nodontb==5;
	replace beta=betab;replace beta2=betab^2;replace beta3=betab^3;replace beta4=betab^4;
end;


capture program drop descompo;
program define descompo;
	version 7.0;
	syntax varlist,IN(integer) [WITH(varlist)] [AND(varlist)];
	tempvar xbcl bxsl;
	tokenize `varlist';
	reg salario `with' `and' if nodon==`in' & muestra==1,robust ;
		matrix A=e(b);
		matrix B=vecdiag(e(V));
		local p : word count `with';
		local with " ";
		local i=1;
		while `i'<=`p' {;
			global t=abs(A[1,`i'])/sqrt(B[1,`i']);
			if $t>1.96{;
				if `i'==1{;local with `with' beta;};
				if `i'>=2{;local with `with' beta`i';};
			};
			local i=`i'+1;
		};
	reg salario `with' `and' if nodon==`in' & muestra==1,robust ;
	predict `xbcl' if nodon==`in';
	local i=1;
	while `i'<=`p' {;
		if `i'==1{;replace beta=0;};
		if `i'>=2{;replace beta`i'=0;};
		local i=`i'+1;
		};

	predict `bxsl' if nodon==`in';
	replace `1'=`bxsl' if nodon==`in';
	replace `2'=`xbcl'-`bxsl' if nodon==`in';
	replace `3'=salario - `xbcl' if nodon==`in';
	local i=1;
	while `i'<=`p' {;
		if `i'==1{;replace beta=betab;};
		if `i'>=2{;replace beta`i'=betab^`i';};
		local i=`i'+1;
		};
end;

capture program drop descomtb;
program define descomtb;
	version 7.0;
	syntax varlist,IN(integer) [WITH(varlist)] [AND(varlist)];
	tempvar xbcl bxsl;
	tokenize `varlist';
	reg salario `with' `and' if nodontb==`in' & muestra==1 & codnodtb==codnod,robust ;
		matrix A=e(b);
		matrix B=vecdiag(e(V));
		local p : word count `with';
		local with " ";
		local i=1;
		while `i'<=`p' {;
			global t=abs(A[1,`i'])/sqrt(B[1,`i']);
			if $t>1.96{;
				if `i'==1{;local with `with' beta;};
				if `i'>=2{;local with `with' beta`i';};
			};
			local i=`i'+1;
		};
	reg salario `with' `and' if nodontb==`in' & muestra==1 & codnodtb==codnod,robust ;
	predict `xbcl' if nodontb==`in';
	local i=1;
	while `i'<=`p' {;
		if `i'==1{;replace beta=0;};
		if `i'>=2{;replace beta`i'=0;};
		local i=`i'+1;
		};
	predict `bxsl' if nodontb==`in';
	replace `1'=`bxsl' if nodontb==`in';
	replace `2'=`xbcl'-`bxsl' if nodontb==`in';
	replace `3'=salario - `xbcl' if nodontb==`in';
	local i=1;
	while `i'<=`p' {;
		if `i'==1{;replace beta=betab;};
		if `i'>=2{;replace beta`i'=betab^`i';};
		local i=`i'+1;
		};
end;

capture program drop descomtm;
program define descomtm;
	version 7.0;
	syntax varlist,IN(integer) [WITH(varlist)] [AND(varlist)];
	tempvar xbcl bxsl;
	tokenize `varlist';
	reg salario `with' `and' if nodontm==`in' & muestra==1 & codnodtm==codnod,robust ;
		matrix A=e(b);
		matrix B=vecdiag(e(V));
		local p : word count `with';
		local with " ";
		local i=1;
		while `i'<=`p' {;
			global t=abs(A[1,`i'])/sqrt(B[1,`i']);
			if $t>1.96{;
				if `i'==1{;local with `with' beta;};
				if `i'>=2{;local with `with' beta`i';};
			};
			local i=`i'+1;
		};
	reg salario `with' `and' if nodontm==`in' & muestra==1 & codnodtm==codnod,robust ;
	predict `xbcl' if nodontm==`in';
	local i=1;
	while `i'<=`p' {;
		if `i'==1{;replace beta=0;};
		if `i'>=2{;replace beta`i'=0;};
		local i=`i'+1;
		};
	predict `bxsl' if nodontm==`in';
	replace `1'=`bxsl' if nodontm==`in';
	replace `2'=`xbcl'-`bxsl' if nodontm==`in';
	replace `3'=salario - `xbcl' if nodontm==`in';
	local i=1;
	while `i'<=`p' {;
		if `i'==1{;replace beta=betab;};
		if `i'>=2{;replace beta`i'=betab^`i';};
		local i=`i'+1;
		};
end;

capture program drop estandar;											
program define estandar;											
	version 7.0;
	syntax varlist;
	tempvar m;
	tokenize `varlist';
	quietly while "`1'" ~= ""{;
		egen `m'=group(`1');
		replace `1'=`m';
		drop `m';
		macro shift;
	};

end;
capture program drop prepara;
program define prepara;
	gen betab=beta;
	gen etniab=etnia;
	gen bxd=0;
	gen lan=0;
	gen eps=0;
	gen bxdtb=0;
	gen lantb=0;
	gen epstb=0;
	gen bxdtm=0;
	gen lantm=0;
	gen epstm=0;
	gen bxnn=0;
	gen nodo=0;
end;
capture program drop salari01;											
program define salari01;											
 replace nodo= 12 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 13 if        
    age >= 1 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 16 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 17 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 22 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 28 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 30 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 2 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 31 if        
    age >= 1 & age <= 38 &
    educa >= 3 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 36 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 8 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 37 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 9 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 38 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 40 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 5 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 44 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 22 ;
 replace nodo= 56 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 57 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 75 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 76 if        
    age >= 1 & age <= 2 &
    educa >= 6 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 77 if        
    age >= 3 & age <= 9 &
    educa >= 6 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 78 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 80 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 14 ;
 replace nodo= 85 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 128 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 129 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 138 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 139 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 143 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 149 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 252 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 253 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 264 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 88 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 442 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 89 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 24 ;
 replace nodo= 443 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 89 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 27 ;
end;           
capture program drop salari02;           
program define salari02;           
 replace nodo= 8 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 12 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 14 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 22 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 23 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 27 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 52 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 53 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari03;           
program define salari03;           
 replace nodo= 3 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 4 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari04;           
program define salari04;           
 replace nodo= 4 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 5 if        
    age >= 1 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 6 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 7 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari05;           
program define salari05;           
 replace nodo= 6 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 7 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 8 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    age >= 1 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari06;           
program define salari06;           
 replace nodo= 4 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 7 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 12 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 13 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari11;           
program define salari11;           
 replace nodo= 7 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 12 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 22 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 16 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 1 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 17 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 2 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 21 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 23 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 26 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 23 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 27 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 36 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 37 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 39 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 15 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 40 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 11 ;
 replace nodo= 76 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 14 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 88 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 89 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 24 ;
 replace nodo= 90 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 26 ;
 replace nodo= 91 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 27 & dindphis <= 41 ;
 replace nodo= 142 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 14 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 27 ;
 replace nodo= 143 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 14 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 46 ;
 replace nodo= 152 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 153 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 154 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 155 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
end;           
capture program drop salari12;           
program define salari12;           
 replace nodo= 4 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 13 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 24 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 11 ;
 replace nodo= 56 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 57 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 24 ;
 replace nodo= 58 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 27 ;
 replace nodo= 59 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 96 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 97 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 98 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 99 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
end;           
capture program drop salari13;           
program define salari13;           
 replace nodo= 6 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 7 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 8 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari14;           
program define salari14;           
 replace nodo= 2 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 6 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 7 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari15;           
program define salari15;           
 replace nodo= 6 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 7 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 8 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 18 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 19 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 20 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 21 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 23 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 45 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 41 ;
 replace nodo= 88 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 89 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 24 ;
end;           
capture program drop salari16;           
program define salari16;           
 replace nodo= 4 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 12 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 13 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 29 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 41 ;
 replace nodo= 56 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 57 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 24 ;
end;           
capture program drop salari31;           
program define salari31;           
 replace nodo= 6 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 14 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 16 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 17 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 18 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 20 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 22 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 23 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 38 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 39 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 42 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 43 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari32;           
program define salari32;           
 replace nodo= 8 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 18 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 20 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 8 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 28 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 72 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 29 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 73 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 38 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 39 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 42 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 9 & hisppor <= 9 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 43 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 10 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 45 if        
    age >= 13 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 47 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 50 if        
    age >= 1 & age <= 6 &
    educa >= 10 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 51 if        
    age >= 7 & age <= 9 &
    educa >= 10 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 52 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 59 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 19 & dindphis <= 22 ;
 replace nodo= 61 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 45 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 83 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 9 & dindphis <= 46 ;
 replace nodo= 90 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 4 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 91 if        
    age >= 1 & age <= 9 &
    educa >= 5 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 92 if        
    age >= 1 & age <= 2 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 103 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 9 & dindphis <= 14 ;
 replace nodo= 105 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 106 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 18 ;
 replace nodo= 141 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 8 ;
 replace nodo= 148 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 88 &
    hisppor >= 6 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 150 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 1 ;
 replace nodo= 151 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 46 ;
 replace nodo= 161 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 174 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 175 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 177 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 178 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 5 ;
 replace nodo= 179 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 8 ;
 replace nodo= 182 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 188 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 17 ;
 replace nodo= 189 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 18 ;
 replace nodo= 194 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 24 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 197 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 244 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 59 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 5 ;
 replace nodo= 258 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 89 & periodo <= 90 &
    hisppor >= 6 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 259 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 91 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 309 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 322 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 22 ;
 replace nodo= 323 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 341 if        
    age >= 1 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 25 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 342 if        
    age >= 1 & age <= 13 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 343 if        
    age >= 14 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 408 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 60 & periodo <= 76 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 5 ;
 replace nodo= 409 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 77 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 5 ;
 replace nodo= 460 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 24 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 17 ;
 replace nodo= 461 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 24 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 46 ;
 replace nodo= 462 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 25 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 463 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 506 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 507 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 565 if        
    age >= 3 & age <= 38 &
    educa >= 4 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 25 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 842 if        
    age >= 1 & age <= 2 &
    educa >= 4 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 25 & periodo <= 73 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 843 if        
    age >= 1 & age <= 2 &
    educa >= 4 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 74 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
end;           
capture program drop salari33;           
program define salari33;           
 replace nodo= 3 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 8 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    age >= 1 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari34;           
program define salari34;           
 replace nodo= 8 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 12 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 14 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 26 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 27 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari41;           
program define salari41;           
 replace nodo= 7 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 12 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 22 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 16 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 1 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 17 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 2 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 21 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 23 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 26 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 23 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 27 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 36 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 37 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 76 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 14 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 77 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 15 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 78 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 27 ;
 replace nodo= 79 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 46 ;
 replace nodo= 80 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 22 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 11 ;
 replace nodo= 81 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 23 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 11 ;
 replace nodo= 82 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 88 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 89 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 24 ;
 replace nodo= 90 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 27 ;
 replace nodo= 91 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 152 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 256 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 257 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
end;           
capture program drop salari42;           
program define salari42;           
 replace nodo= 8 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 1 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 2 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 20 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 21 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 26 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 27 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 44 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 14 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 45 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 15 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 46 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 27 ;
 replace nodo= 47 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 46 ;
 replace nodo= 48 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 22 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 11 ;
 replace nodo= 50 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 58 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 27 ;
 replace nodo= 59 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 94 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 23 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 11 ;
 replace nodo= 95 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 11 ;
 replace nodo= 108 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 18 ;
 replace nodo= 109 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 19 & dindphis <= 23 ;
 replace nodo= 110 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 69 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 24 ;
 replace nodo= 111 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 70 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 24 ;
 replace nodo= 174 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 17 ;
 replace nodo= 175 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 46 ;
 replace nodo= 176 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 177 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
end;           
capture program drop salari43;           
program define salari43;           
 replace nodo= 6 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 7 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 8 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 20 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 21 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari44;           
program define salari44;           
 replace nodo= 4 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 7 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 12 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 13 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari51;           
program define salari51;           
 replace nodo= 24 if        
    age >= 1 & age <= 8 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 26 if        
    age >= 1 & age <= 10 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 28 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 30 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 2 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 32 if        
    age >= 1 & age <= 7 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 33 if        
    age >= 1 & age <= 7 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 36 if        
    age >= 8 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 40 if        
    age >= 1 & age <= 2 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 44 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 65 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 45 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 66 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 50 if        
    age >= 9 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 51 if        
    age >= 9 & age <= 38 &
    educa >= 8 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 55 if        
    age >= 11 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 66 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 1 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 67 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 2 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 69 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 7 & dindphis <= 46 ;
 replace nodo= 81 if        
    age >= 3 & age <= 9 &
    educa >= 10 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 87 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 19 & dindphis <= 22 ;
 replace nodo= 89 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 98 if        
    age >= 11 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 9 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 99 if        
    age >= 11 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 10 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 106 if        
    age >= 1 & age <= 9 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 107 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 110 if        
    age >= 1 & age <= 38 &
    educa >= 3 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 112 if        
    age >= 1 & age <= 8 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 113 if        
    age >= 9 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 122 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 5 ;
 replace nodo= 123 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 6 ;
 replace nodo= 130 if        
    age >= 8 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 1 ;
 replace nodo= 131 if        
    age >= 8 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 46 ;
 replace nodo= 132 if        
    age >= 8 & age <= 26 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 133 if        
    age >= 27 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 135 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 9 & dindphis <= 46 ;
 replace nodo= 136 if        
    age >= 13 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 87 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 137 if        
    age >= 13 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 88 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 138 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 141 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 146 if        
    age >= 3 & age <= 9 &
    educa >= 1 & educa <= 5 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 150 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 29 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 152 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 154 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 14 ;
 replace nodo= 157 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 158 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 18 ;
 replace nodo= 196 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 13 ;
 replace nodo= 197 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 14 & dindphis <= 46 ;
 replace nodo= 198 if        
    age >= 1 & age <= 6 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 199 if        
    age >= 7 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 203 if        
    age >= 1 & age <= 38 &
    educa >= 3 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 45 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 46 ;
 replace nodo= 240 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 5 ;
 replace nodo= 241 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 8 ;
 replace nodo= 250 if        
    age >= 8 & age <= 9 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 252 if        
    age >= 8 & age <= 10 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 22 ;
 replace nodo= 253 if        
    age >= 11 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 22 ;
 replace nodo= 263 if        
    age >= 3 & age <= 9 &
    educa >= 6 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 270 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 30 & hisppor <= 30 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 271 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 31 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 275 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 294 if        
    age >= 1 & age <= 10 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 295 if        
    age >= 11 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 348 if        
    age >= 1 & age <= 38 &
    educa >= 3 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 27 ;
 replace nodo= 349 if        
    age >= 1 & age <= 38 &
    educa >= 3 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 46 ;
 replace nodo= 442 if        
    age >= 3 & age <= 9 &
    educa >= 6 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 11 ;
 replace nodo= 443 if        
    age >= 3 & age <= 9 &
    educa >= 6 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 12 & dindphis <= 46 ;
 replace nodo= 464 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 465 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 471 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 8 ;
 replace nodo= 472 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 9 & dindphis <= 14 ;
 replace nodo= 473 if        
    age >= 10 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 9 & dindphis <= 14 ;
 replace nodo= 474 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 475 if        
    age >= 10 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 484 if        
    age >= 1 & age <= 7 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 17 ;
 replace nodo= 485 if        
    age >= 1 & age <= 7 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 18 ;
 replace nodo= 486 if        
    age >= 8 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 18 ;
 replace nodo= 487 if        
    age >= 8 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 18 ;
 replace nodo= 494 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 88 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 495 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 88 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 496 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 89 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 24 ;
 replace nodo= 497 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 89 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 27 ;
 replace nodo= 656 if        
    age >= 10 & age <= 32 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 1 ;
 replace nodo= 657 if        
    age >= 33 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 1 ;
 replace nodo= 659 if        
    age >= 10 & age <= 38 &
    educa >= 12 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 46 ;
 replace nodo= 722 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 2 ;
 replace nodo= 723 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 3 & dindphis <= 5 ;
 replace nodo= 734 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 17 ;
 replace nodo= 737 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 922 if        
    age >= 10 & age <= 38 &
    educa >= 11 & educa <= 11 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 11 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 46 ;
 replace nodo= 923 if        
    age >= 10 & age <= 38 &
    educa >= 11 & educa <= 11 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 12 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 46 ;
 replace nodo= 1037 if        
    age >= 10 & age <= 38 &
    educa >= 12 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 46 ;
 replace nodo= 1038 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 22 ;
 replace nodo= 1039 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 1372 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 11 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 1 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 46 ;
 replace nodo= 1373 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 11 &
    voca >= 1 & voca <= 2 &
    veterano >= 2 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 46 ;
end;           
capture program drop salari52;           
program define salari52;           
 replace nodo= 16 if        
    age >= 1 & age <= 7 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 35 if        
    age >= 7 & age <= 7 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 36 if        
    age >= 8 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 7 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 37 if        
    age >= 8 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 8 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 40 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 1 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 51 if        
    age >= 7 & age <= 9 &
    educa >= 10 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 56 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 57 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 24 ;
 replace nodo= 58 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 41 ;
 replace nodo= 59 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 66 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 6 ;
 replace nodo= 78 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 81 &
    hisppor >= 2 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 79 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 82 & periodo <= 108 &
    hisppor >= 2 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 80 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 5 ;
 replace nodo= 82 if        
    age >= 1 & age <= 2 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 7 & dindphis <= 46 ;
 replace nodo= 85 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 9 & dindphis <= 46 ;
 replace nodo= 87 if        
    age >= 13 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 87 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 93 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 96 if        
    age >= 1 & age <= 6 &
    educa >= 10 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 22 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 108 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 18 ;
 replace nodo= 110 if        
    age >= 1 & age <= 4 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 19 & dindphis <= 22 ;
 replace nodo= 114 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 45 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 120 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 7 & dindphis <= 23 ;
 replace nodo= 130 if        
    age >= 8 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 40 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 1 ;
 replace nodo= 131 if        
    age >= 8 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 41 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 1 ;
 replace nodo= 132 if        
    age >= 8 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 46 ;
 replace nodo= 136 if        
    age >= 27 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 137 if        
    age >= 27 & age <= 38 &
    educa >= 8 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 144 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 9 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 6 ;
 replace nodo= 145 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 10 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 6 ;
 replace nodo= 149 if        
    age >= 3 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 15 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 7 & dindphis <= 46 ;
 replace nodo= 150 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 5 ;
 replace nodo= 151 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 8 ;
 replace nodo= 155 if        
    age >= 13 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 86 &
    hisppor >= 2 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 159 if        
    age >= 18 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 164 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 30 ;
 replace nodo= 165 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 31 & dindphis <= 46 ;
 replace nodo= 166 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 29 &
    hisppor >= 18 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 167 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 30 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 171 if        
    age >= 1 & age <= 2 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 176 if        
    age >= 1 & age <= 1 &
    educa >= 10 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 23 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 182 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 24 ;
 replace nodo= 183 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 46 ;
 replace nodo= 184 if        
    age >= 10 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 189 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 193 if        
    age >= 10 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 9 & dindphis <= 14 ;
 replace nodo= 204 if        
    age >= 5 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 19 & dindphis <= 22 ;
 replace nodo= 205 if        
    age >= 5 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 19 & dindphis <= 22 ;
 replace nodo= 209 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 210 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 6 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 45 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 46 ;
 replace nodo= 216 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 24 ;
 replace nodo= 217 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 46 ;
 replace nodo= 232 if        
    age >= 8 & age <= 26 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 1 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 264 if        
    age >= 13 & age <= 38 &
    educa >= 11 & educa <= 12 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 86 &
    hisppor >= 1 & hisppor <= 1 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 265 if        
    age >= 13 & age <= 38 &
    educa >= 13 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 86 &
    hisppor >= 1 & hisppor <= 1 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 273 if        
    age >= 8 & age <= 17 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 3 & dindphis <= 46 ;
 replace nodo= 276 if        
    age >= 8 & age <= 32 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 1 ;
 replace nodo= 277 if        
    age >= 33 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 1 ;
 replace nodo= 280 if        
    age >= 8 & age <= 10 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 12 ;
 replace nodo= 281 if        
    age >= 8 & age <= 10 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 13 & dindphis <= 22 ;
 replace nodo= 283 if        
    age >= 11 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 14 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 22 ;
 replace nodo= 294 if        
    age >= 1 & age <= 2 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 22 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 301 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 309 if        
    age >= 2 & age <= 6 &
    educa >= 10 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 318 if        
    age >= 10 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 319 if        
    age >= 10 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 324 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 28 ;
 replace nodo= 325 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 29 & dindphis <= 46 ;
 replace nodo= 328 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 5 ;
 replace nodo= 330 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 9 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 8 ;
 replace nodo= 332 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 9 & dindphis <= 10 ;
 replace nodo= 333 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 11 & dindphis <= 14 ;
 replace nodo= 336 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 340 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 40 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 16 ;
 replace nodo= 341 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 41 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 16 ;
 replace nodo= 342 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 1 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 17 & dindphis <= 46 ;
 replace nodo= 343 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 2 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 17 & dindphis <= 46 ;
 replace nodo= 348 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 39 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 18 ;
 replace nodo= 349 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 40 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 18 ;
 replace nodo= 355 if        
    age >= 3 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 362 if        
    age >= 1 & age <= 38 &
    educa >= 7 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 45 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 42 ;
 replace nodo= 363 if        
    age >= 1 & age <= 38 &
    educa >= 7 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 45 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 43 & dindphis <= 46 ;
 replace nodo= 378 if        
    age >= 8 & age <= 11 &
    educa >= 8 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 46 ;
 replace nodo= 379 if        
    age >= 8 & age <= 11 &
    educa >= 8 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 46 ;
 replace nodo= 381 if        
    age >= 12 & age <= 38 &
    educa >= 8 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 382 if        
    age >= 8 & age <= 10 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 64 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 383 if        
    age >= 8 & age <= 10 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 65 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 384 if        
    age >= 11 & age <= 26 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 388 if        
    age >= 8 & age <= 26 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 2 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 14 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 389 if        
    age >= 8 & age <= 26 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 2 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 15 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 416 if        
    age >= 3 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 7 & dindphis <= 46 ;
 replace nodo= 418 if        
    age >= 3 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 14 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 7 & dindphis <= 25 ;
 replace nodo= 419 if        
    age >= 3 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 14 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 26 & dindphis <= 46 ;
 replace nodo= 444 if        
    age >= 8 & age <= 12 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 2 ;
 replace nodo= 445 if        
    age >= 13 & age <= 17 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 2 ;
 replace nodo= 455 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 11 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 7 & dindphis <= 46 ;
 replace nodo= 456 if        
    age >= 8 & age <= 38 &
    educa >= 12 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 22 ;
 replace nodo= 457 if        
    age >= 8 & age <= 38 &
    educa >= 12 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 462 if        
    age >= 11 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 13 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 20 ;
 replace nodo= 463 if        
    age >= 11 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 13 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 21 & dindphis <= 22 ;
 replace nodo= 487 if        
    age >= 1 & age <= 2 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 23 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 46 ;
 replace nodo= 492 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 8 ;
 replace nodo= 493 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 9 & dindphis <= 13 ;
 replace nodo= 496 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 99 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 497 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 100 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 504 if        
    age >= 2 & age <= 6 &
    educa >= 10 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 23 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 505 if        
    age >= 2 & age <= 6 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 23 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 523 if        
    age >= 34 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 524 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 26 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 526 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 2 ;
 replace nodo= 528 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 529 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 541 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 3 & dindphis <= 5 ;
 replace nodo= 543 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 10 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 7 & dindphis <= 8 ;
 replace nodo= 554 if        
    age >= 10 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 23 ;
 replace nodo= 555 if        
    age >= 10 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 46 ;
 replace nodo= 557 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 21 & dindphis <= 22 ;
 replace nodo= 567 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 17 & dindphis <= 17 ;
 replace nodo= 568 if        
    age >= 1 & age <= 6 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 17 ;
 replace nodo= 569 if        
    age >= 7 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 17 ;
 replace nodo= 580 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 87 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 24 ;
 replace nodo= 581 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 87 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 27 ;
 replace nodo= 582 if        
    age >= 1 & age <= 2 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 73 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 583 if        
    age >= 1 & age <= 2 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 74 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 587 if        
    age >= 1 & age <= 13 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 43 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 588 if        
    age >= 14 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 589 if        
    age >= 14 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 617 if        
    age >= 12 & age <= 38 &
    educa >= 8 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 8 & dindphis <= 22 ;
 replace nodo= 626 if        
    age >= 11 & age <= 26 &
    educa >= 9 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 14 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 627 if        
    age >= 11 & age <= 26 &
    educa >= 9 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 15 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 654 if        
    age >= 3 & age <= 4 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 7 & dindphis <= 46 ;
 replace nodo= 692 if        
    age >= 8 & age <= 17 &
    educa >= 11 & educa <= 11 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 6 ;
 replace nodo= 693 if        
    age >= 18 & age <= 38 &
    educa >= 11 & educa <= 11 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 6 ;
 replace nodo= 726 if        
    age >= 1 & age <= 2 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 23 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 24 ;
 replace nodo= 727 if        
    age >= 1 & age <= 2 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 24 ;
 replace nodo= 741 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 22 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 14 & dindphis <= 46 ;
 replace nodo= 742 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 14 & dindphis <= 46 ;
 replace nodo= 772 if        
    age >= 10 & age <= 33 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 17 ;
 replace nodo= 777 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 27 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 46 ;
 replace nodo= 778 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 3 & dindphis <= 22 ;
 replace nodo= 779 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 798 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 2 ;
 replace nodo= 799 if        
    age >= 10 & age <= 38 &
    educa >= 10 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 2 ;
 replace nodo= 802 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 10 & periodo <= 83 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 6 ;
 replace nodo= 803 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 84 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 6 & dindphis <= 6 ;
 replace nodo= 832 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 11 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 833 if        
    age >= 10 & age <= 38 &
    educa >= 12 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 834 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 835 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 844 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 32 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 16 ;
 replace nodo= 845 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 33 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 16 ;
 replace nodo= 858 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 86 &
    hisppor >= 37 & hisppor <= 37 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 859 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 86 &
    hisppor >= 38 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 861 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 86 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 870 if        
    age >= 1 & age <= 13 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 42 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 871 if        
    age >= 1 & age <= 13 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 42 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 908 if        
    age >= 12 & age <= 38 &
    educa >= 8 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 15 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 7 ;
 replace nodo= 909 if        
    age >= 12 & age <= 38 &
    educa >= 8 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 16 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 2 & dindphis <= 7 ;
 replace nodo= 952 if        
    age >= 5 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 7 & dindphis <= 12 ;
 replace nodo= 953 if        
    age >= 5 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 13 & dindphis <= 46 ;
 replace nodo= 1042 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 21 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 14 & dindphis <= 23 ;
 replace nodo= 1048 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 1 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 14 & dindphis <= 46 ;
 replace nodo= 1049 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 2 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 14 & dindphis <= 46 ;
 replace nodo= 1081 if        
    age >= 10 & age <= 33 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 22 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 46 ;
 replace nodo= 1083 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 30 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 1155 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 33 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 17 ;
 replace nodo= 1156 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 1 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 20 ;
 replace nodo= 1192 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 18 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 1382 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 68 &
    hisppor >= 18 & hisppor <= 21 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 46 ;
 replace nodo= 1424 if        
    age >= 10 & age <= 33 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 75 &
    hisppor >= 18 & hisppor <= 21 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 46 ;
 replace nodo= 1428 if        
    age >= 10 & age <= 24 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 27 & hisppor <= 29 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 1429 if        
    age >= 25 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 27 & hisppor <= 29 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 1513 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 32 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 17 ;
 replace nodo= 1518 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 2 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 20 ;
 replace nodo= 1519 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 2 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 20 ;
 replace nodo= 1556 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 19 & periodo <= 86 &
    hisppor >= 37 & hisppor <= 37 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 1557 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 19 & periodo <= 86 &
    hisppor >= 38 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 1722 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 69 & periodo <= 81 &
    hisppor >= 18 & hisppor <= 21 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 46 ;
 replace nodo= 1723 if        
    age >= 3 & age <= 9 &
    educa >= 8 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 82 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 21 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 46 ;
 replace nodo= 1762 if        
    age >= 10 & age <= 33 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 76 & periodo <= 81 &
    hisppor >= 18 & hisppor <= 21 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 46 ;
 replace nodo= 1763 if        
    age >= 10 & age <= 33 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 82 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 21 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 18 & dindphis <= 46 ;
 replace nodo= 1830 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 12 &
    hisppor >= 19 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 17 ;
 replace nodo= 2108 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 13 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 17 ;
 replace nodo= 2322 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 13 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 27 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 17 ;
 replace nodo= 2323 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 13 & periodo <= 108 &
    hisppor >= 28 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 17 ;
end;           
capture program drop salari53;           
program define salari53;           
 replace nodo= 12 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 13 if        
    age >= 1 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 14 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 16 if        
    age >= 1 & age <= 7 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 17 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 18 if        
    age >= 8 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 20 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 38 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 42 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 43 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 44 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 65 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 45 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 66 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 46 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 22 ;
 replace nodo= 47 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 76 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 77 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari54;           
program define salari54;           
 replace nodo= 8 if        
    age >= 1 & age <= 7 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    age >= 8 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 22 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 24 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 9 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 25 if        
    age >= 1 & age <= 9 &
    educa >= 10 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 27 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 29 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 46 ;
 replace nodo= 30 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 22 ;
 replace nodo= 46 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 47 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 52 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 56 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 23 ;
 replace nodo= 57 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 24 & dindphis <= 24 ;
 replace nodo= 63 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 45 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 46 ;
 replace nodo= 102 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 103 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 112 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 113 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 44 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 46 ;
end;           
capture program drop salari61;           
program define salari61;           
 replace nodo= 6 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 14 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 16 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 17 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 18 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 20 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 22 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 23 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 38 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 39 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 42 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 43 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari62;           
program define salari62;           
 replace nodo= 6 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 14 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 16 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 17 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 18 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 20 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 22 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 23 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 38 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 39 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 42 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 43 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari63;           
program define salari63;           
 replace nodo= 8 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 12 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 14 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 22 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 23 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 27 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 52 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 53 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           
capture program drop salari64;           
program define salari64;           
 replace nodo= 8 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 12 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 14 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 15 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 22 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 23 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 27 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 52 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 53 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           

capture program drop salari21;           
program define salari21;           
 replace nodo= 1 if etnia==1;
 replace nodo= 2 if etnia==2; 
end;           

capture program drop salari22;
program define salari22;
 replace nodo= 1;
end;           

capture program drop salari23;           
program define salari23;           
 replace nodo= 1 if etnia==1;
 replace nodo= 2 if etnia==2; 
end;           

capture program drop salari24;
program define salari24;
 replace nodo= 1;
end;           

capture program drop salari25;
program define salari25;
 replace nodo= 1;
end;           

capture program drop salari26;
program define salari26;
 replace nodo= 1;
end;           


capture program drop salari71;
program define salari71;
 replace nodo= 1;
end;           


capture program drop salari72;
program define salari72;
 replace nodo= 1;
end;           

capture program drop salari73;           
program define salari73;           
 replace nodo= 1 if etnia==1;
 replace nodo= 2 if etnia==2; 
end;           

capture program drop masvar;
program define masvar;
	version 7.0;
	syntax varlist [if] [in], AT(integer);
	tokenize `varlist';
	quietly while "`1'" ~= ""{;
		gen `1'`at'=(`1'^`at')/(10^`at');
		macro shift;
	};
end;


********************************************************************************;
log using ${output},replace;


* descomposiciones no parametricas;
use ${datain}salario\sal1ts.dta,clear;
gen muestra=2;
append using ${datain}salario\sal1ls.dta;
replace muestra=1 if muestra==.;
descom01 salari01 salari02 salari03 , with(beta beta2 beta3 beta4);

*$*descom01 salari01 salari02 salari03 salari04, with(beta beta2 beta3 beta4);
*$*descom01 salari31 salari32 salari33 salari34, with(beta beta2);
*$*descom01 salari51 salari52 salari53 salari54;

* descomposiciones semi-parametricas;
use ${datain}salario\sal2ts.dta,clear;
gen muestra=2;
append using ${datain}salario\sal2ls.dta;
replace muestra=1 if muestra==.;
descom01 salari13 , with(beta beta2 beta3 beta4) 
	and(age age2 educa agexed);

*$*descom01 salari11 salari12 salari13 salari14, with(beta beta2 beta3 beta4) 
*$*	and(age age2 educa agexed);
*$*descom01 salari41 salari42 salari43 salari44, with(beta beta2) 
*$*	and(age age2 educa agexed);

* descomposiciones parametricas;
use ${datain}salario\sal3ts.dta,clear;
gen muestra=2;
append using ${datain}salario\sal3ls.dta;
replace muestra=1 if muestra==.;
descom01 salari21, with(beta beta2 beta3 beta4) 
	and(age age2 educa agexed voca hisppor doccphis dindphis veterano periodo);

*$*descom01 salari21 salari25 , with(beta beta2 beta3 beta4) 
*$* and(age age2 educa agexed voca hisppor doccphis dindphis veterano periodo);
*$*descom01 salari22, with(beta beta2 beta3 beta4) 
*$* and(age age2 educa agexed voca hisppor doccphis dindphis veterano periodo etnia);
*$*descom01 salari23 , and(age age2 educa agexed voca hisppor doccphis dindphis veterano periodo);
*$*descom01 salari24, with(beta beta2 beta3 beta4) 
*$* and(age age2 educa agexed voca hisppor doccphis dindphis veterano periodo etnia);
*$*descom01 salari26 , and(age age2 educa agexed voca hisppor doccphis dindphis veterano periodo);

* descomposiciones fuertemente no-lineales y parametricas;
use ${datain}salario\sal3ts.dta,clear;
gen muestra=2;
append using ${datain}salario\sal3ls.dta;
replace muestra=1 if muestra==.;
* defino las variables non lineales que faltan;
	masvar periodo educa doccphis dindphis hisppor,at(2);
	masvar periodo age educa doccphis dindphis hisppor,at(3);
	masvar periodo age educa doccphis dindphis hisppor,at(4);
	keep periodo* salarios age* educa* voca etnia veterano doccphis* dindphis* 
		hisppor* beta* muestra;
save ${datain}salario\temp01.dta,replace;

use ${datain}salario\temp01.dta,clear;

descom01 salari73 , with(beta beta2 beta3 beta4) 
	and(age age2 age3 age4 educa educa2 educa3 educa4 agexed
	voca veterano 
	hisppor hisppor2 hisppor3 hisppor4
	doccphis doccphis2 doccphis3 doccphis4
	dindphis dindphis2 dindphis3 dindphis4 
	periodo);

*$*descom01 salari71 , with(beta beta2 beta3 beta4) 
*$* and(age age2 age3 age4 educa educa2 educa3 educa4 agexed
*$*     voca veterano
*$*     hisppor doccphis dindphis periodo hisppor2 hisppor3 hisppor4
*$*     doccphis2 dindphis2 periodo2 doccphis3 dindphis3 periodo3 doccphis4 dindphis4 periodo4);
*$*descom01 salari72 , with(beta beta2 beta3 beta4) 
*$* and(age age2 age3 age4 educa educa2 educa3 educa4 agexed
*$*     voca veterano etnia
*$*     hisppor doccphis dindphis periodo hisppor2 hisppor3 hisppor4
*$*     doccphis2 dindphis2 periodo2 doccphis3 dindphis3 periodo3 doccphis4 dindphis4 periodo4);
*$*descom01 salari73 , with(beta beta2 beta3 beta4) 
*$* and(age age2 age3 age4 educa educa2 educa3 educa4 agexed
*$*     voca veterano 
*$*     hisppor doccphis dindphis periodo
*$*     doccphis2 dindphis2 periodo2 doccphis3 dindphis3 periodo3 doccphis4 dindphis4 periodo4);

log close;


exit;


