#delimit;
capture log close;
set more off;
clear;
set matsize 800;

* prepara los datos para la ecuacion de salarios parametrica
* fuertemente no lineal;
 

******************************** Sendas ****************************************;
global output "C:\AAPAPERS\HISPANOS\OUTPUT\salari03.log";
global datain "C:\AAPAPERS\HISPANOS\DATA\";
global progra "C:\AAPAPERS\HISPANOS\PROGRAMA\";
********************************************************************************;

* periodo state year salarios age age2 exp exp2 agexed expxed educa voca 
* etnia veterano marital calif arizo texas newme sindi wagesmpl 
* doccphis doccmedu dindphis dindmedu dmsaphis dmsamedu hisppor
* educcon agecon educpad agepad selfpad educmad agemad selfmad;

********************************************************************************;

capture program drop masvar;
program define masvar;
	version 7.0;
	syntax varlist [if] [in], AT(integer);
	tokenize `varlist';
	quietly while "`1'" ~= ""{;
		gen `1'`at'=(`1'^`at')/(10^`at');
		macro shift;
	};
end;

********************************************************************************;

log using ${output},replace;

* entrada de resultados del modelo no parametrico de la participacion;
* generacion del grid de datos del modelo de participacion;
use ${datain}datos01.dta,replace;
	gen grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
* aries utiliza transformaciones de educa y hisppor;
	gen oldhip=hisppor;
	gen oldeduc=educa;
	replace hisppor=floor(10^6*hisppor);	
	replace educa=10*educa;
* entrada de resultados del modelo no parametrico de la participacion;
	quietly do ${progra}parall2.do;
	sort grid;
	by grid:egen malpha=mean(wagesmpl);
	* la definicion de participacion esta mal en aries;
	replace alpha2=1-alpha2;
	replace alpha2=malpha if nodo2==-1;
	* me aseguro de que las estimaciones se hacen con un minimo de observaciones;
	sort nodo2 grid;
	by nodo2 grid:egen malpha2=mean(wagesmpl);
	by nodo2 grid:egen cnum2=count(wagesmpl);
	count if alpha2>0 & numls2<40;
	count if alpha2>0 & cnum2<40;
	replace alpha2=malpha2 if numls2<40;
	replace alpha2=malpha if cnum2<40;
	* tengo que eliminar los unos;
	replace alpha2=cnum2/(cnum2+1) if alpha2==1;
	* luego tengo los ceros. Me dan igual, pero hago el cambio para que funcione el programa;
	capture gen ceros=alpha2==0;
	replace alpha2=1/(cnum2+1) if alpha2==0;
	drop numls2 nodo2 malpha malpha2 cnum2;
* cambio los nombres;
	rename alpha2 alpha;
* genero los betas;
	gen beta=invnorm(alpha);
	gen beta2=beta^2;
	gen beta3=beta^3;
	gen beta4=beta^4;
* me quedo solo con la muestra de salarios;
	keep if wagesmpl==1;
* defino las variables non lineales que faltan;
	masvar periodo educa doccphis dindphis hisppor,at(2);
	masvar periodo age educa doccphis dindphis hisppor,at(3);
	masvar periodo age educa doccphis dindphis hisppor,at(4);
	keep periodo* salarios age* educa* voca etnia veterano doccphis* dindphis* 
		hisppor* beta*;
save ${datain}partic\salari03.dta,replace;
!C:\Archiv~1\StatTr~1\st.exe C:\AAPAPERS\HISPANOS\DATA\partic\salari03.dta C:\ARIES\DATOS\partic\salari03.dat /V;
log close;
exit;

