#delimit;
capture log close;
set more off;
clear;
set matsize 800;

* toma la superficies no parametrica SALARI03 y calcula los efectos marginales;
 
******************************** Sendas ****************************************;
global output "C:\AAPAPERS\HISPANOS\OUTPUT\regre02.log";
global datain "C:\AAPAPERS\HISPANOS\DATA\";
global temporal "C:\AAPAPERS\HISPANOS\DATA\temporal.dta";
global progra "C:\AAPAPERS\HISPANOS\PROGRAMA\";
********************************************************************************;

capture program drop salari01;											
program define salari01;											
 replace nodo= 12 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 13 if        
    age >= 1 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 25 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 16 if        
    age >= 1 & age <= 6 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 17 if        
    age >= 7 & age <= 38 &
    educa >= 1 & educa <= 10 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 22 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 3 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 28 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 30 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 2 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 31 if        
    age >= 1 & age <= 38 &
    educa >= 3 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 36 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 8 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 37 if        
    age >= 1 & age <= 7 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 9 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 38 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 5 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 40 if        
    age >= 1 & age <= 9 &
    educa >= 1 & educa <= 5 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 44 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 22 ;
 replace nodo= 56 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 26 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 57 if        
    age >= 1 & age <= 38 &
    educa >= 8 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 75 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 13 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 76 if        
    age >= 1 & age <= 2 &
    educa >= 6 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 77 if        
    age >= 3 & age <= 9 &
    educa >= 6 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 78 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 31 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 80 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 14 ;
 replace nodo= 85 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 42 & dindphis <= 46 ;
 replace nodo= 128 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 6 & hisppor <= 10 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 129 if        
    age >= 8 & age <= 38 &
    educa >= 11 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 11 & hisppor <= 12 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 138 if        
    age >= 10 & age <= 38 &
    educa >= 1 & educa <= 7 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 139 if        
    age >= 10 & age <= 38 &
    educa >= 8 & educa <= 8 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 32 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 143 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 34 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 149 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 28 & dindphis <= 41 ;
 replace nodo= 252 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 18 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 253 if        
    age >= 10 & age <= 38 &
    educa >= 9 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 19 & hisppor <= 33 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 15 & dindphis <= 46 ;
 replace nodo= 264 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 88 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 27 ;
 replace nodo= 442 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 89 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 23 & dindphis <= 24 ;
 replace nodo= 443 if        
    age >= 1 & age <= 38 &
    educa >= 4 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 89 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 25 & dindphis <= 27 ;
end;           

capture program drop salari03;           
program define salari03;           
 replace nodo= 3 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 4 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    age >= 1 & age <= 38 &
    educa >= 1 & educa <= 13 &
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           

capture program drop salari13;           
program define salari13;           
 replace nodo= 6 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 7 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 2 & etnia <= 2 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 8 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 1 & hisppor <= 4 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 9 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 5 & hisppor <= 17 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 10 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 18 & hisppor <= 36 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
 replace nodo= 11 if        
    voca >= 1 & voca <= 2 &
    veterano >= 1 & veterano <= 2 &
    etnia >= 1 & etnia <= 1 &
    periodo >= 1 & periodo <= 108 &
    hisppor >= 37 & hisppor <= 45 &
    doccphis >= 1 & doccphis <= 45 &
    dindphis >= 1 & dindphis <= 46 ;
end;           

capture program drop masvar;
program define masvar;
	version 7.0;
	syntax varlist [if] [in], AT(integer);
	tokenize `varlist';
	quietly while "`1'" ~= ""{;
		gen `1'`at'=(`1'^`at')/(10^`at');
		macro shift;
	};
end;


********************************************************************************;
log using ${output},replace;

*$*use ${datain}datos01.dta,replace;
*$*
*$*gen grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
*$*	+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
*$*	+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
*$*	gen oldhip=hisppor;
*$*	gen oldeduc=educa;
*$*	gen oldetni=etnia;
*$*	replace hisppor=floor(10^6*hisppor);	
*$*	replace educa=10*educa;
*$** entra modelo de participacion;
*$*	quietly do ${progra}parall2.do;
*$*	sort grid;
*$*	by grid:egen malpha=mean(wagesmpl);
*$*	* la definicion de participacion esta mal en aries;
*$*	replace alpha2=1-alpha2;
*$*	replace alpha2=malpha if nodo2==-1;
*$*	* me aseguro de que las estimaciones se hacen con un minimo de observaciones;
*$*	sort nodo2 grid;
*$*	by nodo2 grid:egen malpha2=mean(wagesmpl);
*$*	by nodo2 grid:egen cnum2=count(wagesmpl);
*$*	count if alpha2>0 & numls2<40;
*$*	count if alpha2>0 & cnum2<40;
*$*	replace alpha2=malpha2 if numls2<40;
*$*	replace alpha2=malpha if cnum2<40;
*$*	* tengo que eliminar los unos;
*$*	replace alpha2=cnum2/(cnum2+1) if alpha2==1;
*$*	* luego tengo los ceros. Me dan igual, pero hago el cambio para que funcione el programa;
*$*	capture gen ceros=alpha2==0;
*$*	replace alpha2=1/(cnum2+1) if alpha2==0;
*$*	drop numls2 nodo2 malpha malpha2 cnum2;
*$** cambio los nombres;
*$*	rename alpha2 alpha;
*$** genero los betas;
*$*	gen beta=invnorm(alpha);
*$*	gen beta2=beta^2;
*$*	gen beta3=beta^3;
*$*	gen beta4=beta^4;
*$** me quedo solo con la muestra de salarios;
*$*	keep if wagesmpl==1;
*$*	keep periodo state year salarios age exp educa voca etnia veterano marital 
*$*		calif arizo texas newme sindi doccphis doccmedu dindphis dindmedu 
*$*		dmsaphis dmsamedu hisppor beta beta2 beta3 beta4;
*$**reparametrizacion de age;
*$*	qui tab age, g(dummy);
*$*	local icount=1;
*$*	while `icount' <= 38 {;
*$*		replace age=`icount' if dummy`icount'==1;
*$*		local icount=`icount'+1; 
*$*		};
*$*	drop dummy*;
*$**reparametrizacion de educa;
*$*	qui tab educa, g(dummy);
*$*	local icount=1;
*$*	while `icount' <= 13 {;
*$*		replace educa=`icount' if dummy`icount'==1;
*$*		local icount=`icount'+1; 
*$*		};
*$*	drop dummy*;
*$**reparametrizacion de voca;
*$*	replace voca=(voca==0)+2*(voca==1);
*$**reparametrizacion de veterano;
*$*	replace veterano=(veterano==0)+2*(veterano==1);
*$**reparametrizacion de etnia;
*$*	replace etnia=(etnia==0)+2*(etnia==1);
*$**reparametrizacion de hisspor;
*$*	qui tab hisppor, g(dummy);
*$*	local icount=1;
*$*	while `icount' <= 45 {;
*$*		replace hisppor=`icount' if dummy`icount'==1;
*$*		local icount=`icount'+1; 
*$*		};
*$*	drop dummy*;
*$** particion de la muestra segun salari01;
*$*	gen nodo=-1;
*$*	qui salari01;
*$*save ${datain}temp00.dta,replace;


*$*use ${datain}temp00.dta,clear;
*$** computacion del R2;
*$*quietly {;
*$*	regress salario if etnia==1;
*$*	predict yb1;
*$*	regress salario if etnia==2;
*$*	predict yb2;
*$*	gen yhat=yb1;
*$*	replace yhat=yb2 if etnia==2;
*$*	egen nodon=group(nodo);
*$*	su nodon;
*$*	local m=r(max);
*$*	local i=2;
*$*	while `i'<=`m' {;
*$*		regress salario beta beta2 beta3 beta4 if nodon==`i';
*$*		predict xb;
*$*		replace yhat=xb if nodon==`i';
*$*		drop xb;
*$*		local i=`i'+1;
*$*	};
*$*	egen snum1=sum((etnia==1)*(salario-yhat)^2);
*$*	egen dnum1=sum((etnia==1)*(salario-yb1)^2);
*$*	egen snum2=sum((etnia==2)*(salario-yhat)^2);
*$*	egen dnum2=sum((etnia==2)*(salario-yb1)^2);
*$*	gen r2=(etnia==1)*(1-(snum1/dnum1))+(etnia==2)*(1-(snum2/dnum2));
*$*	su r2 if etnia==1;
*$*	noi dis "R2 for NHW: " %9.4f r(mean);
*$*	su r2 if etnia==2;
*$*	noi dis "R2 for MA: " %9.4f r(mean);
*$*};

*computacion de los efectos marginales;
use ${datain}temp00.dta,clear;
	gen betaold=beta;
	gen nodoold=nodo;
	egen nodon=group(nodo);

capture program drop predice;           
program define predice;           
quietly {;
	replace nodo=-1;
	qui salari01;
	su nodon;
	local m=r(max);
	local icount=1;
	while `icount'<=`m' {;
*		regress salario beta beta2 beta3 beta4 if nodon==`icount';
		regress salario if nodon==`icount';
		replace beta=0;
		replace beta2=0;
		replace beta3=0;
		replace beta4=0;
		predict xb;
		replace `1'=xb if nodo==nodoold;
		replace beta=betaold;
		replace beta2=betaold^2;
		replace beta3=betaold^3;
		replace beta4=betaold^4;
		drop xb;
		local icount=`icount'+1;
		};
	};
end;


* Age: de 25 a 62;
quietly {;
	gen old=age;
	gen pxb=0;
	gen pxbmu=0;
	replace age=1;*1;
	predice pxb;
	replace age=10;*38;
	predice pxbmu;
	gen dp=(pxbmu-pxb)/(30-27);
	noi su dp if etnia==1;
	noi su dp if etnia==2;
	replace age=old;
	drop old* pxb* dp;
	};

* Education: de 0 a 20;
quietly {;
	gen old=educa;
	gen pxb=0;
	gen pxbmu=0;
	replace educa=1;
	predice pxb;
	replace educa=13;
	predice pxbmu;
	gen dp=(pxbmu-pxb)/(20);
	noi su dp if etnia==1;
	noi su dp if etnia==2;
	replace educa=old;
	drop old* pxb* dp;
	};

* Hispanic Area: 0.03 a 0.64;
quietly {;
	gen old=hisppor;
	gen pxb=0;
	gen pxbmu=0;
	replace hisppor=1;
	predice pxb;
	replace hisppor=45;
	predice pxbmu;
	gen dp=(pxbmu-pxb)/(0.64-0.03);
	noi su dp if etnia==1;
	noi su dp if etnia==2;
	replace hisppor=old;
	drop old* pxb* dp;
	};

* Hispanic Occupation: de 1 a 47;
quietly {;
	gen old=doccphis;
	gen pxb=0;
	gen pxbmu=0;
	replace doccphis=1;
	predice pxb;
	replace doccphis=47;
	predice pxbmu;
	gen dp=(pxbmu-pxb)/(47-1);
	noi su dp if etnia==1;
	noi su dp if etnia==2;
	replace doccphis=old;
	drop old* pxb* dp;
	};

* Hispanic Industry: de 1 a 49;
quietly {;
	gen old=dindphis;
	gen pxb=0;
	gen pxbmu=0;
	replace dindphis=1;
	predice pxb;
	replace dindphis=49;
	predice pxbmu;
	gen dp=(pxbmu-pxb)/(49-1);
	noi su dp if etnia==1;
	noi su dp if etnia==2;
	replace dindphis=old;
	drop old* pxb* dp;
	};

log close;

beep;
exit;


