#delimit;
capture log close;
set more off;
clear;
set matsize 800;

* Estima las regresiones parametricas y los efectos marginales;
 
******************************** Sendas ****************************************;
global output "C:\AAPAPERS\HISPANOS\OUTPUT\regre01.log";
global datain "C:\AAPAPERS\HISPANOS\DATA\";
global temporal "C:\AAPAPERS\HISPANOS\DATA\temporal.dta";
global progra "C:\AAPAPERS\HISPANOS\PROGRAMA\";
********************************************************************************;

********************************************************************************;
log using ${output},replace;


* Modelo Parametrico cuadratico;

use ${datain}datos01.dta,replace;

qui tab periodo, g(dtiempo);
drop dtiempo1;
qui tab dmsamedu, g(darea);
drop darea1;

gen ageconB=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45));
gen educconB=((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14));
gen ano96=(year>1996);
gen padres=(((agepad>0)|(agemad>0)) & (marital==0));

* En la presentacion de las estimaciones parametricas utilizo la muestra completa, como
* en la presentacion de los modelos de participacion;

* Parametrica Cuadratica
	* Blancos;
	reg salario age age2 educa agexed voca hisppor doccphis dindphis veterano periodo
		if etnia==0;
capture program drop jequeman;
program define jequeman;
	quietly  {;
	preserve;
	keep if etnia==`0';
	noi heckman salario age age2 educa agexed voca hisppor doccphis dindphis veterano periodo,
	sel(age age2 educa agexed voca ageconB educconB padres veterano calif arizo texas 
		dtiempo* hisppor) two;
	};
end;
	jequeman 0;
	quietly {;
	probit wagesmpl age age2 educa agexed voca ageconB educconB padres veterano calif arizo texas 
		dtiempo* hisppor if etnia==0;
	predict gz, xb;
	predict prob;
	gen double phibx=normd(gz);
	gen heclam=phibx/prob;

	noi reg salario age age2 educa agexed voca hisppor doccphis dindphis veterano periodo heclam
		if etnia==0;
replace heclam=0;
	noi dis in g "Age: de 25 a 60";
	gen old=age;
	replace age=25;
	replace age2=25^2;
	replace agexed=25*educa;
	predict pxb;
	replace age=62;
	replace age2=62^2;
	replace agexed=62*educa;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(62-25);
	noi su dp if etnia==0 & wagesmpl==1;
	replace age=old;
	replace age2=old^2;
	replace agexed=old*educa;
	drop old* pxb* dp;

	noi dis in g "Education: de 0 a 20";
	gen old=educa;
	replace educa=0;
	replace agexed=age*0;
	predict pxb;
	replace educa=20;
	replace agexed=age*20;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/20;
	noi su dp if etnia==0 & wagesmpl==1;
	replace educa=old;
	replace agexed=age*old;
	drop old* pxb* dp;

	noi dis in g "Vocational Training: de 0 a 1";
	gen old=voca;
	replace voca=0;
	predict pxb;
	replace voca=1;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(1-0);
	noi su dp if etnia==0 & wagesmpl==1;
	replace voca=old;
	drop old* pxb* dp;

	noi dis in g "Hispanic Area: de 0.03 a 0.64";
	gen old=hisppor;
	replace hisppor=0.0262534;
	predict pxb;
	replace hisppor=0.6423225;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(0.6423225-0.0262534);
	noi su dp if etnia==0 & wagesmpl==1;
	replace hisppor=old;
	drop old* pxb* dp;

	noi dis in g "Hispanic Occupation: de 1 a 47";
	gen old=doccphis;
	replace doccphis=1;
	predict pxb;
	replace doccphis=47;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(47-1);
	noi su dp if etnia==0 & wagesmpl==1;
	replace doccphis=old;
	drop old* pxb* dp;

	noi dis in g "Hispanic Industry: de 1 a 49";
	gen old=dindphis;
	replace dindphis=1;
	predict pxb;
	replace dindphis=49;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(49-1);
	noi su dp if etnia==0 & wagesmpl==1;
	replace dindphis=old;
	drop old* pxb* dp;

	noi dis in g "Veteran: de 0 a 1";
	gen old=veterano;
	replace veterano=0;
	predict pxb;
	replace veterano=1;
	predict pxbmu;
	gen dp=(pxbmu-pxb);
	noi su dp if etnia==0 & wagesmpl==1;
	replace veterano=old;
	drop old* pxb* dp;

	noi dis in g "Time Trend: de 1 a 108";
	gen old=periodo;
	replace periodo=1;
	predict pxb;
	replace periodo=108;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(108-1);
	noi su dp if etnia==0 & wagesmpl==1;
	replace periodo=old;
	drop old* pxb* dp;
	drop gz prob phibx heclam;
	};

	* Mexican;
	reg salario age age2 educa agexed voca hisppor doccphis dindphis veterano periodo
		if etnia==1;
	jequeman 1;
	quietly {;
	probit wagesmpl age age2 educa agexed voca ageconB educconB padres veterano calif arizo texas 
		dtiempo* hisppor if etnia==1;
	predict gz, xb;
	predict prob;
	gen double phibx=normd(gz);
	gen heclam=phibx/prob;

	noi reg salario age age2 educa agexed voca hisppor doccphis dindphis veterano periodo heclam
		if etnia==1;

	noi dis in g "Age: de 25 a 60";
	gen old=age;
	replace age=25;
	replace age2=25^2;
	replace agexed=25*educa;
	predict pxb;
	replace age=62;
	replace age2=62^2;
	replace agexed=62*educa;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(62-25);
	noi su dp if etnia==1 & wagesmpl==1;
	replace age=old;
	replace age2=old^2;
	replace agexed=old*educa;
	drop old* pxb* dp;

	noi dis in g "Education: de 0 a 1";
	gen old=educa;
	replace educa=0;
	replace agexed=age*0;
	predict pxb;
	replace educa=20;
	replace agexed=age*20;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/20;
	noi su dp if etnia==1 & wagesmpl==1;
	replace educa=old;
	replace agexed=age*old;
	drop old* pxb* dp;

	noi dis in g "Vocational Training: de 0 a 1";
	gen old=voca;
	replace voca=0;
	predict pxb;
	replace voca=1;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(1-0);
	noi su dp if etnia==1 & wagesmpl==1;
	replace voca=old;
	drop old* pxb* dp;

	noi dis in g "Hispanic Area: de 0.03 a 0.64";
	gen old=hisppor;
	replace hisppor=0.0262534;
	predict pxb;
	replace hisppor=0.6423225;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(0.6423225-0.0262534);
	noi su dp if etnia==1 & wagesmpl==1;
	replace hisppor=old;
	drop old* pxb* dp;

	noi dis in g "Hispanic Occupation: de 1 a 47";
	gen old=doccphis;
	replace doccphis=1;
	predict pxb;
	replace doccphis=47;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(47-1);
	noi su dp if etnia==1 & wagesmpl==1;
	replace doccphis=old;
	drop old* pxb* dp;

	noi dis in g "Hispanic Industry: de 1 a 49";
	gen old=dindphis;
	replace dindphis=1;
	predict pxb;
	replace dindphis=49;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(49-1);
	noi su dp if etnia==1 & wagesmpl==1;
	replace dindphis=old;
	drop old* pxb* dp;

	noi dis in g "Veteran: de 0 a 1";
	gen old=veterano;
	replace veterano=0;
	predict pxb;
	replace veterano=1;
	predict pxbmu;
	gen dp=(pxbmu-pxb);
	noi su dp if etnia==1 & wagesmpl==1;
	replace veterano=old;
	drop old* pxb* dp;

	noi dis in g "Time Trend: de 1 a 108";
	gen old=periodo;
	replace periodo=1;
	predict pxb;
	replace periodo=108;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(108-1);
	noi su dp if etnia==1 & wagesmpl==1;
	replace periodo=old;
	drop old* pxb* dp;
	drop gz prob phibx heclam;
	};


* Parametrica muy flexible;

use ${datain}datos01.dta,replace;

qui tab periodo, g(dtiempo);
drop dtiempo1;
qui tab dmsamedu, g(darea);
drop darea1;

gen ageconB=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45));
gen educconB=((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14));
gen ano96=(year>1996);
gen padres=(((agepad>0)|(agemad>0)) & (marital==0));

gen age3=age^3;
gen age4=age^4;
gen age5=age^5;
gen age6=age^6;
gen educa2=educa^2;
gen educa3=educa^3;
gen educa4=educa^4;
gen educa5=educa^5;
gen educa6=educa^6;
gen hisppor2=hisppor^2;
gen hisppor3=hisppor^3;
gen hisppor4=hisppor^4;
gen hisppor5=hisppor^5;
gen hisppor6=hisppor^6;
gen doccphi2=doccphis^2;
gen doccphi3=doccphis^3;
gen doccphi4=doccphis^4;
gen dindphi2=dindphis^2;
gen dindphi3=dindphis^3;
gen dindphi4=dindphis^4;
	* Blancos;
	reg salario 
		age age2 age3 age4 
		educa educa2 educa3 educa4
		agexed voca veterano periodo
		hisppor hisppor2 hisppor3 hisppor4
		doccphis doccphi2 doccphi3 doccphi4
		dindphis dindphi2 dindphi3 dindphi4
		 if etnia==0;

capture program drop jequeman;
program define jequeman;
	quietly  {;
	preserve;
	keep if etnia==`0';
	noi heckman salario
		age age2 age3 age4 
		educa educa2 educa3 educa4
		agexed voca veterano periodo
		hisppor hisppor2 hisppor3 hisppor4
		doccphis doccphi2 doccphi3 doccphi4
		dindphis dindphi2 dindphi3 dindphi4,
	sel(age age2 age3 age4 age5
		educa educa2 educa3 educa4 educa5
		agexed voca ageconB educconB padres veterano calif 
		arizo texas dtiempo* 
		hisppor hisppor2 hisppor3 hisppor4 hisppor5) two;
	};
end;
	jequeman 0;
	quietly {;
	probit wagesmpl
		age age2 age3 age4 age5
		educa educa2 educa3 educa4 educa5
		agexed voca ageconB educconB padres veterano calif 
		arizo texas dtiempo* 
		hisppor hisppor2 hisppor3 hisppor4 hisppor5
		if etnia==0;
	predict gz, xb;
	predict prob;
	gen double phibx=normd(gz);
	gen heclam=phibx/prob;
	reg salario 
		age age2 age3 age4 
		educa educa2 educa3 educa4
		agexed voca veterano periodo
		hisppor hisppor2 hisppor3 hisppor4
		doccphis doccphi2 doccphi3 doccphi4
		dindphis dindphi2 dindphi3 dindphi4
		heclam if etnia==0;

	noi dis in g "Age: de 25 a 60";
	gen old=age;
	replace age=25;
	replace age2=25^2;
	replace age3=25^3;
	replace age4=25^4;
	replace agexed=25*educa;
	predict pxb;
	replace age=62;
	replace age2=62^2;
	replace age3=62^3;
	replace age4=62^4;
	replace agexed=62*educa;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(62-25);
	noi su dp if etnia==0 & wagesmpl==1;
	replace age=old;
	replace age2=old^2;
	replace age3=old^3;
	replace age4=old^4;
	replace agexed=old*educa;
	drop old* pxb* dp;

	noi dis in g "Education: de 0 a 20";
	gen old=educa;
	replace educa=0;
	replace educa2=0^2;
	replace educa3=0^3;
	replace educa4=0^4;
	replace agexed=age*0;
	predict pxb;
	replace educa=20;
	replace educa2=20^2;
	replace educa3=20^3;
	replace educa4=20^4;
	replace agexed=age*20;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/20;
	noi su dp if etnia==0 & wagesmpl==1;
	replace educa=old;
	replace educa2=old^2;
	replace educa3=old^3;
	replace educa4=old^4;
	replace agexed=age*old;
	drop old* pxb* dp;

	noi dis in g "Vocational Training: de 0 a 1";
	gen old=voca;
	replace voca=0;
	predict pxb;
	replace voca=1;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(1-0);
	noi su dp if etnia==0 & wagesmpl==1;
	replace voca=old;
	drop old* pxb* dp;

	noi dis in g "Hispanic Area: de 0.03 a 0.64";
	gen old=hisppor;
	replace hisppor=0.0262534;
	replace hisppor2=0.0262534^2;
	replace hisppor3=0.0262534^3;
	replace hisppor4=0.0262534^4;
	predict pxb;
	replace hisppor=0.6423225;
	replace hisppor2=0.6423225^2;
	replace hisppor3=0.6423225^3;
	replace hisppor4=0.6423225^4;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(0.6423225-0.0262534);
	noi su dp if etnia==0 & wagesmpl==1;
	replace hisppor=old;
	replace hisppor2=old^2;
	replace hisppor3=old^3;
	replace hisppor4=old^4;
	drop old* pxb* dp;

	noi dis in g "Hispanic Occupation: de 1 a 47";
	gen old=doccphis;
	replace doccphis=1;
	replace doccphi2=1^2;
	replace doccphi3=1^3;
	replace doccphi4=1^4;
	predict pxb;
	replace doccphis=47;
	replace doccphi2=47^2;
	replace doccphi3=47^3;
	replace doccphi4=47^4;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(47-1);
	noi su dp if etnia==0 & wagesmpl==1;
	replace doccphis=old;
	replace doccphi2=old^2;
	replace doccphi3=old^3;
	replace doccphi4=old^4;
	drop old* pxb* dp;

	noi dis in g "Hispanic Industry: de 1 a 49";
	gen old=dindphis;
	replace dindphis=1;
	replace dindphi2=1^2;
	replace dindphi3=1^3;
	replace dindphi4=1^4;
	predict pxb;
	replace dindphis=49;
	replace dindphi2=49^2;
	replace dindphi3=49^3;
	replace dindphi4=49^4;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(49-1);
	noi su dp if etnia==0 & wagesmpl==1;
	replace dindphis=old;
	replace dindphi2=old^2;
	replace dindphi3=old^3;
	replace dindphi4=old^4;
	drop old* pxb* dp;

	noi dis in g "Veteran: de 0 a 1";
	gen old=veterano;
	replace veterano=0;
	predict pxb;
	replace veterano=1;
	predict pxbmu;
	gen dp=(pxbmu-pxb);
	noi su dp if etnia==0 & wagesmpl==1;
	replace veterano=old;
	drop old* pxb* dp;

	noi dis in g "Time Trend: de 1 a 108";
	gen old=periodo;
	replace periodo=1;
	predict pxb;
	replace periodo=108;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(108-1);
	noi su dp if etnia==0 & wagesmpl==1;
	replace periodo=old;
	drop old* pxb* dp;
	drop gz prob phibx heclam;
	};

	* Mexican;
	reg salario 
		age age2 age3 age4 
		educa educa2 educa3 educa4
		agexed voca veterano periodo
		hisppor hisppor2 hisppor3 hisppor4
		doccphis doccphi2 doccphi3 doccphi4
		dindphis dindphi2 dindphi3 dindphi4
		 if etnia==1;
	jequeman 1;
	quietly {;
	probit wagesmpl 
		age age2 age3 age4 age5
		educa educa2 educa3 educa4 educa5
		agexed voca ageconB educconB padres veterano calif 
		arizo texas dtiempo* 
		hisppor hisppor2 hisppor3 hisppor4 hisppor5
		if etnia==1;
	predict gz, xb;
	predict prob;
	gen double phibx=normd(gz);
	gen heclam=phibx/prob;
	noi reg salario 
		age age2 age3 age4 
		educa educa2 educa3 educa4
		agexed voca veterano periodo
		hisppor hisppor2 hisppor3 hisppor4
		doccphis doccphi2 doccphi3 doccphi4
		dindphis dindphi2 dindphi3 dindphi4
		heclam if etnia==1;
	noi dis in g "Age: de 25 a 60";
	gen old=age;
	replace age=25;
	replace age2=25^2;
	replace age3=25^3;
	replace age4=25^4;
	replace agexed=25*educa;
	predict pxb;
	replace age=62;
	replace age2=62^2;
	replace age3=62^3;
	replace age4=62^4;
	replace agexed=62*educa;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(62-25);
	noi su dp if etnia==1 & wagesmpl==1;
	replace age=old;
	replace age2=old^2;
	replace age3=old^3;
	replace age4=old^4;
	replace agexed=old*educa;
	drop old* pxb* dp;

	noi dis in g "Education: de 0 a 20";
	gen old=educa;
	replace educa=0;
	replace educa2=0^2;
	replace educa3=0^3;
	replace educa4=0^4;
	replace agexed=age*0;
	predict pxb;
	replace educa=20;
	replace educa2=20^2;
	replace educa3=20^3;
	replace educa4=20^4;
	replace agexed=age*20;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/20;
	noi su dp if etnia==1 & wagesmpl==1;
	replace educa=old;
	replace educa2=old^2;
	replace educa3=old^3;
	replace educa4=old^4;
	replace agexed=age*old;
	drop old* pxb* dp;

	noi dis in g "Vocational Training: de 0 a 1";
	gen old=voca;
	replace voca=0;
	predict pxb;
	replace voca=1;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(1-0);
	noi su dp if etnia==1 & wagesmpl==1;
	replace voca=old;
	drop old* pxb* dp;

	noi dis in g "Hispanic Area: de 0.03 a 0.64";
	gen old=hisppor;
	replace hisppor=0.0262534;
	replace hisppor2=0.0262534^2;
	replace hisppor3=0.0262534^3;
	replace hisppor4=0.0262534^4;
	predict pxb;
	replace hisppor=0.6423225;
	replace hisppor2=0.6423225^2;
	replace hisppor3=0.6423225^3;
	replace hisppor4=0.6423225^4;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(0.6423225-0.0262534);
	noi su dp if etnia==1 & wagesmpl==1;
	replace hisppor=old;
	replace hisppor2=old^2;
	replace hisppor3=old^3;
	replace hisppor4=old^4;
	drop old* pxb* dp;

	noi dis in g "Hispanic Occupation: de 1 a 47";
	gen old=doccphis;
	replace doccphis=1;
	replace doccphi2=1^2;
	replace doccphi3=1^3;
	replace doccphi4=1^4;
	predict pxb;
	replace doccphis=47;
	replace doccphi2=47^2;
	replace doccphi3=47^3;
	replace doccphi4=47^4;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(47-1);
	noi su dp if etnia==1 & wagesmpl==1;
	replace doccphis=old;
	replace doccphi2=old^2;
	replace doccphi3=old^3;
	replace doccphi4=old^4;
	drop old* pxb* dp;

	noi dis in g "Hispanic Industry: de 1 a 49";
	gen old=dindphis;
	replace dindphis=1;
	replace dindphi2=1^2;
	replace dindphi3=1^3;
	replace dindphi4=1^4;
	predict pxb;
	replace dindphis=49;
	replace dindphi2=49^2;
	replace dindphi3=49^3;
	replace dindphi4=49^4;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(49-1);
	noi su dp if etnia==1 & wagesmpl==1;
	replace dindphis=old;
	replace dindphi2=old^2;
	replace dindphi3=old^3;
	replace dindphi4=old^4;
	drop old* pxb* dp;

	noi dis in g "Veteran: de 0 a 1";
	gen old=veterano;
	replace veterano=0;
	predict pxb;
	replace veterano=1;
	predict pxbmu;
	gen dp=(pxbmu-pxb);
	noi su dp if etnia==1 & wagesmpl==1;
	replace veterano=old;
	drop old* pxb* dp;

	noi dis in g "Time Trend: de 1 a 108";
	gen old=periodo;
	replace periodo=1;
	predict pxb;
	replace periodo=108;
	predict pxbmu;
	gen dp=(pxbmu-pxb)/(108-1);
	noi su dp if etnia==1 & wagesmpl==1;
	replace periodo=old;
	drop old* pxb* dp;
	drop gz prob phibx heclam;
	};

beep;
log close;
exit;


