#delimit;
capture log close;
set more off;
clear;
set matsize 800;

* analisis de los resultados del modelo no-parametrico de participacion;
* calcula los efectos marginales con sus SEs;
* calcula los efectos marginales minimos y maximos con sus SEs; 

******************************** Sendas ****************************************;
global output "C:\AAPAPERS\HISPANOS\OUTPUT\partic03.log";
global datain "C:\AAPAPERS\HISPANOS\DATA\";
global progra "C:\AAPAPERS\HISPANOS\PROGRAMA\";
********************************************************************************;

* periodo state year salarios age age2 exp exp2 agexed expxed educa voca 
* etnia veterano marital calif arizo texas newme sindi wagesmpl 
* doccphis doccmedu dindphis dindmedu dmsaphis dmsamedu hisppor
* educcon agecon educpad agepad selfpad educmad agemad selfmad;

********************************************************************************;
capture program drop predice;
program define predice;
	quietly do ${progra}parall2.do;
	quietly limpia;
	capture rename alpha2 `1';
end;

capture program drop limpia;
program define limpia;
	sort grid;
	by grid:egen malpha=mean(wagesmpl);
	* la definicion de participacion esta mal en aries;
	replace alpha2=1-alpha2;
	replace alpha2=malpha if nodo2==-1;
	* me aseguro de que las estimaciones se hacen con un minimo de observaciones;
	sort nodo2 grid;
	by nodo2 grid:egen malpha2=mean(wagesmpl);
	by nodo2 grid:egen cnum2=count(wagesmpl);
	count if alpha2>0 & numls2<40;
	count if alpha2>0 & cnum2<40;
	replace alpha2=malpha2 if numls2<40;
	replace alpha2=malpha if cnum2<40;
	* tengo que eliminar los unos;
	replace alpha2=cnum2/(cnum2+1) if alpha2==1;
	* luego tengo los ceros. Me dan igual, pero hago el cambio para que funcione el programa;
	capture gen ceros=alpha2==0;
	replace alpha2=1/(cnum2+1) if alpha2==0;
	drop numls2 nodo2 malpha malpha2 cnum2;
end;

log using ${output},replace;

* generacion del grid de datos para los modelos de participacion;

*$*use ${datain}datos01.dta,replace;
gen grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
	+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
	+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));

* aries utiliza transformaciones de educa y hisppor;
	gen oldhip=hisppor;
	gen oldeduc=educa;
	replace hisppor=floor(10^6*hisppor);	
	replace educa=10*educa;
* entrada de resultados del modelo no parametrico de la participacion;
	predice alpha2;
* cambio los nombres;
	rename alpha2 alpha;
	rename numls2 numls;
	rename nodo2 nodo;
save ${datain}temp00.dta,replace;

use ${datain}temp00.dta,replace;
drop malpha malpha2 cnum2;
* Calculo de los efectos marginales;
	* age: de 25 a 62;
	gen old=age;
	replace age=25;
	predice pxb;
	replace age=62;
	predice pxbmu;
	gen dp=(pxbmu-pxb)/(62-25);
	su dp if etnia==0;
	su dp if etnia==1;
	replace age=old;
	drop old pxb* dp;

	* educa: de 0 a 20 anos;
	gen old=educa;
	replace educa=10*0;
	predice pxb;
	replace educa=10*20;
	predice pxbmu;
	gen dp=(pxbmu-pxb)/(20);
	su dp if etnia==0;
	su dp if etnia==1;
	replace educa=old;
	drop old* pxb* dp;
	
	* vocational training;
	gen old=voca;
	replace voca=0;
	predice pxb;
	replace voca=1;
	predice pxbmu;
	gen dp=pxbmu-pxb;
	su dp if etnia==0;
	su dp if etnia==1;
	replace voca=old;
	drop old* pxb* dp;
	
	* ageconB: de 2 a 4;
	gen old=grid;
	gen oldagec=agecon;
	replace agecon=2;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxb;
	replace agecon=46;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxbmu;
	gen dp=(pxbmu-pxb)/(4-2);
	su dp if etnia==0;
	su dp if etnia==1;
	replace agecon=oldagec;
	replace grid=old;
	drop old* pxb* dp;
	
	* educconB: de 2 a 4; 
	gen old=grid;
	gen oldeduc=educcon;
	replace educcon=2;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxb;
	replace educcon=15;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxbmu;
	gen dp=(pxbmu-pxb)/(4-2);
	su dp if etnia==0;
	su dp if etnia==1;
	replace educcon=oldeduc;
	replace grid=old;
	drop old* pxb* dp;
	
	* padres;
	gen old=grid;
	gen oldagep=agepad;
	gen oldagem=agemad;
	gen oldmari=marital;
	replace agepad=0;
	replace agemad=0;
	replace marital=1;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxb;
	replace agepad=1;
	replace agemad=1;
	replace marital=0;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxbmu;
	gen dp=(pxbmu-pxb);
	su dp if etnia==0;
	su dp if etnia==1;
	replace agepad=oldagep;
	replace agemad=oldagem;
	replace marital=oldmari;
	replace grid=old;
	drop old* pxb* dp;
	
	* veterano;
	gen old=veterano;
	replace veterano=0;
	predice pxb;
	replace veterano=1;
	predice pxbmu;
	gen dp=(pxbmu-pxb);
	su dp if etnia==0;
	su dp if etnia==1;
	replace veterano=old;
	drop old* pxb* dp;
	
	* california;
	gen old=grid;
	gen oldsta=state;
	replace state=85;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxb;
	replace state=93;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxbmu;
	gen dp=(pxbmu-pxb);
	su dp if etnia==0;
	su dp if etnia==1;
	replace state=oldsta;
	replace grid=old;
	drop old* pxb* dp;
	
	* arizona;
	gen old=grid;
	gen oldsta=state;
	replace state=85;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxb;
	replace state=86;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxbmu;
	gen dp=(pxbmu-pxb);
	su dp if etnia==0;
	su dp if etnia==1;
	replace state=oldsta;
	replace grid=old;
	drop old* pxb* dp;
	
	* texas;
	gen old=grid;
	gen oldsta=state;
	replace state=85;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxb;
	replace state=74;
	replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
		+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
		+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
	predice pxbmu;
	gen dp=(pxbmu-pxb);
	su dp if etnia==0;
	su dp if etnia==1;
	replace state=oldsta;
	replace grid=old;
	drop old* pxb* dp;

	* hisppor: de 0.03 a 0.64;
	gen old=hisppor;
	replace hisppor=floor(10^6*0.03);
	predice pxb;
	replace hisppor=floor(10^6*0.64);
	predice pxbmu;
	gen dp=(pxbmu-pxb)/(0.64-0.03);
	su dp if etnia==0;
	su dp if etnia==1;
	replace hisppor=old;
	drop old* pxb* dp;

* lambda de Heckman y score en el modelo no-parametrico;
gen double beta=invnorm(alpha);
gen heclam=normden(beta)/alpha;
gen gz=(wagesmpl-1)*normden(beta)/(1-alpha)+wagesmpl*heclam;
label var heclam "Lambda de Heckman asalariado";
label var gz "score";
su gz heclam;
su gz heclam if etnia==0;
su gz heclam if etnia==1;

log close;

* creacion de datos de asignacion mediante merge;
use ${datain}temp00.dta,clear;
	* hago el collapse;
	collapse (mean) alpha (mean) numls, by(grid nodo);
	rename alpha alphan;
	rename numls numlsn;
	rename nodo nodon;
	sort grid nodon;
save ${datain}temp01.dta,replace;

* cambio los datos de edad, computo nuevos nodos, y asigno los parametros;
use ${datain}temp00.dta,clear;

capture program drop margave;
program define margave;
	version 7.0;
	syntax varlist [if] [, WITH(integer 1)];
	preserve;
	tempvar dif vardif;
	noi di _n as txt "     Average Increase Effects For Non-Parametric Surface" _newline;
	noi di _n as txt "     Increase: " in y "`with'";
	noi di as txt "    {hline 67}";
	noi di as txt "     Variable      Mean      SE      Min       SE       Max       SE";
	noi di as txt "    {hline 67}";
	tokenize `varlist';
	if "`if'" ~= ""{;
	keep `if';
	if "`1'"=="agecon"{;
		replace educcon=13;
		};
	if "`1'"=="educcon"{;
		replace agecon=42;
		};
	};
	quietly while "`1'" ~= ""{;
		replace `1'=`1' + `with';
		replace grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
			+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
			+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));
		quietly do ${progra}parnod2.do;
		sort grid nodon;
		merge grid nodon using ${datain}temp01.dta;
		drop if numlsn<=0;
		drop if numls<=0;
	* calculo diferencial y su varianza para cada individuo;
		gen `dif'=alphan-alpha;
		gen `vardif'=(1/numlsn)*alphan*(1-alphan)+(1/numls)*alpha*(1-alpha);
		replace `dif'=. if `vardif'==.;
	* calculo la desviacion tipica de la diferencia media;
		su `dif';
		local media = r(mean);
		local minimo = r(min);
		local maximo = r(max);
		su `vardif', meanonly;
		local dtdif=sqrt((1/r(N))*r(mean));
		su `vardif' if `dif'==float(`minimo'),meanonly;
		local dtmin=sqrt((1/r(N))*r(mean));
		su `vardif' if `dif'==float(`maximo');
		local dtmax=sqrt((1/r(N))*r(mean));
		noi di as txt _col(6) abbrev("`1'",12)  as res _col(16) %9.4f `media'  
				_col(25) %9.4f `dtdif' _col(33) %9.4f `minimo' 
				_col(41) %9.4f `dtmin' _col(49) %9.4f `maximo' 
				_col(57) %9.4f `dtmax';
		replace `1' = `1' - `with';
		drop nodon alphan numlsn _merge `dif' `vardif';
	macro shift;
	};
end;

margave age etnia voca veterano periodo;
margave educa, with(30);
margave hisppor, with(100000);


margave agecon if agecon==0, with(42);
margave agecon if agecon>0, with(20);

margave educcon if agecon>0, with(13);
margave educcon if agecon>0, with(6);
margave educcon if agecon>0, with(2);

margave agepad if agepad==0 & agemad==0 & marital==0, with(62);
margave agemad if agemad==0 & agepad==0 & marital==0, with(64);
margave marital if agemad==0 & agepad==0 & marital==0;

* Cramer's Goodness-of-Fit Measure For Non-Parametric Surface;
capture program drop cramer;
program define cramer;
quietly {;
noi di _n as txt "     Cramer's Goodness-of-Fit Measure For Non-Parametric Surface" _newline;
noi di as txt "    {hline 40}";
noi di as txt "     Model        Cramer     F|1     F|0";
noi di as txt "    {hline 40}";
su alpha if wagesmpl==1, meanonly;
local d1=r(mean);
su alpha if wagesmpl==0, meanonly;
local d2=r(mean);
local lam=`d1'-`d2';
noi di as txt _col(6) abbrev("Wagesmpl",12)  as res _col(16) %9.4f `lam'  
				_col(25) %9.4f `d1' _col(33) %9.4f `d2' ;
	};
end;
cramer;

log close;
exit;

