#delimit;
capture log close;
set more off;
clear;
set matsize 800;

* analisis de los resultados del modelo no-parametrico de participacion;
 

******************************** Sendas ****************************************;
global output "C:\AAPAPERS\HISPANOS\OUTPUT\partic02.log";
global datain "C:\AAPAPERS\HISPANOS\DATA\";
global progra "C:\AAPAPERS\HISPANOS\PROGRAMA\";
********************************************************************************;

* periodo state year salarios age age2 exp exp2 agexed expxed educa voca 
* etnia veterano marital calif arizo texas newme sindi wagesmpl 
* doccphis doccmedu dindphis dindmedu dmsaphis dmsamedu hisppor
* educcon agecon educpad agepad selfpad educmad agemad selfmad;

********************************************************************************;

log using ${output},replace;

* generacion del grid de datos para los modelos de participacion;

use ${datain}datos01.dta,replace;
gen grid=((agecon>=0)+(agecon>0)+(agecon>35)+(agecon>45))*100000
	+((educcon>=0)+(educcon>0)+(educcon>12)+(educcon>14))*10000
	+(year>1996)*1000+state*10+(((agepad>0)|(agemad>0)) & (marital==0));

gen oldhip=hisppor;
gen oldeduc=educa;
replace hisppor=floor(10^6*hisppor);	
replace educa=10*educa;

* entrada de resultados del modelo no parametrico de la participacion;
	quietly do ${progra}parall0.do;
	quietly do ${progra}parall1.do;
	quietly do ${progra}parall2.do;
save ${datain}temp00.dta,replace;

use ${datain}temp00.dta,clear;

sort grid;
by grid:egen malpha=mean(wagesmpl);
* la definicion de participacion esta mal en aries;
replace alpha=1-alpha;
replace alpha1=1-alpha1;
replace alpha2=1-alpha2;
replace alpha=malpha if nodo==-1;
replace alpha1=malpha if nodo1==-1;
replace alpha2=malpha if nodo2==-1;
* me aseguro de que las estimaciones se hacen con un minimo de observaciones;
sort nodo grid;
by nodo grid:egen malpha0=mean(wagesmpl);
by nodo grid:egen cnum0=count(wagesmpl);
replace alpha=malpha0 if numls<40;
replace alpha=malpha if cnum0<40;
sort nodo1 grid;
by nodo1 grid:egen malpha1=mean(wagesmpl);
by nodo1 grid:egen cnum1=count(wagesmpl);
replace alpha1=malpha1 if numls1<40;
replace alpha1=malpha if cnum1<40;
sort nodo2 grid;
by nodo2 grid:egen malpha2=mean(wagesmpl);
by nodo2 grid:egen cnum2=count(wagesmpl);
count if alpha2>0 & numls2<40;
count if alpha2>0 & cnum2<40;
replace alpha2=malpha2 if numls2<40;
replace alpha2=malpha if cnum2<40;

* tengo que eliminar los unos;
replace alpha=cnum0/(cnum0+1) if alpha==1;
replace alpha1=cnum1/(cnum1+1) if alpha1==1;
replace alpha2=cnum2/(cnum2+1) if alpha2==1;


* luego tengo los ceros. Me dan igual, pero hago el cambio para que funcione el programa;
replace alpha=1/(cnum0+1) if alpha==0;
replace alpha1=1/(cnum1+1) if alpha1==0;
gen ceros=alpha2==0;
replace alpha2=1/(cnum2+1) if alpha2==0;

* compute log-likelihood: SE=0;
gen li=wagesmpl*log(alpha)+(1-wagesmpl)*log(1-alpha);
qui su li if etnia==0;
local pseudo=1-((r(N)*r(mean))/(-39688.282));
dis "Pseudo-R2 for NHW SE=0: " %9.4f `pseudo';
qui su li if etnia==1;
local pseudo=1-((r(N)*r(mean))/(-6013.0756));
dis "Pseudo-R2 for MA SE=0: " %9.4f `pseudo';


* compute log-likelihood: SE=1;
replace li=wagesmpl*log(alpha1)+(1-wagesmpl)*log(1-alpha1);
qui su li if etnia==0;
local pseudo=1-((r(N)*r(mean))/(-39688.282));
* non-Hispanic whites;
dis "Pseudo-R2 for NHW SE=1: " %9.4f `pseudo';
qui su li if etnia==1;
local pseudo=1-((r(N)*r(mean))/(-6013.0756));
dis "Pseudo-R2 for MA SE=1: " %9.4f `pseudo';

* compute log-likelihood: SE=2;
replace li=wagesmpl*log(alpha2)+(1-wagesmpl)*log(1-alpha2);
qui su li if etnia==0;
local pseudo=1-((r(N)*r(mean))/(-39688.282));
dis "Pseudo-R2 for NHW SE=2: " %9.4f `pseudo';
qui su li if etnia==1;
local pseudo=1-((r(N)*r(mean))/(-6013.0756));
dis "Pseudo-R2 for MA SE=2: " %9.4f `pseudo';

* ahora calculo las betas, los residuos, el inverse mills-ratio y el score;
gen beta2=invnorm(alpha2);
gen epsi2=wagesmpl-beta2;
gen epsi2th=epsi2^3;
gen epsi2ft=epsi2^4;
gen invMrat2=normden(beta2)/alpha2;
gen score2=(wagesmpl-1)*normden(beta2)/(1-alpha2)+wagesmpl*invMrat2;

* tests de normalidad;
regress epsi2th score2 if ceros==0;
regress epsi2ft score2 if ceros==0;
sort grid;
by grid:regress epsi2th score2 if ceros==0;
by grid:regress epsi2ft score2 if ceros==0;


beep;
exit;


