#delimit;
capture log close;
set more off;
clear;

* preparacion de datos inicial;
* seleccion del suroeste;
* creaccion de todas las variables;

******************************** Sendas ****************************************;
global output "C:\AAPAPERS\HISPANOS\OUTPUT\datos01.log";
global datain "C:\Aadata\CPS\";
global dataout  "C:\AAPAPERS\HISPANOS\DATA\";
********************************************************************************;
capture program drop codemsa;
program define codemsa;
	* cambios en la codificacion hasta 1994;
	replace msafips=8800 if msafips==3810 & year<=1994;
	replace msafips=7360 if msafips==7485 & year<=1994;	
	* cambios en la codificacion hasta 1995;
	replace msafips=8735 if msafips==6000 & year<=1995;
	replace msafips=5945 if msafips== 360 & year<=1995;
	* cambios en la codificacion desde 1995;
	replace msafips=  74 if msafips==4080 & year>=1995;
	replace msafips=  85 if msafips==4100 & year>=1995;
	replace msafips=  74 if msafips==5800 & year>=1995;
	replace msafips=  93 if msafips==4940 & year>=1995;
	replace msafips=  93 if msafips==7460 & year>=1995;
	replace msafips=  85 if msafips==7490 & year>=1995;
	replace msafips=6920 if msafips==9270 & year>=1995;
	replace msafips=  86 if msafips==9360 & year>=1995;
end;

capture program drop data9402;
program define data9402;
	* california, arizona, new mexico, texas;
	keep if (state==93 | state==86 | state==85 | state==74);
	replace msafips=state if msafips==.;
	qui codemsa;
	* generacion de "Relationship to Reference Person" (relref) homogenea;
	gen byte relref=.;
	if year==1994 {;
		replace relref=relref94;
		};
	if year==1995 {;
		replace relref=relref94 if intmonth<=2;
		replace relref=relref95 if intmonth>=3;
		replace relref=11 if relref95>=13 & intmonth>=3;
		};
	if year>=1996 {;
		replace relref=relref95;
		replace relref=11 if relref95>=13;
		};
	* Variables de experiencia y educacion;
	qui educa2;
	* Errores de codificacion en la variable de relacion con el cabeza de familia;
	replace relref=1 if relref==2;
	egen scab=sum(relref==1), by(year intmonth minsamp state hhid hhnum);
	egen sspo=sum(relref==3), by(year intmonth minsamp state hhid hhnum);
	drop if scab~=1;
	drop if sspo==2;
	* Logaritmo del salario nominal a la hora;
	gen byte cenizq=0;
	replace cenizq=1 if earnwke==1923 & year<=1997;
	replace cenizq=2 if earnwke==2884 & year>=1998;
	replace earnwke=1.33*earnwke if cenizq>=1;
	* a partir de 1994, cuando el numero de horas varia, se codifica como missing;
	replace uhourse=hourslw if lfsr94==1 & class94<=5 & uhourse==. & hourslw<.;
	gen salarios = ln(earnwke/uhourse);
	la var salarios "Salarios a la hora-logaritmos";
	keep hhid hhnum minsamp year intmonth earnwt state msafips sex race ethnic age 
		marital veteran grade92 relref penatvty pemntvty pefntvty earnwke class94 
		lfsr94 dind docc80 uhourse unionmme educa voca exp salarios cenizq;
end;

capture program drop educa2;
program define educa2;
	gen byte educa=.;
	replace educa=0 if grade92==31;
	replace educa=2.5 if grade92==32;
	replace educa=5.5 if grade92==33;
	replace educa=7.5 if grade92==34;
	replace educa=9 if grade92==35;
	replace educa=10 if grade92==36;
	replace educa=11 if grade92==37;
	replace educa=12 if grade92==38;
	replace educa=12 if grade92==39;
	replace educa=13.5 if grade92==40;
	replace educa=14 if grade92==41;
	replace educa=14 if grade92==42;
	replace educa=16.5 if grade92==43;
	replace educa=18 if grade92==44;
	replace educa=18 if grade92==45;
	replace educa=20 if grade92==46;
	gen byte exp = age - educa - 6;
	gen byte voca=(grade92==41)+(grade92==42);
	la var educa "Anyos en educacion";
	la var voca "Associate Degree";
	la var exp "Experiencia";
end;

capture program drop agrega2;
program define agrega2;
	drop if minsamp==4;
	keep if (state==93 | state==86 | state==85 | state==74);
	replace msafips=state if msafips==.;
	qui educa2;
	qui codemsa;
	keep weight year msafips ethnic grade92 docc80 dind educa;
end;

capture program drop agrega3;
program define agrega3;
	use ${dataout}temp00.dta;
	gen phisp=(ethnic<8);
	gen meduca=educa;
	collapse (mean) phisp meduca [iw=weight], by(`1');
	sort phisp;
	gen byte cphisp=_n;
	sort meduca;
	gen byte cmeduca=_n;
	sort `1';
	local fich = "${dataout}" + "`1'" + ".dta";
	save `fich',replace;
end;

********************************************************************************;

* Recogida de datos individuales para el household;
local i=94;
while `i'<=99 {;
	use ${datain}morg`i'.dta,clear;
	qui data9402;
	if `i'>94 {;
		append using ${dataout}datos01.dta;
		};
	save ${dataout}datos01.dta, replace;
	local i=`i'+1;
	};
local i=0;
while `i'<=2 {;
	use ${datain}morg0`i'.dta,clear;
	qui data9402;
	append using ${dataout}datos01.dta;
	save ${dataout}datos01.dta, replace;
	local i=`i'+1;
	};
save ${dataout}datos01.dta, replace;

* Creaccion de ficheros variables agregadas;
* Inflacion;
	use ${dataout}datos01.dta, clear;
	keep if salarios<.;
	keep year earnwt intmonth salarios;
	collapse (mean) salarios [iw=earnwt], by(year intmonth);
	gen salindex=salarios-salarios[1];
	keep year intmonth salindex;
	sort year intmonth;
	save ${dataout}salindex.dta, replace;

* Recodificacion de msfips, dind, y docc80;
	use ${datain}morg92.dta, clear;
	qui agrega2;
	save ${dataout}temp00.dta, replace;
	use ${datain}morg93.dta, clear;
	qui agrega2;
	append using ${dataout}temp00.dta;
	save ${dataout}temp00.dta, replace;
	* creacion de codigos de areas metropolitanas de acuerdo con el porcentaje de los hispanos
	* en el area y de acuerdo con el numero medio de anyos de educacion en el area;
	qui agrega3 msafips;

**** pwcorr cmeduca cphisp,sig;
****
****             |  cmeduca   cphisp
****-------------+------------------
****     cmeduca |   1.0000 
****             |
****             |
****      cphisp |  -0.6624   1.0000 
****             |   0.0000;
	* creacion de codigos de ocupaciones de acuerdo con el porcentaje de los hispanos
	* en la ocupacion y de acuerdo con el numero medio de anyos de educacion en la ocupacion;
	qui agrega3 docc80;
**** 	pwcorr cmeduca cphisp,sig;
****              |  cmeduca   cphisp
**** -------------+------------------
****      cmeduca |   1.0000 
****              |
****              |
****       cphisp |  -0.9339   1.0000 
****              |   0.0000;
	* creacion de codigos de industrias de acuerdo con el porcentaje de los hispanos
	* en la industria y de acuerdo con el numero medio de anyos de educacion en la industria;
	qui agrega3 dind;
**** 	pwcorr cmeduca cphisp,sig;
****              |  cmeduca   cphisp
**** -------------+------------------
****      cmeduca |   1.0000 
****              |
****              |
****       cphisp |  -0.8664   1.0000 
****              |   0.0000;

* Datos de educacion, self-employment y earnings de cada miembro del household;

use ${dataout}datos01.dta, clear;

**** El numero de miembros por household tiene la siguiente distribucion;
****gen num=1;
****collapse (sum) num , by(year intmonth minsamp state hhid hhnum);
****tab num;
****  (sum) num |      Freq.     Percent        Cum.
****------------+-----------------------------------
****          1 |     58,258       29.10       29.10
****          2 |    101,252       50.58       79.69
****          3 |     26,254       13.12       92.80
****          4 |     10,328        5.16       97.96
****          5 |      2,858        1.43       99.39
****          6 |        853        0.43       99.82
****          7 |        252        0.13       99.94
****          8 |         83        0.04       99.98
****          9 |         18        0.01       99.99
****         10 |          7        0.00      100.00
****         11 |          8        0.00      100.00
****         14 |          1        0.00      100.00
****------------+-----------------------------------
****      Total |    200,172      100.00;
****;

* Luego necesitamos earn01-14, educ01-14, age01-14, self01-14, sex01-14 y relref01-14;
	keep earnwke educa age year intmonth minsamp state hhid hhnum relref sex class94;
	sort year intmonth minsamp state hhnum hhid relref;
	gen numhog=1;
	replace numhog=numhog[_n-1]+1 if hhid==hhid[_n-1];
	mvencode earnwke, mv(0) o;
	local i=1;
	while `i'<=9 {;
		egen earn0`i'=sum(earnwke*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		egen educ0`i'=sum(educa*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		egen age0`i'=sum(age*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		egen byte sex0`i'=sum(sex*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		egen byte self0`i'=sum((class94==6|class94==7)*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		egen byte relref0`i'=sum(relref*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		local i=`i'+1;
		};
	while `i'<=14 {;
		egen earn`i'=sum(earnwke*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		egen educ`i'=sum(educa*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		egen age`i'=sum(age*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		egen byte sex`i'=sum(sex*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		egen byte self`i'=sum((class94==6|class94==7)*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		egen byte relref`i'=sum(relref*(numhog==`i')), by(year intmonth minsamp state hhid hhnum);
		local i=`i'+1;
		};
* educacion y edad del conyuge;
gen educcon=(relref==1)*(educ01*(relref01==3)+educ02*(relref02==3)+educ03*(relref03==3)+educ04*(relref04==3)
	+educ05*(relref05==3)+educ06*(relref06==3)+educ07*(relref07==3)+educ08*(relref08==3)
	+educ09*(relref09==3)+educ10*(relref10==3)+educ11*(relref11==3)+educ12*(relref12==3)
	+educ13*(relref13==3)+educ14*(relref14==3))+
	(relref==3)*(educ01*(relref01==1)+educ02*(relref02==1)+educ03*(relref03==1)+educ04*(relref04==1)
	+educ05*(relref05==1)+educ06*(relref06==1)+educ07*(relref07==1)+educ08*(relref08==1)
	+educ09*(relref09==1)+educ10*(relref10==1)+educ11*(relref11==1)+educ12*(relref12==1)
	+educ13*(relref13==1)+educ14*(relref14==1));
gen agecon=(relref==1)*(age01*(relref01==3)+age02*(relref02==3)+age03*(relref03==3)+age04*(relref04==3)
	+age05*(relref05==3)+age06*(relref06==3)+age07*(relref07==3)+age08*(relref08==3)+age09*(relref09==3)
	+age10*(relref10==3)+age11*(relref11==3)+age12*(relref12==3)+age13*(relref13==3)+age14*(relref14==3))
	+(relref==3)*(age01*(relref01==1)+age02*(relref02==1)+age03*(relref03==1)+age04*(relref04==1)
	+age05*(relref05==1)+age06*(relref06==1)+age07*(relref07==1)+age08*(relref08==1)+age09*(relref09==1)
	+age10*(relref10==1)+age11*(relref11==1)+age12*(relref12==1)+age13*(relref13==1)+age14*(relref14==1));

* caracteristicas del padre;
gen educpad=(relref==1)*(educ01*(relref01==6)*(sex01==1)+educ02*(relref02==6)*(sex02==1)
  +educ03*(relref03==6)*(sex03==1)+educ04*(relref04==6)*(sex04==1)+educ05*(relref05==6)*(sex05==1)
  +educ06*(relref06==6)*(sex06==1)+educ07*(relref07==6)*(sex07==1)+educ08*(relref08==6)*(sex08==1)
  +educ09*(relref09==6)*(sex09==1)+educ10*(relref10==6)*(sex10==1)+educ11*(relref11==6)*(sex11==1)
  +educ12*(relref12==6)*(sex12==1)+educ13*(relref13==6)*(sex13==1)+educ14*(relref14==6)*(sex14==1))
          +(relref==4)*(educ01*(relref01==1)*(sex01==1)+educ02*(relref02==1)*(sex02==1)
  +educ03*(relref03==1)*(sex03==1)+educ04*(relref04==1)*(sex04==1)+educ05*(relref05==1)*(sex05==1)
  +educ06*(relref06==1)*(sex06==1)+educ07*(relref07==1)*(sex07==1)+educ08*(relref08==1)*(sex08==1)
  +educ09*(relref09==1)*(sex09==1)+educ10*(relref10==1)*(sex10==1)+educ11*(relref11==1)*(sex11==1)
  +educ12*(relref12==1)*(sex12==1)+educ13*(relref13==1)*(sex13==1)+educ14*(relref14==1)*(sex14==1));
gen agepad=(relref==1)*(age01*(relref01==6)*(sex01==1)+age02*(relref02==6)*(sex02==1)
  +age03*(relref03==6)*(sex03==1)+age04*(relref04==6)*(sex04==1)+age05*(relref05==6)*(sex05==1)
  +age06*(relref06==6)*(sex06==1)+age07*(relref07==6)*(sex07==1)+age08*(relref08==6)*(sex08==1)
  +age09*(relref09==6)*(sex09==1)+age10*(relref10==6)*(sex10==1)+age11*(relref11==6)*(sex11==1)
  +age12*(relref12==6)*(sex12==1)+age13*(relref13==6)*(sex13==1)+age14*(relref14==6)*(sex14==1))
          +(relref==4)*(age01*(relref01==1)*(sex01==1)+age02*(relref02==1)*(sex02==1)
  +age03*(relref03==1)*(sex03==1)+age04*(relref04==1)*(sex04==1)+age05*(relref05==1)*(sex05==1)
  +age06*(relref06==1)*(sex06==1)+age07*(relref07==1)*(sex07==1)+age08*(relref08==1)*(sex08==1)
  +age09*(relref09==1)*(sex09==1)+age10*(relref10==1)*(sex10==1)+age11*(relref11==1)*(sex11==1)
  +age12*(relref12==1)*(sex12==1)+age13*(relref13==1)*(sex13==1)+age14*(relref14==1)*(sex14==1));
gen selfpad=(relref==1)*(self01*(relref01==6)*(sex01==1)+self02*(relref02==6)*(sex02==1)
  +self03*(relref03==6)*(sex03==1)+self04*(relref04==6)*(sex04==1)+self05*(relref05==6)*(sex05==1)
  +self06*(relref06==6)*(sex06==1)+self07*(relref07==6)*(sex07==1)+self08*(relref08==6)*(sex08==1)
  +self09*(relref09==6)*(sex09==1)+self10*(relref10==6)*(sex10==1)+self11*(relref11==6)*(sex11==1)
  +self12*(relref12==6)*(sex12==1)+self13*(relref13==6)*(sex13==1)+self14*(relref14==6)*(sex14==1))
          +(relref==4)*(self01*(relref01==1)*(sex01==1)+self02*(relref02==1)*(sex02==1)
  +self03*(relref03==1)*(sex03==1)+self04*(relref04==1)*(sex04==1)+self05*(relref05==1)*(sex05==1)
  +self06*(relref06==1)*(sex06==1)+self07*(relref07==1)*(sex07==1)+self08*(relref08==1)*(sex08==1)
  +self09*(relref09==1)*(sex09==1)+self10*(relref10==1)*(sex10==1)+self11*(relref11==1)*(sex11==1)
  +self12*(relref12==1)*(sex12==1)+self13*(relref13==1)*(sex13==1)+self14*(relref14==1)*(sex14==1));
* caracteristicas de la madre;
gen educmad=(relref==1)*(educ01*(relref01==6)*(sex01==2)+educ02*(relref02==6)*(sex02==2)
  +educ03*(relref03==6)*(sex03==2)+educ04*(relref04==6)*(sex04==2)+educ05*(relref05==6)*(sex05==2)
  +educ06*(relref06==6)*(sex06==2)+educ07*(relref07==6)*(sex07==2)+educ08*(relref08==6)*(sex08==2)
  +educ09*(relref09==6)*(sex09==2)+educ10*(relref10==6)*(sex10==2)+educ11*(relref11==6)*(sex11==2)
  +educ12*(relref12==6)*(sex12==2)+educ13*(relref13==6)*(sex13==2)+educ14*(relref14==6)*(sex14==2))
          +(relref==4)*(educ01*(relref01==1)*(sex01==2)+educ02*(relref02==1)*(sex02==2)
  +educ03*(relref03==1)*(sex03==2)+educ04*(relref04==1)*(sex04==2)+educ05*(relref05==1)*(sex05==2)
  +educ06*(relref06==1)*(sex06==2)+educ07*(relref07==1)*(sex07==2)+educ08*(relref08==1)*(sex08==2)
  +educ09*(relref09==1)*(sex09==2)+educ10*(relref10==1)*(sex10==2)+educ11*(relref11==1)*(sex11==2)
  +educ12*(relref12==1)*(sex12==2)+educ13*(relref13==1)*(sex13==2)+educ14*(relref14==1)*(sex14==2));
gen agemad=(relref==1)*(age01*(relref01==6)*(sex01==2)+age02*(relref02==6)*(sex02==2)
  +age03*(relref03==6)*(sex03==2)+age04*(relref04==6)*(sex04==2)+age05*(relref05==6)*(sex05==2)
  +age06*(relref06==6)*(sex06==2)+age07*(relref07==6)*(sex07==2)+age08*(relref08==6)*(sex08==2)
  +age09*(relref09==6)*(sex09==2)+age10*(relref10==6)*(sex10==2)+age11*(relref11==6)*(sex11==2)
  +age12*(relref12==6)*(sex12==2)+age13*(relref13==6)*(sex13==2)+age14*(relref14==6)*(sex14==2))
          +(relref==4)*(age01*(relref01==1)*(sex01==2)+age02*(relref02==1)*(sex02==2)
  +age03*(relref03==1)*(sex03==2)+age04*(relref04==1)*(sex04==2)+age05*(relref05==1)*(sex05==2)
  +age06*(relref06==1)*(sex06==2)+age07*(relref07==1)*(sex07==2)+age08*(relref08==1)*(sex08==2)
  +age09*(relref09==1)*(sex09==2)+age10*(relref10==1)*(sex10==2)+age11*(relref11==1)*(sex11==2)
  +age12*(relref12==1)*(sex12==2)+age13*(relref13==1)*(sex13==2)+age14*(relref14==1)*(sex14==2));
gen selfmad=(relref==1)*(self01*(relref01==6)*(sex01==2)+self02*(relref02==6)*(sex02==2)
  +self03*(relref03==6)*(sex03==2)+self04*(relref04==6)*(sex04==2)+self05*(relref05==6)*(sex05==2)
  +self06*(relref06==6)*(sex06==2)+self07*(relref07==6)*(sex07==2)+self08*(relref08==6)*(sex08==2)
  +self09*(relref09==6)*(sex09==2)+self10*(relref10==6)*(sex10==2)+self11*(relref11==6)*(sex11==2)
  +self12*(relref12==6)*(sex12==2)+self13*(relref13==6)*(sex13==2)+self14*(relref14==6)*(sex14==2))
          +(relref==4)*(self01*(relref01==1)*(sex01==2)+self02*(relref02==1)*(sex02==2)
  +self03*(relref03==1)*(sex03==2)+self04*(relref04==1)*(sex04==2)+self05*(relref05==1)*(sex05==2)
  +self06*(relref06==1)*(sex06==2)+self07*(relref07==1)*(sex07==2)+self08*(relref08==1)*(sex08==2)
  +self09*(relref09==1)*(sex09==2)+self10*(relref10==1)*(sex10==2)+self11*(relref11==1)*(sex11==2)
  +self12*(relref12==1)*(sex12==2)+self13*(relref13==1)*(sex13==2)+self14*(relref14==1)*(sex14==2));
sort year intmonth minsamp state hhid hhnum relref;
keep year intmonth minsamp state hhid hhnum relref educcon agecon educpad agepad selfpad educmad agemad selfmad;
save ${dataout}family.dta, replace;

* Seleccion de los datos de la muestra;

use ${dataout}datos01.dta, clear;
* Filtros sobre las variables de salarios;
* se eliminan 6 observaciones para las que no tenemos earnings
* pero estan trabajando como asalariados;
****tab year if earnwke==. & lfsr94==1 & class94<=5;
****       year |      Freq.     Percent        Cum.
****------------+-----------------------------------
****       1999 |          6      100.00      100.00
****------------+-----------------------------------
****      Total |          6      100.00;
drop if earnwke==. & lfsr94==1 & class94<=5;
* se eliminan 3 observaciones para las que no tenemos 
* horas trabajadas;
**** tab year if lfsr94==1 & class94<=5 & (uhourse==.);
****
****       year |      Freq.     Percent        Cum.
****------------+-----------------------------------
****       1996 |          3      100.00      100.00
****------------+-----------------------------------
****      Total |          3      100.00;
drop if lfsr94==1 & class94<=5 & (uhourse==.);
* se eliminan todos aquellos con earnings u horas iguales a cero que trabajan;
drop if (earnwke==0 | uhourse==0) & lfsr94<=2 & class94<=5;
drop if salarios==. & lfsr94==2;
tab year if earnwke<. & lfsr94>=3;
**** censura por la izquierda;
**** 1997 es el anyo con un porcentage mayor de censurados por la izquierda: 1.67%;
****tab year cenizq if class94<=5, row;
****           |              cenizq
****      year |         0          1          2 |     Total
****-----------+---------------------------------+----------
****      1994 |     98.68       1.32       0.00 |    100.00 
****      1995 |     98.68       1.32       0.00 |    100.00 
****      1996 |     98.69       1.31       0.00 |    100.00 
****      1997 |     98.33       1.67       0.00 |    100.00 
****      1998 |     99.28       0.00       0.72 |    100.00 
****      1999 |     99.17       0.00       0.83 |    100.00 
****      2000 |     99.09       0.00       0.91 |    100.00 
****      2001 |     99.16       0.00       0.84 |    100.00 
****      2002 |     98.95       0.00       1.05 |    100.00 
****-----------+---------------------------------+----------
****     Total |     98.90       0.61       0.49 |    100.00 ;
	egen onepc=pctile(earnwke), p(98.33) by(year);
	gen censura=(earnwke>onepc) if earnwke<.;
	drop if censura==1;
* universo del analisis;
	keep if sex==1;
	keep if age>24 & age<63;
	keep if (ethnic<4 | ethnic==8);
	drop if (race>1 & ethnic==8);
	keep if (penatvty==57);
	keep if (pemntvty==57)|(pefntvty==57);
* variable de participacion;
	gen wagesmpl=(class94<=5) & (lfsr94<=2);
	replace wagesmpl=0 if dind==51;
* Introducion de variables agregadas;
	* inflacion salarial;
	sort year intmonth;
	merge year intmonth using ${dataout}salindex.dta;
	drop _merge;
	* codigos de ocupaciones;
	sort docc80;
	merge docc80 using ${dataout}docc80.dta;
	rename cphisp doccphis;
	rename cmeduca doccmedu;
	drop _merge;
	* codigos de industrias;
	sort dind;
	merge dind using ${dataout}dind.dta;
	rename cphisp dindphis;
	rename cmeduca dindmedu;
	drop _merge;
	* codigos de msafips;
	sort msafips;
	merge msafips using ${dataout}msafips.dta;
	rename cphisp dmsaphis;
	rename cmeduca dmsamedu;
	rename phisp hisppor;
	drop _merge;
* Introduccion de variables familiares;
	sort year intmonth minsamp state hhid hhnum relref;
	merge year intmonth minsamp state hhid hhnum relref using ${dataout}family.dta;
	drop if _merge==2;
	drop _merge;
* Salarios Reales;
	replace salarios=salarios-salindex;
* Seleccion de variables relevantes;
	replace exp=0 if exp<0;
	gen age2=age*age;
	gen exp2=exp*exp;
	gen agexed=age*educa;
	gen expxed=exp*educa;
	gen etnia=(ethnic<4);
	gen veterano=(veteran<6);
	replace marital=(marital<=3);
	gen calif=(state==93);
	gen arizo=(state==86);
	gen texas=(state==74);
	gen newme=(state==85);
	gen sindi=(unionmme==1);
	gen periodo=(year-1994)*12+intmonth;
	keep periodo state year salarios age age2 exp exp2 agexed expxed educa voca 
		etnia veterano marital calif arizo texas newme sindi wagesmpl 
		doccphis doccmedu dindphis dindmedu dmsaphis dmsamedu hisppor
		educcon agecon educpad agepad selfpad educmad agemad selfmad class94 lfsr94;
save ${dataout}datos01.dta,replace;
beep;
