@ Takes pits from Figure 1 (GBR's IID case) for each of the 4 forecasters 
and uses the evaluation tests in MW to try and discriminate between them.

The results from these simulations are presented in the text of MW, near the end of 
the section on GBR's example @

new;
library pgraph,maxlik,optmum;
	

t=150; @ T=sample size @
R=500; @ no of replications @

@ set this to forecaster you wish to consider @
forecaster=2; @ =1 for ideal;
		           =2 for climatological
			   =3 for unfocused
			   =4 for Hamill's forecaster @

@ don't change anything below here @	

integ={};r_wallis={};res={};
spits1={};spits2={};spits3={};spits4={};spits5={};st={};klics={};st2={};walds={};score={};rest={};s_mean={};s_coeff={};walds2={};
scoref={};klicsf={};restf={};stf={};st2f={};waldsf={}; walds2f={};ag={}; agf={}; extra_test={};perr={};


ii=1; do until ii>R; @ no of replications @


st={};klics={};st2={};walds={};score={};s_mean={};s_coeff={};walds2={};logs_ideal={};logs_u={};
s_mew={};s_bi={};sss_pit1={};sss_pit2={};sss_pit3={};
pforecastbias={};

@ ideal forecaster @

density1={}; density2={}; density3={};zc={};ssu={};sss_pits={};mmulti={};hamillp={};sss_pits_ideal={};
outturn={};mews={};ssu1={};ssu2={};ssu3={};ssu4={};sss_pits1={};sss_pits2={};sss_pits3={};sss_pits4={};
i=1;do until i>t;

mew=rndn(1,1);
{outturnp}=rgauss(1,1,mew,1);
outturn=outturn|outturnp; 
pits_ideal=cdfn(outturnp-mew);
sss_pits_ideal=sss_pits_ideal|pits_ideal;

s_mew=s_mew|mew;

loss_forecaster=dgauss(outturnp,mew,1); 
logsl=ln(loss_forecaster); 
logs_ideal=logs_ideal|logsl;

@ climatalogical @
x1=(zeros(1,1))~(ones(1,1).*sqrt(2));
	z1t=cdfn((outturnp-x1[1,1])./(x1[1,2]));
sss_pits1=sss_pits1|z1t;
	su=dgauss(outturnp,0,sqrt(2)); 
	su=ln(su); 
ssu1=ssu1|su;

@ Hamill's ensemble or combined forecaster @

w1=1/3;w2=1/3;
m=1;nn=1;p=w1|w2|(1-w1-w2);

{multi}=rmulti(m,p,nn);
if multi[1,1]==1; phamill=mew+0.5; pits1=cdfn((outturnp-phamill)./1); su=dgauss(outturnp,phamill,sqrt(1)); 
elseif multi[1,2]==1; phamill=mew-0.5; pits1=cdfn((outturnp-phamill)./1); su=dgauss(outturnp,phamill,sqrt(1)); 
elseif multi[1,3]==1; phamill=mew+0; pits1=cdfn((outturnp-phamill)./sqrt(1.69)); su=dgauss(outturnp,phamill,sqrt(1.69)); 
endif;

mmulti=mmulti|multi;
hamillp=hamillp|phamill;
sss_pits4=sss_pits4|pits1;
ssu4=ssu4|ln(su);


@ unfocused mixture @
xxr=rndu(1,1);
tauv=(xxr-0.5).>0; tauvn=(xxr-0.5).<=0; tauvn=tauvn.*-1;
bi=tauv+tauvn;s_bi=s_bi|bi;

loss_forecaster=dgauss(outturnp,mew,1); 
logsl1=(loss_forecaster); 
loss_forecaster=dgauss(outturnp,mew+bi,1); 
logsl2=(loss_forecaster); 
logsl=0.5*logsl1+0.5*logsl2;
ssu3=ssu3|ln(logsl);

biasguy=outturnp-mew-bi;
pitsbias=cdfn(biasguy./(sqrt(1))); 
pits1=cdfn((outturnp-mew)./1);
pitc=0.5*(pits1+pitsbias);
sss_pits3=sss_pits3|pitc;
pforecastbias=pforecastbias|(0.5*(mew+bi)+0.5*mew);


i=i+1;endo;

if forecaster==1; 
ssu=ssu4;
sss_pits=sss_pits_ideal;
endif;

if forecaster==2; 
ssu=ssu1;
sss_pits=sss_pits1;
endif;

if forecaster==3; 
ssu=ssu3;
sss_pits=sss_pits3;
endif;

if forecaster==4; 
ssu=ssu4;
sss_pits=sss_pits4;
endif;

@ Test equality of logS - rel to ideal forecaster using GW type Wald test. Play with 4 different HAC estimators below. 
In fact, first is assuming iid-ness @
 z=logs_ideal-ssu;

lagg=1;tt=rows(z);
	{hac1}=covv(z,0,2,0,1,1);
{hac3}=hac(z,2,0,lagg); if prodc(eig(hac3)) <=0;vx= inv(hac3./tt); elseif prodc(eig(hac3)) >0;vx=invpd(hac3./tt);endif;
vx2=NW(z,meanc(z),lagg);
wald=(tt-1)*(sumc(z)/(tt-1))'*vx*(sumc(z)/(tt-1));waldc=cdfchic(wald,1);
    vx=invpd(vx2./tt);
waldhac2=(tt-1)*(sumc(z)/(tt-1))'*vx*(sumc(z)/(tt-1));waldchac2=cdfchic(waldhac2,1);
vx=invpd(vcx(z)); 
    waldtrad=(tt-1)*(sumc(z)/(tt-1))'*vx*(sumc(z)/(tt-1));waldctrad=cdfchic(waldtrad,1);
vx2=NW(z,meanc(z),round(0.75*(tt^(1/3))));vx=invpd(vx2./tt);
walda=(tt-1)*(sumc(z)/(tt-1))'*vx*(sumc(z)/(tt-1));waldca=cdfchic(walda,1);

ag1=(waldtrad~waldctrad~wald~waldc~waldhac2~waldchac2~walda~waldca);


pits=sss_pits;
pit_star=inv_normal(pits);

@ here select which pits you wish to evaluate @

	
	{dh}=NormTest(pit_star);

	dh2=cdfchic(dh,2); @ p-value for normality @ dh2=dh2.<0.05; 
	tt=rows(pit_star);
	{lr,pvb,bhat}=berkovitz(pit_star,Tt);pvb=pvb.<0.05;

	klic1=lr/(2*Tt);

	{s1}=GF_KS(pits); 
	C1 = CV_KS(0.05,rows(pits)) ; cks2=s1.>c1;
	
	s2 = GF_AD(pits) ;  
	c2 = CV_AD(0.05,rows(pits)) ;  
	cad2=s2;cad2=s2.>c2;

	{r3,r4}=ljung_box(pits,4); r4=r4.<0.05;
	
rest=rest|(dh2~cad2~cks2~r4~pvb);
agf=agf|ag1;


ii=ii+1;endo;


agfp=agf[.,2 4 6 8  ].<0.05; agfp=meanc(agfp)';
if forecaster==1; agfp=zeros(1,4);endif;
m_rest=meanc(rest)';
screen on;
res=m_rest;
"Rejection proportions for DH, AD, KS, LB and Bk tests";res';?;
"Rejection proportions using the KLIC test for equal log-scores: using 4 different HACs";agfp';stop;


@ average log scores @
meanc(ssu);
meanc(logs_ideal);


stop;


@---------------------------- Procedures ----------------------------------------------------------------@



proc(1)=inv_normal(p);
local lim, p0, p1, p2, p3, p4, q0, q1, q2, q3, q4, maskgt, maskeq, sgn,
y, xp, pn;

@ Constants @

lim =  1e-20;

p0  = - 0.322232431088;             q0  =   0.0993484626060;
p1  = - 1.0;                        q1  =   0.588581570495;
p2  = - 0.342242088547;             q2  =   0.531103462366;
p3  = - 0.0204231210245;            q3  =   0.103537752850;
p4  = - 0.453642210148*1e-4;        q4  =   0.38560700634*1e-2;


@ Main body of code @

 @ Create masks for handling p > .5 and p >= .5 @

maskgt=(p .> 0.5);
maskeq=(p .ne 0.5);
sgn=missrv(miss(maskgt,0),-1);

 @ Convert p > .5 --> 1-p @

pn=(maskgt-p).*sgn;   clear maskgt;

 @ Computation of function for p < 0.5 @

y=sqrt(-2*ln(pn));     clear pn;
xp=y + ((((y*p4 + p3).*y + p2).*y + p1).*y + p0)./
       ((((y*q4 + q3).*y + q2).*y + q1).*y + q0); clear y;

 @ Convert results for p > .5 and p = .5 @

xp=(xp.*sgn).*maskeq;
clear sgn, maskeq;
retp(xp);
endp;




proc(1)= tdis_inv(p,a);
@ PURPOSE: returns the inverse (quantile) at x of the t(n) distribution
---------------------------------------------------
 USAGE: x = tdis_inv(p,n)
 where: p = a vector of probabilities 
        n = a scalar dof parameter
---------------------------------------------------
 RETURNS:
        a vector of tinv at each element of x of the t(n) distribution      
 --------------------------------------------------
 SEE ALSO: tdis_cdf, tdis_rnd, tdis_pdf, tdis_prb
---------------------------------------------------@
   
local s,x;
s = p<0.5; 
p = p + (1-2*p).*s;
p = 1-(2*(1-p));
x = ibeta@beta_inv@(p,1/2,a/2);
x = x.*a./((1-x));
x = (1-2*s).*sqrt(x);
retp(x);endp;

PROC tdis_pdf(x,v);
 LOCAL b;
 @ scalar(v); argtest(v,"0<*");@
  b = GAMMA((1+v)/2)/GAMMA(v/2);
 RETP(b*SQRT(1/(PI*v))*(1+x.*x/v)^(-(v+1)/2));
ENDP;

/*
**  fish.src
**
**  Version 1.0  16/05/2000 (C) Copyright 2000 by Rainer Schlittgen
**  All rights Reserved.
**
**    Density, cumulative distribution function, quantiles
**    and random variates of the Fisher's F distribution
**
**  Format
**  -----------------------------------------------------------------
**  y=dfish(x,v1,v2)                                        Line  35
**  z=pfish(x,v1,v2)                                        Line  46
**  q=ifish(p,v1,v2)   ...Cornish-Fisher-Approximation      Line  55
**  r=rfish(r,c,v1,v2)                                      Line 113
**
**  Input
**  -----------------------------------------------------------------
**  x....(k,m)-matrix,
**  v1...scalar, >0, degrees of freedom1
**  v1...scalar, >0, degrees of freedom2
**  p....(k,m)-matrix, 0<p<1  (percentages)
**  r....integer, number of rows
**  c....integer, number of cols
**
**  Output
**  -----------------------------------------------------------------
**  y...f(x), (k,m)-matrix, density function
**  z...F(x), (k,m)-matrix, cumulative distribution function
**  q...x_p,  (k,m)-matrix, p-quantiles
**  r...x,    (r,c)-matrix, random numbers
**
*********************************************************************/

PROC dfish(x,v1,v2);
 LOCAL k,xx;
  scalar(v1); scalar(v2); argtest(v1|v2,"0<*");
  xx = x.*(x.>0) + (x.<=0);
  k = GAMMA((v1+v2)/2)*(v1/v2)^(v1/2)/(GAMMA(v1/2)*GAMMA(v2/2));
  k = k*xx^(v1/2-1)./SQRT((1+v1*xx/v2)^(v1+v2));
 RETP(k.*(x.>0));
ENDP;

/********************************************************************/

PROC pfish(x,v1,v2);
 LOCAL k,xx;
  scalar(v1); scalar(v2); argtest(v1|v2,"0<*");
  xx = x.*(x.>0) + (x.<=0);
 RETP((1-CDFFC(xx,v1,v2)).*(x.>0));
ENDP;

/********************************************************************/

PROC ifish(p,v1,v2);
 LOCAL w,r,coef3,d3,coef2,d2,l,k,y,z,xp,p0;
  scalar(v1); scalar(v2); argtest(v1|v2,"0<*"); argtest(p,"0<=*<1");

  p0 = (p.==0);
   p = p + 0.5*(p.==0);

  IF v1==1; xp=istudent((p+1)/2,v2); xp=xp^2; GOTO fini; ENDIF;
  IF v2==1; xp=istudent((1-p/2),v1); xp=1/xp^2; GOTO fini;ENDIF;
  IF v1==2; xp=(v2/2)*((1-p)^(-2/v2)-1); GOTO fini; ENDIF;
  IF v2==2; xp=(2/v1)*p^(2/v1)./(1-p^(2/v1)); GOTO fini; ENDIF;

  IF v1==v2;
    xp=istudent((1-p),v1);
    xp=(1+2*xp^2/v1-2*xp/v1^0.5.*(1+xp^2/v1)^0.5); GOTO fini;
  ENDIF;

  z=VECR(CDFNI(p));
  y=z^2;

  k=0.5*(1/v2-1/v1);
  l=(0.5*(1/v1+1/v2))^0.5;

  coef2={1 9 8,3 7 -16,1 20 15,1 44 183,9 -284 -1513};
  d2={30,810,480,720,38880};
  coef2=(coef2./d2)';
  coef3={4 -25 -177 192,4 101 117 -480,12 513 841 -2560,1 7 7 105,
         801 10511 30151 62241,477 4507 82933 -264363,
         3753 55383 -368987 -1213927};
  d3={2520,11340,204120,2688,604800,5443200,146966400};
  coef3=(coef3./d3)';

  r=ONES(1,ROWS(p)*COLS(p));
  w=l*z
    + k*(y+2)/3
    + l*z.*(l^2*(y+3)/12+k^2*(y+11)/(36*l^2))
    + k*l^2 * POLYEVAL(y',coef2[.,1*r])
    - k^3*(l^-2) * POLYEVAL(y',coef2[.,2*r])
    + l*z.*(l^4 * POLYEVAL(y',coef2[.,3*r])
    + k^2 * POLYEVAL(y',coef2[.,4*r])
    + k^4*(l^-4) * POLYEVAL(y',coef2[.,5*r]) )
    - k*l^4 * POLYEVAL(y',coef3[.,1*r])
    - k^3 * POLYEVAL(y',coef3[.,2*r])
    + k^5*(l^-4) * POLYEVAL(y',coef3[.,3*r])
    - l*z.*(l^6 * POLYEVAL(y',coef3[.,4*r])
    + k^2*l^2 * POLYEVAL(y',coef3[.,5*r])
    - k^4*(l^-2) * POLYEVAL(y',coef3[.,6*r])
    + (k/l)^6 * POLYEVAL(y',coef3[.,7*r]) );

 xp = RESHAPE(EXP(2*w),ROWS(p),COLS(p));

 fini:

 RETP(xp.*(1-p0));
ENDP;

/********************************************************************/

PROC rfish(r,c,v1,v2);
  scalar(v1); scalar(v2); integer(r); integer(c);
  argtest(v1|v2|r|c,"0<*");
 RETP(ifish(RNDU(r,c),v1,v2));
ENDP;

/********************************************** O.K. (29.05.00) *****/

PROC (0) = scalar(arg);
  if (1-(ROWS(arg)==1)*(COLS(arg)==1));
     ERRORLOG("Argument(s) must be scalar!! ...Break!!");END;
  ENDIF;
ENDP;

PROC (0) = integer(arg);
  IF (1-(ROWS(arg)==1)*(COLS(arg)==1)*(TRUNC(arg)==arg));
     ERRORLOG("Argument(s) must be integer!! ...Break !!");END;
  ENDIF;
ENDP;

PROC (0) = argtest(var,teststr);
  LOCAL i,n,j1,j2,a,b,temp,false;
    false=0;
    var=VEC(var);
    i=STRINDX(teststr,"*",1);
    n=STRLEN(teststr);
    j1=0;  a=MISS(0,0); j2=0; b=MISS(0,0);
    if i>1;
         j1 = STRINDX(STRSECT(teststr,1,i),"<",1);
          a = STOF(STRSECT(teststr,1,j1-1));
       temp = STRSECT(teststr,i,n-i+1);
       IF STRLEN(temp);
          j2 = MAXC(STRINDX(temp,"<",1)|STRINDX(temp,"=",1));
           b = STOF(STRSECT(temp,j2+1,n-i-j2+1));
       endif;
     else;
        j2 = MAXC(STRINDX(teststr,"<",1)|STRINDX(teststr,"=",1));
         b = STOF(STRSECT(teststr,j2+1,n-j2));
    endif;
    IF j1; false = false + SUMC((var.<a) + (2-(i-j1))*(var.==a)); ENDIF;
    IF j2; false = false + SUMC((var.>b) + (3-j2)*(var.==b)); ENDIF;
    IF false;
       ERRORLOG("Domain of argument(s) violated!! ...Break!!");END;
    ENDIF;
ENDP;

PROC istudent(p,v);
  scalar(v); argtest(v,"0<*"); argtest(p,"0<*<1");
 RETP(CDFTCI(1-p,v));
ENDP;

PROC ibeta(p,a,b);
 LOCAL xx;
  scalar(a); scalar(b); argtest(a|b,"0<*");
  argtest(p,"0<=*<=1");
  xx=ifish(p,a,b);
 RETP(a*xx./(b+a*xx));
ENDP;

PROC igauss(p,a,b);
  scalar(a); scalar(b); argtest(b,"0<*");
  argtest(p,"0<*<1");
 RETP(cdfni(p)*b+a);
ENDP;


PROC dstudent(x,v);
 LOCAL b;
  scalar(v); argtest(v,"0<*");
  b = GAMMA((1+v)/2)/GAMMA(v/2);
 RETP(b*SQRT(1/(PI*v))*(1+x.*x/v)^(-(v+1)/2));
ENDP;

/********************************************************************/

PROC pstudent(x,v);
  scalar(v); argtest(v,"0<*");
 RETP(1-CDFTC(x,v));
ENDP;


/*
**  normal.src
**
**  Version 1.0  5/05/2000 (C) Copyright 2000 by Rainer Schlittgen
**  All rights Reserved.
**
**   Density, cumulative distribution function and random variates
**   of the NORMAL distribution
**
**  Format
**  -----------------------------------------------------------------
**  y=dgauss(x,a,b)                                          Line 35
**  z=pgauss(x,a,b)                                          Line 42
**  q=igauss(p,a,b)                                          Line 49
**  r=rgauss(r,c,a,b)                                        Line 57
**
**  Input
**  -----------------------------------------------------------------
**  x....(k,m)-matrix
**  a....scalar,
**  b....scalar, >0, standard deviation
**  p....(k,m)-matrix, 0<p<1
**  r....integer, number of rows
**  c....integer, number of cols
**
**  Output
**  -----------------------------------------------------------------
**  y...f(x), (k,m) matrix, density function
**  z...F(x), (k,m) matrix, cumulative distribution function
**  q...xp,   (k,m)-matrix, p-quantiles
**  r...x,    (r,c)-matrix, random numbers
**
*********************************************************************/

PROC dgauss(x,a,b);
 @ scalar(a); scalar(b); argtest(b,"0<*");@
 RETP(pdfn((x-a)./b)./b);
ENDP;

/*********************************************************************/

PROC pgauss(x,a,b);
 @ scalar(a); scalar(b); argtest(b,"0<*");@
 RETP(cdfn((x-a)./b));
ENDP;

/********************************************************************/

PROC igauss(p,a,b);
  scalar(a); scalar(b); argtest(b,"0<*");
  argtest(p,"0<*<1");
 RETP(cdfni(p)*b+a);
ENDP;

/********************************************************************/

PROC rgauss(r,c,a,b);
@  scalar(a); scalar(b); integer(r); integer(c); argtest(b|r|c,"0<*");@
 RETP(rndn(r,c)*b+a);
ENDP;

/*************************************************  **/

proc(1)=NormTest(mX);
local ct, vskew, vkurt, newskew, newkurt;

    ct = rows(mX);
    mX = IN01Data(mX);

    vskew = (sumc(mX .^ 3) /ct);
    vkurt = (sumc(mX .^ 4) / ct);

    newskew = SkewSU(vskew, ct);         /* transform skewness to normality */

    newkurt = KurtGamma(vskew, vkurt, ct);  /* transform kurtosis via gamma */

retp(sumc(newskew .^ 2)' + sumc(newkurt .^ 2)');
endp;




proc(1)=IN01Data(mX);                             /* transform to approximate N(0,I) */
local veval, mevec,vevals,smx,i,dveval,stx,meanx;

{veval,mevec} = eighv(corrx(mx));     /* corr.matrix C */
veval = abs(veval);
veval=rev(veval);mevec=rev(mevec')';

i=1;do until i>rows(veval);
if veval[i] .>1e-12; veval[i]= (1/ sqrt(veval[i]));
elseif veval[i] .<1e-12; veval[i]=0;
endif;
i=i+1;endo;

meanx=meanc(mx)';
stx=sqrt((rows(mx)-1)/rows(mx))*(stdc(mx)');
smx=(mx-meanc(mx)')./stx;

dveval=diagrv(eye(rows(veval)),veval);

               /* inv(sqrt(L)) = 1 / dg(sqrt(m)), sqrt(C)=E*inv(sqrt(L))E' */
@return standardize(mX) * mevec * dveval * mevec';  @
retp(smx*mevec*dveval*mevec');
endp;


proc(1)=SkewSU(vSkew, cT);
local n, n2, beta, w2, delta, alfa, vy;
                  /* transform skewness to normality, see D'Agostino [1970] */
	n = @double@(cT);
	if (n < 8); n = 8;endif;
    n2 = n * n;

    beta = 3 * (n2+27*n-70)/((n-2)*(n+5)) * ((n+1)/(n+7)) * ((n+3)/(n+9));
   w2 = -1 + sqrt(2*(beta - 1));
    delta = 1 / sqrt(ln(sqrt(w2)));
    alfa = sqrt(2/(w2 - 1));
    vy = vSkew * sqrt((n+1)*(n+3)/(6*(n-2))) / alfa;
  vy = delta * ln(vy + sqrt(vy .^ 2 + 1));
retp(vy);
endp;


proc(1)=KurtGamma(vSkew, vKurt, cT);
local i, n, n2, delta, a, c, k, r, p, vz, kurt;

   /* transform kurtosis to gamma
                     see Shenton and Bowman [1977], Johnson and Kotz [1970] */
	n = @double@(cT);
	if (n < 8); n = 8;endif;
    n2 = n * n;

	delta = ((n+5)/(n-3)) * ((n+7)/(n+1)) / (6*(n2+15*n-4));
    a = (n-2) * (n2+27*n-70) * delta;
    c = (n-7) * (n2+2*n-5) * delta;
    k = (n*n2+37*n2+11*n-313) * delta / 2;
    r = 1 + c / k;
    p = 3 * (n-1)/(n+1) - r *6*(n-2)/((n+1)*(n+3));
    vz = a + (vSkew .^ 2) * c;                                      /* alfa */

    kurt = (vKurt - 1 - vSkew .^ 2) * k * 2;   /*  gamma standard. to chisq */
	@kurt = matrix(kurt);@
   i=1; do until i>rows(kurt);     /* individual Wilson-Hilferty */
   kurt[i]=( ((kurt[i] / (2 * vz[i])) ^ (1/3)) - 1 +1/(9*vz[i])) * sqrt(9*vz[i]);
i=i+1;endo;

retp(kurt);endp;

@Proc to undertake a Jarque-Bera test on a variable@ 


/* DEFINITION OF THE PROC FOR BERA/JARQUE NORMALITY TESTING */ 
PROC(4) = jarqbera(vartest,n) ; /*where vartest is the variable to be tested, and n is the sample size */ 
local m1, m2, m3, m4,m5, xbar, skew, y, sqr_skew, w, kurt, kurt_3,prob_w; 

/* Calculating SqrtB1, the skewness statistic, and B2, the kurtosis statistic */ 

m1 = ones(n,1); m2 = ones(n,1); m3 = ones(n,1); m4 = ones(n,1);
m5 = ones(1,1); 
skew = 1; kurt = 1; 
m1 = vartest- meanc(vartest); 
m2 = m1^2 ; 
m3 = m1^3 ; 
m4 = m1^4 ; 
m2 = SUMC(m2)/n ; 
m3 = SUMC(m3)/n ; 
m4 = SUMC(m4)/n ; 
m5 = m2^3 ; 
m5 = sqrt(m5) ; 
skew = m3/m5 ; 
kurt = m4/(m2^2) ; 

/*Calculating the Bera-Jarque W, omnibus test for normality */ 

kurt_3 = kurt - 3; 
sqr_skew = skew^2; 
w = n*((sqr_skew/6)+((kurt_3^2)/24)); 
prob_w = cdfchic(w,2); 

RETP (skew,kurt,w,prob_w) ; 
ENDP ; 



proc(3)= berkovitz(y,t);
local prmtr_in,xout,fout,gout,cout,lik2,lik3,xout2,rest,likr,lr,prm_fnl1,yyy2;

save yyy2=y;
prmtr_in={0 0 0}; 
prmtr_in=prmtr_in'; screen off;
{xout,fout,gout,cout}=optmum(&lik_fcn2,prmtr_in); 
prm_fnl1=trans(xout); 

lik3=lik_fcn2(xout); 
lik2=-fout;

rest={0, 0,1};
rest=trans(rest);
{likr}=lik_fcn2(rest); 
{likr}=lik_fcn3(rest); 
likr=-likr;

lr=-2*(likr-lik2);
@{xout,fout,gout,cout}=optmum(&lik_fcn2,prmtr_in); @
 
@prm_fnl2=trans(xout); 
lik2=-fout; 
hessn0=hessp(&lik_fcn2,xout); 
cov0=inv(hessn0);  
grdn_fnl=gradfd(&TRANS,xout); 
cov=grdn_fnl*cov0*grdn_fnl'; 

SD2 =sqrt(diag(cov)); 
output on; 
"CMLE Estimates (standard errors in parenthesis)"; 
"mu 
phi 
sig_e"; 
prm_fnl1'; 
"(";;sd1';;")"; 
""; "ll=";;lik1; 
""; 
" Exact MLE Estimates (standard errors in parenthesis)"; 
"mu 
phi 
sig_e"; 
prm_fnl2'; 
"(";;sd2';;")"; 
""; "ll=";;lik2; 
output off; @
retp(lr,cdfchic(lr,3),xout);
endp;

@PROCEDURE TO CALCULATE EXACT LIKELIHOOD VALUE FOR AR(1)@ 
proc lik_fcn2(prmtr1); 
local prmtr,mu_hat,phi_hat,sig_hat,j,e_t,llikv,yyy2,t; 
@local variables for procedure@ 
load yyy2;
t=rows(yyy2);
prmtr=trans(prmtr1); @constrain parameters@ 
mu_hat=prmtr[1]; phi_hat=prmtr[2]; sig_hat=prmtr[3]; 
@Initialize for FULL SAMPLE MLE@ 
e_t=yyy2[1]-mu_hat; 
llikv = -0.5*ln(2*PI*((sig_hat^2)/(1-phi_hat^2))) -0.5*(e_t^2)/((sig_hat^2)/(1-phi_hat^2)); @log likelihood value@ 
@Errors 2 through T and log likelihood@ 
j=2; do until j>T; 
e_t = yyy2[j] - mu_hat - phi_hat*(yyy2[j-1] - mu_hat); 
llikv = llikv -0.5*ln(2*PI*sig_hat^2)-0.5*(e_t^2)/sig_hat^2; @log likelihood value@ 
j=j+1; 
endo; 
retp(-llikv); 
@return minus llikv since optmum minimizes@
endp;

@PROCEDURE TO CONSTRAIN PARAMETERS@
proc trans(c0); local c1; c1 = c0; c1[2]=c0[2]/(1+abs(c0[2]));
@constrain AR to be stable@ c1[3]=exp(-c0[3]); 
@constrain variance to be non-negative@ retp(c1);
endp; 

@PROCEDURE TO CONSTRAIN PARAMETERS@
proc trans2(c0); local c1; c1 = c0; @c1[2]=c0[2]/(1+abs(c0[2]));@c1[2]=exp(-c0[2]); 
@constrain variance to be non-negative@ retp(c1);
endp; 

@PROCEDURE TO CALCULATE EXACT LIKELIHOOD VALUE FOR AR(1)@ 
proc lik_fcn3(prmtr1); 
local prmtr,mu_hat,phi_hat,sig_hat,j,e_t,llikv,yyy2,t; 
@local variables for procedure@ 
load yyy2;
t=rows(yyy2);
prmtr=trans(prmtr1); @constrain parameters@ 
mu_hat=0; phi_hat=0;  sig_hat=1; 
@Initialize for FULL SAMPLE MLE@ 
e_t=yyy2[1]-mu_hat; 
llikv = -0.5*ln(2*PI*((sig_hat^2)/(1-phi_hat^2))) -0.5*(e_t^2)/((sig_hat^2)/(1-phi_hat^2)); @log likelihood value@ 
@Errors 2 through T and log likelihood@ 
j=2; do until j>T; 
e_t = yyy2[j] - mu_hat - phi_hat*(yyy2[j-1] - mu_hat); 
llikv = llikv -0.5*ln(2*PI*sig_hat^2)-0.5*(e_t^2)/sig_hat^2; @log likelihood value@ 
j=j+1; 
endo; 
retp(-llikv); 
@return minus llikv since optmum minimizes@
endp;


@ Berkowitz test for N(0,1) but assuming independence @
proc(3)= berkovitziid(y,t);
local prmtr_in,xout,fout,gout,cout,lik2,lik3,xout2,rest,likr,lr,prm_fnl1,yyy2;

save yyy2=y;
prmtr_in={0 1}; 
prmtr_in=prmtr_in'; 
{xout,fout,gout,cout}=optmum(&lik_fcn4,prmtr_in); 

prm_fnl1=trans2(xout); 

lik3=lik_fcn4(xout); 
lik2=-fout;

rest={0, 0,1};
rest=trans(rest);
{likr}=lik_fcn3(rest); 
likr=-likr;

lr=-2*(likr-lik2);

retp(lr,cdfchic(lr,2),xout);
endp;


@PROCEDURE TO CALCULATE EXACT LIKELIHOOD VALUE FOR AR(1)@ 
proc lik_fcn4(prmtr1); 
local prmtr,mu_hat,phi_hat,sig_hat,j,e_t,llikv,yyy2,t; 
@local variables for procedure@ 
load yyy2;
t=rows(yyy2);
prmtr=trans2(prmtr1); @constrain parameters@ 
mu_hat=prmtr[1]; sig_hat=prmtr[2];phi_hat=0; 
@Initialize for FULL SAMPLE MLE@ 
e_t=yyy2[1]-mu_hat; 
llikv = -0.5*ln(2*PI*((sig_hat^2)/(1-phi_hat^2))) -0.5*(e_t^2)/((sig_hat^2)/(1-phi_hat^2)); @log likelihood value@ 
@Errors 2 through T and log likelihood@ 
j=2; do until j>T; 
e_t = yyy2[j] - mu_hat - phi_hat*(yyy2[j-1] - mu_hat); 
llikv = llikv -0.5*ln(2*PI*sig_hat^2)-0.5*(e_t^2)/sig_hat^2; @log likelihood value@ 
j=j+1; 
endo; 
retp(-llikv); 
@return minus llikv since optmum minimizes@
endp;



/**************** Goodness of Fit ************************
This library of goodness of fit statistics was
written by David Baird and may be distributed as freeware
for public non-commercial use. Please provide appropriate
acknowledgment if this library supports published work.
There are no performance guarantees for this code.
Last update: 11/9/94

  Dr David Baird  Biometrician
  Mail:           AgResearch, PO Box 60, Lincoln, NEW ZEALAND
  Phone:          +64 3 325 6900    Fax: +64 3 325 2946
  Direct Dial:    +64 3 325 6901 3975#
  Internet:       BairdD@AgResearch.CRI.NZ
***********************************************************/



/* EMPCDF.SRC Procedures for calculating Goodness of fit statistics for
**            Empirical distribution functions and their critical values
**            and P values
** David Baird AgResearch PO Box 60 Lincoln 1/7/92
**
Procedure        Description                                           Line
*==========================================================================
s = GF_AD(d)   ;   Anderson-Darling Goodness of Fit Statistic            25
c = CV_AD(p,n) ;   Critical value for Anderson-Darling Statistic         57
p = PR_AD(c,n) ;   P value for Anderson-Darling Statistic                90
s = GF_C2(d)   ;   Cramer-von Mises Goodness of Fit Statistic           128
c = CV_C2(p,n) ;   Critical value for Cramer-von Mises Statistic        160
p = PR_C2(c,n) ;   P value for Cramer-von Mises Statistic               193
s = GF_KS(d)   ;   Kolmogorov-Smirnov Goodness of Fit Statistic         230
c = CV_KS(p,n) ;   Critical value for Kolmogorov-Smirnov Statistic      264
p = PR_KS(c,n) ;   P value for Kolmogorov-Smirnov Statistic             300
s = GF_K0(d)   ;   K0 squared Goodness of Fit Statistic                 341
c = CV_K0(p,n) ;   Critical value for K0 squared Statistic              377
p = PR_K0(c,n) ;   P value for K0 squared Statistic                     415
s = GF_K2(d)   ;   K squared Goodness of Fit Statistic                  486
c = CV_K2(p,n) ;   Critical value for K squared Statistic               523
p = PR_K2(c,n) ;   P value for K squared Statistic                      560
**========================================================================*/

/* GF_AD - Calculate Anderson-Darling Goodness of Fit Statistic
**
** The AD statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different
**
** Input:  D  - N x C matrix - Empirical distribution function
**
** Output: S  - C x 1 matrix of test statistics
**
** Usage   S = GF_AD(D) ;
**
** Notes:  Use CV_AD or PR_AD to evaluate the significance of AD under the
**         Null hypothesis that D and T come from the same distribution
*/

proc gf_ad(d) ;
     local n,c,i,t,ad,f:proc ;
     n = rows(d) ;
     c = cols(d) ;
     i = 1 ;
     do until(i > c) ;
        d[.,i] = sortc(d[.,i],1) ;
        i = i + 1 ;
     endo ;

@if (d.*(1-rev(d)))<=0.0000000001;d=0.00000000001;endif;@
     ad = -sumc(seqa(1,2,n).*ln(d.*(1-rev(d))))./n - n ;
     retp(ad) ;
endp ;

/* CV_AD - Calculate critical value for Anderson-Darling Statistic
**
** The AD statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different
**
** Input:  P - R x C matrix of probabilities ( 0 < p < 1 )
**         N - S x T matrix of distribution size, ExE conformable with P
**
** Output: C - R x C matrix of critical values ie Prob(AD > C) = P
**
** Usage   C = CV_AD(0.05,80) ;
**
** Notes:  C is only returned for N > 5 and P in (0.0001,0.2)
**         C is invariant to the value of N
**         PR_AD provides the inverse tranform, and estimates P given C,N
*/

proc cv_ad(p,n) ;
     local c0,c1,c2 ;
     if not (0.0001 <= p and p <= 0.2) ;
        errorlog "ERROR: CV_AD - p value out of range (0.0001,0.2)" ;
        retp(error(1)) ;
     elseif not (n > 4) ;
        errorlog  "ERROR: CV_AD - n value too small (n <= 4)" ;
        retp(error(1)) ;
     endif ;
     p = ln(p) ;
     c0 =  0.164111752625 ;
     c1 = -0.719787337528 ;
     c2 =  0.020207904162 ;
     retp((c0 + p.*(c1 + p.*c2))+zeros(rows(n),cols(n))) ;
endp ;

/* PR_AD - Calculate probability values for Anderson-Darling Statistic
**
** The AD statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
**
** Input:  C - R x C matrix of critical values
**         N - S x T matrix of distribution size, ExE conformable with C
**
** Output: P - R x C matrix of probabilities ie Prob(AD > C) = P
**
** Usage   P = PR_AD(2.0,80) ;
**
** Notes:  P is only returned for N > 5
**         P is invariant to the value of N
**         Values of P are not calculated accurately for P < 0.0001 or P >
0.2
**         CV_AD provides the inverse transform, and estimates C given P,N
*/

proc pr_ad(z,n) ;
     local c0,c1,c2,d,p ;
     if not (n > 4) ;
        errorlog  "ERROR: PR_AD - n value too small (n <= 4)" ;
        retp(error(1)) ;
     endif ;
     n = 1./n ;
     c0 =  0.164111752625 ;
     c1 = -0.719787337528 ;
     c2 =  0.020207904162 ;
     d = c1^2 + 4.*c2.*(z - c0) ;
     if not (d > 0) ;
        d = d.* (d .> 0) ;
        errorlog("WARNING: PR_AD - some p values only approximate") ;
     endif ;
     p = exp(-(c1+sqrt(d))./(2.*c2)) ;
     p = p.*(p .> 0) + (1 - p).*(p .> 1) ;
     retp(p) ;
endp ;

/* GF_C2 - Calculate Cramer-von Mises Goodness of Fit Statistic
**
** The C2 statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different
**
** Input:  D  - N x C matrix - Empirical distribution function
**
** Output: S  - C x 1 matrix of test statistics
**
** Usage   S = GF_C2(D) ;
**
** Notes:  Use CV_C2 or PR_C2 to evaluate the significance of AD under the
**         Null hypothesis that D and T come from the same distribution
*/

proc gf_c2(d) ;
     local n,c,i,t,c2 ;
     n = rows(d) ;
     c = cols(d) ;
     i = 1 ;
     do until(i > c) ;
        d[.,i] = sortc(d[.,i],1) ;
        i = i + 1 ;
     endo ;
     c2 = sumc((d - seqa(1/(2.*n),1./n,n))^2) + 1/(12.*n) ;
     retp(c2) ;
endp ;

/* CV_C2 - Calculate critical value for Cramer-von Mises Statistic
**
** The C2 statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
**
** Input:  P - R x C matrix of probabilities ( 0 < p < 1 )
**         N - S x T matrix of distribution size, ExE conformable with P
**
** Output: C - R x C matrix of critical values ie Prob(AD > C) = P
**
** Usage   C = CV_C2(0.05,80) ;
**
** Notes:  C is only returned for N > 5 and P in (0.0001,0.2)
**         PR_C2 provides the inverse tranform, and estimates P given C,N
*/

proc cv_c2(p,n) ;
     local c0,c1,c2 ;
     if not (0.0001 <= p and p <= 0.2) ;
        errorlog "ERROR: CV_C2 - p value out of range (0.0001,0.2)" ;
        retp(error(1)) ;
     elseif not n > 4 ;
        errorlog  "ERROR: CV_C2 - n value too small (n <= 4)" ;
        retp(error(1)) ;
     endif ;
     p = ln(p) ;
     n = 1./sqrt(n) ;
     c0 = -0.02226684 ;
     c1 = -0.14766489 - n.*(0.03720187 + n.*(0.12325507 - n.*0.38246277)) ;
     c2 =  0.00414260 - n.*0.01159939 ;
     retp(c0 + p.*(c1 + p.*c2)) ;
endp ;

/* PR_C2 - Calculate probability values for Cramer-von Mises Statistic
**
** The C2 statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
**
** Input:  C - R x C matrix of critical values
**         N - S x T matrix of distribution size, ExE conformable with C
**
** Output: P - R x C matrix of probabilities ie Prob(AD > C) = P
**
** Usage   P = PR_C2(2.0,80) ;
**
** Notes:  P is only returned for N > 5
**         Values of P are not calculated accurately for P < 0.0001 or P >
0.2
**         CV_AD provides the inverse transform, and estimates C given P,N
*/

proc pr_c2(z,n) ;
     local c0,c1,c2,d,p ;
     if not (n > 4) ;
        errorlog  "ERROR: PR_C2 - n value too small (n <= 4)" ;
        retp(error(1)) ;
     endif ;
     n = 1./sqrt(n) ;
     c0 = -0.02226684 ;
     c1 = -0.14766489 - n.*(0.03720187 + n.*(0.12325507 - n.*0.38246277)) ;
     c2 =  0.00414260 - n.*0.01159939 ;
     d = c1^2 + 4.*c2.*(z - c0) ;
     if not (d > 0) ;
        d = d.* (d .> 0) ;
        errorlog("WARNING: PR_KS - some p values only approximate") ;
     endif ;
     p = exp(-(c1+sqrt(d))./(2.*c2)) ;
     p = p + (1 - p).*(p .> 1) ;
     retp(p) ;
endp ;

/* GF_KS - Calculate Kolmogorov-Smirnov Goodness of Fit Statistic
**
** The KS statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
** The KS statistic is the maximum difference between the CDF's of the
** two distrubutions
**
** Input:  D  - N x C matrix - Empirical distribution function
**
** Output: S  - C x 1 matrix of test statistics
**
** Usage   S = GF_KS(D) ;
**
** Notes:  Use CV_KS or PR_KS to evaluate the significance of AD under the
**         Null hypothesis that D and T come from the same distribution
*/

proc gf_ks(d) ;
     local n,c,i,ks ;
     n = rows(d) ;
     c = cols(d) ;
     i = 1 ;
     do until(i > c) ;
        d[.,i] = sortc(d[.,i],1) ;
        i = i + 1 ;
     endo ;
     ks = maxc((seqa(1./n,1./n,n) - d)|(d - seqa(0,1./n,n))) ;
     retp(ks) ;
endp ;

/* CV_KS - Calculate critical value for Kolmogorov-Smirnov Statistic
**
** The KS statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
** The KS statistic is the maximum difference between the CDF's of the
** two distrubutions
**
** Input:  P - R x C matrix of probabilities ( 0 < p < 1 )
**         N - S x T matrix of distribution size, ExE conformable with P
**
** Output: C - R x C matrix of critical values ie Prob(AD > C) = P
**
** Usage   C = CV_KS(0.05,80) ;
**
** Notes:  C is only returned for N > 5 and P in (0.0001,0.2)
**         C is invariant to the value of N
**         PR_KS provides the inverse tranform, and estimates P given C,N
*/

proc cv_ks(p,n) ;
     local c0,c1,c2 ;
     if not (0.0001 <= p and p <= 0.2) ;
        errorlog "ERROR: CV_KS - p value out of range (0.0001,0.2)" ;
        retp(error(1)) ;
     elseif not (n > 4) ;
        errorlog  "ERROR: CV_KS - n value too small (n <= 4)" ;
        retp(error(1)) ;
     endif ;
     p = ln(p) ;
     n = 1./sqrt(n) ;
     c0 =  0.733183379676 ;
     c1 = -0.229138856954 - n.*0.016445061725 ;
     c2 = -0.007245795230 - n.*0.005111922399 ;
     retp((c0 + p.*(c1 + p.*c2))./(1./n + 0.11 + 0.12.*n)) ;
endp ;

/* PR_KS - Calculate probability values for Cramer-von Mises Statistic
**
** The KS statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
**
** Input:  C - R x C matrix of critical values
**         N - S x T matrix of distribution size, ExE conformable with C
**
** Output: P - R x C matrix of probabilities ie Prob(AD > C) = P
**
** Usage   P = PR_KS(2.0,80) ;
**
** Notes:  P is only returned for N > 5
**         Values of P are not calculated accurately for P < 0.0001 or P >
0.2
**         CV_KS provides the inverse transform, and estimates C given P,N
*/

proc pr_ks(z,n) ;
     local c0,c1,c2,d,p ;
     if not (n > 4) ;
        errorlog  "ERROR: PR_KS - n value too small (n <= 4)" ;
        retp(error(1)) ;
     endif ;
     if not(0 < z and z < 1) ;
        errorlog  "ERROR: PR_KS - z value outside range (0,1)" ;
        retp(error(1)) ;
     endif ;
     n = 1./sqrt(n) ;
     c0 =  0.733183379676 ;
     c1 = -0.229138856954 - n.*0.016445061725 ;
     c2 = -0.007245795230 - n.*0.005111922399 ;
     d = c1^2 + 4.*c2.*(z.*(1./n + 0.11 + 0.12.*n)  - c0) ;
     if not (d > 0) ;
        d = d.* (d .> 0) ;
        errorlog("WARNING: PR_KS - some p values only approximate") ;
     endif ;
     p = exp(-(c1+sqrt(d))./(2.*c2)) ;
     p = p + (1 - p).*(p .> 1) ;
     retp(p) ;
endp ;

/* GF_K0 - Calculate K0 squared Goodness of Fit Statistic
**
** The K0 statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
** It is the correlation coefficent between the cdf's of the two functions
** without the usual mean correction (which gives the K2 statistic)
** and so must take values between 0 and 1.
**
** Input:  D  - N x C matrix - Empirical distribution function
**
** Output: S  - C x 1 matrix of test statistics
**
** Usage   S = GF_K0(D) ;
**
** Notes:  Use CV_K0 or PR_K0 to evaluate the significance of AD under the
**         Null hypothesis that D and T come from the same distribution
*/

proc gf_k0(d) ;
     local n,c,i,px,k0 ;
     n = rows(d) ;
     c = cols(d) ;
     i = 1 ;
     do until(i > c) ;
        d[.,i] = sortc(d[.,i],1) ;
        i = i + 1 ;
     endo ;
     px = seqa(1,1,n)./(n+1) - 0.5 ;
     d  = d - 0.5 ;
     k0 = (sumc(px.*d))^2 ./ (sumc(px^2).*sumc(d^2)) ;
     retp(k0) ;
endp ;

/* CV_K0 - Calculate critical value for k squared Statistic
**
** The K0 statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
** It is the correlation coefficent between the cdf's of the two functions
** without the usual mean correction (which gives the K2 statistic)
** and so must take values between 0 and 1.
**
** Input:  P - R x C matrix of probabilities ( 0 < p < 1 )
**         N - S x T matrix of distribution size, ExE conformable with P
**
** Output: C - R x C matrix of critical values ie Prob(AD > C) = P
**
** Usage   C = CV_K0(0.05,80) ;
**
** Notes:  C is only returned for N > 5 and P in (0.001,0.2)
**         PR_K2 provides the inverse tranform, and estimates P given C,N
*/

proc cv_k0(p,n) ;
     local c0,c1,c2,c3,c4 ;
     if not (0.001 <= p and p <= 0.2) ;
        errorlog "ERROR: CV_K0 - p value out of range (0.001,0.2)" ;
        retp(error(1)) ;
     elseif not (n > 4) ;
        errorlog  "ERROR: CV_K0 - n value too small (n <= 4)" ;
        retp(error(1)) ;
     endif ;
     p = ln(p) ;
     n = 1./n ;
     c0 =  0.8653139 + n.*(0.1926594 - n.*(0.0192220 + n.*0.7795628)) ;
     c1 =  0.4632579 - n.*(0.0206542 + n.* 0.2664381) ;
     c2 =  0.1143172 + n.* 0.0030095 ;
     c3 =  0.0134711 + n.* 0.0004322 ;
     c4 =  0.0006115 ;
    retp(1 - n./(c0 + p.*(c1 + p.*(c2 + p.*(c3 + p.*c4))))) ;
endp ;

/* PR_K0 - Calculate probability values for k0 squared Statistic
**
** The K0 statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
** It is the correlation coefficent between the cdf's of the two functions
** without the usual mean correction (which gives the K2 statistic)
** and so must take values between 0 and 1.
**
** Input:  C - R x C matrix of critical values
**         N - S x T matrix of distribution size, ExE conformable with C
**
** Output: P - R x C matrix of probabilities ie Prob(AD > C) = P
**
** Usage   P = PR_K0(.995,80) ;
**
** Notes:  P is only returned for N > 5
**         Values of P are not calculated accurately for P < 0.001 or P >
0.2
**         CV_K0 provides the inverse transform, and estimates C given P,N
*/

proc pr_k0(z,n) ;
     local c0,c1,c2,c3,c4,p,mnz,mnp,mxz,mxp,tol,converge,f,df,pn,i,zn ;
     tol = 1e-8 ;
     if not (n > 4) ;
        errorlog  "ERROR: PR_K0 - n value too small (n <= 4)" ;
        retp(error(1)) ;
     elseif not(0 < z and z < 1) ;
        errorlog  "ERROR: PR_K0 - z value outside range (0,1)" ;
        retp(error(1)) ;
     endif ;
     n = 1./n ;
     c0 = 0.8653139 + n.*(0.1926594 - n.*(0.0192220 + n.*0.7795628)) ;
     c1 = 0.4632579 - n.*(0.0206542 + n.* 0.2664381) ;
     c2 = 0.1143172 + n.* 0.0030095 ;
     c3 = 0.0134711 + n.* 0.0004322 ;
     c4 = 0.0006115 ;
     mnp = ln(0.001) ;
     mnz = c0 + mnp.*(c1 + mnp.*(c2 + mnp.*(c3 + mnp.*c4))) ;
     mxp = ln(0.2) ;
     mxz = c0 + mxp.*(c1 + mxp.*(c2 + mxp.*(c3 + mxp.*c4))) ;
     z   = n./(1-z) ;
     zn  = z ;
     zn  = substute(zn,zn .< (mnz-tol),mnz) ;
     zn  = substute(zn,zn .> (mxz+tol),mxz) ;
     clear converge,i ;
     p = ln(0.1).*ones(rows(z+n),cols(z+n)) ;
     do until(converge or i > 50) ;
        f  = c0 + p.*(c1 + p.*(c2 + p.*(c3 + p.*c4))) ;
        df = c1 + p.*(2.*c2 + p.*(3.*c3 + p.*4.*c4)) ;
        pn = p + (z - f)./df ;
        converge = abs(p-pn) < tol ;
        p = pn ;
        i = i + 1 ;
     endo ;
     if not converge ;
        errorlog("WARNING: PR_K0 - iterations have not converged.") ;
     endif ;
     if not (z == zn) ;
        errorlog("WARNING: PR_K0 - some p values outside range 0.001 - 0.2")
;
        p = substute(exp(p),zn.==mnz,0.001) ;
        p = substute(exp(p),zn.==mxz,0.200) ;
     else ;
        p = exp(p) ;
     endif ;
     if not(p > 0.002 and n > 6) ;
        errorlog("WARNING: PR_K0 - returned values inaccurate"\
                 " for p < 0.002, n <= 6)") ;
     endif ;
     retp(p) ;
endp ;

/* GF_K2 - Calculate K squared Goodness of Fit Statistic
**
** The K2 statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
** It is the correlation coefficent between the cdf's of the two functions
** and so must take values between 0 and 1.
**
** Input:  D  - N x C matrix - Empirical distribution function
**
** Output: S  - C x 1 matrix of test statistics
**
** Usage   S = GF_K2(D) ;
**
** Notes:  Use CV_K2 or PR_K2 to evaluate the significance of AD under the
**         Null hypothesis that D and T come from the same distribution
*/

proc gf_k2(d) ;
     local n,c,i,px,k2 ;
     n = rows(d) ;
     c = cols(d) ;
     i = 1 ;
     do until(i > c) ;
        d[.,i] = sortc(d[.,i],1) ;
        i = i + 1 ;
     endo ;
     px = seqa(1,1,n)./(n+1) ;
     d  = d  - meanc(d)' ;
     px = px - meanc(px)' ;
     k2 = (sumc(px.*d))^2 ./ (sumc(px^2).*sumc(d^2)) ;
     retp(k2) ;
endp ;

/* CV_K2 - Calculate critical value for k squared Statistic
**
** The K2 statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
** It is the correlation coefficent between the cdf's of the two functions
** and so must take values between 0 and 1.
**
** Input:  P - R x C matrix of probabilities ( 0 < p < 1 )
**         N - S x T matrix of distribution size, ExE conformable with P
**
** Output: C - R x C matrix of critical values ie Prob(AD > C) = P
**
** Usage   C = CV_K2(0.05,80) ;
**
** Notes:  C is only returned for N > 5 and P in (0.001,0.2)
**         PR_K2 provides the inverse tranform, and estimates P given C,N
*/

proc cv_k2(p,n) ;
     local c0,c1,c2,c3,c4 ;
     if not (p >= .001 and p <= 0.2) ;
        errorlog "ERROR: CV_K2 - p value out of range (0.001,0.2)" ;
        retp(error(1)) ;
     elseif not (n > 4) ;
        errorlog  "ERROR: CV_K2 - n value too small (n <= 4)" ;
        retp(error(1)) ;
     endif ;
     p = ln(p) ;
     n = 1./n ;
     c0 =  1.7487259 + n.*(2.2565277  - n.*(0.3038449 - n.*16.1713960)) ;
     c1 =  0.7536611 + n.* 0.7059508 ;
     c2 =  0.1675119 + n.*(0.0609113 + n.*0.0141376) ;
     c3 =  0.0184351 ;
     c4 =  0.0007881 ;
     retp(1 - n./(c0 + p.*(c1 + p.*(c2 + p.*(c3 + p.*c4))))) ;
endp ;

/* PR_K2 - Calculate probability values for k squared Statistic
**
** The K2 statistic is a goodness of fit statistic to test whether two
** cumulative frequency distributions are significantly different.
** It is the correlation coefficent between the cdf's of the two functions
** and so must take values between 0 and 1.
**
** Input:  C - R x C matrix of critical values
**         N - S x T matrix of distribution size, ExE conformable with C
**
** Output: P - R x C matrix of probabilities ie Prob(AD > C) = P
**
** Usage   P = PR_K2(2.0,80) ;
**
** Notes:  P is only returned for N > 5
**         Values of P are not calculated accurately for P < 0.001 or P >
0.2
**         CV_K2 provides the inverse transform, and estimates C given P,N
*/

proc pr_k2(z,n) ;
     local c0,c1,c2,c3,c4,p,mnz,mnp,mxz,mxp,tol,converge,f,df,pn,i,zn ;
     tol = 1e-8 ;
     if not (n > 4) ;
        errorlog  "ERROR: PR_K2 - n value too small (n <= 4)" ;
        retp(error(1)) ;
     elseif not(0 < z and z < 1) ;
        errorlog  "ERROR: PR_K2 - z value outside range (0,1)" ;
        retp(error(1)) ;
     endif ;
     n = 1./n ;
     c0 =  1.7487259 + n.*(2.2565277  - n.*(0.3038449 - n.*16.1713960)) ;
     c1 =  0.7536611 + n.* 0.7059508 ;
     c2 =  0.1675119 + n.*(0.0609113 + n.*0.0141376) ;
     c3 =  0.0184351 ;
     c4 =  0.0007881 ;
     mnp = ln(0.001) ;
     mnz = c0 + mnp.*(c1 + mnp.*(c2 + mnp.*(c3 + mnp.*c4))) ;
     mxp = ln(0.2) ;
     mxz = c0 + mxp.*(c1 + mxp.*(c2 + mxp.*(c3 + mxp.*c4))) ;
     z = n./(1 - z) ;
     zn = z ;
     zn  = substute(zn,zn .< (mnz-tol),mnz) ;
     zn  = substute(zn,zn .> (mxz+tol),mxz) ;
     clear converge,i ;
     p = ln(0.1).*ones(rows(z+n),cols(z+n)) ;
     do until(converge or i > 50) ;
        f  = c0 + p.*(c1 + p.*(c2 + p.*(c3 + p.*c4))) ;
        df = c1 + p.*(2.*c2 + p.*(3.*c3 + p.*4.*c4)) ;
        pn = p + (z - f)./df ;
        converge = abs(p-pn) < tol ;
        p = pn ;
        i = i + 1 ;
     endo ;
     if not converge ;
        errorlog("WARNING: PR_K2 - iterations have not converged.") ;
     endif ;
     if not (z == zn) ;
        errorlog("WARNING: PR_K2 - some p values outside range 0.001 - 0.2")
;
        p = substute(exp(p),zn.==mnz,0.200) ;
        p = substute(exp(p),zn.==mxz,0.001) ;
     else ;
        p = exp(p) ;
     endif ;
     retp(p) ;
endp ;

end;



PROC istudent(p,v);
 p=abs(p);
 RETP(CDFTCI(1-p,v));
ENDP;



PROC rstudent(r,c,v);

 RETP(istudent(RNDU(r,c),v));
ENDP;

/* The procedure below estimates the long run covariance matrix

       Expression :  {omega} = covv(u,whiten,ar12,_band,kernel,crit);

   Input:    u          vector or matrix series.

             whiten     If 0 prewhiten series.
                        no prewhiten otherwise.

             ar12       If 2, a ar(2) is used for prewhitening. A ar(1) is used otherwise.

             _band      If zero, the bandwidth is chosen following Andrews (1991)
                        criteria. If a different value is given, that will be the chosen 
                        band.

             kernel     If 1 Quadratic Spectral kernel is used.
                        If 2 Parzen kernel is used.
                        If 3 Barlett kernel is used.


   Output:   omega  long run covariance matrix



   If prewhitenning and QS kernel. i.e.: whiten=0; ar12=1;  kernel=1;

                                                       */

proc(1) = covv(u,whiten,ar12,_band,kernel,crit);
local t,p,ub,uf,a,e,a,te,eb,ef,ae,ee,se,ad,a1,a2,band2,bandd;
local jb,jband,kern,sig,lam,j,omega,uu,ai;

t = rows(u);
p=cols(u);
/* PreWhiten Residuals Using VAR(1) or VAR(2) */
if whiten == 0;
 IF ar12 EQ 2;                
   ub = u[2:t-2,.]~u[1:t-3,.];
   uf = u[3:t-1,.];
   a = (ub'uf)/moment(ub,0);                     /* VAR(2) matrix */
   e = uf - ub*a;                                /* Whitened residuals */
   a = a[1:p,.] + a[p+1:2*p,.];
   te = t-3;
 ELSE;
   ub = u[1:t-2,.];
   uf = u[2:t-1,.];
   a = (ub'uf)/moment(ub,0);                     /* VAR(1) matrix */
   e = uf - ub*a;                                /* Whitened residuals */
   te = t-2;
 ENDIF;
else;
 e = u;
 te = t-1;
endif;

/* Select Bandwidth */

if _band == 0;
 eb = e[1:te-1,.];
 ef = e[2:te,.];
 ae = sumc(eb.*ef)./sumc(eb.^2);
 ee = ef - eb.*(ae');
 se = meanc(ee.^2);
 ad = sumc((se./((1-ae).^2)).^2);
 a1 = 4*sumc((ae.*se./(((1-ae).^3).*(1+ae))).^2)/ad;
 a2 = 4*sumc((ae.*se./((1-ae).^4)).^2)/ad;
 if kernel == 1;                               /*  Quadratic Spectral */
  bandd = 1.3221*((a2*te)^.2);
 elseif kernel == 2;                           /*  Parzen     */
  bandd = 2.6614*((a2*te)^.2);
 elseif kernel == 3;                           /*  Bartlett   */
  bandd = 1.1447*((a1*te)^.333);
 endif;
else;
 bandd = _band;
endif;
/*if bandd >15; bandd = 15; endif;*/

/* Estimate Covariances */
jb = seqa(1,1,te-1)/bandd;
if kernel == 1;                                /* Quadratic Spectral Kernel */
  jband = jb*1.2*pi;
  kern = ((sin(jband)./jband - cos(jband))./(jband.^2)).*3;
elseif kernel == 2;                            /*  Parzen kernel */
  kern = (1 - (jb.^2)*6 + (jb.^3)*6).*(jb .<= .5);
  kern = kern + ((1-jb).^3).*(jb .<=1).*(jb .> .5)*2;
elseif kernel == 3;                           /*  Bartlett kernel */
  kern = (1-jb).*(jb .<= 1);
endif;

sig = e'e;
lam = zeros(p,p);
j = 1; do while j <=te-1;
  lam = lam + (e[1:te-j,.]'e[1+j:te,.])*kern[j];
j = j + 1; endo;
omega = sig + lam + (lam');
uu = u'u;

/* Recolor */
if whiten == 0;
 ai = inv(eye(p) - a);
 omega = ai'omega*ai;
endif;

retp(omega); endp;



/*	Procedure WhiteCov() 
**
**	This procedure calculates White's heteroskedastic robust estimate of the	
**	covariance matrix of the (linear) least squares estimator of Beta. The
**	user supplies the estimated noise elements in ehat as well as the explanatory
**	variable matrix in x.  The 'inflate' options, which are applied to the elements
**	of the squared residuals (ehat^2) are:
**
**		0 ---> No noise element inflation
**		1 ---> Inflation by the factor n/(n-k)
**		2 ---> Inflation by (1-h[i])^(-1)
**		3 ---> Inflation by (1-h[i])^(-2)
**
**	where:
**
**		h[i]=(1-x[i,.]*inv(x'x)*x[i,.]')
**
*/

proc WhiteCov(ehat,x,inflate);
	local n, k, esqr, i, invxTx, covbhat;

	n = rows(ehat);
	k = cols(x);
	invxTx = invpd(x'x);

	if inflate == 0;
		esqr = ehat.*ehat;
	elseif inflate == 1;
		esqr = ehat.*ehat*n/(n-k);
	elseif inflate == 2;
		
			esqr = ehat.*ehat./(1 - sumc(x'.*(invxTx*x')));
		
	else;
		
			esqr = ehat.*ehat./((1 - sumc(x'.*(invxTx*x')))^2);
		
	endif;

	covbhat = invxTx*(x'(x.*esqr))*invxTx;

	retp(covbhat);
endp;


/*	Procedure NWCov() 
**
**	This procedure calculates Newey and West's robust estimate of the	
**	covariance matrix of the (linear) least squares estimator of Beta.  The
**	user supplies the estimated noise elements in ehat as well as the
**	explanatory variable matrix in x. The 'truncate' options, which are
**	applied to the estimated covariance terms in the sum are:
**
**		0 ---> Automatic, using L = trunc(4*(n/100)^(2/9))
**		L ---> Positive integer indicating the maximum |i-j| for
**			which cov(e[i],e[j]) will be accounted for.
**		
**	All cov(e[i],e[j]) terms are weighted by the factor defined as	
**			w[i-j] = 1 - abs(i-j)/(L+1)	
**
*/

proc NWCov(ehat,x,truncate);
	local n, k, t, j, invxTx, covbhat,L, w;

	n = rows(ehat);
	k = cols(x);
	invxTx = invpd(x'x);
	truncate = int(truncate);

	if truncate == 0;
		L = trunc(4*(n/100)^(2/9));
	else;
		L = truncate;
	endif;

	covbhat = zeros(k,k);

	for j (1,L,1);
		w = 1 - (j/(L + 1));
		for t (j+1,n,1);
			covbhat = covbhat + (w*ehat[t]*ehat[t-j]*(x[t,.]'x[t-j,.]));
		endfor;
	endfor;

	covbhat = covbhat+covbhat';

	covbhat = invxTx*covbhat*invxTx+WhiteCov(ehat,x,0);

	retp(covbhat);
endp;

proc NWCov2(ehat,truncate);
	local n, k, t, j, invxTx, covbhat,L, w;

	n = rows(ehat);
	k = 1;
	invxTx = moment(ehat,0);
	truncate = int(truncate);

	if truncate == 0;
		L = trunc(4*(n/100)^(2/9));
	else;
		L = truncate;
	endif;

	covbhat = zeros(k,k);

	for j (1,L,1);
		w = 1 - (j/(L + 1));
		for t (j+1,n,1);
			covbhat = covbhat + (w*ehat[t,.]'*ehat[t-j,.]);
		endfor;
	endfor;

	covbhat = covbhat+covbhat';

	covbhat = covbhat+invxTx;

	retp(covbhat);
endp;


proc(2)=ljung_box(x,lag);
local q,ss,ac,n,ac1;

n=rows(x);
{ac}=acor(x,lag);"AR";ac;ac1=ac;
ss=n-seqa(1,1,lag);
ac=(ac[2:lag+1].^2)./ss;
q=sumc(ac);

retp(ac1,cdfchic(n*(n+2)*q,lag));
endp;

proc(2)=boxP(x,lag);
local q,ac,n;

n=rows(x);
{ac}=acor(x,lag);
ac=ac.^2;
q=sumc(ac[2:lag+1]);
retp(cdfchic(n*q,lag),(n*q));
endp;

/*       {ac}=ACOV(x,nlag):  x  is n,k matrix  of k time series of length n
**                           ac is (nlag+1),k matrix of autocovariances
**                           starting at lag 0 to nlag
*/
PROC 1 = ACOV(x,nlag);
  LOCAL ac,i,k,l,m,n,n1,s,y,z;
    k = COLS(x);
    n = ROWS(x);
    m = tsmean(x);
    l = trunc(minc(minc(x))-10);
    n1 = SUMC( MISSRV(x,l)./=(l*ONES(n,1)));
    y = MISSRV(x,m');
    ac = ZEROS(nlag+1,k);
    i=0;
    DO WHILE i<k;
      i=i+1;
      z = (y[.,i]-m[i])'~ZEROS(1,nlag+1);
      z = RESHAPE(z,nlag+1,n+nlag);
      ac[.,i]= z*z[1,.]'./n1[i] ;
    ENDO;
 RETP(ac);
ENDP;

/*       {ac}=ACOR(x,nlag):  x  is n,k matrix  of k time series of length n
**                           ac is (nlag+1),k matrix of autocorelations
**                           starting at lag 0 to nlag
*/
PROC 1 = ACOR(x,nlag);
   RETP(acov(x,nlag)./tsvar(x)');
  ENDP;

PROC 1 = tsmean(x);
  LOCAL i,k,m;
  k=COLS(x);  m=ZEROS(k,1);
  i=0;
  DO WHILE i<k;
    i=i+1;  m[i]=MEANC(PACKR(x[.,i]));
   ENDO;
 RETP(m);
ENDP;

/*       {s}=TSVAR(x):  x is n,k matrix  of k time series of length n
**                      s is k,1 vector of variances
*/
PROC 1 = TSVAR(x);
  LOCAL i,k,s,y;
    k=COLS(x); s=ZEROS(k,1);
    i=0;
    DO WHILE i<k;
     i=i+1;
     y=PACKR(x[.,i]);  s[i]=MEANC(y^2)-MEANC(y)^2;
    ENDO;
 RETP(s);
endp;

proc NW(z,b,lag);

    local sse,n,yhat,e,G,w,a,t,ga,V,F,nwerr,olserr,k,za,hhat;

    n=ROWS(z); k=ROWS(B);
      hhat=z';
    G=ZEROS(k,k); w=ZEROS(2*lag+1,1);

    a=0;

    do until a==lag+1;
        ga=ZEROS(ROWS(b),ROWS(b));
        w[lag+1+a]=(lag+1-a)/(lag+1);
        za=hhat[.,(a+1):n]*hhat[.,1:n-a]';
        if a==0; ga=ga+za; else; ga=ga+za+za'; endif;
        G=G+w[lag+1+a]*ga;
        a=a+1;
    endo;

@g=g./n;@
        F=z'*z./n;
        V=INV(F)*G*INV(F);
        nwerr= @(DIAG(V))^.5@V;
       
    retp(g);

endp;

/* The procedure below estimates the long run covariance matrix

       Expression :  {omega} = covv(u,whiten,ar12,_band,kernel,crit);

   Input:    u          vector or matrix series.

             whiten     If 0 prewhiten series.
                        no prewhiten otherwise.

             ar12       If 2, a ar(2) is used for prewhitening. A ar(1) is used otherwise.

             _band      If zero, the bandwidth is chosen following Andrews (1991)
                        criteria. If a different value is given, that will be the chosen 
                        band.

             kernel     If 1 Quadratic Spectral kernel is used.
                        If 2 Parzen kernel is used.
                        If 3 Barlett kernel is used.


   Output:   omega  long run covariance matrix



   If prewhitenning and QS kernel. i.e.: whiten=0; ar12=1;  kernel=1;

                                                       */

proc(1) = covv(u,whiten,ar12,_band,kernel,crit);
local t,p,ub,uf,a,e,a,te,eb,ef,ae,ee,se,ad,a1,a2,band2,bandd;
local jb,jband,kern,sig,lam,j,omega,uu,ai;

t = rows(u);
p=cols(u);
/* PreWhiten Residuals Using VAR(1) or VAR(2) */
if whiten == 0;
 IF ar12 EQ 2;                
   ub = u[2:t-2,.]~u[1:t-3,.];
   uf = u[3:t-1,.];
   a = (ub'uf)/moment(ub,0);                     /* VAR(2) matrix */
   e = uf - ub*a;                                /* Whitened residuals */
   a = a[1:p,.] + a[p+1:2*p,.];
   te = t-3;
 ELSE;
   ub = u[1:t-2,.];
   uf = u[2:t-1,.];
   a = (ub'uf)/moment(ub,0);                     /* VAR(1) matrix */
   e = uf - ub*a;                                /* Whitened residuals */
   te = t-2;
 endif;
else;
 e = u;
 te = t-1;
endif;

/* Select Bandwidth */

if _band == 0;
 eb = e[1:te-1,.];
 ef = e[2:te,.];
 ae = sumc(eb.*ef)./sumc(eb.^2);
 ee = ef - eb.*(ae');
 se = meanc(ee.^2);
 ad = sumc((se./((1-ae).^2)).^2);
 a1 = 4*sumc((ae.*se./(((1-ae).^3).*(1+ae))).^2)/ad;
 a2 = 4*sumc((ae.*se./((1-ae).^4)).^2)/ad;
 if kernel == 1;                               /*  Quadratic Spectral */
  bandd = 1.3221*((a2*te)^.2);
 elseif kernel == 2;                           /*  Parzen     */
  bandd = 2.6614*((a2*te)^.2);
 elseif kernel == 3;                           /*  Bartlett   */
  bandd = 1.1447*((a1*te)^.333);
 endif;
else;
 bandd = _band;
endif;
/*if bandd >15; bandd = 15; endif;*/

/* Estimate Covariances */
jb = seqa(1,1,te-1)/bandd;
if kernel == 1;                                /* Quadratic Spectral Kernel */
  jband = jb*1.2*pi;
  kern = ((sin(jband)./jband - cos(jband))./(jband.^2)).*3;
elseif kernel == 2;                            /*  Parzen kernel */
  kern = (1 - (jb.^2)*6 + (jb.^3)*6).*(jb .<= .5);
  kern = kern + ((1-jb).^3).*(jb .<=1).*(jb .> .5)*2;
elseif kernel == 3;                           /*  Bartlett kernel */
  kern = (1-jb).*(jb .<= 1);
endif;

sig = e'e;
lam = zeros(p,p);
j = 1; do while j <=te-1;
  lam = lam + (e[1:te-j,.]'e[1+j:te,.])*kern[j];
j = j + 1; endo;
omega = sig + lam + (lam');
uu = u'u;

/* Recolor */
if whiten == 0;
 ai = inv(eye(p) - a);
 omega = ai'omega*ai;
endif;

retp(omega); endp;

@ Non-parametric HAC variance-covariance estimation @
proc hac(e,_kernel,_const,lag);
local t,k,a2,bandw,j,xx,delta,kern,sig,ac,e1,e2,se,ee,ae,w,sa,hac_vcm; 
 t=rows(e);
 k=cols(e);
 ae=zeros(k,1); ee=zeros(t-1,k); se=zeros(k,1);
 j=1; do while j<=k;
  e1=e[2:t,j];
  e2=e[1:t-1,j];
  ae[j]=e1/e2;
  ee[.,j]=e1-e2*ae[j];
  se[j]=meanc(ee[.,j].^2);
 j=j+1;
 endo;
 if _const==0;
  w=ones(k,1);
 elseif _const==1; @ the weight on the constant term is 0 @
  w=0|ones(k-1,1);
 endif;
 a2=4*sumc(w.*(ae.*se./((1-ae).^4)).^2)/sumc(w.*(se./((1-ae).^2)).^2);
 if _kernel==1; @  Bandwidth for Quadratic spectral kernel @
  bandw=1.3221*((a2*t)^.2);
 elseif _kernel==2; @  Bandwidth for Parzen kernel @
  bandw=2.6614*((a2*t)^.2);
 endif;
 xx=seqa(1,1,t-1)/bandw;
 if _kernel==1; @ Quadratic spectral kernel @
  delta=xx*1.2*pi;
  kern=3*((sin(delta)./delta-cos(delta))./(delta.^2));
 elseif _kernel==2; @ Parzen kernel @
  kern=(1-6*(xx.^2)+6*(xx.^3)).*(xx.<=0.5).*(xx.>=0)+
         (2*((1-xx).^3)).*(xx .<=1).*(xx.>0.5);
 endif;
 sig=moment(e,0);
 ac=zeros(k,k);
 j=1; do while j<=@t-1@lag;
   ac=ac+(e[1:t-j,.]'e[1+j:t,.])*kern[j];
 j=j+1; endo;
 hac_vcm=sig+ac+ac'; @ HAC variance-covariance matrix estimate @
retp(hac_vcm);
endp;

@ proc to graph a normal distribution: J. Mitchell @
proc(1) = 	onepiecen(x);
local mean,mode,uncert,s,junk,gam_2,gam,var1,var2,var,sd,meani,A,denom1,denom2,fxx,xx,i,xxx,fx1,fx2,sd1,sd2,fxx1,fxx2,a1,a2,fx;

mean=x[.,1];sd=x[.,2];
fxx={};fx1={};fx2={};fxx1={};fxx2={};
xx=seqa(-35,0.01,6500);
i=1;do until i>6500;
xxx=xx[i];

fx=pdfn((xxx-mean)/sd)/sd; 

fxx=fxx|fx;
i=i+1;endo;

retp(xx~fxx);endp;


proc(1) = 	onepiecen_fast(x);
local mean,mode,uncert,s,junk,gam_2,gam,var1,var2,var,sd,meani,A,denom1,denom2,fxx,xx,i,xxx,fx1,fx2,sd1,sd2,fxx1,fxx2,a1,a2,fx;

mean=x[.,1];sd=x[.,2];
fxx={};fx1={};fx2={};fxx1={};fxx2={};
xx=seqa(-35,0.01,6500);

fx=pdfn((xx-mean)./sd)./sd; 

retp(fx);endp;

proc score3(density1,density2,density3,w1,w2,outturnv);
local i,xx,x1,x2,comb,outturn,pit,z,x3;

z={};
xx=seqa(-35,0.01,6500); @ x-axis @
i=1; do until i>cols(density1);

x1=density1[.,i];
x2=density2[.,i];
x3=density3[.,i];

comb=mixtd3(x1,x2,x3,w1[i],w2[i]);
if comb==999;retp(999);endif;

outturn=outturnv[i];

save xx comb outturn;
{pit}=num_score(xx,comb,outturn); @ numerical calculation of pit's @
save pit; 
z=z|pit;
i=i+1;endo;

retp(ln(z));endp;

proc num_score(xx,comb,outturn);
@ numerical calculation of pit's @

local v1,v2,v,zitt,nn,zit,oo;

v1=outturn-0.001;
v2=outturn+0.001;
v=v1|v2;v=outturn;

zitt=comb.*0.01;
@nn=indexcat(xx,v);@
nn=indexcat2(xx,v);
zit=sumc(zitt[1:nn]);
oo=comb[nn];
if oo==0; oo=meanc(comb[nn-25:nn+25]) ;endif;
retp(oo);
endp;


proc combp3(density1,density2,density3,w1,w2,outturnv);
local i,xx,x1,x2,comb,outturn,pit,z,x3;

z={};
xx=seqa(-35,0.01,6500); @ x-axis @
i=1; do until i>cols(density1);

x1=density1[.,i];
x2=density2[.,i];
x3=density3[.,i];

comb=mixtd3(x1,x2,x3,w1[i],w2[i]);
if comb==999;retp(999);endif;

outturn=outturnv[i];


{pit}=num_pit(xx,comb,outturn); @ numerical calculation of pit's @
z=z|pit;
i=i+1;endo;

retp(z);endp;

proc mixtd3(x1,x2,x3,w1,w2);
local w;
w=1-w1-w2;
if w<0; retp(999);endif;

retp(w1.*x1+w2.*x2);endp;

@ numerical calculation of PITS; James Mitchell @
proc num_pit(xx,comb,outturn);
@ numerical calculation of pit's @

local v1,v2,v,zitt,nn,zit;

v1=outturn-0.001;
v2=outturn+0.001;
v=v1|v2;v=outturn;

zitt=comb.*0.01;
nn=indexcat2(xx,v);
zit=sumc(zitt[1:nn]);
retp(zit);
endp;

proc indexcat2(xx,v);
local c,i;

c=0;
i=-35;do until i>v;
c=c+1;
i=i+0.01;endo;
retp(c);endp;


proc rmulti(m,p,n);
 local s,k,y,w,i;
  p = VEC(p);
  k = ROWS(p);
  integer(m); integer(n); argtest(m|n,"0<*"); argtest(SUMC(p),"1<=*<=1");
  if k==1;
     w = ONES(m,1)*n;
    else;
     s = CUMSUMC(p);
     y = RNDU(1,m*n);
     y = RESHAPE(SUMC(y.>s),m,n);
     w={};
     i=0;
     do while i<m;
       i=i+1;
       w=w|COUNTS(y[i,.]',SEQA(0.5,1,k-1))';
     endo;
     w=w~(n-SUMC(w'));
  endif;
 retp(w);
endp;



