@ Re-creates Fig1 in MW: GBR's IID case for their 4 forecasters.

For the "unfocused" forecaster we compute 2 variants: both produce uniform pits densities,
but the construction of the pits is different.  @

new;
library pgraph;





integ={}; mmulti={};s_mew={};logs_ideal={};hamillp={};s_bi={};pforecastbias={};


R2=10000;
density1={}; density2={}; density3={};zc={};ssu={};sss_pits={};sss_pits2={};sss_pits3={};sss_pits4={};sss_pits4b={};
outturn={};mews={};
i=1;do until i>R2;


@ ideal forecaster @
mew=rndn(1,1);
{outturnp}=rgauss(1,1,mew,1);
outturn=outturn|outturnp; 
pits_ideal=cdfn(outturnp-mew);
sss_pits=sss_pits|pits_ideal;

s_mew=s_mew|mew;

loss_forecaster=dgauss(outturnp,mew,1); 
logsl=ln(loss_forecaster); 
logs_ideal=logs_ideal|logsl;

@ climatalogical @
x1=(zeros(1,1))~(ones(1,1).*sqrt(2));
	z1t=cdfn((outturnp-x1[1,1])./(x1[1,2]));
sss_pits2=sss_pits2|z1t;
	su=dgauss(outturnp,0,sqrt(2)); 
	su=ln(su); 


@ Hamill's ensemble or combined forecaster @
w1=1/3;w2=1/3;
m=1;nn=1;p=w1|w2|(1-w1-w2);

{multi}=rmulti(m,p,nn);
if multi[1,1]==1; phamill=mew+0.5; pits1=cdfn((outturnp-phamill)./1); su=dgauss(outturnp,phamill,sqrt(1)); 
elseif multi[1,2]==1; phamill=mew-0.5; pits1=cdfn((outturnp-phamill)./1); su=dgauss(outturnp,phamill,sqrt(1)); 
elseif multi[1,3]==1; phamill=mew+0; pits1=cdfn((outturnp-phamill)./sqrt(1.69)); su=dgauss(outturnp,phamill,sqrt(1.69)); 
endif;

mmulti=mmulti|multi;
hamillp=hamillp|phamill;
sss_pits3=sss_pits3|pits1;
ssu=ssu|ln(su);


@ unfocused mixture. Consider 2 possibilities. First, is as in GBR. Second (denoted: b), explicitly computes and evaluates mixture normal density @
xxr=rndu(1,1);
tauv=(xxr-0.5).>0; tauvn=(xxr-0.5).<=0; tauvn=tauvn.*-1;
bi=tauv+tauvn;s_bi=s_bi|bi;

loss_forecaster=dgauss(outturnp,mew,1); 
logsl1=(loss_forecaster); 
loss_forecaster=dgauss(outturnp,mew+bi,1); 
logsl2=(loss_forecaster); 
logsl=0.5*logsl1+0.5*logsl2;
@ssu=ssu|ln(logsl);@

@ GBR @
biasguy=outturnp-mew-bi;
pitsbias=cdfn(biasguy./(sqrt(1))); 
pits1=cdfn((outturnp-mew)./1);
pitc=0.5*(pits1+pitsbias);
sss_pits4=sss_pits4|pitc;
pforecastbias=pforecastbias|(0.5*(mew+bi)+0.5*mew);

@ Second option : Generate a mixture normal density combination with 2 components. Comment in if you wish to use it. @
@	x1=(mew)~ones(1,1);
	{fx}=onepiecen(x1);
	density1=fx[.,2];

	x1=(mew+bi)~ones(1,1);
	{fx}=onepiecen(x1);
	density2=fx[.,2];

{zt}= combp3(density1[.,1],density2[.,1],density2[.,1],0.5,0.5,outturnp[1]);  @
zt=1;
sss_pits4b=sss_pits4b|zt;

i=i+1;endo;

@ Plot the pits densities @

{c,c1,f1}=histp(sss_pits,20);
{c,c2,f2}=histp(sss_pits2,20);
{c,c3,f3}=histp(sss_pits3,20);
{c,c4,f4}=histp(sss_pits4,20);
{c,c4b,f4b}=histp(sss_pits4b,20);


@ ******* @
  begwind;
@ ******* @
cformat= "1";
cname= "fig1.eps";
_protate=0;_pnum=1;_pbarwid=1.1;


_pframe=0;
_pdate=0;
_pcolor = 0;
_pmcolor = 0;
_pcsel = 0;
_plctrl=0;
_pnumht=0.17;
_paxht=0.23;


xtics(0,1,0.2,1);
@graphset;@

window(2,2,0); setwind(1);


xlabel("Probability Integral Transform (a)" );
ylabel("Relative Frequency");
 


histf(f1./(sumc(f1)/20),c1);
nextwind;
xlabel("Probability Integral Transform (b)" );
histf(f2./(sumc(f2)/20),c2);

nextwind;
xlabel("Probability Integral Transform (c)" );
histf(f4./(sumc(f4)/20),c4);
nextwind;
xlabel("Probability Integral Transform (d)" );
histf(f3./(sumc(f3)/20),c3);

endwind;

stop;

@ this computes the 2 variant unfocused forecaster pit densities @

window(2,1,0); setwind(1);


xlabel("Probability Integral Transform (d)" );
ylabel("Relative Frequency");
 


histf(f4./(sumc(f4)/20),c4);
nextwind;
xlabel("Probability Integral Transform (db)" );
histf(f4b./(sumc(f4b)/20),c4b);

endwind;


stop;

@---------------------- procedures ---------------------------------------------@

PROC (0) = scalar(arg);
  if (1-(ROWS(arg)==1)*(COLS(arg)==1));
     ERRORLOG("Argument(s) must be scalar!! ...Break!!");END;
  ENDIF;
ENDP;

PROC (0) = integer(arg);
  IF (1-(ROWS(arg)==1)*(COLS(arg)==1)*(TRUNC(arg)==arg));
     errorlog("Argument(s) must be integer!! ...Break !!");end;
  ENDIF;
ENDP;

PROC (0) = argtest(var,teststr);
  LOCAL i,n,j1,j2,a,b,temp,false;
    false=0;
    var=VEC(var);
    i=STRINDX(teststr,"*",1);
    n=STRLEN(teststr);
    j1=0;  a=MISS(0,0); j2=0; b=MISS(0,0);
    if i>1;
         j1 = STRINDX(STRSECT(teststr,1,i),"<",1);
          a = STOF(STRSECT(teststr,1,j1-1));
       temp = STRSECT(teststr,i,n-i+1);
       IF STRLEN(temp);
          j2 = MAXC(STRINDX(temp,"<",1)|STRINDX(temp,"=",1));
           b = STOF(STRSECT(temp,j2+1,n-i-j2+1));
       endif;
     else;
        j2 = MAXC(STRINDX(teststr,"<",1)|STRINDX(teststr,"=",1));
         b = STOF(STRSECT(teststr,j2+1,n-j2));
    endif;
    IF j1; false = false + SUMC((var.<a) + (2-(i-j1))*(var.==a)); ENDIF;
    IF j2; false = false + SUMC((var.>b) + (3-j2)*(var.==b)); ENDIF;
    IF false;
       ERRORLOG("Domain of argument(s) violated!! ...Break!!");END;
    ENDIF;
ENDP;

PROC istudent(p,v);
  scalar(v); argtest(v,"0<*"); argtest(p,"0<*<1");
 RETP(CDFTCI(1-p,v));
ENDP;



PROC igauss(p,a,b);
  scalar(a); scalar(b); argtest(b,"0<*");
  argtest(p,"0<*<1");
 RETP(cdfni(p)*b+a);
endp;


PROC dstudent(x,v);
 LOCAL b;
  scalar(v); argtest(v,"0<*");
  b = GAMMA((1+v)/2)/GAMMA(v/2);
 RETP(b*SQRT(1/(PI*v))*(1+x.*x/v)^(-(v+1)/2));
ENDP;

/********************************************************************/

PROC pstudent(x,v);
  scalar(v); argtest(v,"0<*");
 RETP(1-CDFTC(x,v));
ENDP;



/*
**  normal.src
**
**  Version 1.0  5/05/2000 (C) Copyright 2000 by Rainer Schlittgen
**  All rights Reserved.
**
**   Density, cumulative distribution function and random variates
**   of the NORMAL distribution
**
**  Format
**  -----------------------------------------------------------------
**  y=dgauss(x,a,b)                                          Line 35
**  z=pgauss(x,a,b)                                          Line 42
**  q=igauss(p,a,b)                                          Line 49
**  r=rgauss(r,c,a,b)                                        Line 57
**
**  Input
**  -----------------------------------------------------------------
**  x....(k,m)-matrix
**  a....scalar,
**  b....scalar, >0, standard deviation
**  p....(k,m)-matrix, 0<p<1
**  r....integer, number of rows
**  c....integer, number of cols
**
**  Output
**  -----------------------------------------------------------------
**  y...f(x), (k,m) matrix, density function
**  z...F(x), (k,m) matrix, cumulative distribution function
**  q...xp,   (k,m)-matrix, p-quantiles
**  r...x,    (r,c)-matrix, random numbers
**
*********************************************************************/

PROC dgauss(x,a,b);
 @ scalar(a); scalar(b); argtest(b,"0<*");@
 retp(pdfn((x-a)./b)./b);
ENDP;

/*********************************************************************/

PROC pgauss(x,a,b);
 @ scalar(a); scalar(b); argtest(b,"0<*");@
 RETP(cdfn((x-a)./b));
ENDP;

/********************************************************************/

PROC igauss(p,a,b);
  scalar(a); scalar(b); argtest(b,"0<*");
  argtest(p,"0<*<1");
 RETP(cdfni(p)*b+a);
ENDP;

/********************************************************************/

PROC rgauss(r,c,a,b);
@  scalar(a); scalar(b); integer(r); integer(c); argtest(b|r|c,"0<*");@
 RETP(rndn(r,c)*b+a);
ENDP;

proc rmulti(m,p,n);
 local s,k,y,w,i;
  p = VEC(p);
  k = ROWS(p);
  integer(m); integer(n); argtest(m|n,"0<*"); argtest(SUMC(p),"1<=*<=1");
  if k==1;
     w = ONES(m,1)*n;
    else;
     s = CUMSUMC(p);
     y = RNDU(1,m*n);
     y = RESHAPE(SUMC(y.>s),m,n);
     w={};
     i=0;
     do while i<m;
       i=i+1;
       w=w|COUNTS(y[i,.]',SEQA(0.5,1,k-1))';
     endo;
     w=w~(n-SUMC(w'));
  endif;
 retp(w);
endp;

proc score3(density1,density2,density3,w1,w2,outturnv);
local i,xx,x1,x2,comb,outturn,pit,z,x3;

z={};
xx=seqa(-35,0.01,6500); @ x-axis @
i=1; do until i>cols(density1);

x1=density1[.,i];
x2=density2[.,i];
x3=density3[.,i];

comb=mixtd3(x1,x2,x3,w1[i],w2[i]);
if comb==999;retp(999);endif;

outturn=outturnv[i];
@outturn;
xy(xx,comb);@

save xx comb outturn;
{pit}=num_score(xx,comb,outturn); @ numerical calculation of pit's @
save pit; 
z=z|pit;
i=i+1;endo;

retp(ln(z));endp;

proc num_score(xx,comb,outturn);
@ numerical calculation of pit's @

local v1,v2,v,zitt,nn,zit,oo;

v1=outturn-0.001;
v2=outturn+0.001;
v=v1|v2;v=outturn;

zitt=comb.*0.01;
@nn=indexcat(xx,v);@
nn=indexcat2(xx,v);
zit=sumc(zitt[1:nn]);
oo=comb[nn];
if oo==0; oo=meanc(comb[nn-25:nn+25]) ;endif;
retp(oo);
endp;


proc combp3(density1,density2,density3,w1,w2,outturnv);
local i,xx,x1,x2,comb,outturn,pit,z,x3;

z={};
xx=seqa(-35,0.01,6500); @ x-axis @
i=1; do until i>cols(density1);

x1=density1[.,i];
x2=density2[.,i];
x3=density3[.,i];

comb=mixtd3(x1,x2,x3,w1[i],w2[i]);
if comb==999;retp(999);endif;

outturn=outturnv[i];


{pit}=num_pit(xx,comb,outturn); @ numerical calculation of pit's @
z=z|pit;
i=i+1;endo;

retp(z);endp;

proc mixtd3(x1,x2,x3,w1,w2);
local w;
w=1-w1-w2;
if w<0; retp(999);endif;

retp(w1.*x1+w2.*x2);endp;

@ numerical calculation of PITS; James Mitchell @
proc num_pit(xx,comb,outturn);
@ numerical calculation of pit's @

local v1,v2,v,zitt,nn,zit;

v1=outturn-0.001;
v2=outturn+0.001;
v=v1|v2;v=outturn;

zitt=comb.*0.01;
@nn=indexcat(xx,v);@
nn=indexcat2(xx,v);
zit=sumc(zitt[1:nn]);
retp(zit);
endp;

proc indexcat2(xx,v);
local c,i;

c=0;
i=-35;do until i>v;
c=c+1;
i=i+0.01;endo;
retp(c);endp;

proc(1) = 	onepiecen(x);
local mean,mode,uncert,s,junk,gam_2,gam,var1,var2,var,sd,meani,A,denom1,denom2,fxx,xx,i,xxx,fx1,fx2,sd1,sd2,fxx1,fxx2,a1,a2,fx;

mean=x[.,1];sd=x[.,2];
fxx={};fx1={};fx2={};fxx1={};fxx2={};
xx=seqa(-35,0.01,6500);
i=1;do until i>6500;
xxx=xx[i];

fx=pdfn((xxx-mean)/sd)/sd; 

fxx=fxx|fx;
i=i+1;endo;

retp(xx~fxx);endp;