## Accompanying materials to the Online Appendix to
## "Private returns to R\&D in the presence of spillovers, revisited"
## Forthcoming, Journal of Applied Econometrics
## Giovanni Millo, September 14th 2018

wartest <- function(mod, order=1, vcov=vcovHC,
                    hyp=c("ols", "fe", "fd"), ...) {
    ## test serial correlation at 'order'
    t. <- pdim(mod)$nT$T
    delta.bar <- switch(match.arg(hyp),
                        ols=0,
                        fe=-1/(t.-1),
                        fd=-0.5)
    #res <- pres(mod) # fix for models without residual pseries
    res <- resid(mod)
    res.l <- lag(res, order)
    wardata <- data.frame(id=attr(mod$model, "index")[,1],
                          time=attr(mod$model, "index")[,2],
                          res=as.numeric(res),
                          res.l=as.numeric(res.l))
    mytest <- lht(plm(res~res.l, data=wardata, model="p"),
                  hyp=c(0,1), rhs=delta.bar, vcov=vcov)
    return(mytest)
}
