## Accompanying materials to the Online Appendix to
## "Private returns to R\&D in the presence of spillovers, revisited"
## Forthcoming, Journal of Applied Econometrics
## Giovanni Millo, September 14th 2018

pres.pgmm <- function(x, rm.zeros=TRUE) {
    ## transforms the extracts estimation "residuals" from a GMM panel
    ## into a pseries, for use with diagnostics.
    ## notice: the result will have different lengths depending
    ## on the 'transformation' argument.

    res <- residuals(x) # is a list
    ## extract values
    e <- unlist(res)
    ## make individual indices
    lgts <- lapply(res, function(x) rep(NA, length(x)))
    for(i in 1:length(lgts)) lgts[[i]] <- rep(i, length(lgts[[i]]))
    ind <- unlist(lgts)
    ## extract timestamps
    timestp <- lapply(res, names)
    tind <- unlist(timestp)
    ## make data.frame with residuals and indices
    resdata <- data.frame(ee=e, ind=ind, tind=tind)
    ## dispose with zeros if needed
    if(rm.zeros) resdata <- resdata[resdata$ee != 0, ]
    pee<-pdata.frame(resdata, index=c("ind","tind"))
    pres <- pee$ee
    return(pres)
}
