## Accompanying materials to the Online Appendix to
## "Private returns to R\&D in the presence of spillovers, revisited"
## Forthcoming, Journal of Applied Econometrics
## Giovanni Millo, September 14th 2018

describe <- plm:::describe

mtest3 <- function(x, order=1, ...) {
    UseMethod("mtest3")
}

mtest3.pgmm <- function (object, order = 1, vcov = NULL)
{
    myvcov <- vcov
    if (is.null(vcov))
        vv <- vcov(object)
    else if (is.function(vcov))
        vv <- myvcov(object)
    else vv <- myvcov
    model <- describe(object, "model")
    transformation <- describe(object, "transformation")
    Kt <- length(object$args$namest)
    if (transformation == "d") {
        resid <- object$residuals
        residl <- lapply(resid, function(x) c(rep(0, order),
            x[1:(length(x) - order)]))
    }
    else {
        resid <- lapply(object$residuals, function(x) c(x[-c(Kt:(2 *
            Kt + 1))], rep(0, Kt)))
        residl <- lapply(object$residuals, function(x) c(rep(0,
            order), x[1:(Kt - order - 1)], rep(0, Kt)))
    }
    X <- lapply(object$model, function(x) x[, -1, drop = FALSE])
    W <- object$W
    if (model == "onestep")
        A <- object$A1
    else A <- object$A2
    EVE <- Reduce("+", mapply(function(x, y) t(y) %*% x %*% t(x) %*%
        y, resid, residl, SIMPLIFY = FALSE))
    EX <- Reduce("+", mapply(crossprod, residl, X, SIMPLIFY = FALSE))
    XZ <- Reduce("+", mapply(crossprod, W, X, SIMPLIFY = FALSE))
    ZVE <- Reduce("+", mapply(function(x, y, z) t(x) %*% y %*%
        t(y) %*% z, W, resid, residl, SIMPLIFY = FALSE))
    denom <- EVE - 2 * EX %*% vcov(object) %*% t(XZ) %*% A %*%
        ZVE + EX %*% vv %*% t(EX)
# vcov(object) or rather vv?

    num <- Reduce("+", mapply(crossprod, resid, residl, SIMPLIFY = FALSE))

    stat <- num/sqrt(denom)
    names(stat) <- "normal"
    pval <- pnorm(abs(stat), lower.tail = FALSE) * 2
    mtest <- list(statistic = stat, p.value = pval, method = paste("Autocorrelation test of degree",
        order))
    class(mtest) <- "htest"
    mtest
}


## convenience function
pseries2list <- function(x) {
    ## extract indices from pseries
    ind <- attr(x, "index")[[1]]
    tind <- attr(x, "index")[[2]]
    N <- length(unique(ind))
    res <- vector("list", N)
    for(i in 1:length(ind)) {
        res[[i]] <- x[ind==ind[i]]
    }
    res
}


mtest3.plm <- function (object, order = 1, vcov = NULL)
{
    ## The Arellano-Bond m2 test is based on GMM, therefore it contains
    ## OLS and 2SLS as special cases. Hence the method for 'plm' objects,
    ## which is based on substituting:
    ## A=I
    ## Z=X for OLS, Z=W for 2SLS
    ## (see Roodman, https://ideas.repec.org/c/boc/bocode/s437501.html)

    myvcov <- vcov
    if (is.null(vcov)) {
        vv <- vcov(object)
    } else {
        if (is.function(vcov)) {
            vv <- myvcov(object)
        } else {
            vv <- myvcov
        }
    }
    model <- describe(object, "model")

    psres <- resid(object)
    ## use lagging facilities of plm
        res <- as.numeric(psres) #pseries2list(psres)
        resl <- as.numeric(lag(psres, order)) #pseries2list(lag(psres))

    ## extract (transformed) data from model
    demX <- model.matrix(object, model = model)
    demy <- pmodel.response(object, model = model)
    ## make lists
    ind <- attr(object$model, "index")[[1]]
    tind <- attr(object$model, "index")[[2]]
    uind <- unique(ind)
    utind <- unique(tind)
    N <- length(uind)
    X <- demX #vector("list", N)
    y <- demy #vector("list", N)
#    for(i in 1:length(ind)) {
#        X[[i]] <- demX[ind==ind[i], , drop=FALSE]
#        y[[i]] <- demy[ind==ind[i]]
#    }

    W <- X #object$W for 2SLS
    #A <- object$A1

    ## reduce to available rows (away with NAs, which can be produced
    ## only by lagging res)
    nona <- which(!is.na(resl))
    ind <- ind[nona]
    res <- res[nona]
    resl <- resl[nona]
    y <- y[nona]
    X <- X[nona, ]
    W <- W[nona, ]

    eve <- rep(NA, N)
    for(i in 1:length(uind)) {
        vi <- res[ind==uind[i]]
        vli <- resl[ind==uind[i]]
        eve[i] <- crossprod(crossprod(vi, vli))
    }
    primo <- sum(eve, na.rm=TRUE)

    EVE <- crossprod(resl, res) %*% crossprod(res, resl)
    EX <- crossprod(resl, X)
    XZ <- crossprod(W, X)
    ZVE <- crossprod(W, res) %*% crossprod(res, resl)

    zve <- matrix(NA, nrow=dim(W)[[2]], ncol=N)
    for(i in 1:length(uind)) {
        Zi <- W[ind==uind[i], , drop=FALSE]
        vi <- res[ind==uind[i]]
        vli <- resl[ind==uind[i]]
        zve[, i] <- crossprod(Zi, vli) %*% crossprod(vi, vli)
    }
    secondo <- apply(zve, 1, sum)

    A <- solve(crossprod(W)/N)

    vv2 <- solve(crossprod(X,W) %*% A %*% crossprod(W,X)) # or just solve(crossprod(X)) for OLS?
    #denom <- EVE - 2 * EX %*% vv2 %*% t(XZ) %*% ZVE + EX %*% vv %*% t(EX)
    denom <- primo - 2 * EX %*% vv2 %*% t(XZ) %*% A %*% secondo +
        EX %*% (N*vv) %*% t(EX)
    num <- crossprod(res, resl) #Reduce("+", mapply(crossprod, res, resl, SIMPLIFY = FALSE))

    xve <- matrix(NA, nrow=dim(X)[[2]], ncol=N)
    for(i in 1:length(uind)) {
        Xi <- X[ind==uind[i], , drop=FALSE]
        vi <- res[ind==uind[i]]
        vli <- resl[ind==uind[i]]
        xve[, i] <- crossprod(Xi, vli) %*% crossprod(vi, vli)
    }
    altsecondo <- apply(xve, 1, sum)

    ## OLS alternative: simplify to OLS matrices (same result)
    altden <- primo - 2*EX %*% solve(crossprod(X)) %*% altsecondo + EX %*% (N*vv) %*% t(EX)

    stat <- num/sqrt(altden)
    names(stat) <- "normal"
    pval <- pnorm(abs(stat), lower.tail = FALSE) * 2
    mtest <- list(statistic = stat, p.value = pval, method = paste("Autocorrelation test of degree",
        order))
    class(mtest) <- "htest"
    mtest
}
