
preshape <- function(x, na.rm=TRUE, ...) {
    ## reshapes pseries,
    ## e.g. of residuals from a panelmodel,
    ## in wide form
    inames <- names(attr(x, "index"))
    mres <- reshape(cbind(as.vector(x), attr(x, "index")),
                    direction="wide",
                    timevar=inames[2], idvar=inames[1])
    ## drop ind in first column
    mres <- mres[,-1]
    ## if requested, drop columns (time periods) with NAs
    if(na.rm) {
        rmc <- which(is.na(apply(mres, 2, sum)))
        if(sum(rmc)>0) mres <- mres[,-rmc]
    }
    return(mres)
}



ffilter <- function(x, m=3, pool=FALSE) {
    ## extracts first m principal components from a pseries
    ## and uses them to filter out factor dependence from the
    ## pseries itself (likely one of model residuals)
    ##
    ## returns a data.frame, which is the most flexible structure
    ## with indices and filtered series

    ## if m=0 returns original residuals (needed for diagnostic purposes
    ## of fxdtest)

    ## reshape residuals as wide matrix and transpose
    ## NB default preshape() eliminates unbalanced rows (=obs)
    um <- t(as.matrix(preshape(x)))

    if(m>0) {
        ## calculate princomps
        pcu <- predict(prcomp(um)) # unscaled

        if(pool) {
            ## regress u_it (stacked from um so no NAs left) on pcu(1..k)
            ## on a stack made replicating the PC n times; imposes the
            ## factor loadings to be equal across i
            ## NB this is undocumented, although it seems to work
            ## reasonably well, espec. with "moran"; might be useful
            ## when T is too short.

            u.it <- as.vector(um)
            pcu.it <- matrix(NA, ncol=m, nrow=length(u.it))
            for(j in 1:m) pcu.it[,j] <- rep(pcu[,j], dim(um)[[2]])

            ## regress u.it on first m princomps
            auxmod <- lm(u.it ~ pcu.it-1)

            ## extract "factor-filtered" residuals from auxmod and reorder
            e <- resid(auxmod)
        } else {
            ## original Holly et al. procedure:
            ## regress u_it on [PC1_t, ... PCn_t] for each i, then stack
            ## the 'filtered' residuals e_it

            ## regress multiple residuals (across i) on same regressors
            ## (first m components) and extract the matrix of 'filtered'
            ## residuals
            ## (notice the incredible elegance of R!)
            em <- resid(lm(um ~ pcu[, 1:m] -1))

            ## stack results
            e <- as.vector(em)
        }

    } else {
        ## return original residuals pruning out unbalanced data
        ## and in same format
        e <- as.vector(um)
    }

    en <- dim(um)[[2]]
    et <- dim(um)[[1]]
    edata <- cbind(rep(1:en, each=et), rep(1:et, en), e)
    edata <- data.frame(edata)

    return(edata)
}
