### R code from vignette source 'Millo_JAE2014_CompuApp.snw'

###################################################
### code chunk number 1: data
###################################################

## read data
## read from HPsort.fmt-->HPsort.xls-->HPsort.txt
hpy<-read.table(file="HPsort.txt", sep="\t", header=TRUE)

## read BEA codes and ordering of States as in Table 11
bea <- read.table(file="BEACODE.txt", sep="\t")
dimnames(bea)[[2]] <- c("code","name","acode","region")
## read regions' coding
regions <- read.table(file="regions.txt", sep="\t", header=TRUE)



###################################################
### code chunk number 2: pdata
###################################################

## make pdata.frame
library(plm)
phpy<-pdata.frame(hpy, index=c("ST","YEAR"))

## do some data transformations to keep formulas clear, using the panel
## data infrastructure
phpy$p <- log(phpy$P)
phpy$y <- log(phpy$Y)
phpy$g <- as.numeric(diff(log(phpy$POP))) # alt.: log(phpy$POP/lag(phpy$POP))
## NB plm would keep the "integer" nature of POP forcing it upon g

## real cost of borrowing:
phpy$r <- phpy$RRB/100
phpy$c <- phpy$r-diff(phpy$p)



###################################################
### code chunk number 3: wmats
###################################################
## make USA contiguity matrix including DC:

## usaww is 48x48, excludes DC
library(splm)
data(usaww)

## make binary
usw<-matrix(as.numeric(as.logical(usaww)), ncol=ncol(usaww))

## add row and column in 8th position
usw<-cbind(usw[,1:7], rep(0,48), usw[,8:48])
usw<-rbind(usw[1:7,], rep(0,49), usw[8:48,])

## set names
nams<-c(row.names(usaww)[1:7], "DISTRICT_OF_COLUMBIA", row.names(usaww)[8:48])
dimnames(usw)<-list(nams, nams)

## Set neighbours of DC: Maryland is 19, Virginia is 45
usw[8, c(19,45)]<-usw[c(19,45), 8]<-1

## row-std.
USW <- usw/apply(usw, 1, sum)



###################################################
### code chunk number 4: cortables
###################################################

## make index for macroregs East, Middle, West
regions$mr <- c(1,1,2,2,1,3,3,3)
mrind <- regions$mr[phpy$REG] # has dimension as in hpy

regnames.short <- c("NE","ME","SE","GL","Pl","SW","RM","FW")

source("cortab.R")

## make Table 3.i
tab3i <- round(cortab(diff(log(phpy$Y)), grouping=mrind), 2)
dimnames(tab3i) <- list(c("East", "Middle", "West"),
                        c("East", "Middle", "West"))

## make Table 3.ii
tab3ii <- round(cortab(diff(log(phpy$Y)), grouping=phpy$REG), 2)

## reorder as in HPY
regord <- c(1,2,5,3,4,6,7,8)
regnames <- regions[regord, "region"]
tab3ii <- tab3ii[regord, regord]
tab3ii[4:5, 3] <- tab3ii[3, 4:5]
tab3ii[3, 4:5] <- NA
dimnames(tab3ii) <- list(regnames, regnames.short)

## make Table 4.i
tab4i <- round(cortab(diff(log(phpy$P)), grouping=mrind), 2)
dimnames(tab4i) <- dimnames(tab3i)

## make Table 4.ii
tab4ii <- round(cortab(diff(log(phpy$P)), grouping=phpy$REG), 2)

## reorder as in HPY
tab4ii <- tab4ii[regord, regord]
tab4ii[4:5, 3] <- tab4ii[3, 4:5]
tab4ii[3, 4:5] <- NA
dimnames(tab4ii) <- list(regnames, regnames.short)



###################################################
### code chunk number 5: tabs3and4
###################################################
library(xtable)
## print Table 3i
xtable(tab3i, caption="Average of correlation coefficients within and
 between regions, first difference of log real per capita disposable
 income; three geographical regions (Table 3i in HPY).")
## print Table 3ii
xtable(tab3ii, caption="Average of correlation coefficients within and
 between regions, first difference of log real per capita disposable
 income; eight BEA regions (Table 3ii in HPY).")
## print Table 4i
xtable(tab4i, caption="Average of correlation coefficients within and
 between regions, first difference of log real house prices; three
 geographical regions (Table 4i in HPY).")
## print Table 4ii
xtable(tab4ii, caption="Average of correlation coefficients within and
 between regions, first difference of log real house prices; eight BEA
 regions (Table 4ii in HPY).")


###################################################
### code chunk number 6: residcrosscor
###################################################

## Table 5:
## Residual cross correlation of ADF(p) regressions

tab5a <- matrix(NA, ncol=4, nrow=4)
tab5b <- matrix(NA, ncol=4, nrow=4)

## y:
for(i in 1:4) {
    mymod <- pmg(diff(y)~lag(y)+
                 lag(diff(y),1:i),
                 data=phpy, model="mg", trend=TRUE)
    tab5a[1, i] <- pcdtest(mymod, test="rho")$statistic
    tab5b[1, i] <- pcdtest(mymod, test="cd")$statistic
}

## p:
for(i in 1:4) {
    mymod <- pmg(diff(p)~lag(p)+
                 lag(diff(p),1:i),
                 data=phpy, model="mg", trend=TRUE)
    tab5a[2, i] <- pcdtest(mymod, test="rho")$statistic
    tab5b[2, i] <- pcdtest(mymod, test="cd")$statistic
}

## g:
for(i in 1:4) {
    mymod <- pmg(diff(g)~lag(g)+
                 lag(diff(g),1:i),
                 data=phpy, model="mg", trend=FALSE)
    tab5a[3, i] <- pcdtest(mymod, test="rho")$statistic
    tab5b[3, i] <- pcdtest(mymod, test="cd")$statistic
}

## c:
for(i in 1:4) {
    mymod <- pmg(diff(c)~lag(c)+
                 lag(diff(c),1:i),
                 data=phpy, model="mg", trend=FALSE)
    tab5a[4, i] <- pcdtest(mymod, test="rho")$statistic
    tab5b[4, i] <- pcdtest(mymod, test="cd")$statistic
}

tab5a <- round(tab5a, 3)
tab5b <- round(tab5b, 2)
dimnames(tab5a) <- dimnames(tab5b) <- list(c("y", "p", "g", "c"),
                                        paste("ADF(", 1:4, ")", sep=""))



###################################################
### code chunk number 7: tab5
###################################################
## print Table 5, first panel
xtable(tab5a, digits=3, caption="Residual cross-correlation of ADF(p)
 regressions: average correlation coefficients (first panel of Table 5
 in HPY).")
## print Table 5, sec. p.
xtable(tab5b, caption="Residual cross-correlation of ADF(p) regressions:
 CD test statistics (second panel of Table 5 in HPY).")


###################################################
### code chunk number 8: cips
###################################################

## Table 6:

tab6i <- matrix(NA, nrow=6, ncol=4)
dimnames(tab6i) <- list(c("diff(y)", "diff(p)", "y", "p", "g", "c"),
                       paste("CADF(", 1:4, ")", sep=""))
for(i in 1:4) {
    tab6i[1, i] <- cipstest(diff(phpy$y), lag=i, type="drift")$statistic
    tab6i[2, i] <- cipstest(diff(phpy$p), lag=i, type="drift")$statistic
    tab6i[3, i] <- cipstest(phpy$y, lag=i, type="drift")$statistic
    tab6i[4, i] <- cipstest(phpy$p, lag=i, type="drift")$statistic
    tab6i[5, i] <- cipstest(phpy$g, lag=i, type="drift")$statistic
    tab6i[6, i] <- cipstest(phpy$c, lag=i, type="drift")$statistic
}

tab6ii <- matrix(NA, nrow=2, ncol=4)
dimnames(tab6ii) <- list(c("y", "p"), paste("CADF(", 1:4, ")", sep=""))
for(i in 1:4) {
    tab6ii[1, i] <- cipstest(phpy$y, lag=i, type="trend")$statistic
    tab6ii[2, i] <- cipstest(phpy$p, lag=i, type="trend")$statistic
}
## no exact correspondence. Qualitatively ok.


###################################################
### code chunk number 9: tab6
###################################################
## print Table 6i
xtable(tab6i, caption="Pesaran's CIPS panel unit root test results: with
 an intercept (first panel of Table 6 in HPY). 5 percent and 10 percent
 critical values for rejection of the unit root hypothesis are,
respectively, -2.11 and -2.03. ", label="tab:six1")
## print Table 6ii
xtable(tab6ii, caption="Pesaran's CIPS panel unit root test results: with
 an intercept and a linear trend (second panel of Table 6 in HPY). 5 percent
 and 10 percent critical values for rejection of the unit root hypothesis
 are, respectively,  -2.62 and -2.54.", label="tab:six2")


###################################################
### code chunk number 10: lrmodtab7
###################################################

## Table 7:

tab7 <- matrix(NA, nrow=6, ncol=3)
dimnames(tab7) <- list(c("(Intercept)", "", "y", " ",
                         "avg. rho", "CD test"),
                        c("MG", "CCEMG", "CCEP"))

## populate Table 7
fm <- p ~ y
    ## estimate models
    mgmod<-pmg(fm, data=phpy, model="mg")
    ccemod<-pmg(fm, data=phpy, model="cmg") # use pmg because of intercept
    ccepmod<-pcce(fm, data=phpy, model="p")

## notice that in this (very unfortunate) instance, y.bar (conventional
## for "XS average of response" is named exactly as y.bar, XS average of
## regressor 'y'

## retrieve coefs
tab7[names(coef(mgmod)), 1] <- round(coef(mgmod), 2)
tab7[names(coef(ccemod)[1:2]), 2] <- round(coef(ccemod)[1:2], 2)
tab7[names(coef(ccepmod)), 3] <- round(coef(ccepmod), 2)
## retrieve SEs
tab7[which(dimnames(tab7)[[1]] %in% names(coef(mgmod)))+1, 1] <-
    round(summary(mgmod)$CoefTable[1:2, 2], 2)
tab7[which(dimnames(tab7)[[1]] %in% names(coef(ccemod)[1:2]))+1, 2] <-
    round(summary(ccemod)$CoefTable[1:2, 2], 2)
tab7[which(dimnames(tab7)[[1]] %in% names(coef(ccepmod)))+1, 3] <-
    round(summary(ccepmod)$CoefTable[, 2], 2)
## average rho
tab7["avg. rho", 1] <- round(pcdtest(mgmod, test="rho")$statistic, 2)
tab7["avg. rho", 2] <- round(pcdtest(ccemod, test="rho")$statistic, 2)
tab7["avg. rho", 3] <- round(pcdtest(ccepmod, test="rho")$statistic, 2)
## CD tests
tab7["CD test", 1] <- round(pcdtest(mgmod, test="cd")$statistic, 2)
tab7["CD test", 2] <- round(pcdtest(ccemod, test="cd")$statistic, 2)
tab7["CD test", 3] <- round(pcdtest(ccepmod, test="cd")$statistic, 2)


###################################################
### code chunk number 11: tab7
###################################################
## print Table 6i
xtable(tab7, caption="Estimation result: income elasticity of real house
 price (Table 7 in HPY).")


###################################################
### code chunk number 12: cortableres
###################################################
## make Table 8: average pairwise corr. coefficients of residuals
tab8 <- round(cortab(Within(log(phpy$Y)-log(phpy$P)),
                     grouping=phpy$REG), 2)

## reorder as in HPY
tab8 <- tab8[regord, regord]
tab8[4:5, 3] <- tab8[3, 4:5]
tab8[3, 4:5] <- NA
dimnames(tab8) <- list(regnames, regnames.short)

## Notice: a similar test on "true" residuals would be equally
## easy, provided a correctly dimensioned and sorted index is supplied
## (hint: use pmerge())


###################################################
### code chunk number 13: tab8
###################################################
## print Table 8
xtable(tab8, caption="Average residual cross correlation coefficients
 within and between eight BEA geographical regions:
 u.it=p.it-y.it-alpha.i (Table 8 in HPY).")


###################################################
### code chunk number 14: panelcoint
###################################################
## panel cointegration test:
## test stationarity of p-y, subtracting individual means:

cointest <- matrix(NA, nrow=1, ncol=4)
dimnames(cointest) <- list("p.it-y.it-alpha.i",
                           paste("CIPS(", 1:4, ")", sep=""))

for(i in 1:4) {
    cointest[1,i] <- cipstest(Within(log(phpy$P)-log(phpy$Y)),
                              lag=i, type="drift")$statistic
}
## no exact correspondence, again; but qualitatively ok.
## Residuals are stationary at every augm. order and sign. level.


###################################################
### code chunk number 15: cointests
###################################################
## print table of cointegration tests
xtable(cointest, caption="Panel cointegration tests as in HPY, 5.3.
 1 percent and 5 percent critical values for rejection of the unit root
 hypothesis are, respectively, -2.23 and -2.11.")


###################################################
### code chunk number 16: ecmtab9
###################################################

## Table 9: panel error correction estimation

tab9 <- matrix(NA, nrow=10, ncol=3)
dimnames(tab9) <- list(c("lag(p - y)", "", "diff(lag(p))", " ",
                          "diff(y)", "  ", "half-life", "R2",
                          "avg. rho", "CD test"),
                        c("MG", "CCEMG", "CCEP"))

## populate Table 9
efm <- diff(p) ~ lag(p - y) + diff(lag(p)) + diff(y)

    ## estimate models
    emgmod<-pmg(efm, data=phpy, model="mg")
    eccemod<-pcce(efm, data=phpy, model="mg")
    eccepmod<-pcce(efm, data=phpy, model="p")

    ## retrieve coefs
    tab9[names(coef(emgmod))[-1], 1] <- round(coef(emgmod)[-1], 3)
    tab9[names(coef(eccemod)), 2] <- round(coef(eccemod), 3)
    tab9[names(coef(eccepmod)), 3] <- round(coef(eccepmod), 3)
    ## retrieve SEs
    tab9[which(dimnames(tab9)[[1]] %in% names(coef(emgmod))[-1])+1, 1] <-
        round(summary(emgmod)$CoefTable[-1, 2], 3)
    tab9[which(dimnames(tab9)[[1]] %in% names(coef(eccemod)))+1, 2] <-
        round(summary(eccemod)$CoefTable[, 2], 3)
    tab9[which(dimnames(tab9)[[1]] %in% names(coef(eccepmod)))+1, 3] <-
        round(summary(eccepmod)$CoefTable[, 2], 3)
    ## Half-life
    tab9["half-life", ] <- round(log(0.5)/log(1+tab9[1, ]), 3)
    ## R2
    tab9["R2", 1] <- round(emgmod$r.squared, 2)
    tab9["R2", 2] <- round(eccemod$r.squared, 2)
    tab9["R2", 3] <- round(eccepmod$r.squared, 2)
    ## average rho
    tab9["avg. rho", 1] <- round(pcdtest(emgmod, test="rho")$statistic, 3)
    tab9["avg. rho", 2] <-
        round(pcdtest(eccemod, test="rho")$statistic, 3)
    tab9["avg. rho", 3] <-
        round(pcdtest(eccepmod, test="rho")$statistic, 3)
    ## CD tests
    tab9["CD test", 1] <- round(pcdtest(emgmod, test="cd")$statistic, 2)
    tab9["CD test", 2] <-
        round(pcdtest(eccemod, test="cd")$statistic, 2)
    tab9["CD test", 3] <-
        round(pcdtest(eccepmod, test="cd")$statistic, 2)



###################################################
### code chunk number 17: tab9
###################################################
## print Table 9
xtable(tab9, digits=3, caption="Panel error correction estimates without
 net cost of borrowing and population growth (Table 9 in HPY).")


###################################################
### code chunk number 18: ecmtab10
###################################################

## Table 10: panel ECM with additional variables

## full model:
fma <- diff(p) ~ lag(p - y) + diff(lag(p)) + diff(y) + lag(c) + lag(g)

## restricted models:
fma1 <- update(fma, .~.-lag(g))
fma2 <- update(fma, .~.-diff(lag(p)))
fma3 <- update(fma, .~.-diff(lag(p))-lag(g))

fms <- c(fma, fma1, fma2, fma3)

tab10 <- matrix(NA, nrow=14, ncol=3*4)
dimnames(tab10) <- list(c("lag(p - y)", "", "diff(lag(p))", " ", "diff(y)",
                          "  ", "lag(c)", "   ", "lag(g)", "    ",
                          "half-life", "R2", "avg. rho", "CD test"),
                        c(paste("MG", 1:4, sep=""),
                          paste("CCEMG", 1:4, sep=""),
                          paste("CCEP", 1:4, sep="")))

## populate Table 10 by loop on formulae
for(i in 1:4) {
    ## estimate models
    mgamod<-pmg(fms[[i]], data=phpy, model="mg")
    cceamod<-pcce(fms[[i]], data=phpy, model="mg")
    ccepamod<-pcce(fms[[i]], data=phpy, model="p")
    ## retrieve coefs
    tab10[names(coef(mgamod))[-1], i] <- round(coef(mgamod)[-1], 3)
    tab10[names(coef(cceamod)), i + 4] <- round(coef(cceamod), 3)
    tab10[names(coef(ccepamod)), i + 8] <- round(coef(ccepamod), 3)
    ## retrieve SEs
    tab10[which(dimnames(tab10)[[1]] %in% names(coef(mgamod))[-1])+1, i] <-
        round(summary(mgamod)$CoefTable[-1, 2], 3)
    tab10[which(dimnames(tab10)[[1]] %in% names(coef(cceamod)))+1, i+4] <-
        round(summary(cceamod)$CoefTable[, 2], 3)
    tab10[which(dimnames(tab10)[[1]] %in% names(coef(ccepamod)))+1, i+8] <-
        round(summary(ccepamod)$CoefTable[, 2], 3)
    ## Half-life
    tab10["half-life", ] <- round(log(0.5)/log(1+tab10[1, ]), 3)
    ## R2
    tab10["R2", i] <- round(mgamod$r.squared, 3)
    tab10["R2", i+4] <- round(cceamod$r.squared, 3)
    tab10["R2", i+8] <- round(ccepamod$r.squared, 3)
    ## average rho
    tab10["avg. rho", i] <- round(pcdtest(mgamod, test="rho")$statistic, 3)
    tab10["avg. rho", i+4] <-
        round(pcdtest(cceamod, test="rho")$statistic, 3)
    tab10["avg. rho", i+8] <-
        round(pcdtest(ccepamod, test="rho")$statistic, 3)
    ## CD tests
    tab10["CD test", i] <- round(pcdtest(mgamod, test="cd")$statistic, 2)
    tab10["CD test", i+4] <-
        round(pcdtest(cceamod, test="cd")$statistic, 2)
    tab10["CD test", i+8] <-
        round(pcdtest(ccepamod, test="cd")$statistic, 2)
}


###################################################
### code chunk number 19: tab10
###################################################
## print Table 10

## in two pieces:
tab10a <- tab10[, 1:8]
dimnames(tab10a)[[2]][5:8] <- paste("CMG", 1:4, sep="")
tab10b <- tab10[, 9:12]

xtable(tab10a, digits=3, caption="Panel error correction estimates with
 net cost of borrowing and population growth (Table 10 in HPY): MG and
 CCEMG results.")

xtable(tab10b, digits=3, caption="Panel error correction estimates with
 net cost of borrowing and population growth (Table 10 in HPY): CCEP
 results.")


###################################################
### code chunk number 20: spatial
###################################################

source("ffilter.R")

## check SAR on long-run "residuals"
## by lagsarlm:

## calc 'residuals' as p.it-y.it-alpha.i
uhat<-Within(log(phpy$P)-log(phpy$Y))
## filter through first m principal components
ffuhat1<-ffilter(uhat, m=1)
ffuhat2<-ffilter(uhat, m=2)
ffuhat3<-ffilter(uhat, m=3)

## compare two different estimation methods
defacSAR <- matrix(NA, nrow=4, ncol=3)
dimnames(defacSAR) <- list(c("psi, SAR by lagsarlm()", "analytical SE",
                             "psi, SAR by spreml()", "numerical SE"),
                           paste("m=", 1:3, sep=""))

## make listw of USW
lUSW <- mat2listw(kronecker(USW,diag(1,length(unique(ffuhat1[,2])))))

## est. SAR model with (pooled) lagsarlm()
fuhat1sar<-lagsarlm(e~1, data=ffuhat1, listw=lUSW)
fuhat2sar<-lagsarlm(e~1, data=ffuhat2, listw=lUSW)
fuhat3sar<-lagsarlm(e~1, data=ffuhat3, listw=lUSW)

defacSAR[1, 1] <- fuhat1sar$rho
defacSAR[2, 1] <- fuhat1sar$rho.se
defacSAR[1, 2] <- fuhat2sar$rho
defacSAR[2, 2] <- fuhat2sar$rho.se
defacSAR[1, 3] <- fuhat3sar$rho
defacSAR[2, 3] <- fuhat3sar$rho.se

## ferpect!

## by sp(re)ml:
sar.fuh1 <- spreml(e~1, data=ffuhat1, w=USW, errors="ols", lag=T)
sar.fuh2 <- spreml(e~1, data=ffuhat2, w=USW, errors="ols", lag=T)
sar.fuh3 <- spreml(e~1, data=ffuhat3, w=USW, errors="ols", lag=T)

defacSAR[3, 1] <- sar.fuh1$arcoef
defacSAR[4, 1] <- sqrt(sar.fuh1$vcov.arcoef)
defacSAR[3, 2] <- sar.fuh2$arcoef
defacSAR[4, 2] <- sqrt(sar.fuh2$vcov.arcoef)
defacSAR[3, 3] <- sar.fuh3$arcoef
defacSAR[4, 3] <- sqrt(sar.fuh3$vcov.arcoef)

defacSAR <- round(defacSAR, 3)
## ferpect too.

## standardized defactored residuals:
## calc. SEs by State along first index
## m=1
e1 <- ffuhat1$e
s1.i <- tapply(ffuhat1$e, ffuhat1[, 1],
               FUN=function(x) sqrt(sum(x^2)/length(x)))
## standardize residuals
ffuhat1$estar <- e1/rep(s1.i, times=tapply(e1,
                              ffuhat1[, 1], FUN=length))
## m=2
e2 <- ffuhat2$e
s2.i <- tapply(ffuhat2$e, ffuhat2[, 1],
               FUN=function(x) sqrt(sum(x^2)/length(x)))
## standardize residuals
ffuhat2$estar <- e2/rep(s2.i, times=tapply(e2,
                              ffuhat2[, 1], FUN=length))
## m=3
e3 <- ffuhat3$e
s3.i <- tapply(ffuhat3$e, ffuhat3[, 1],
              FUN=function(x) sqrt(sum(x^2)/length(x)))
## standardize residuals
ffuhat3$estar <- e3/rep(s3.i, times=tapply(e3,
                              ffuhat3[, 1], FUN=length))

stdSAR <- matrix(NA, nrow=4, ncol=3)
dimnames(stdSAR) <- list(c("psi, SAR by lagsarlm()", "analytical SE",
                           "psi, SAR by spreml()", "numerical SE"),
                         paste("m=", 1:3, sep=""))

## est. SAR model with (pooled) lagsarlm()
sfuhat1sar<-lagsarlm(estar~1, data=ffuhat1, listw=lUSW)
sfuhat2sar<-lagsarlm(estar~1, data=ffuhat2, listw=lUSW)
sfuhat3sar<-lagsarlm(estar~1, data=ffuhat3, listw=lUSW)

stdSAR[1, 1] <- sfuhat1sar$rho
stdSAR[2, 1] <- sfuhat1sar$rho.se
stdSAR[1, 2] <- sfuhat2sar$rho
stdSAR[2, 2] <- sfuhat2sar$rho.se
stdSAR[1, 3] <- sfuhat3sar$rho
stdSAR[2, 3] <- sfuhat3sar$rho.se

## idem with spreml()
ssar.fuh1 <- spreml(estar~1, data=ffuhat1, w=USW, errors="ols", lag=T)
ssar.fuh2 <- spreml(estar~1, data=ffuhat2, w=USW, errors="ols", lag=T)
ssar.fuh3 <- spreml(estar~1, data=ffuhat3, w=USW, errors="ols", lag=T)

stdSAR[3, 1] <- ssar.fuh1$arcoef
stdSAR[4, 1] <- sqrt(ssar.fuh1$vcov.arcoef)
stdSAR[3, 2] <- ssar.fuh2$arcoef
stdSAR[4, 2] <- sqrt(ssar.fuh2$vcov.arcoef)
stdSAR[3, 3] <- ssar.fuh3$arcoef
stdSAR[4, 3] <- sqrt(ssar.fuh3$vcov.arcoef)

stdSAR <- round(stdSAR, 3)

## (alt.: check SAR on CCEP residuals from long-run model)
## standard
#uu<-pres(pcce(log(P)~log(Y), data=phpy, model="m", residuals="standard"))
#duu<-data.frame(ind=attr(uu, "index")$ind, tind=attr(uu, "index")$tind,
#                uu=as.numeric(uu))
#fuusar<-lagsarlm(uu~1, data=duu, listw=lUSW)
## defactored
#eu<-pres(pcce(log(P)~log(Y), data=phpy, model="m"))
#deu<-data.frame(ind=attr(eu, "index")$ind, tind=attr(eu, "index")$tind,
#                eu=as.numeric(eu))
#feusar<-lagsarlm(eu~1, data=deu, listw=lUSW)


###################################################
### code chunk number 21: sarmods
###################################################
## print results of SAR estimation
xtable(defacSAR, digits=3, caption="Estimates of spatial autocorrelation
 in defactored residuals as in HPY, 5.5 (p.169).")
## print results of SAR estimation
xtable(stdSAR, digits=3, caption="Estimates of spatial autocorrelation in
 standardized defactored residuals as in HPY, 5.5 (p.170).")


###################################################
### code chunk number 22: factorloadings
###################################################
## Table 11: Estimation of factor loadings:
## regress separately each (p-y)_it on XS avg. bar(p-y)_t
flfm <- I(log(P)-log(Y)) ~ Between(log(P)-log(Y), effect="time")
flmgmod <- pvcm(flfm, data=phpy, model="within")
## retrieve individual coefs and SEs
indcoefs <- flmgmod$coef
indses <- flmgmod$std.error

tab11 <- round(cbind(indcoefs[,2], indses[,2]), 2)
dimnames(tab11) <- list(dimnames(indcoefs)[[1]],
                        c("(pbar_t - ybar_t)", "se"))

## reorder as in HPY Tables 2 and 11 (see bea.txt for
## correspondence table)
tabstatecode <- bea$code[c(1:12, 25:36, 13:24, 37:49)]
tabstatename <- bea$name[c(1:12, 25:36, 13:24, 37:49)]

tab11 <- tab11[as.character(tabstatecode), ]
dimnames(tab11)[[1]] <- tabstatename


###################################################
### code chunk number 23: tab11
###################################################
## print Table 11
xtable(tab11, caption="Factor loading estimates (Table 11 in HPY).")


