clear all
set more off
cd "C:\Users\03638881\Dropbox\spacing\mc\JAE Revision 2"

qui {

********************************************
**X's correlated with alpha
**X's serially correlated - vary rho
**alpha in model

**M = 0,...,6
**T = 0,...,17
********************************************

********************************************
**Define parameters to be passed into dpdSim
********************************************
**Parameters
loc gam 		= $Gamma
loc beta		= $Beta

**Higher values increase the signal in Y due to X,L.Y relative to unobserved components
loc sig_s2 		= $SigmaS2

**Normalization in Everaert
loc sig_eps2	= 1.0

**Following Everaert
loc theta 		= $Theta  //Note: theta is Everaert's gamma  

**Simplification relative to Everaert (eta is time invariant heterogeneity generating serial correlation in X, but does not impact Y except through X)
g eta_i			= 0

**Vary serial correlation in X
loc rho 		= $Rho

**Higher values increase relative importance of time invariant errors (vs. time-varying errors in X, Y)
loc mu_alpha 	= $MuAlpha
loc mu_omega 	= 1.0  //Note: irrelevant since we eliminate eta

**For stationarity of initial conditions
loc pi_0 		= $Pi0
loc pi_1 		= $Pi1
loc pi_2 		= $Pi2

loc nobs = $nobs
loc T0 	 = $init
loc T 	 = 17
loc time = `T0' + `T' + 1
loc reps = $reps

program define dpdSim, rclass

	syntax [, rho(real 0) sig_s2(real 2) sig_eps2(real 1) mu_alpha(real 1) mu_omega(real 1) theta(real 1) pi_0(real 0) pi_1(real 1) pi_2(real 1) gam(real 0.5) beta(real 0.5) nobs(integer 10) time(integer 10) t0(int 0)]
	loc nt = `nobs'*`time'
	set obs `nt'
	
	egen int ivar = seq(), from(1) to(`nobs') block(`time')
	sort ivar
	
	by ivar: g int tvar = _n - `t0' - 1
	xtset ivar tvar
	
	*******************************
	**DGP following Everaert 2012**
	*******************************
	ret sca case = $case
	ret sca beta = `beta'
	ret sca gamma = `gam'
	loc lrcoef = `beta'/(1-`gam')
	ret sca lrcoef = `lrcoef'
	loc betasq = `beta'*`beta'
	loc gamsq = `gam'*`gam'
	loc rhosq = `rho'*`rho'
	loc thetasq = `theta'*`theta'
	
	loc A = `sig_s2' - (`gamsq'*`sig_eps2')/(1-`gamsq')
	loc B = ((1-`gam'*`rho')*(1-`gamsq')*(1-`rhosq'))/(`betasq'*(1+`gam'*`rho'))  
	loc sig_Xi2 = `A'*`B' //Note: See eq 6.6 in Everaert
	
	loc sig_alpha2 = `mu_alpha'*`sig_eps2'*(1-`gam')^2
	
	bys ivar: g alpha_iTmp = rnormal(0,sqrt(`sig_alpha2')) if tvar == -`t0'
	bys ivar: g alpha_i = alpha_iTmp[1]
	drop alpha_iTmp

	bys ivar: g omega_iTmp = `theta'*alpha_i if tvar == -`t0'
	bys ivar: g omega_i = omega_iTmp[1]
	drop omega_iTmp
	
	loc sig_zi02 = `pi_2'*((`sig_eps2'/(1-`gamsq')) + (`betasq'*`sig_Xi2'*(1+`gam'*`rho'))/((1-`gam'*`rho')*(1-`gamsq')*(1-`rhosq')))
 
	********************
	**Generate x and y**
	********************
	bys ivar: g x = (omega_i/(1-`rho')) + rnormal(0,sqrt(`sig_Xi2'))*sqrt(1/(1-`rhosq')) if tvar == -`t0'
	bys ivar: replace x = omega_i + `rho'*L.x + rnormal(0,sqrt(`sig_Xi2')) if tvar > -`t0'
	
	bys ivar: g y = `pi_0' + (`pi_1'*(alpha_i + (`beta'*omega_i*(1-`rho')^(-1)))/(1-`gam')) + rnormal(0,sqrt(`sig_zi02')) if tvar == -`t0'
	bys ivar: replace y = `gam'*L.y + `beta'*x + alpha_i + rnormal(0,sqrt(`sig_eps2')) if t > -`t0'
	
	drop if tvar<0
	sort ivar tvar
	
	*******************************************
	**Create Observed Structure/Skip Patterns**
	*******************************************
	
	sort ivar tvar
	xtset ivar tvar
		corr x L.x
		ret sca x_lx_rho = r(rho)
		loc rhox = r(rho)
		corr x alpha_i
		ret sca x_a_rho = r(rho)
		
	keep if tvar == 0 | tvar == 1 | tvar == 2 | tvar == 3 | tvar == 7 | tvar == 11 | tvar == 17
		
	bys ivar: g int m = _n - 1
	xtset ivar m
	
	bys ivar: g gap	= D.tvar
	bys ivar: g lgap  = L.gap
	bys ivar: g ly	= L.y
	bys ivar: g l2y	= L2.y
	bys ivar: g l3y	= L3.y
	bys ivar: g l4y	= L4.y
	bys ivar: g dy	= D.y
	bys ivar: g ldy	= L.dy
	bys ivar: g lx	= L.x
	bys ivar: g l2x	= L2.x
	bys ivar: g dx	= D.x
	bys ivar: g ldx	= L.dx
	forval i=0/5 {
		loc ii = 6 - `i'
		bys ivar: g x`i' = L`ii'.x if m==6
	}
	g x6 = x if m==6
	forval i=0/6 {
		bys ivar: egen w = mean(x`i')
		replace x`i' = w
		drop w
	}

	*******************************************
	**Estimators with Unequal Spacing in Data**
	*******************************************
	*AH (1981)  
		ivreg2 dy (ldy = l2y) dx, robust 
		ret sca ah_g = _b[ldy]
		ret sca ah_b = _b[dx]
		ret sca ah_g_se = _se[ldy]
		ret sca ah_b_se = _se[dx]
		loc lb = _b[ldy]-1.9599639*_se[ldy]
		loc ub = _b[ldy]+1.9599639*_se[ldy]
		if (`gam'>=`lb' & `gam'<=`ub') {
			ret sca ah_g_cover = 1
		}
		else {
			ret sca ah_g_cover = 0
		}
		loc lb = _b[dx]-1.9599639*_se[dx]
		loc ub = _b[dx]+1.9599639*_se[dx]
		if (`beta'>=`lb' & `beta'<=`ub') {
			ret sca ah_b_cover = 1
		}
		else {
			ret sca ah_b_cover = 0
		}
		nlcom _b[dx]/(1-_b[ldy])
		mat A1=r(b)
		mat A2=r(V)
		ret sca ah_lr = A1[1,1]
		ret sca ah_lr_se = sqrt(A2[1,1])
		loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
		loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
		if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
			ret sca ah_lr_cover = 1
		}
		else {
			ret sca ah_lr_cover = 0
		}
		mat drop A1 A2
	*AB (1991)
		xtabond y x, vce(robust)
		ret sca ab_g = _b[L.y]
		ret sca ab_b = _b[x]
		ret sca ab_g_se = _se[L.y]
		ret sca ab_b_se = _se[x]
		loc lb = _b[L.y]-1.9599639*_se[L.y]
		loc ub = _b[L.y]+1.9599639*_se[L.y]
		if (`gam'>=`lb' & `gam'<=`ub') {
			ret sca ab_g_cover = 1
		}
		else {
			ret sca ab_g_cover = 0
		}
		loc lb = _b[x]-1.9599639*_se[x]
		loc ub = _b[x]+1.9599639*_se[x]
		if (`beta'>=`lb' & `beta'<=`ub') {
			ret sca ab_b_cover = 1
		}
		else {
			ret sca ab_b_cover = 0
		}
		nlcom _b[x]/(1-_b[L.y])
		mat A1=r(b)
		mat A2=r(V)
		ret sca ab_lr = A1[1,1]
		ret sca ab_lr_se = sqrt(A2[1,1])
		loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
		loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
		if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
			ret sca ab_lr_cover = 1
		}
		else {
			ret sca ab_lr_cover = 0
		}		
		mat drop A1 A2	
	*BB (1998)
		xtdpdsys y x, vce(robust)
		ret sca bb_g = _b[L.y]
		ret sca bb_b = _b[x]
		ret sca bb_g_se = _se[L.y]
		ret sca bb_b_se = _se[x]
		loc lb = _b[L.y]-1.9599639*_se[L.y]
		loc ub = _b[L.y]+1.9599639*_se[L.y]
		if (`gam'>=`lb' & `gam'<=`ub') {
			ret sca bb_g_cover = 1
		}
		else {
			ret sca bb_g_cover = 0
		}
		loc lb = _b[x]-1.9599639*_se[x]
		loc ub = _b[x]+1.9599639*_se[x]
		if (`beta'>=`lb' & `beta'<=`ub') {
			ret sca bb_b_cover = 1
		}
		else {
			ret sca bb_b_cover = 0
		}
		nlcom _b[x]/(1-_b[L.y])
		mat A1=r(b)
		mat A2=r(V)
		ret sca bb_lr = A1[1,1]
		ret sca bb_lr_se = sqrt(A2[1,1])
		loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
		loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
		if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
			ret sca bb_lr_cover = 1
		}
		else {
			ret sca bb_lr_cover = 0
		}	
		mat drop A1 A2
	*QD-GMM
		#delimit ;
		gmm (y-((1-{g}^(gap+lgap))/(1-({g}^lgap)))*L.y+((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*L2.y - {b}*(x-((1-({g}^gap))/(1-({g}^lgap)))*L.x) )
			, instruments(x0 x1 x2 x3 x4 x5 x6, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster ivar) from(g `gam' b `beta');
		#delimit cr
		ret sca qdgmm_g = _b[/g]
		ret sca qdgmm_b = _b[/b]
		ret sca qdgmm_g_se = _se[/g]
		ret sca qdgmm_b_se = _se[/b]
		loc lb = _b[/g]-1.9599639*_se[/g]
		loc ub = _b[/g]+1.9599639*_se[/g]
		if (`gam'>=`lb' & `gam'<=`ub') {
			ret sca qdgmm_g_cover = 1
		}
		else {
			ret sca qdgmm_g_cover = 0
		}
		loc lb = _b[/b]-1.9599639*_se[/b]
		loc ub = _b[/b]+1.9599639*_se[/b]
		if (`beta'>=`lb' & `beta'<=`ub') {
			ret sca qdgmm_b_cover = 1
		}
		else {
			ret sca qdgmm_b_cover = 0
		}	
		nlcom _b[/b]/(1-_b[/g])
		mat A1=r(b)
		mat A2=r(V)
		ret sca qdgmm_lr = A1[1,1]
		ret sca qdgmm_lr_se = sqrt(A2[1,1])
		loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
		loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
		if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
			ret sca qdgmm_lr_cover = 1
		}
		else {
			ret sca qdgmm_lr_cover = 0
		}	
		mat drop A1 A2
	*E-CRE	
		gen xx = x
		replace xx = . if m == 0
		bys ivar: egen xm = mean(xx)	
		bys ivar: g runsum_ly = sum(ly)
		gen yb_bar = runsum_ly/m 
		reg ly yb_bar
		predict res, r
		reg ly res x xm
		predict lyhat
		cap nl (y = lyhat*({g=`gam'}^gap) + {b=`beta'}*x + {d}*xm*((1-({g}^gap))/(1-{g}))) if m > 0, iter(500) nolog vce(cluster ivar)
		if e(converge) == 0 | _rc != 0 {
			ret sca ecre_g = .
			ret sca ecre_b = .
			ret sca ecre_lr = .
			ret sca ecre_g_se = .
			ret sca ecre_b_se = .
			ret sca ecre_lr_se = .
			ret sca ecre_g_cover = .
			ret sca ecre_b_cover = .
			ret sca ecre_lr_cover = .
		}
		else {
			ret sca ecre_g = _b[/g]
			ret sca ecre_b = _b[/b]
			ret sca ecre_g_se = _se[/g]
			ret sca ecre_b_se = _se[/b]
			loc lb = _b[/g]-1.9599639*_se[/g]
			loc ub = _b[/g]+1.9599639*_se[/g]
			if (`gam'>=`lb' & `gam'<=`ub') {
				ret sca ecre_g_cover = 1
			}
			else {
				ret sca ecre_g_cover = 0
			}
			loc lb = _b[/b]-1.9599639*_se[/b]
			loc ub = _b[/b]+1.9599639*_se[/b]
			if (`beta'>=`lb' & `beta'<=`ub') {
				ret sca ecre_b_cover = 1
			}
			else {
				ret sca ecre_b_cover = 0
			}
			nlcom _b[/b]/(1-_b[/g])
			mat A1=r(b)
			mat A2=r(V)
			ret sca ecre_lr = A1[1,1]
			ret sca ecre_lr_se = sqrt(A2[1,1])
			loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
			loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
			if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
				ret sca ecre_lr_cover = 1
			}
			else {
				ret sca ecre_lr_cover = 0
			}
			mat drop A1 A2
		}
		drop lyhat runsum_ly yb_bar xx
	*********************
	*Handle missing x's**
	*********************
	*QDGMM-L
		gen x0_m = lx
		gen Dm = gap > 1 & lx != .
		gen Dmx0_m = Dm*x0_m
		gen x0_m1 = l2x
		gen Dm1 = lgap > 1 & l2x != .
		gen Dm1x0_m1 = Dm1*x0_m1
		#delimit ;
		cap gmm (y-((1-{g}^(gap+lgap))/(1-({g}^lgap)))*L.y+((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*L2.y - {b}*(x-((1-({g}^gap))/(1-({g}^lgap)))*L.x)
				-{b}*(({g}-{g}^gap)/(1-{g}))*Dmx0_m + {b}*((1-{g}^gap)/(1-{g}^lgap))*(({g}-{g}^lgap)/(1-{g}))*Dm1x0_m1 )
				, instruments(x0 x1 x2 x3 x4 x5 x6, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster ivar) from(g `gam' b `beta');
		#delimit cr
		if e(converge) == 0 | _rc != 0 {
			ret sca qdgmmL_g = .
			ret sca qdgmmL_b = .
			ret sca qdgmmL_g_se = .
			ret sca qdgmmL_b_se = .
			ret sca qdgmmL_g_cover = .
			ret sca qdgmmL_b_cover = .
			ret sca qdgmmL_lr = .
			ret sca qdgmmL_lr_se = .
			ret sca qdgmmL_lr_cover = .
		}
		else {
			ret sca qdgmmL_g = _b[/g]
			ret sca qdgmmL_b = _b[/b]
			ret sca qdgmmL_g_se = _se[/g]
			ret sca qdgmmL_b_se = _se[/b]
			loc lb = _b[/g]-1.9599639*_se[/g]
			loc ub = _b[/g]+1.9599639*_se[/g]
			if (`gam'>=`lb' & `gam'<=`ub') {
				ret sca qdgmmL_g_cover = 1
			}
			else {
				ret sca qdgmmL_g_cover = 0
			}
			loc lb = _b[/b]-1.9599639*_se[/b]
			loc ub = _b[/b]+1.9599639*_se[/b]
			if (`beta'>=`lb' & `beta'<=`ub') {
				ret sca qdgmmL_b_cover = 1
			}
			else {
				ret sca qdgmmL_b_cover = 0
			}
			nlcom _b[/b]/(1-_b[/g])
			mat A1=r(b)
			mat A2=r(V)
			ret sca qdgmmL_lr = A1[1,1]
			ret sca qdgmmL_lr_se = sqrt(A2[1,1])
			loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
			loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
			if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
				ret sca qdgmmL_lr_cover = 1
			}
			else {
				ret sca qdgmmL_lr_cover = 0
			}
			mat drop A1 A2
		}
		drop x0_m Dm Dmx0_m x0_m1 Dm1 Dm1x0_m1	
	*QDGMM-A
		gen x0_m = 0.5*(x+lx)
		gen Dm = gap > 1 & lx != .
		gen Dmx0_m = Dm*x0_m
		gen x0_m1 = 0.5*(lx+l2x)
		gen Dm1 = lgap > 1 & l2x != .
		gen Dm1x0_m1 = Dm1*x0_m1
		#delimit ;
		cap gmm (y-((1-{g}^(gap+lgap))/(1-({g}^lgap)))*L.y+((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*L2.y - {b}*(x-((1-({g}^gap))/(1-({g}^lgap)))*L.x)
				-{b}*(({g}-{g}^gap)/(1-{g}))*Dmx0_m + {b}*((1-{g}^gap)/(1-{g}^lgap))*(({g}-{g}^lgap)/(1-{g}))*Dm1x0_m1 )
				, instruments(x0 x1 x2 x3 x4 x5 x6, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster ivar) from(g `gam' b `beta');
		#delimit cr
		if e(converge) == 0 | _rc != 0 {
			ret sca qdgmmA_g = .
			ret sca qdgmmA_b = .
			ret sca qdgmmA_g_se = .
			ret sca qdgmmA_b_se = .
			ret sca qdgmmA_g_cover = .
			ret sca qdgmmA_b_cover = .
			ret sca qdgmmA_lr = .
			ret sca qdgmmA_lr_se = .
			ret sca qdgmmA_lr_cover = .
		}
		else {
			ret sca qdgmmA_g = _b[/g]
			ret sca qdgmmA_b = _b[/b]
			ret sca qdgmmA_g_se = _se[/g]
			ret sca qdgmmA_b_se = _se[/b]
			loc lb = _b[/g]-1.9599639*_se[/g]
			loc ub = _b[/g]+1.9599639*_se[/g]
			if (`gam'>=`lb' & `gam'<=`ub') {
				ret sca qdgmmA_g_cover = 1
			}
			else {
				ret sca qdgmmA_g_cover = 0
			}
			loc lb = _b[/b]-1.9599639*_se[/b]
			loc ub = _b[/b]+1.9599639*_se[/b]
			if (`beta'>=`lb' & `beta'<=`ub') {
				ret sca qdgmmA_b_cover = 1
			}
			else {
				ret sca qdgmmA_b_cover = 0
			}
			nlcom _b[/b]/(1-_b[/g])
			mat A1=r(b)
			mat A2=r(V)
			ret sca qdgmmA_lr = A1[1,1]
			ret sca qdgmmA_lr_se = sqrt(A2[1,1])
			loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
			loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
			if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
				ret sca qdgmmA_lr_cover = 1
			}
			else {
				ret sca qdgmmA_lr_cover = 0
			}
			mat drop A1 A2
		}
		drop x0_m Dm Dmx0_m x0_m1 Dm1 Dm1x0_m1
	*QDGMM-C
		gen x0_m = x
		gen Dm = gap > 1 & x != .
		gen Dmx0_m = Dm*x0_m
		gen x0_m1 = lx
		gen Dm1 = lgap > 1 & lx != .
		gen Dm1x0_m1 = Dm1*x0_m1
		#delimit ;
		cap gmm (y-((1-{g}^(gap+lgap))/(1-({g}^lgap)))*L.y+((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*L2.y - {b}*(x-((1-({g}^gap))/(1-({g}^lgap)))*L.x)
				-{b}*(({g}-{g}^gap)/(1-{g}))*Dmx0_m + {b}*((1-{g}^gap)/(1-{g}^lgap))*(({g}-{g}^lgap)/(1-{g}))*Dm1x0_m1 )
				, instruments(x0 x1 x2 x3 x4 x5 x6, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster ivar) from(g `gam' b `beta');
		#delimit cr
		if e(converge) == 0 | _rc != 0 {
			ret sca qdgmmC_g = .
			ret sca qdgmmC_b = .
			ret sca qdgmmC_g_se = .
			ret sca qdgmmC_b_se = .
			ret sca qdgmmC_g_cover = .
			ret sca qdgmmC_b_cover = .
			ret sca qdgmmC_lr = .
			ret sca qdgmmC_lr_se = .
			ret sca qdgmmC_lr_cover = .
		}
		else {
			ret sca qdgmmC_g = _b[/g]
			ret sca qdgmmC_b = _b[/b]
			ret sca qdgmmC_g_se = _se[/g]
			ret sca qdgmmC_b_se = _se[/b]
			loc lb = _b[/g]-1.9599639*_se[/g]
			loc ub = _b[/g]+1.9599639*_se[/g]
			if (`gam'>=`lb' & `gam'<=`ub') {
				ret sca qdgmmC_g_cover = 1
			}
			else {
				ret sca qdgmmC_g_cover = 0
			}
			loc lb = _b[/b]-1.9599639*_se[/b]
			loc ub = _b[/b]+1.9599639*_se[/b]
			if (`beta'>=`lb' & `beta'<=`ub') {
				ret sca qdgmmC_b_cover = 1
			}
			else {
				ret sca qdgmmC_b_cover = 0
			}
			nlcom _b[/b]/(1-_b[/g])
			mat A1=r(b)
			mat A2=r(V)
			ret sca qdgmmC_lr = A1[1,1]
			ret sca qdgmmC_lr_se = sqrt(A2[1,1])
			loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
			loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
			if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
				ret sca qdgmmC_lr_cover = 1
			}
			else {
				ret sca qdgmmC_lr_cover = 0
			}
			mat drop A1 A2
		}
		drop x0_m Dm Dmx0_m x0_m1 Dm1 Dm1x0_m1			
	*QDGMM-AR1
		gen x0_L = lx		
		gen Dm4=(gap==4)
		gen Dm6=(gap==6)
		gen Dm4x0_L=Dm4*x0_L
		gen Dm6x0_L=Dm6*x0_L
		gen x0_L2 = l2x		
		gen Dm14=(lgap==4)
		gen Dm14x0_L2=Dm14*x0_L2
		#delimit ;
		gmm (y-((1-{g}^(gap+lgap))/(1-({g}^lgap)))*L.y+((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*L2.y - {b}*(x-((1-({g}^gap))/(1-({g}^lgap)))*L.x)
				-{b}*( Dm4x0_L*(({r}^(gap-1))*({g}^(1)) + ({r}^(gap-2))*({g}^(2)) + ({r}^(gap-3))*({g}^(3))) + 
					   Dm6x0_L*(({r}^(gap-1))*({g}^(1)) + ({r}^(gap-2))*({g}^(2)) + ({r}^(gap-3))*({g}^(3)) + ({r}^(gap-4))*({g}^(4)) + ({r}^(gap-5))*({g}^(5))))
				+{b}*(1-{g}^gap)/(1-{g}^lgap)*(Dm14x0_L2*(({r}^(lgap-1))*({g}^(1)) + ({r}^(lgap-2))*({g}^(2)) + ({r}^(lgap-3))*({g}^(3))))	   
			), instruments(x0 x1 x2 x3 x4 x5 x6 Dm4x0_L Dm6x0_L Dm14x0_L2, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster ivar)
			from(g `gam' b `beta' r `rhox');
		#delimit cr
		if e(converge) == 0 | _rc != 0 {
			ret sca qdgmmAR1_g = .
			ret sca qdgmmAR1_b = .
			ret sca qdgmmAR1_g_se = .
			ret sca qdgmmAR1_b_se = .
			ret sca qdgmmAR1_g_cover = .
			ret sca qdgmmAR1_b_cover = .
			ret sca qdgmmAR1_lr = .
			ret sca qdgmmAR1_lr_se = .
			ret sca qdgmmAR1_lr_cover = .
		}
		else {
			ret sca qdgmmAR1_g = _b[/g]
			ret sca qdgmmAR1_b = _b[/b]
			ret sca qdgmmAR1_g_se = _se[/g]
			ret sca qdgmmAR1_b_se = _se[/b]
			loc lb = _b[/g]-1.9599639*_se[/g]
			loc ub = _b[/g]+1.9599639*_se[/g]
			if (`gam'>=`lb' & `gam'<=`ub') {
				ret sca qdgmmAR1_g_cover = 1
			}
			else {
				ret sca qdgmmAR1_g_cover = 0
			}
			loc lb = _b[/b]-1.9599639*_se[/b]
			loc ub = _b[/b]+1.9599639*_se[/b]
			if (`beta'>=`lb' & `beta'<=`ub') {
				ret sca qdgmmAR1_b_cover = 1
			}
			else {
				ret sca qdgmmAR1_b_cover = 0
			}
			nlcom _b[/b]/(1-_b[/g])
			mat A1=r(b)
			mat A2=r(V)
			ret sca qdgmmAR1_lr = A1[1,1]
			ret sca qdgmmAR1_lr_se = sqrt(A2[1,1])
			loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
			loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
			if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
				ret sca qdgmmAR1_lr_cover = 1
			}
			else {
				ret sca qdgmmAR1_lr_cover = 0
			}
			mat drop A1 A2
		}
		drop x0_L Dm4x0_L Dm6x0_L Dm4 Dm6 x0_L2 Dm14x0_L2 Dm14
		
	*********************
	*Handle missing x's**
	*********************
	*E-CRE-L
		gen x0_m = lx
		gen D = gap > 1 & lx != .
		gen Dx0_m = D*x0_m
		gen xx = Dx0_m 
		replace xx = . if m == 0
		bys ivar: egen Dx0_m_m = mean(xx)
		reg ly res x Dx0_m xm Dx0_m_m
		predict lyhat
		cap nl (y = lyhat*({g=`gam'}^gap) + {b=`beta'}*(x + Dx0_m*(({g}-{g}^gap)/(1-{g}))) + ({d1}*xm + {d2}*Dx0_m_m)*((1-({g}^gap))/(1-{g}))) if m > 0, iter(500) nolog vce(cluster ivar)
		if e(converge) == 0 | _rc != 0 {
			ret sca ecreL_g = .
			ret sca ecreL_b = .
			ret sca ecreL_g_se = .
			ret sca ecreL_b_se = .
			ret sca ecreL_g_cover = .
			ret sca ecreL_b_cover = .
			ret sca ecreL_lr = .
			ret sca ecreL_lr_se = .
			ret sca ecreL_lr_cover = .
		}
		else {
			ret sca ecreL_g = _b[/g]
			ret sca ecreL_b = _b[/b]
			ret sca ecreL_g_se = _se[/g]
			ret sca ecreL_b_se = _se[/b]
			loc lb = _b[/g]-1.9599639*_se[/g]
			loc ub = _b[/g]+1.9599639*_se[/g]
			if (`gam'>=`lb' & `gam'<=`ub') {
				ret sca ecreL_g_cover = 1
			}
			else {
				ret sca ecreL_g_cover = 0
			}
			loc lb = _b[/b]-1.9599639*_se[/b]
			loc ub = _b[/b]+1.9599639*_se[/b]
			if (`beta'>=`lb' & `beta'<=`ub') {
				ret sca ecreL_b_cover = 1
			}
			else {
				ret sca ecreL_b_cover = 0
			}
			nlcom _b[/b]/(1-_b[/g])
			mat A1=r(b)
			mat A2=r(V)
			ret sca ecreL_lr = A1[1,1]
			ret sca ecreL_lr_se = sqrt(A2[1,1])
			loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
			loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
			if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
				ret sca ecreL_lr_cover = 1
			}
			else {
				ret sca ecreL_lr_cover = 0
			}
			mat drop A1 A2
		}
		drop lyhat x0_m xx Dx0_m Dx0_m_m
	*E-CRE-A
		gen x0_m = 0.5*(lx+x)
		gen Dx0_m = D*x0_m
		gen xx = Dx0_m 
		replace xx = . if m == 0
		bys ivar: egen Dx0_m_m = mean(xx)
		reg ly res x Dx0_m xm Dx0_m_m
		predict lyhat
		cap nl (y = lyhat*({g=`gam'}^gap) + {b=`beta'}*(x + Dx0_m*(({g}-{g}^gap)/(1-{g}))) + ({d1}*xm + {d2}*Dx0_m_m)*((1-({g}^gap))/(1-{g}))) if m > 0, iter(500) nolog vce(cluster ivar)
		if e(converge) == 0 | _rc != 0 {
			ret sca ecreA_g = .
			ret sca ecreA_b = .
			ret sca ecreA_g_se = .
			ret sca ecreA_b_se = .
			ret sca ecreA_g_cover = .
			ret sca ecreA_b_cover = .
			ret sca ecreA_lr = .
			ret sca ecreA_lr_se = .
			ret sca ecreA_lr_cover = .
		}
		else {
			ret sca ecreA_g = _b[/g]
			ret sca ecreA_b = _b[/b]
			ret sca ecreA_g_se = _se[/g]
			ret sca ecreA_b_se = _se[/b]
			loc lb = _b[/g]-1.9599639*_se[/g]
			loc ub = _b[/g]+1.9599639*_se[/g]
			if (`gam'>=`lb' & `gam'<=`ub') {
				ret sca ecreA_g_cover = 1
			}
			else {
				ret sca ecreA_g_cover = 0
			}
			loc lb = _b[/b]-1.9599639*_se[/b]
			loc ub = _b[/b]+1.9599639*_se[/b]
			if (`beta'>=`lb' & `beta'<=`ub') {
				ret sca ecreA_b_cover = 1
			}
			else {
				ret sca ecreA_b_cover = 0
			}
			nlcom _b[/b]/(1-_b[/g])
			mat A1=r(b)
			mat A2=r(V)
			ret sca ecreA_lr = A1[1,1]
			ret sca ecreA_lr_se = sqrt(A2[1,1])
			loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
			loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
			if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
				ret sca ecreA_lr_cover = 1
			}
			else {
				ret sca ecreA_lr_cover = 0
			}
			mat drop A1 A2
		}
		drop lyhat x0_m xx Dx0_m Dx0_m_m 
	*E-CRE-C
		gen x0_m = x
		gen Dx0_m = D*x0_m
		gen xx = Dx0_m 
		replace xx = . if m == 0
		bys ivar: egen Dx0_m_m = mean(xx)
		reg ly res x Dx0_m xm Dx0_m_m
		predict lyhat
		cap nl (y = lyhat*({g=`gam'}^gap) + {b=`beta'}*(x + Dx0_m*(({g}-{g}^gap)/(1-{g}))) + ({d1}*xm + {d2}*Dx0_m_m)*((1-({g}^gap))/(1-{g}))) if m > 0, iter(500) nolog vce(cluster ivar)
		if e(converge) == 0 | _rc != 0 {
			ret sca ecreC_g = .
			ret sca ecreC_b = .
			ret sca ecreC_g_se = .
			ret sca ecreC_b_se = .
			ret sca ecreC_g_cover = .
			ret sca ecreC_b_cover = .
			ret sca ecreC_lr = .
			ret sca ecreC_lr_se = .
			ret sca ecreC_lr_cover = .
		}
		else {
			ret sca ecreC_g = _b[/g]
			ret sca ecreC_b = _b[/b]
			ret sca ecreC_g_se = _se[/g]
			ret sca ecreC_b_se = _se[/b]
			loc lb = _b[/g]-1.9599639*_se[/g]
			loc ub = _b[/g]+1.9599639*_se[/g]
			if (`gam'>=`lb' & `gam'<=`ub') {
				ret sca ecreC_g_cover = 1
			}
			else {
				ret sca ecreC_g_cover = 0
			}
			loc lb = _b[/b]-1.9599639*_se[/b]
			loc ub = _b[/b]+1.9599639*_se[/b]
			if (`beta'>=`lb' & `beta'<=`ub') {
				ret sca ecreC_b_cover = 1
			}
			else {
				ret sca ecreC_b_cover = 0
			}
			nlcom _b[/b]/(1-_b[/g])
			mat A1=r(b)
			mat A2=r(V)
			ret sca ecreC_lr = A1[1,1]
			ret sca ecreC_lr_se = sqrt(A2[1,1])
			loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
			loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
			if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
				ret sca ecreC_lr_cover = 1
			}
			else {
				ret sca ecreC_lr_cover = 0
			}
			mat drop A1 A2
		}
		drop lyhat x0_m xx Dx0_m Dx0_m_m
	*E-CRE-AR1
		gen x0_L = lx		
		gen D4=(gap==4)
		gen D6=(gap==6)
		loc gs "4 6"
		foreach p of num `gs' {
			gen D`p'x0_L=D`p'*x0_L
			gen xx = D`p'x0_L 
			replace xx = . if m == 0
			bys ivar: egen D`p'x0_L_m = mean(xx)
			drop xx
		}
		reg ly res x D4x0_L D6x0_L xm D4x0_L_m D6x0_L_m
		predict lyhat
		#delimit ;
		cap nl (y = lyhat*({g=`gam'}^gap) + {b=`beta'}*(x + D4x0_L*(({r=`rhox'}^(gap-1))*({g}^(1)) + ({r}^(gap-2))*({g}^(2)) + ({r}^(gap-3))*({g}^(3))) 
			+ D6x0_L*(({r}^(gap-1))*({g}^(1)) + ({r}^(gap-2))*({g}^(2)) + ({r}^(gap-3))*({g}^(3)) + ({r}^(gap-4))*({g}^(4)) + ({r}^(gap-5))*({g}^(5)))) 
			+ ({d1}*xm + {d4}*D4x0_L_m + {d6}*D6x0_L_m)*((1-({g}^gap))/(1-{g})) ) if m > 0, iter(500) nolog vce(cluster ivar);
		#delimit cr
		if e(converge) == 0 | _rc != 0 {
			ret sca ecreAR1_g = .
			ret sca ecreAR1_b = .
			ret sca ecreAR1_g_se = .
			ret sca ecreAR1_b_se = .
			ret sca ecreAR1_g_cover = .
			ret sca ecreAR1_b_cover = .
			ret sca ecreAR1_lr = .
			ret sca ecreAR1_lr_se = .
			ret sca ecreAR1_lr_cover = .
		}
		else {
			ret sca ecreAR1_g = _b[/g]
			ret sca ecreAR1_b = _b[/b]
			ret sca ecreAR1_g_se = _se[/g]
			ret sca ecreAR1_b_se = _se[/b]
			loc lb = _b[/g]-1.9599639*_se[/g]
			loc ub = _b[/g]+1.9599639*_se[/g]
			if (`gam'>=`lb' & `gam'<=`ub') {
				ret sca ecreAR1_g_cover = 1
			}
			else {
				ret sca ecreAR1_g_cover = 0
			}
			loc lb = _b[/b]-1.9599639*_se[/b]
			loc ub = _b[/b]+1.9599639*_se[/b]
			if (`beta'>=`lb' & `beta'<=`ub') {
				ret sca ecreAR1_b_cover = 1
			}
			else {
				ret sca ecreAR1_b_cover = 0
			}
			nlcom _b[/b]/(1-_b[/g])
			mat A1=r(b)
			mat A2=r(V)
			ret sca ecreAR1_lr = A1[1,1]
			ret sca ecreAR1_lr_se = sqrt(A2[1,1])
			loc lb = A1[1,1]-1.9599639*sqrt(A2[1,1])
			loc ub = A1[1,1]+1.9599639*sqrt(A2[1,1])
			if (`lrcoef'>=`lb' & `lrcoef'<=`ub') {
				ret sca ecreAR1_lr_cover = 1
			}
			else {
				ret sca ecreAR1_lr_cover = 0
			}
			mat drop A1 A2
		}
		drop lyhat x0_L D4x0_L D6x0_L D4x0_L_m D6x0_L_m D4 D6
	clear
		
end 

**Calls Simulation Program**
#delimit ;

simulate 
		 case		= r(case)
		 gamma		= r(gamma)
		 beta		= r(beta)
		 lrcoef		= r(lrcoef)
		 x_lx_rho	= r(x_lx_rho)
		 x_a_rho	= r(x_a_rho) 
		 ah_g	    	= r(ah_g) 
		 ah_b	    	= r(ah_b)
		 ah_g_se	    = r(ah_g_se) 
		 ah_b_se	    = r(ah_b_se)
		 ah_g_cover	    = r(ah_g_cover) 
		 ah_b_cover	    = r(ah_b_cover) 
		 ah_lr 			= r(ah_lr) 
		 ah_lr_se 		= r(ah_lr_se)
		 ah_lr_cover	= r(ah_lr_cover)
		 ab_g	    	= r(ab_g) 
		 ab_b	    	= r(ab_b) 
		 ab_g_se	    = r(ab_g_se) 
		 ab_b_se	    = r(ab_b_se)
		 ab_g_cover	    = r(ab_g_cover) 
		 ab_b_cover	    = r(ab_b_cover)
		 ab_lr 			= r(ab_lr) 
		 ab_lr_se 		= r(ab_lr_se)
		 ab_lr_cover	= r(ab_lr_cover)
		 bb_g	    	= r(bb_g) 
		 bb_b	  		= r(bb_b)
		 bb_g_se	    = r(bb_g_se) 
		 bb_b_se	    = r(bb_b_se)
		 bb_g_cover	    = r(bb_g_cover) 
		 bb_b_cover	    = r(bb_b_cover)
		 bb_lr 			= r(bb_lr) 
		 bb_lr_se 		= r(bb_lr_se)
		 bb_lr_cover	= r(bb_lr_cover)
		 qdgmm_g		= r(qdgmm_g) 
		 qdgmm_b		= r(qdgmm_b)
		 qdgmm_g_se	    = r(qdgmm_g_se) 
		 qdgmm_b_se	    = r(qdgmm_b_se)
		 qdgmm_g_cover	= r(qdgmm_g_cover) 
		 qdgmm_b_cover	= r(qdgmm_b_cover)
		 qdgmm_lr 		= r(qdgmm_lr) 
		 qdgmm_lr_se 	= r(qdgmm_lr_se)
		 qdgmm_lr_cover	= r(qdgmm_lr_cover)
		 qdgmmL_g		= r(qdgmmL_g) 
		 qdgmmL_b		= r(qdgmmL_b) 
		 qdgmmL_g_se	= r(qdgmmL_g_se) 
		 qdgmmL_b_se	= r(qdgmmL_b_se)
		 qdgmmL_g_cover	= r(qdgmmL_g_cover) 
		 qdgmmL_b_cover	= r(qdgmmL_b_cover)
		 qdgmmL_lr 		= r(qdgmmL_lr) 
		 qdgmmL_lr_se 	= r(qdgmmL_lr_se)
		 qdgmmL_lr_cover	= r(qdgmmL_lr_cover)
		 qdgmmA_g		= r(qdgmmA_g) 
		 qdgmmA_b		= r(qdgmmA_b) 
		 qdgmmA_g_se	= r(qdgmmA_g_se) 
		 qdgmmA_b_se	= r(qdgmmA_b_se)
		 qdgmmA_g_cover	= r(qdgmmA_g_cover) 
		 qdgmmA_b_cover	= r(qdgmmA_b_cover)
		 qdgmmA_lr 		= r(qdgmmA_lr) 
		 qdgmmA_lr_se 	= r(qdgmmA_lr_se)
		 qdgmmA_lr_cover	= r(qdgmmA_lr_cover)
		 qdgmmC_g		= r(qdgmmC_g) 
		 qdgmmC_b		= r(qdgmmC_b) 
		 qdgmmC_g_se	= r(qdgmmC_g_se) 
		 qdgmmC_b_se	= r(qdgmmC_b_se)
		 qdgmmC_g_cover	= r(qdgmmC_g_cover) 
		 qdgmmC_b_cover	= r(qdgmmC_b_cover)
		 qdgmmC_lr 		= r(qdgmmC_lr) 
		 qdgmmC_lr_se 	= r(qdgmmC_lr_se)
		 qdgmmC_lr_cover	= r(qdgmmC_lr_cover)
		 qdgmmAR1_g		= r(qdgmmAR1_g) 
		 qdgmmAR1_b		= r(qdgmmAR1_b)
		 qdgmmAR1_g_se	= r(qdgmmAR1_g_se) 
		 qdgmmAR1_b_se	= r(qdgmmAR1_b_se)
		 qdgmmAR1_g_cover    = r(qdgmmAR1_g_cover) 
		 qdgmmAR1_b_cover    = r(qdgmmAR1_b_cover)
		 qdgmmAR1_lr 		= r(qdgmmAR1_lr) 
		 qdgmmAR1_lr_se 	= r(qdgmmAR1_lr_se)
		 qdgmmAR1_lr_cover	= r(qdgmmAR1_lr_cover)
		 ecre_g			= r(ecre_g) 
		 ecre_b	 		= r(ecre_b)  
		 ecre_g_se	    = r(ecre_g_se) 
		 ecre_b_se	    = r(ecre_b_se)
		 ecre_g_cover	= r(ecre_g_cover) 
		 ecre_b_cover	= r(ecre_b_cover)
		 ecre_lr 		= r(ecre_lr) 
		 ecre_lr_se 	= r(ecre_lr_se)
		 ecre_lr_cover	= r(ecre_lr_cover)
		 ecreL_g		= r(ecreL_g) 
		 ecreL_b		= r(ecreL_b) 
		 ecreL_g_se	    = r(ecreL_g_se) 
		 ecreL_b_se	    = r(ecreL_b_se)
		 ecreL_g_cover	= r(ecreL_g_cover) 
		 ecreL_b_cover	= r(ecreL_b_cover)
		 ecreL_lr 		= r(ecreL_lr) 
		 ecreL_lr_se 	= r(ecreL_lr_se)
		 ecreL_lr_cover	= r(ecreL_lr_cover)
		 ecreA_g		= r(ecreA_g) 
		 ecreA_b		= r(ecreA_b) 
		 ecreA_g_se	    = r(ecreA_g_se) 
		 ecreA_b_se	    = r(ecreA_b_se)
		 ecreA_g_cover	= r(ecreA_g_cover) 
		 ecreA_b_cover	= r(ecreA_b_cover)
		 ecreA_lr 		= r(ecreA_lr) 
		 ecreA_lr_se 	= r(ecreA_lr_se)
		 ecreA_lr_cover	= r(ecreA_lr_cover)
		 ecreC_g		= r(ecreC_g) 
		 ecreC_b		= r(ecreC_b) 
		 ecreC_g_se	    = r(ecreC_g_se) 
		 ecreC_b_se	    = r(ecreC_b_se)
		 ecreC_g_cover	= r(ecreC_g_cover) 
		 ecreC_b_cover	= r(ecreC_b_cover)
		 ecreC_lr 		= r(ecreC_lr) 
		 ecreC_lr_se 	= r(ecreC_lr_se)
		 ecreC_lr_cover	= r(ecreC_lr_cover)
		 ecreAR1_g		= r(ecreAR1_g) 
		 ecreAR1_b		= r(ecreAR1_b)
		 ecreAR1_g_se	= r(ecreAR1_g_se) 
		 ecreAR1_b_se	= r(ecreAR1_b_se)
		 ecreAR1_g_cover    = r(ecreAR1_g_cover) 
		 ecreAR1_b_cover    = r(ecreAR1_b_cover)
		 ecreAR1_lr 		= r(ecreAR1_lr) 
		 ecreAR1_lr_se 		= r(ecreAR1_lr_se)
		 ecreAR1_lr_cover	= r(ecreAR1_lr_cover),
		 
		 seed($seed) reps(`reps') saving(mcResults_$case, replace) nodots: dpdSim, rho(`rho') sig_s2(`sig_s2') sig_eps2(`sig_eps2') mu_alpha(`mu_alpha')  
         mu_omega(`mu_omega') theta(`theta') pi_0(`pi_0') pi_1(`pi_1') pi_2(`pi_2') gam(`gam') beta(`beta') nobs(`nobs') time(`time') t0(`T0');
		 
#delimit cr

}
