cap log cl
clear all
set more off
cd "C:\YOUR\PATH\HERE\"

qui {

use mm_dpd_app_data, replace

**Vars
loc xvars  "ses ses2 sesmiss hhsize hhsizemiss r_ff_index"

**Empirical MC parameters
loc seed 2458752
loc reps 10
loc gam 0.4
loc beta 0.1
loc case 1
loc mu_alpha 5
loc scale = 6
keep i t zbmi `xvars'
ren zbmi y
gen d = (y != .)
bys i: egen dd = total(d)
keep if dd == 6
drop d dd
save tdmp_mc, replace

program define bmiSim, rclass

	syntax [, case(int 1) mu_alpha(real 1) gam(real 0.5) beta(real 0.1) scale(real 1)]

	ret sca case = `case'
	ret sca beta = `beta'
	ret sca gamma = `gam'
	ret sca mu_alpha = `mu_alpha'
	ret sca scale = `scale'

	**Data Simulation
	use tdmp_mc, clear
	loc xvars  "ses ses2 sesmiss hhsize hhsizemiss r_ff_index"
	gen xb = 0 
	
	foreach xx of loc xvars {
	
		replace xb = xb +0.1*`xx'
	}
	
	sort i t
		
	loc sig_alpha = `mu_alpha'*(1-`gam')^2

	by i: egen mxb = mean(xb)
	by i: g a = rnormal(mxb,sqrt(`sig_alpha')/`scale') if _n==1
	by i: egen aa = mean(a)
	replace a = aa
	drop aa
	sort i t
	xtset i t
	g gap = 1 if t == 2
	replace gap = 2 if t == 3
	replace gap = 4 if t == 4
	replace gap = 4 if t == 5
	replace gap = 6 if t == 6
	
	by i: replace y = (`gam'^gap)*L.y + xb + ((1-(`gam'^gap))/(1-`gam'))*a + rnormal((`gam'^2)*xb,0.5/`scale') + rnormal((`gam'^2)*L.xb,0.5/`scale') + rnormal(0,sqrt(0.5)/`scale') if _n>1
	
	**Estimation
	replace t = t - 1
	sort i t
	xtset i t
	by i: g lgap = L.gap
	by i: g ly	= L.y
	by i: g l2y	= L2.y
	by i: g l3y	= L3.y
	by i: g l4y	= L4.y
	by i: g dy	= D.y
	by i: g ldy	= L.dy
	
	loc xs 		" "
	loc lxs 	" "
	loc l2xs 	" "
	loc dxs 	" "
	loc ldxs	" "
	loc xms 	" "
	loc xs_demean " "
	loc k=1
	foreach x of loc xvars {
		g x`k'=`x'
		by i: g lx`k'	= L.x`k'
		by i: g l2x`k'	= L2.x`k'
		by i: g dx`k'	= D.x`k'
		by i: g ldx`k'	= L.dx`k'
		loc xs 		"`xs' x`k'"
		loc lxs 	"`lxs' lx`k'"
		loc l2xs 	"`l2xs' l2x`k'"
		loc dxs 	"`dxs' dx`k'"
		loc ldxs	"`ldxs' ldx`k'"
		by i: egen x`k'm = mean(x`k')
		loc xms 	"`xms' x`k'm"
		g x`k'_demean = x`k' - x`k'm
		loc xs_demean "`xs_demean' x`k'_demean"
		loc k=`k'+1
	}
	loc kx = `k'-1
	
	forval d=0/5 {
		g d`d'=t==`d'
	}
	
	loc ivs " "
	forval k=1/`kx' {
		forval d=0/5 {
			g z`k'_`d' = x`k' if t==`d'
			by i: egen m`k'_`d'=mean(z`k'_`d')
			loc ivs "`ivs' m`k'_`d'"
		}
	}
	
	*******************************************
	**Estimators with Unequal Spacing in Data**
	*******************************************
	*AH (1981)
		noi di "AH...."
		noi ivreg2 dy (ldy = l2y) `dxs' d3-d5, robust
		ret sca ah_g = _b[ldy]
		forval p=1/`kx' {
			ret sca ah_b`p' = _b[dx`p']
		}
	*AB (1991)
		noi di "AB...."
		noi xtabond y `xs' d2-d5, vce(robust)
		ret sca ab_g = _b[L.y]
		forval p=1/`kx' {
			ret sca ab_b`p' = _b[x`p']
		}
	*BB (1998)
		noi di "BB...."
		noi xtdpdsys y `xs' d2-d5, vce(robust)
		ret sca bb_g = _b[L.y]
		forval p=1/`kx' {
			ret sca bb_b`p' = _b[x`p']
		}
		loc gam = _b[L.y]
		loc gmminits " "
		forval k=1/`kx' {
			loc ibeta`k' = _b[x`k']
			loc gmminits "`gmminits' b`k' `ibeta`k'' "
		}
	*E-CRE-A
		noi di "ECREA...."
		g D = gap > 1 & lx1 != .
		loc Dxs " "
		loc Dxms " "
		forval k=1/`kx' {
			g Dx`k'=0.5*D*(x`k'+lx`k')
			loc Dxs 	"`Dxs' Dx`k'"
			by i: egen Dx`k'm=mean(Dx`k')
			loc Dxms 	"`Dxms' Dx`k'm"
		}
		loc ecreA " "
		forval k=1/`kx' {
			loc ecreA "`ecreA' + {b`k'=`ibeta`k''}*(x`k'  + Dx`k'*(({g}-{g}^gap)/(1-{g})))"
		}
		sort i t
		by i: g runsum_ly = sum(ly)
		g yb_bar = runsum_ly/t
		reg ly yb_bar
		predict res if e(sample), r
		reg ly res `xs' `Dxs' `xms' `Dxms'
		test res	
		predict lyhat if e(sample)
		noi nl (y = lyhat*({g=`gam'}^gap) `ecreA' + ({b0=0.1} + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 + {xb: `xms' `Dxms'})*((1-({g}^gap))/(1-{g}))) if t > 0, iter(500) nolog vce(cluster i)
		if e(converge) == 1 {
			ret sca ecreA_g = _b[/g]
			forval p=1/`kx' {
				ret sca ecreA_b`p' = _b[/b`p']
			}
		}
		drop runsum_ly yb_bar res lyhat 	
	*E-CRE
		noi di "ECRE...."
		sort i t
		by i: g runsum_ly = sum(ly)
		g yb_bar = runsum_ly/t
		reg ly yb_bar
		predict res, r
		reg ly res `xs' `xms'
		test res
		predict lyhat
		noi nl (y = lyhat*({g=`gam'}^gap) + {xb: `xs'} + ({b0=0.1} + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 + {xb: `xms'})*((1-({g}^gap))/(1-{g}))) if t > 0, iter(500) nolog vce(cluster i)
		if e(converge) == 1 {
			ret sca ecre_g = _b[/g]
			forval p=1/`kx' {
				ret sca ecre_b`p' = _b[/xb_x`p']
			}
		}
		drop runsum_ly yb_bar res lyhat 	
	*E-CRE-C
		noi di "ECREC...."
		drop D `Dxs' `D1xs' `Dxms' //<-- guess that Dxms error occurs here
		g D = gap > 1 & x1 != .
		loc Dxs " "
		loc Dxms " "
		forval k=1/`kx' {
			g Dx`k'=D*x`k'
			loc Dxs 	"`Dxs' Dx`k'"
			by i: egen Dx`k'm=mean(Dx`k')
			loc Dxms 	"`Dxms' Dx`k'm"
		}
		loc ecreC " "
		forval k=1/`kx' {
			loc ecreC "`ecreC' + {b`k'=`ibeta`k''}*(x`k'  + Dx`k'*(({g}-{g}^gap)/(1-{g})))"
		}
		bys i: g runsum_ly = sum(ly)
		g yb_bar = runsum_ly/t
		reg ly yb_bar
		predict res if e(sample), r
		noi reg ly res `xs' `Dxs' `xms' `Dxms'
		noi test res	
		predict lyhat if e(sample)
		
		noi nl (y = lyhat*({g=`gam'}^gap) `ecreC' + ({b0=0.1} + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 + {xb: `xms' `Dxms'})*((1-({g}^gap))/(1-{g}))) if t > 1, iter(500) nolog vce(cluster i)
		if e(converge) == 1 {
			ret sca ecreC_g = _b[/g]
			forval p=1/`kx' {
				ret sca ecreC_b`p' = _b[/b`p']
			}
		}
		drop runsum_ly yb_bar res lyhat
	*QD-GMM-A
		noi di "QDGMMA...."
		loc qdxs " "
		forval k=1/`kx' {
			loc qdxs "`qdxs' - {b`k'=`ibeta`k''}*(x`k'-((1-({g}^gap))/(1-({g}^lgap)))*lx`k')"
		}		
		drop D `Dxs' `Dxms'
		g D = gap > 1 & lx1 != .
		g D1 = lgap > 1 & l2x1 != .
		
		loc Dxs  " "
		loc D1xs " "
		
		forval k=1/`kx' {
			g Dx`k'=0.5*D*(x`k'+lx`k')
			g D1x`k'=0.5*D1*(lx`k'+l2x`k')
			
			loc Dxs 	"`Dxs' Dx`k'"
			loc D1xs 	"`D1xs' D1x`k'" //most recent code added; last error in QDGMMC was "variable D1x1 already defined."			
			
		}
		loc qAdxs " "
		forval k=1/`kx' {
			loc qAdxs "`qAdxs' - {b`k'}*(({g}-{g}^gap)/(1-{g}))*Dx`k' + {b`k'}*((1-{g}^gap)/(1-{g}^lgap))*(({g}-{g}^lgap)/(1-{g}))*D1x`k'"
		}
		#delimit ;
		noi gmm (y-((1-{g}^(gap+lgap))/(1-({g}^lgap)))*ly + ((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*l2y + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 `qdxs' `qAdxs'), 
			instruments(`ivs' d3 d4 d5, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster i)
			from(g `gam' `gmminits');
		#delimit cr
		ret sca qdgmmA_g = _b[/g]
		forval p=1/`kx' {
			ret sca qdgmmA_b`p' = _b[/b`p']
		}	
	*QD-GMM
		noi di "QDGMM...."
		loc qdxs " "
		forval k=1/`kx' {
			loc qdxs "`qdxs' - {b`k'=`ibeta`k''}*(x`k'-((1-({g}^gap))/(1-({g}^lgap)))*lx`k')"
		}
		#delimit ;
		noi gmm (y-((1-{g}^(gap+lgap))/(1-({g}^lgap)))*ly + ((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*l2y + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 `qdxs' ), 
			instruments(`ivs' d3 d4 d5, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster i) 
			from(g `gam' `gmminits');
		#delimit cr
		ret sca qdgmm_g = _b[/g]
		forval p=1/`kx' {
			ret sca qdgmm_b`p' = _b[/b`p']
		}
	*QD-GMM-C
		noi di "QDGMMC...."
		loc qdxs " "
		forval k=1/`kx' {
			loc qdxs "`qdxs' - {b`k'=`ibeta`k''}*(x`k'-((1-({g}^gap))/(1-({g}^lgap)))*lx`k')"
		}		
		drop D D1 `Dxs' `D1xs'
		g D = gap > 1 & x1 != .
		g D1 = lgap > 1 & lx1 != .
		forval k=1/`kx' {
			g Dx`k'= D*x`k'
			g D1x`k'= D1*lx`k'
		}
		loc qCdxs " "
		forval k=1/`kx' {
			loc qCdxs "`qCdxs' - {b`k'}*(({g}-{g}^gap)/(1-{g}))*Dx`k' + {b`k'}*((1-{g}^gap)/(1-{g}^lgap))*(({g}-{g}^lgap)/(1-{g}))*D1x`k'"
		}
		#delimit ;
		noi gmm (y-((1-{g=`gam'}^(gap+lgap))/(1-({g}^lgap)))*ly + ((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*l2y + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 `qdxs' `qCdxs'), 
			instruments(`ivs' d3 d4 d5, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster i)
			from(g `gam' `gmminits');
		#delimit cr
		ret sca qdgmmC_g = _b[/g]
		forval p=1/`kx' {
			ret sca qdgmmC_b`p' = _b[/b`p']
		}

	clear
		
end 

*Calls Simulation Program**
#delimit ;

noi simulate 
		 case		= r(case)
		 mu_alpha 	= r(mu_alpha)
		 scale		= r(scale)
		 gamma		= r(gamma)
		 beta		= r(beta)
		 ah_g	    	= r(ah_g)
		 ab_g	    	= r(ab_g)
		 bb_g	  		= r(bb_g)
		 qdgmm_g		= r(qdgmm_g)
		 qdgmmA_g		= r(qdgmmA_g)
		 qdgmmC_g		= r(qdgmmC_g)
		 ecre_g			= r(ecre_g)
		 ecreA_g		= r(ecreA_g)
		 ecreC_g		= r(ecreC_g)
		 ah_b1	    	= r(ah_b1)
		 ah_b2	    	= r(ah_b2)
		 ah_b3	    	= r(ah_b3)
		 ah_b4	    	= r(ah_b4)
		 ah_b5	    	= r(ah_b5)
		 ah_b6	    	= r(ah_b6)
		 ab_b1	    	= r(ab_b1)
		 ab_b2	    	= r(ab_b2)
		 ab_b3	    	= r(ab_b3)
		 ab_b4	    	= r(ab_b4)
		 ab_b5	    	= r(ab_b5)
		 ab_b6	    	= r(ab_b6)
		 bb_b1	    	= r(bb_b1)
		 bb_b2	    	= r(bb_b2)
		 bb_b3	    	= r(bb_b3)
		 bb_b4	    	= r(bb_b4)
		 bb_b5	    	= r(bb_b5)
		 bb_b6	    	= r(bb_b6)
		 ecre_b1	    	= r(ecre_b1)
		 ecre_b2	    	= r(ecre_b2)
		 ecre_b3	    	= r(ecre_b3)
		 ecre_b4	    	= r(ecre_b4)
		 ecre_b5	    	= r(ecre_b5)
		 ecre_b6	    	= r(ecre_b6)
		 ecreA_b1	    	= r(ecreA_b1)
		 ecreA_b2	    	= r(ecreA_b2)
		 ecreA_b3	    	= r(ecreA_b3)
		 ecreA_b4	    	= r(ecreA_b4)
		 ecreA_b5	    	= r(ecreA_b5)
		 ecreA_b6	    	= r(ecreA_b6)
		 ecreC_b1	    	= r(ecreC_b1)
		 ecreC_b2	    	= r(ecreC_b2)
		 ecreC_b3	    	= r(ecreC_b3)
		 ecreC_b4	    	= r(ecreC_b4)
		 ecreC_b5	    	= r(ecreC_b5)
		 ecreC_b6	    	= r(ecreC_b6)
		 qdgmm_b1	    	= r(qdgmm_b1)
		 qdgmm_b2	    	= r(qdgmm_b2)
		 qdgmm_b3	    	= r(qdgmm_b3)
		 qdgmm_b4	    	= r(qdgmm_b4)
		 qdgmm_b5	    	= r(qdgmm_b5)
		 qdgmm_b6	    	= r(qdgmm_b6)
		 qdgmmA_b1	    	= r(qdgmmA_b1)
		 qdgmmA_b2	    	= r(qdgmmA_b2)	 
		 qdgmmA_b3	    	= r(qdgmmA_b3) 
		 qdgmmA_b4	    	= r(qdgmmA_b4) 
		 qdgmmA_b5	    	= r(qdgmmA_b5)
		 qdgmmA_b6	    	= r(qdgmmA_b6)
		 qdgmmC_b1	    	= r(qdgmmC_b1)
		 qdgmmC_b2	    	= r(qdgmmC_b2)	 
		 qdgmmC_b3	    	= r(qdgmmC_b3) 
		 qdgmmC_b4	    	= r(qdgmmC_b4) 
		 qdgmmC_b5	    	= r(qdgmmC_b5)
		 qdgmmC_b6	    	= r(qdgmmC_b6),
		 
		 seed(`seed') reps(`reps') saving(EMCbmiResults_`case', replace) nodots: bmiSim, case(`case') mu_alpha(`mu_alpha') gam(`gam') beta(`beta') scale(`scale');
		 
#delimit cr

} //end qui

