cap log cl
clear all
set more off
cd "C:\YOUR\PATH\HERE\"

qui {

use mm_dpd_app_data, replace

********
**Vars**
********
loc yvars "zbmi"

loc xvars  "ses ses2 sesmiss hhsize hhsizemiss r_ff_index nomom exercise3plus exercisemiss cluncha clunchamiss insure insuremiss books booksmiss" //Note, components to create SES variable are: father educ, mother educ, 
loc zvars  "ses ses2 sesmiss hhsize hhsizemiss r_ff_index nomom exercise3plus exercisemiss cluncha clunchamiss insure insuremiss books booksmiss" //father occupation, mother occupation, hh income.
loc parms  "g b1 b2 b4 b6 b7 b8 b10 b12 b14"
loc parms1 "b1 b2 b4 b6 b7 b8 b10 b12 b14"
loc pparms "1 2 4 6	7 8 10 12 14"

**************
**Estimation**
**************
foreach yy of loc yvars {
	preserve
	g y=`yy'
	g d=(y!=.)
	bys i: egen dd=total(d)
	keep if dd==6
	drop d dd
	replace t=t-1
	sort i t
	xtset i t
	g gap=1 if t==1
	replace gap=2 if t==2
	replace gap=4 if t==3
	replace gap=4 if t==4
	replace gap=6 if t==5
	by i: g lgap  = L.gap
	by i: g ly	= L.y
	by i: g l2y	= L2.y
	by i: g l3y	= L3.y
	by i: g l4y	= L4.y
	by i: g dy	= D.y
	by i: g ldy	= L.dy
	
	loc xs 		" "
	loc lxs 	" "
	loc l2xs 	" "
	loc dxs 	" "
	loc ldxs	" "
	loc xms 	" "
	loc xs_demean " "
	loc k=1
	foreach x of loc xvars {
		g x`k'=`x'
		by i: g lx`k'	= L.x`k'
		by i: g l2x`k'	= L2.x`k'
		by i: g dx`k'	= D.x`k'
		by i: g ldx`k'	= L.dx`k'
		loc xs 		"`xs' x`k'"
		loc lxs 	"`lxs' lx`k'"
		loc l2xs 	"`l2xs' l2x`k'"
		loc dxs 	"`dxs' dx`k'"
		loc ldxs	"`ldxs' ldx`k'"
		by i: egen x`k'm=mean(x`k')
		loc xms 	"`xms' x`k'm"
		g x`k'_demean = x`k' - x`k'm
		loc xs_demean "`xs_demean' x`k'_demean"
		loc k=`k'+1
	}
	loc kx = `k'-1
	loc zs 		" "
	loc lzs 	" "
	loc l2zs 	" "
	loc dzs 	" "
	loc ldzs	" "
	loc zms 	" "
	loc zs_demean " "
	loc k = 1
	foreach z of loc zvars {
		g z`k'=`z'
		by i: g lz`k'	= L.z`k'
		by i: g l2z`k'	= L2.z`k'
		by i: g dz`k'	= D.z`k'
		by i: g ldz`k'	= L.dz`k'
		loc zs 		"`zs' z`k'"
		loc lzs 	"`lzs' lz`k'"
		loc l2zs 	"`l2zs' l2z`k'"
		loc dzs 	"`dzs' dz`k'"
		loc ldzs	"`ldzs' ldz`k'"
		by i: egen z`k'm=mean(z`k')
		loc zms 	"`zms' z`k'm"
		g z`k'_demean = z`k' - z`k'm
		loc zs_demean "`zs_demean' z`k'_demean"
		loc k=`k'+1
	}
	loc kz = `k'-1
	
	forval d=0/5 {
		g d`d'=t==`d'
	}

	loc ivs " "
	forval k=1/`kx' {
		forval d=0/5 {
			g z`k'_`d' = x`k' if t==`d'
			by i: egen m`k'_`d'=mean(z`k'_`d')
			loc ivs "`ivs' m`k'_`d'"
		}
	}
	
	*******************************************
	**Estimators with Unequal Spacing in Data**
	*******************************************
	*AH (1981)
		noi di "AH...."
		noi ivreg2 dy (ldy = l2y) `dxs' d3-d5, robust
		loc ah_g = _b[ldy]
		loc ah_sg = _se[ldy]
		foreach p of loc pparms {
			loc ah_b`p' = _b[dx`p']
			loc ah_sb`p' = _se[dx`p']
		}
	*AB (1991)
		noi di "AB...."
		noi xtabond y `xs' d2-d5, vce(robust)
		loc ab_g = _b[L.y]
		loc ab_sg = _se[L.y]
		foreach p of loc pparms {
			loc ab_b`p' = _b[x`p']
			loc ab_sb`p' = _se[x`p']
		}
	*BB (1998)
		noi di "BB...."
		noi xtdpdsys y `xs' d2-d5, vce(robust)
		loc bb_g = _b[L.y]
		loc bb_sg = _se[L.y]
		foreach p of loc pparms {
			loc bb_b`p' = _b[x`p']
			loc bb_sb`p' = _se[x`p']
		}
		loc gam = `bb_g'
		loc gmminits " "
		forval k=1/`kx' {
			loc ibeta`k' = _b[x`k']
			loc gmminits "`gmminits' b`k' `ibeta`k'' "
		}
	**E-CRE-A
		noi di "ECREA...."
		g D = gap > 1 & lx1 != .
		loc Dxs " "
		loc Dxms " "
		forval k=1/`kx' {
			g Dx`k'=0.5*D*(x`k'+lx`k')
			loc Dxs 	"`Dxs' Dx`k'"
			by i: egen Dx`k'm=mean(Dx`k')
			loc Dxms 	"`Dxms' Dx`k'm"
		}
		loc ecreA " "
		forval k=1/`kx' {
			loc ecreA "`ecreA' + {b`k'=`ibeta`k''}*(x`k'  + Dx`k'*(({g}-{g}^gap)/(1-{g})))"
		}
		bys i: g runsum_ly = sum(ly)
		g yb_bar = runsum_ly/t
		reg ly yb_bar
		predict res if e(sample), r
		reg ly res `xs' `Dxs' `xms' `Dxms'
		noi test res	
		predict lyhat if e(sample)
		
		noi nl (y = lyhat*({g=`gam'}^gap) `ecreA' + ({b0=0.1} + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 + {xb: `xms' `Dxms'})*((1-({g}^gap))/(1-{g}))) if t > 1, iter(500) nolog vce(cluster i)
		if e(converge) == 1 {
			foreach p of loc parms {
				loc ecreA_`p' = _b[/`p']
				loc ecreA_s`p' = _se[/`p']
			}
		}
		drop runsum_ly yb_bar res lyhat 	
	**QD-GMM-A
		noi di "QDGMMA...."
		loc qdxs " "
		forval k=1/`kx' {
			loc qdxs "`qdxs' - {b`k'=`ibeta`k''}*(x`k'-((1-({g}^gap))/(1-({g}^lgap)))*lx`k')"
		}		
		drop D `Dxs' `Dxms'
		g D = gap > 1 & lx1 != .
		g D1 = lgap > 1 & l2x1 != .
		forval k=1/`kx' {
			g Dx`k'=0.5*D*(x`k'+lx`k')
			g D1x`k'=0.5*D1*(lx`k'+l2x`k')
			loc D1xs 	"`D1xs' D1x`k'"
		}
		loc qAdxs " "
		forval k=1/`kx' {
			loc qAdxs "`qAdxs' - {b`k'}*(({g}-{g}^gap)/(1-{g}))*Dx`k' + {b`k'}*((1-{g}^gap)/(1-{g}^lgap))*(({g}-{g}^lgap)/(1-{g}))*D1x`k'"
		}
		#delimit ;
		noi gmm (y-((1-{g=`gam'}^(gap+lgap))/(1-({g}^lgap)))*ly + ((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*l2y + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 `qdxs' `qAdxs'), 
			instruments(`ivs' d3 d4 d5, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster i)
			from(g `gam' `gmminits');
		#delimit cr
		foreach p of loc parms {
			loc qdgmmA_`p' = _b[/`p']
			loc qdgmmA_s`p' = _se[/`p']
		}
	**E-CRE-C
		noi di "ECREC...."
		drop D `Dxs' `D1xs'
		g D = gap > 1 & x1 != .
		loc Dxs " "
		loc Dxms " "
		forval k=1/`kx' {
			g Dx`k'=D*x`k'
			loc Dxs 	"`Dxs' Dx`k'"
			by i: egen Dx`k'm=mean(Dx`k')
			loc Dxms 	"`Dxms' Dx`k'm"
		}
		loc ecreC " "
		forval k=1/`kx' {
			loc ecreC "`ecreC' + {b`k'=`ibeta`k''}*(x`k'  + Dx`k'*(({g}-{g}^gap)/(1-{g})))"
		}
		bys i: g runsum_ly = sum(ly)
		g yb_bar = runsum_ly/t
		reg ly yb_bar
		predict res if e(sample), r
		noi reg ly res `xs' `Dxs' `xms' `Dxms'
		noi test res	
		predict lyhat if e(sample)
		
		noi nl (y = lyhat*({g=`gam'}^gap) `ecreC' + ({b0=0.1} + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 + {xb: `xms' `Dxms'})*((1-({g}^gap))/(1-{g}))) if t > 1, iter(500) nolog vce(cluster i)
		if e(converge) == 1 {
			foreach p of loc parms {
				loc ecreC_`p' = _b[/`p']
				loc ecreC_s`p' = _se[/`p']
			}
		}
		drop runsum_ly yb_bar res lyhat
	**QD-GMM-C
		noi di "QDGMMC...."
		loc qdxs " "
		forval k=1/`kx' {
			loc qdxs "`qdxs' - {b`k'=`ibeta`k''}*(x`k'-((1-({g}^gap))/(1-({g}^lgap)))*lx`k')"
		}		
		drop D D1 `Dxs' `Dxms'
		g D = gap > 1 & x1 != .
		g D1 = lgap > 1 & lx1 != .
		forval k=1/`kx' {
			g Dx`k'= D*x`k'
			g D1x`k'= D1*lx`k'
		}
		loc qCdxs " "
		forval k=1/`kx' {
			loc qCdxs "`qCdxs' - {b`k'}*(({g}-{g}^gap)/(1-{g}))*Dx`k' + {b`k'}*((1-{g}^gap)/(1-{g}^lgap))*(({g}-{g}^lgap)/(1-{g}))*D1x`k'"
		}
		#delimit ;
		noi gmm (y-((1-{g=`gam'}^(gap+lgap))/(1-({g}^lgap)))*ly + ((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*l2y + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 `qdxs' `qCdxs'), 
			instruments(`ivs' d3 d4 d5, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster i)
			from(g `gam' `gmminits');
		#delimit cr
		foreach p of loc parms {
			loc qdgmmC_`p' = _b[/`p']
			loc qdgmmC_s`p' = _se[/`p']
		}
	**E-CRE
		noi di "ECRE...."
		bys i: g runsum_ly = sum(ly)
		g yb_bar = runsum_ly/t
		reg ly yb_bar
		predict res, r
		reg ly res `xs' `xms'
		noi test res
		predict lyhat
		noi nl (y = lyhat*({g=`gam'}^gap) + {xb: `xs'} + ({b0=0.1} + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 + {xb: `xms'})*((1-({g}^gap))/(1-{g}))) if t > 0, iter(500) nolog vce(cluster i)
		if e(converge) == 1 {
			loc ecre_g = _b[/g]
			loc ecre_sg = _se[/g]
			foreach p of loc pparms {
				loc ecre_b`p' = _b[/xb_x`p']
				loc ecre_sb`p' = _se[/xb_x`p']
			}
		}
		drop runsum_ly yb_bar res lyhat 
	**QD-GMM
		noi di "QDGMM...."
		loc qdxs " "
		forval k=1/`kx' {
			loc qdxs "`qdxs' - {b`k'=`ibeta`k''}*(x`k'-((1-({g}^gap))/(1-({g}^lgap)))*lx`k')"
		}
		#delimit ;
		noi gmm (y-((1-{g=`gam'}^(gap+lgap))/(1-({g}^lgap)))*ly + ((({g}^lgap)-{g}^(gap+lgap))/(1-({g}^lgap)))*l2y + {d3=0}*d3 + {d4=0}*d4 + {d5=0}*d5 `qdxs'), 
			instruments(`ivs' d3 d4 d5, noconstant) xtinstruments(y, lags(2/.)) winitial(xt D) onestep vce(cluster i) ;
		#delimit cr
		foreach p of loc parms {
			loc qdgmm_`p' = _b[/`p']
			loc qdgmm_s`p' = _se[/`p']
		}
		
	*******************	
	**Display Results**	
	*******************	
	noi di as text "{hline 85}"
	noi di as text "Outcome: " "`yy'"
	noi di as text "{hline 85}"
	noi di as text "{hline 85}"
	noi di as text "PARM " _col(5) "AH" _col(18) "AB" _col(31) "BB" _col(44) "QDGMMA" _col(57) "ECREA" 
	noi di as text "{hline 85}"
	foreach p of loc parms {
		noi di "`p'" _col(5) %11.4f `ah_`p''  _col(18) %11.4f `ab_`p''  _col(31) %11.4f `bb_`p''  _col(44) %11.4f `qdgmmA_`p''  _col(57) %11.4f `ecreA_`p''
		noi di       _col(5) %11.4f `ah_s`p'' _col(18) %11.4f `ab_s`p'' _col(31) %11.4f `bb_s`p'' _col(44) %11.4f `qdgmmA_s`p'' _col(57) %11.4f `ecreA_s`p'' 
	}
	noi di as text "{hline 85}"
	noi di as text "{hline 85}"
	noi di as text "PARM " _col(5) "QDGMM" _col(18) "ECRE"  _col(31) "QDGMMC" _col(44) "ECREC"
	noi di as text "{hline 85}"		
	foreach p of loc parms {
		noi di "`p'" _col(5) %11.4f `qdgmm_`p''  _col(18) %11.4f `ecre_`p''  _col(31) %11.4f `qdgmmC_`p''  _col(44) %11.4f `ecreC_`p''
		noi di 	     _col(5) %11.4f `qdgmm_s`p'' _col(18) %11.4f `ecre_s`p'' _col(31) %11.4f `qdgmmC_s`p'' _col(44) %11.4f `ecreC_s`p''
	}
	noi di as text "{hline 85}"
	noi di as text "{hline 85}"
	
	restore
	
} // end foreach yy of loc yvars

} // end qui
