/*  This program produces Table 2, Figure 6 */

clear all

set mem 100m
set more off

cd c:\scratch\ageeffects\forJAE\forJAErespository
use resultbb_1.dta, clear

drop if appyear < 1975
drop if appyear==2002

generate agenew=appyearc-gyear
drop if appyearc<gyear

drop if agenew>17

generate gr_app=gyear-appyear

drop if gr_app>3

for new cat1-cat6: gen byte X=0
for var cat1-cat6 \ num 1/6: replace X=1 if cat==Y

gen cata1=cat1
gen cata2=cat2
gen cata3=cat3
gen cata4=cat4
gen cata5=cat5
gen cata6=cat6

/*so now, 1=Chemical, 2=Communication/Computer; 3=Drugs and Medical; 4=Eectricity; 5=Manufacturing; 6=Other*/

set matsize 300

xi: poisson ncites cat1-cat5 i.appyear i.appyearc i.agenew [fweight=_freq_] if gr_app<3, robust 

forvalues i = 1976 (1) 1999 {
replace _Iappyear_`i'=0
}

forvalues i = 1976 (1) 1999 {
replace _Iappyearc_`i'=0
}

forvalues i = 1 (1) 5 {
replace cat`i'=0
}

/*
replace  _Iappyear_1990=1
replace  _Iappyearc_1990=1
replace cat2=1
*/

/*expected citations*/
predict nciteshat012, n



xi: poisson ncites cata1-cata5 i.appyear i.appyearc i.agenew [fweight=_freq_] if gr_app<4, robust

forvalues i = 1976 (1) 1999 {
replace _Iappyear_`i'=0
}

forvalues i = 1976 (1) 1999 {
replace _Iappyearc_`i'=0
}

forvalues i = 1 (1) 5 {
replace cata`i'=0
}

/*
replace  _Iappyear_1990=1
replace  _Iappyearc_1990=1
replace cata2=1
*/

/*expected citations*/
predict nciteshat0123, n

/* predict nciteshat0123, xb */


collapse nciteshat0123 nciteshat012, by (agenew)

label var nciteshat012 "Cited Patents with a Grant-Application Lag of Two Years or Less"
label var nciteshat0123 "With a Grant-Application Lag of Three Years or Less"


twoway line nciteshat012 nciteshat0123 agenew, xtitle("Years Since Grant Year") ytitle("Citations Received") legend( label(1 "Patents with a Grant Lag" "of Two Years or Less") label(2 "With a Grant Lag" "of Three Years or Less") cols(2))
graph export AGE0123C.eps, replace

egen sumcites012=sum(nciteshat012)
gen pdf012=nciteshat012/sumcites012

egen sumcites0123=sum(nciteshat0123)
gen pdf0123=nciteshat0123/sumcites0123

set scheme s1mono
twoway line pdf012 pdf0123 agenew, xtitle("Years Since Grant Year") ytitle("Proportion of Total Citations Received") legend( label(1 "Patents with a Grant Lag" "of Two Years or Less") label(2 "With a Grant Lag" "of Three Years or Less") cols(2))

graph export AGE0123pdfC.eps, replace

