/*results in paper: Table 1, Figure 5 */


clear all

cd c:\scratch\ageeffects\forJAE\forJAErepository


capture log close
log using out.txt, replace text
set mem 500m
set more off

use "C:\scratch\ageeffects\forJAE\forJAErepository\resultbb.dta", clear

drop if appyear < 1975
drop if appyear==2002

generate agenew=appyearc-gyear
drop if appyearc<gyear

drop if agenew>17

generate gr_app=gyear-appyear
drop if gr_app>5

recode subcat (min/19=1) (21/25=2) (31/39=3) (41/49=4) (51/59=5) (60/max=6), gen(cat) 


collapse (sum) _freq_, by(appyear appyearc agenew cat ncites)


for new cat1-cat6: gen byte X=0
for var cat1-cat6 \ num 1/6: replace X=1 if cat==Y


set matsize 300

xi: poisson ncites i.appyear i.appyearc cat1-cat5 i.agenew [fweight=_freq_], robust


forvalues i = 1976 (1) 2001 {
replace _Iappyear_`i'=0
}

forvalues i = 1976 (1) 2002 {
replace _Iappyearc_`i'=0
}

forvalues i=1(1)5{
replace cat`i'=0
}

replace  _Iappyear_1990=1
replace  _Iappyearc_1990=1

predict nciteshat, n
collapse nciteshat, by (agenew)

egen sumcites = sum(nciteshat)
replace nciteshat=nciteshat/sumcites


save result1, replace

clear all
set mem 500m
set more off

cd c:\scratch\ageeffects\forJAE\forJAErepository
use "C:\scratch\ageeffects\forJAE\forJAErepository\resultbb.dta", clear

drop if appyear < 1975
drop if appyear==2002

generate agenew=appyearc-gyear
drop if appyearc<gyear-2

drop if agenew>17

generate gr_app=gyear-appyear
drop if gr_app>5

recode subcat (min/19=1) (21/25=2) (31/39=3) (41/49=4) (51/59=5) (60/max=6), gen(cat) 


collapse (sum) _freq_, by(appyear appyearc agenew cat ncites)


for new cat1-cat6: gen byte X=0
for var cat1-cat6 \ num 1/6: replace X=1 if cat==Y


set matsize 300

xi: poisson ncites i.appyear i.appyearc cat1-cat5 i.agenew [fweight=_freq_], robust


forvalues i = 1976 (1) 2001 {
replace _Iappyear_`i'=0
}

forvalues i = 1976 (1) 2002 {
replace _Iappyearc_`i'=0
}

forvalues i=1(1)5{
replace cat`i'=0
}

replace  _Iappyear_1990=1
replace  _Iappyearc_1990=1

predict nciteshat, n
collapse nciteshat, by (agenew)

egen sumcites = sum(nciteshat)
g  nciteshat2=nciteshat/sumcites
keep nciteshat2 age
merge age using result1

label var nciteshat "Estimated with ages 0 to 17"
label var nciteshat2 "With ages -2 to 17"




set scheme s1mono

twoway line nciteshat nciteshat2 age, xtitle("Years Since Grant  Year") ytitle("Citations Received") 

graph export figure5.eps, replace



log close


