/*results in paper: Table 3, Figure 7*/

clear all
capture log close
log using out.txt, replace text
set mem 500m
set more off


use "C:\scratch\ageeffects\jhtreplication\resultbb.dta", clear

drop if appyear < 1975
drop if appyear==2002

generate agenew=appyearc-gyear
drop if appyearc<gyear

drop if agenew>17

generate gr_app=gyear-appyear
drop if gr_app>5

recode subcat (min/19=1) (21/25=2) (31/39=3) (41/49=4) (51/59=5) (60/max=6), gen(cat)


collapse (sum) _freq_, by(appyear appyearc agenew cat ncites)


for new cat1-cat6: gen byte X=0
for var cat1-cat6 \ num 1/6: replace X=1 if cat==Y


set matsize 300

xi: poisson ncites i.appyear i.appyearc i.cat*i.agenew [fweight=_freq_], robust


forvalues i = 1976 (1) 2001 {
replace _Iappyear_`i'=0
}

forvalues i = 1976 (1) 2002 {
replace _Iappyearc_`i'=0
}

replace  _Iappyear_1990=1
replace  _Iappyearc_1990=1

predict nciteshat, n
collapse nciteshat, by (agenew cat)

forvalues i= 1(1)6 {
gen nciteshatC`i'=.
replace nciteshatC`i'=nciteshat if cat==`i'
}

forvalues i=1(1)6 {
egen sumcitesC`i'=sum(nciteshatC`i')
replace nciteshatC`i'=nciteshatC`i'/sumcitesC`i'
}

/*
twoway line nciteshatC1 nciteshatC2 nciteshatC3 nciteshatC4 nciteshatC5 nciteshatC6 age
graph export AGE_CAT.eps, replace
*/

collapse nciteshatC1-nciteshatC6, by(agenew)

label var nciteshatC1 "Chemicals"
label var nciteshatC2 "Communication/Computer"
label var nciteshatC3 "Drugs and Medical"
label var nciteshatC4 "Electricity"
label var nciteshatC5 "Mechanical"
label var nciteshatC5 "Other"



set scheme s1mono
 twoway line nciteshatC1-nciteshatC6  age, xtitle("Years After Grant") ytitle("PDF of Citation Age") 

graph export AGE_CAT.eps, replace



log close


