/*results in paper: Figure 3 and Figure 4 -- Effects of Age(since application) for different grant lags */

clear all
capture log close
log using out.txt, replace text
set mem 500m
set more off

cd c:\scratch\ageeffects\forJAE\forJAErepository
use "C:\scratch\ageeffects\forJAE\forJAErepository\resultbb.dta", clear


drop if appyear < 1975

g age = appyearc-appyear
generate agenew=appyearc-gyear


drop if age>17

generate gr_app=gyear-appyear
drop if gr_app>5

recode subcat (min/19=1) (21/25=2) (31/39=3) (41/49=4) (51/59=5) (60/max=6), gen(cat)

collapse (sum) _freq_, by(appyear appyearc age gr_app ncites)

describe

replace age = age+1
g agelag1 = age*(gr_app==1)
g agelag2 = age*(gr_app==2)
g agelag3 = age*(gr_app==3)
g agelag4 = age*(gr_app==4)
g agelag5 = age*(gr_app==5)



set matsize 300

xi: poisson ncites i.appyear i.appyearc i.agelag1 i.agelag2 i.agelag3 i.agelag4 i.agelag5  [fweight=_freq_], robust


forvalues i = 1976 (1) 2002 {
replace _Iappyear_`i'=0
}

forvalues i = 1976 (1) 2002 {
replace _Iappyearc_`i'=0
}

replace  _Iappyear_1990=1
replace  _Iappyearc_1990=1

predict nciteshat, n
collapse nciteshat, by (gr_app age)

replace nciteshat = . if age==0

forvalues i= 1(1)5 {
gen nciteshatC`i'=.
replace nciteshatC`i'=nciteshat if gr_app==`i'
}

/* For Figure 4: */

forvalues i= 1(1)5 {
gen ncitesAdjC`i'= nciteshatC`i'
replace ncitesAdjC`i' = . if age>13+`i'
replace ncitesAdjC`i' = . if age<`i'+1
}



forvalues i=1(1)5 {
egen sumcitesC`i'=sum(nciteshatC`i')
egen sumcitesA`i'=sum(ncitesAdjC`i')
replace nciteshatC`i'=nciteshatC`i'/sumcitesC`i' 
replace ncitesAdjC`i'=ncitesAdjC`i'/sumcitesA`i' 

}

collapse nciteshatC1-nciteshatC5 ncitesAdjC1-ncitesAdjC5, by(age)

replace age = age -1

label var nciteshatC1 "1 Year Lag"
label var nciteshatC2 "2 Year Lag"
label var nciteshatC3 "3 Year Lag"
label var nciteshatC4 "4 Year Lag"
label var nciteshatC5 "5 Year Lag"

label var ncitesAdjC1 "1 Year Lag"
label var ncitesAdjC2 "2 Year Lag"
label var ncitesAdjC3 "3 Year Lag"
label var ncitesAdjC4 "4 Year Lag"
label var ncitesAdjC5 "5 Year Lag"


set scheme s1mono
 twoway line nciteshatC1-nciteshatC5  age, xtitle("Years Since Application  Year") ytitle("Proportion of Total Citations Received") 

graph export Figure3.eps, replace


 twoway line ncitesAdjC1-ncitesAdjC5  age, xtitle("Years Since Application  Year") ytitle("Proportion of Total Citations Received") 
graph export Figure4.eps, replace


log close


