/*results in paper: Figure 8.  The Excel file "changes over time.xls" uses the variables nciteshatX to create Table 4 */

clear all

cd c:\scratch\ageeffects\forJAE\forJAErepository

capture log close
log using out.txt, replace text
set mem 500m
set more off


use "C:\scratch\ageeffects\forJAE\forJAErepository\resultbb.dta", clear


drop if appyear < 1975

/* drop if appyear > 1999 */

generate agenew=appyearc-gyear
drop if appyearc<gyear

drop if agenew>17

generate gr_app=gyear-appyear
drop if gr_app>5

recode subcat (min/19=1) (21/25=2) (31/39=3) (41/49=4) (51/59=5) (60/max=6), gen(cat)

g ayDum = int((appyear - 1975)/5)+1

replace ayDum = 5 if ayDum == 6

collapse (sum) _freq_, by(appyear appyearc agenew ayDum ncites)

describe


set matsize 300

xi: poisson ncites i.appyear i.appyearc i.ayDum*i.agenew [fweight=_freq_], robust


forvalues i = 1976 (1) 1999 {
replace _Iappyear_`i'=0
}

forvalues i = 1976 (1) 2002 {
replace _Iappyearc_`i'=0
}

replace  _Iappyear_1990=1
replace  _Iappyearc_1990=1

predict nciteshat, n
collapse nciteshat, by (agenew ayDum)

forvalues i= 1(1)5 {
gen nciteshatC`i'=.
replace nciteshatC`i'=nciteshat if ayDum==`i'
}



forvalues i=1(1)5 {
egen sumcitesC`i'=sum(nciteshatC`i')
replace nciteshatC`i'=nciteshatC`i'/sumcitesC`i'
}

collapse nciteshatC1-nciteshatC5, by(agenew)

label var nciteshatC1 "1975-1979"
label var nciteshatC2 "1980-1984"
label var nciteshatC3 "1985-1989"
label var nciteshatC4 "1990-1994"
label var nciteshatC5 "1995-1999"


set scheme s1mono
 twoway line nciteshatC1-nciteshatC5  age, xtitle("Years After Grant") ytitle("PDF of Citation Age") 

graph export AGE_Time.eps, replace



log close


