#include "unif01.h"
#include "ulcg.h"
#include "bbattery.h"
#include <stddef.h>

/* This produces the same output as the R RNG
> set.seed(123457,kind="Wich")
> wich.seed <- .Random.seed
> runif(10)
 [1] 0.731878898 0.753605431 0.005152772 0.634226970 0.647656742 0.657821886
 [7] 0.938788428 0.761084604 0.779370955 0.643913599
> wich.seed
[1]     0 26656  2092  3794
> 
*/

int main (void)
{
  int i;
   unif01_Gen *gen1, *gen2, *gen3, *gen4;
   gen1 = ulcg_CreateLCG (30269,171, 0, 26656);
   gen2 = ulcg_CreateLCG (30307,172, 0, 2092);
   gen3 = ulcg_CreateLCG (30323,170, 0, 3794);
   gen4 = unif01_CreateCombAdd3 (gen1, gen2, gen3, "Wichmann-Hill");
    for (i = 0; i < 10; i++) 
      printf ("%18.16f\n", unif01_StripD (gen4, 0));
   bbattery_SmallCrush (gen4);
   unif01_DeleteCombGen (gen4);
   ulcg_DeleteGen (gen1);
   ulcg_DeleteGen (gen2);
   ulcg_DeleteGen (gen3);
   return 0;
}
