#include "multicarry.h"
#include "unif01.h"
#include "util.h"
#include "addstr.h"
#include <string.h>

/* This produces the same output as the R RNG
> set.seed(123457, kind = "Marsag")
> marsag.seed <- .Random.seed
> runif(10)
 [1] 0.57358579 0.06585771 0.98855517 0.39641843 0.36798657 0.11162489
 [7] 0.61498899 0.07283586 0.80658286 0.48194005
> marsag.seed
[1]          1 1012585244 -997230227
*/
typedef struct{
   unsigned long I1, I2;
} MultiCarry_state;

static unsigned long MultiCarry_Bits (void *par, void *sta)
{
   MultiCarry_state *state = sta;
   state->I1 = 36969 * (state->I1 & 0177777) + ((state->I1 >> 16) & 0177777);
   state->I2 = 18000 * (state->I2 & 0177777) + ((state->I2 >> 16) & 0177777);
   return (state->I1 << 16) ^ (state->I2 & 0177777);
}

static double MultiCarry_U01 (void *par, void *sta)
{
   return MultiCarry_Bits (par, sta) * 2.328306437080797e-10;
}

static void WrMultiCarry (void *sta)
{
   MultiCarry_state *state = sta;
   printf (" I1 = %lu,   I2 = %lu\n", state->I1, state->I2);
}

unif01_Gen *CreateMultiCarry (unsigned long I1, unsigned long I2)
{
   unif01_Gen *gen;
   MultiCarry_state *state;
   size_t leng;
   char name[60];

   gen = util_Malloc (sizeof (unif01_Gen));
   gen->state = state = util_Malloc (sizeof (MultiCarry_state));
   state->I1 = I1;
   state->I2 = I2;
   gen->param = NULL;
   gen->Write = WrMultiCarry;
   gen->GetU01 = MultiCarry_U01;
   gen->GetBits = MultiCarry_Bits;

   strcpy (name, "CreateMultiCarry:");
   addstr_Ulong (name, "   I1 = ", I1);
   addstr_Ulong (name, ",   I2 = ", I2);
   leng = strlen (name);
   gen->name = util_Calloc (leng + 1, sizeof (char));
   strncpy (gen->name, name, leng);
   return gen;
}

void DeleteMultiCarry (unif01_Gen * gen)
{
   gen->state = util_Free (gen->state);
   gen->name = util_Free (gen->name);
   util_Free (gen);
}
