#include "unif01.h"
#include "ugfsr.h"
#include "bbattery.h"
#include <stddef.h>

/* this attempts to duplicate the Mersenne Twister from R
but the TESTU01 version only takes a single integer as
seed.  The 2002 version of the Mersenne takes a 624 vector
seed, but the 1998 version (claimed) by R produces a
624 vector seed.  I have no idea what's going on.

mersenne.crush is with seed 123457
mersenne.crush is with seed 123458
*/

int main (void)
{
  int i;
   unif01_Gen *gen;
   gen = ugfsr_CreateMT19937_98 (123457);
   for (i = 0; i < 10; i++) 
      printf ("%14.10f\n", unif01_StripD (gen, 0));
   bbattery_BigCrush (gen);
   ugfsr_DeleteGen (gen);
   return 0;
}
