function [T6,T6g,T6sg]=getT6_trivar(MSEr1,MSEr2,cond_options)
% =========================================================================
% DESCRIPTION
% This function organizes relative MSEs from the trivariate exercises into
% tables of the form of Table 6 from Marcellino, Stock, and Watson (2006).
%
% INPUTS
%   stat = set of relative MSEs to be organized
%   cond_options = set of conditioning options
%
% OUTPUTS
%   T6 = main results in format of Table 6 from MSW 2006
%   T6g = results from subset of forecasts separated by the group of series
%         being predicted in the format of Table 6 from MSW 2006
%
% =========================================================================

% Check that MSEr1 and MSEr2 are the same size
assert(sum(size(MSEr1)~=size(MSEr2))==0);

% Check that MSEr has right number of dimensions
assert(length(size(MSEr1))==8);



% Get desired dimensions
[~,H,L,C,K,N1,N2,N3]=size(MSEr1);

% Best MSE
MSE_all=MSEr1;
MSE_all(:,:,:,:,:,:,:,:,2)=MSEr2;
best=MSE_all==repmat(min(min(MSE_all,[],3),[],9),1,1,L,1,1,1,1,1,2);


% Preallocate memory for T6
T6=NaN(3*H,2*(L+1),C);
T6g=NaN(3*H,2*(L+1),C,K/2);

for h_idx=1:H
    for c=1:C
        
        % Main results
        if strcmp(cond_options{c},'last1') || strcmp(cond_options{c},'full1')
            K2=K;
        else
            K2=K/2;
        end
        
        for l=1:L
            MSEr1_i=MSEr1(1,h_idx,l,c,1:K2,:,:,:);
            MSEr1_i_col=MSEr1_i(:);
            
            assert(sum(isnan(MSEr1_i_col))==0);
            
            nbest1=sum(sum(sum(sum(sum(best(:,h_idx,l,c,1:K2,:,:,:,1),1),5),6),7),8);
            fracbest1=nbest1/(K2*N1*N2*N3);

            T6(1+(h_idx-1)*3,l,c)=mean(MSEr1_i_col);
            T6(2+(h_idx-1)*3,l,c)=median(MSEr1_i_col);
            T6(3+(h_idx-1)*3,l,c)=fracbest1;

            MSEr2_i=MSEr2(1,h_idx,l,c,1:K2,:,:,:);
            MSEr2_i_col=MSEr2_i(:);
            
            assert(sum(isnan(MSEr2_i_col))==0);
            
            nbest2=sum(sum(sum(sum(sum(best(:,h_idx,l,c,1:K2,:,:,:,2),1),5),6),7),8);
            fracbest2=nbest2/(K2*N1*N2*N3);

            T6(1+(h_idx-1)*3,l+L+1,c)=mean(MSEr2_i_col);
            T6(2+(h_idx-1)*3,l+L+1,c)=median(MSEr2_i_col);
            T6(3+(h_idx-1)*3,l+L+1,c)=fracbest2;

        end
        T6(3+(h_idx-1)*3,L+1,c)=sum(T6(3+(h_idx-1)*3,1:L,c));
        T6(3+(h_idx-1)*3,2*L+2,c)=sum(T6(3+(h_idx-1)*3,(L+2):(2*L+1),c));

        
        % Group results
        for k=1:(K/2)
            if strcmp(cond_options{c},'last1') || strcmp(cond_options{c},'full1')
                k_idx=[k,(K/2)+k];
            else
                k_idx=k;
            end
            
            for l=1:L
                MSEr1_ik=MSEr1(1,h_idx,l,c,k_idx,:,:,:);
                MSEr1_ik_col=MSEr1_ik(:);

                MSEr2_ik=MSEr2(1,h_idx,l,c,k_idx,:,:,:);
                MSEr2_ik_col=MSEr2_ik(:);

                nbest1=sum(sum(sum(sum(sum(best(:,h_idx,l,c,k_idx,:,:,:,1),1),5),6),7),8);
                nbest2=sum(sum(sum(sum(sum(best(:,h_idx,l,c,k_idx,:,:,:,2),1),5),6),7),8);

                fracbest1=nbest1/(length(k_idx)*N1*N2*N3);
                fracbest2=nbest2/(length(k_idx)*N1*N2*N3);

                T6g(1+(h_idx-1)*3,l,c,k)=mean(MSEr1_ik_col);
                T6g(2+(h_idx-1)*3,l,c,k)=median(MSEr1_ik_col);
                T6g(3+(h_idx-1)*3,l,c,k)=fracbest1;

                T6g(1+(h_idx-1)*3,l+L+1,c,k)=mean(MSEr2_ik_col);
                T6g(2+(h_idx-1)*3,l+L+1,c,k)=median(MSEr2_ik_col);
                T6g(3+(h_idx-1)*3,l+L+1,c,k)=fracbest2;

            end
            T6g(3+(h_idx-1)*3,L+1,c,k)=sum(T6g(3+(h_idx-1)*3,1:L,c,k));
            T6g(3+(h_idx-1)*3,2*L+2,c,k)=sum(T6g(3+(h_idx-1)*3,(L+2):(2*L+1),c,k));   
        
        end
        
        
    end
end
        
end

        
        
        
 







