function [T5,T5g]=getT5_trivar(stat,cond_options)
% =========================================================================
% DESCRIPTION
% This function organizes relative MSEs from the trivariate exercises into
% tables of the form of Table 5 from Marcellino, Stock, and Watson (2006).
%
% INPUTS
%   stat = set of relative MSEs to be organized
%   cond_options = set of conditioning options
%
% OUTPUTS
%   T5 = main results in format of Table 5 from MSW 2006
%   T5g = results from subset of forecasts separated by the group of series
%         being predicted in the format of Table 5 from MSW 2006
%
% =========================================================================

% Check dimension of stat
assert(length(size(stat))==8);

% Get desired dimensions
[~,H,L,C,K,~,~,~]=size(stat);

% Preallocate memory for table 
T5=NaN(6*L,H,C);
T5g=NaN(6*L,H,C,K/2);

% Create table 5
for l=1:L
    for h_idx=1:H
        for c=1:C
            
            % Main results
            if strcmp(cond_options{c},'last1') || strcmp(cond_options{c},'full1')
                MSEr_i=stat(1,h_idx,l,c,1:K,:,:,:);
            else
                MSEr_i=stat(1,h_idx,l,c,1:(K/2),:,:,:);
            end
              
            % Check that there are no missing values
            assert(sum(sum(sum(sum(isnan(MSEr_i)))))==0);
           
            % Vectorize
            MSEr_i_col=MSEr_i(:);
        
            % Fill in table for given lag structure, horizon, and conditioning
            % exercise
            T5((1+(l-1)*6):(l*6),h_idx,c)=[mean(MSEr_i_col);prctile(MSEr_i_col,[10,25,50,75,90])'];
            
            % Group results
            for k=1:(K/2)
                if strcmp(cond_options{c},'last1') || strcmp(cond_options{c},'full1')
                    MSEr_ik=stat(1,h_idx,l,c,[k,k+(K/2)],:,:,:);
                else
                    MSEr_ik=stat(1,h_idx,l,c,k,:,:,:);
                end
                
                % Check that there are no missing values
                assert(sum(sum(sum(sum(isnan(MSEr_ik)))))==0);     
                
                % Vectorize
                MSEr_ik_col=MSEr_ik(:);
                
                % Fill in table for given lag structure, horizon, conditioning
                % exercise, and group of series being predicted
                T5g((1+(l-1)*6):(l*6),h_idx,c,k)=[mean(MSEr_ik_col);prctile(MSEr_ik_col,[10,25,50,75,90])'];
            end
            
            
        end
    end
end


