function [T5,T5g]=getT5_largevar(stat,cond_options,sys)
% =========================================================================
% DESCRIPTION
% This function organizes relative MSEs from the larger system exercises
% into tables of the form of Table 5 from Marcellino, Stock, and Watson
% (2006), but just with the mean and median relative MSEs, not the other
% percentiles.
%
% INPUTS
%   stat = set of relative MSEs to be organized
%   cond_options = set of conditioning options
%   sys = systems
%
% OUTPUTS
%   T5 = main results in format of Table 5 from MSW 2006
%   T5g = results from subset of forecasts separated by the group of series
%         being predicted in the format of Table 5 from MSW 2006
%
% =========================================================================
% Check that MSEr has right number of dimensions
assert(length(size(stat))==5 || length(size(stat))==6);


% Get desired dimensions
[~,H,L,C,K,Nsys]=size(stat);

% Number of total variables
N=max(max(sys));

% Preallocate memory for table 5
T5=NaN(2*L,H,C);
T5g=NaN(2*L,H,C,N);



% Create table 5
for l=1:L
    for h_idx=1:H
        for c=1:C
            
            assert(strcmp(cond_options{c},'none'));
            
            % Main results
            MSEr_i=stat(1,h_idx,l,c,:,:);
            assert(sum(sum(sum(sum(isnan(MSEr_i)))))==0);
            MSEr_i_col=MSEr_i(:);
            T5((1+(l-1)*2):(l*2),h_idx,c)=[mean(MSEr_i_col);median(MSEr_i_col)];
            
            % Individual variable results
            for n=1:N
                
                keep_n=zeros(size(MSEr_i));
                for k=1:K
                    for ns=1:Nsys
                        if sys(ns,k)==n
                            keep_n(:,:,:,:,k,ns)=1;
                        end
                    end
                end
                
                MSEr_in=MSEr_i(keep_n==1);
               
                assert(sum(sum(sum(sum(isnan(MSEr_in)))))==0);     
                
                MSEr_in_col=MSEr_in(:);
                
                T5g((1+(l-1)*2):(l*2),h_idx,c,n)=[mean(MSEr_in_col);median(MSEr_in_col)];
            end
            
          
        end
    end
end


