function dates2=eom(dates)
% =========================================================================
% DESCRIPTION
% This function takes a set of dates and returns the date at the end of the
% month of each date.
%
% =========================================================================
% FUNCTION

% Put dates into date number format
dates=datenum(dates);

% Checks
assert(size(dates,2)==1);
assert(size(dates,1)>=size(dates,2));

% Put dates into date vector format
dv=datevec(dates);

% Get year, month, and last day of the month for each date
Y=dv(:,1);
M=dv(:,2);
D=eomday(Y,M);

% Put end-of-month dates into date number format
dates2=datenum(Y,M,D);
