// This program produces the output that goes into Tables 1 and 2 of the paper

// *.out files need to be supplied coming from the Montecarlo simulation program
// with this files containing all the markov-switching smoother estimates for each replication 
// Hence the number of columns per record in such *.out files quite large (117+96)
// Please note that separate *.out files have to be supplied in order to get results for
// seasonal and nonseasonal gdp. 

cls;

ncols = 117+96;
load dato[]=mcarlo.out; 
dato = reshape(dato,rows(dato)/ncols,ncols);

//par={0.7,0.9,1.1,1.3,1.5,2};
par={2,1.5,1.3,1.1,0.9,0.7};
npar=rows(par);

qpsexp=zeros(npar,2);
qpsrec=zeros(npar,2);
rmeanexp=zeros(npar,2);
rmeanrec=zeros(npar,2);
rdurexp=zeros(npar,2);
rdurrec=zeros(npar,2);

for i (1,npar,1);
    // From the *.out files, select the data for the replications under seasonal adjustment vs those under no seasonal adjustment 
    fil=selif(dato,dato[.,2].eq 1 .and dato[.,3].eq par[i] .and dato[.,12] .ge 0.01);
    nfil=selif(dato,dato[.,2].eq 0 .and dato[.,3].eq par[i] .and dato[.,12] .ge 0.01);
    //Compute the medians
    medfil=median(fil);
    mednfil=median(nfil);
    //And fill output matrices
    qpsexp[i,1]=medfil[10];
    qpsexp[i,2]=mednfil[10];
    qpsrec[i,1]=medfil[11];
    qpsrec[i,2]=mednfil[11];
    rmeanexp[i,1]=medfil[4];
    rmeanexp[i,2]=mednfil[4];
    rmeanrec[i,1]=medfil[5];
    rmeanrec[i,2]=mednfil[5];
    rdurexp[i,1]=1/(1-medfil[6]);
    rdurexp[i,2]=1/(1-mednfil[6]);
    rdurrec[i,1]=1/(1-medfil[7]);
    rdurrec[i,2]=1/(1-mednfil[7]);
endfor;

clear dato,fil,nfil,medfil,mednfil; // Memory management

//Finally print the output
lowm=-ones(npar,1)*0.5;
tab1=(par~qpsexp)|(par~qpsrec);
tab2=(par~rmeanexp~rdurexp)|(lowm~rmeanrec~rdurrec);
output file = tab1.out;
output on;
tab1;
output off;
output file = tab2.out;
output on;
tab2;
output off;
