cls;

library maxlik;

seasdgp=1; //This switch controls for the presence of seasonality in the dgp
output file = mcarlo.out; //This is the file where output is appended

p11=.90;  //Probability of remaining in an expansionary regime
p22=.65;  //Probability of remaining in an contractory regime

deltamin = 1-0.9; deltamax = 3.4-0.9;// Parameters controling behaviour of grid search of initial values when this is needed
deltagrid = 0.2;

maxrep = 10000; //Number of replications to be performed
nobs=160;       //Sample size of each replication, prior to X-11 filtering 

ssize = 100;    // Available observations after X-11 filtering

clearg fdata, beta0, swd, nvars,vei,terms,nstat;
closeall;

erg=(1-p22)/(2-p11-p22);
nu2=-0.5; // Mean under lower regime 

rep =0;
do while rep<maxrep; rep = rep+1;
result=-100*ones(11,3);

"********* REPLICATION #"$+ftostrC(rep,"%.0lf")$+" *********";

//THIS SECTION CONTROLS THE FORM OF ARTIFICIAL SEASNOALITY
/*First we generate a noise with variance equal to that of the pseudo-innovations
to the seasonal component coming from TRAMO output*/
w=rndn(nobs,1)*0.0007069; 
ma=w;
/*Impose MA(3) structure using as parameters those coming from the estimation of the
unobservable component in TRAMO*/
ma[2]=ma[2]+1.2826*w[1];
ma[3]=ma[3]+1.2826*w[2]+0.7068*w[1];
for t (4,nobs,1);
    ma[t]=ma[t]+1.2826*w[t-1]+0.7068*w[t-2]-0.1980*w[t-3];
endfor;
/*Set the starting values equal to the log of the first four seasonal factors divided by 100*/
e=zeros(nobs,1);
e[1]=0.0471958140119;
e[2]=-0.0322811859881;
e[3]=-0.0115331859881;
e[4]=-0.00486618598809;
/*Get the simulated seasonal factors*/
for t (5,nobs,1);
    e[t]=ma[t]-e[t-1]-e[t-2]-e[t-3];
endfor;
/*Now get the first difference of the simulated seasonal factors*/
ee=zeros(nobs,1);
ee[1]=0;
for t (2,nobs,1);
    ee[t]=e[t]-e[t-1];
endfor;

u=rndu(nobs,1);
s=ones(nobs,1)*1;

//Simulate the Markov switching process
s[1]=u[1]>(1-erg);
it=1;

do while it<nobs;
   it=it+1;
   if s[it-1]==0;
   s[it]=0*(u[it]<p22)+(1-(u[it]<p22))*1;
   else;
   s[it]=1*(u[it]<p11)+(1-(u[it]<p11))*0;
   endif;
endo;

ssave = s;

nu1x = {0.7, 0.9, 1.1, 1.3, 1.5, 2.0}; 


par =0;
do while par<6;  @set <6 to generate all dgp parameters as in the paper @
par = par+1;

s = ssave;

ww=rndn(nobs,1);

if seasdgp==1;
    /*This dgp has seasonality. The seasonal factor enteres multiplied by 100 because nu2 and nu1x are in percentage terms*/
    y = nu1x[par]*s+nu2*(1-s)+100*ee+ww;
else;
    /*This dgp has no seasonality*/
    y = nu1x[par]*s+nu2*(1-s)+ww;
endif;


ynf = y;



@ ********* Estimating   ************* @

fil=-1; do while fil<1;
fil=fil+1;

if FIL==1;
/*Apply X11*/
y=x11(ynf); S = SSAVE;
s=s[30:129];
else;
/*Remove seasonality by dummies*/
dummies = 1|0|0|0;
j = 1;
do until j > (rows(y)/4)+8;
    dummies = dummies|1|0|0|0;
    j = j+1;  
endo;
@Mean -deviation dummies@
dummies = dummies-lagn(dummies,3)~lagn(dummies,1)-lagn(dummies,3)~lagn(dummies,2)-lagn(dummies,3);
dummies = dummies[4:rows(dummies),.];
dummies = dummies[1:rows(y),.];
xx = ones(rows(y),1)~dummies ;

beta = invpd(xx'*xx)*(xx'*y);
y = ynf-xx*beta+beta[1];

s = ssave;
s=s[30:129];
y=y[30:129];
endif;




// Setting up parameters to call BOC_Markov_Switch.g (Bank of Canada Markov-Switching routines) 
vei={5,5,1,1};  sameness=3; ix=0; iy = 0; lost = 4;
y1=lag(y); y2=lag(y1); y3=lag(y2); y4=lag(y3);

swd = y~ones(ssize,1)~y1~y2~y3~y4~ones(ssize,1);
swd=swd[5:rows(swd),.];
s=s[5:rows(s),.]; nstat=2;
{terms}=mkvstart2(swd,vei,nstat);
nrows=rows(swd);


screen off;


bx = nu1x[par]~0~0~0~0~nu2~incdfn(0.9)~incdfn(0.65)~1 ;
beta0=bx';
x=beta0;

//Settings for the MAXLIK proc
__output = 0; _mlmtime = 90;
__row=0;  _mlalgr=2;   _mlstep=2;   _mlcovp=1;  _mlditer=20;    _mldfct=.001;
_mlstmth = "STEEP"; _mlmdmth = "BFGS-SC STEPBT"; _mlndmth = "NEWTON";
_max_GradProc=0; _max_maxIters=400;_max_MaxTime =100;_max_GradTol=1e-4;
_max_Diagnostic=0; __OUTPUT=0;



// Call Bank of Canada Markov-Switching routines 
{x,f0,g,h,retcode}=(maxlik(swd,0,&swmkv2,beta0));

// Compute Likelihhod ratio of MS model against a linear AR(4) [used to launch a grid search of initial values if needed] 
f0linear=ar4ll(y);
lr = 2*(F0*ROWS(SWD)-F0LINEAR);

result = zeros(15,10);  gridflag=0;
result[1,.]=x'~lr;

// If Likelihood ratio against the null of linearity too close to zero, we might be at local minimum //
// Therefore launch a grid search to see if we can move away from it //
if lr<0.001;
  
   lrsave = lr;
   deltax= deltamin-deltagrid;
   indx = 1;

   do while deltax<deltamax+deltagrid; deltax=deltax+deltagrid;
      indx=indx+1;
      
      beta0[1]=deltax+nu1x[par];

      _max_GradProc=0; _max_Diagnostic=miss(1,1); __OUTPUT=0;
      _max_maxIters=400;_max_MaxTime =100;_max_GradTol=1e-4;
      x = beta0;
      {x,f0,g,h,retcode}=(maxlik(swd,0,&swmkv2,beta0));

      LRNF=  2*(F0*ROWS(SWD)-F0LINEAR);

      result[indx,.]=x'~lrnf;
   endo;

   resultx = sortc(result,10);
   if resultx[15,10]>0.01; result[1,.]=resultx[15,.]; gridflag=1; endif;

endif;



x = result[1,1:9]'; lr = result[1,10];
{pkim,pa,pp}=kimsmth2(x,swd);

probr = 1-pkim;  @ prob of recession @
mrec = sumc(swd[.,1].*probr)/sumc(probr);
mexp = sumc(swd[.,1].*(1-probr))/sumc(1-probr);

cso=1-s; const=ones(rows(swd),1);
qps = (2*   (cso-(1-pkim))^2)'*const/rows(const);
qpsex = (2*   (cso-(1-pkim))^2)'*(1-cso)/((1-cso)'*const);
qpsrec = (2*   (cso-(1-pkim))^2)'*(cso)/((cso)'*const);

arfact = sumc(x[2:5]);

vfil=rep|fil|nu1x[par]|mexp|mrec|cdfn(x[7])|cdfn(x[8])|x[9]|qps|qpsex|qpsrec|lr|gridflag|X[2:5]|x[1]|x[6]|sumc(cso.eq((1-pkim).gt(0.5)))/rows(cso)|999|(1-pkim)|(cso);

h = 0.5*ones(rows(pkim),1);
okex = ((1-cso).*((pkim).>h))'*(1-cso)/((1-cso)'*const);
okrec = ((cso).*((pkim).<=h))'*(cso)/((cso)'*const);
ok = (okex*((1-cso)'*const)+okrec*((cso)'*const))/rows(const);

qpspp = (2*   (cso-(1-pp))^2)'*const/rows(const);
okex = ((1-cso).*((pp).>h))'*(1-cso)/((1-cso)'*const);
okrec = ((cso).*((pp).<=h))'*(cso)/((cso)'*const);
okpp = (okex*((1-cso)'*const)+okrec*((cso)'*const))/rows(const);

r1=x[1];r2=x[2];px=cdfn(x[3]);qx=cdfn(x[4]);
pvector = ones(1,2);
ypred=0*pkim;
ppred=0*pkim;

screen off;
output on;
outwidth 256;
vfil';
output off;
screen on;

endo; @fil @
endo;  @ next parameter config @
endo ;    @ next replication @


proc x11(x);
   local x11lead, x11lag,xlead,xlag,xsa,it;
   x11lead={.051,.041,.050,-.140,.055,.034,.029,-.097,.038,.025,.012,
   -.053,.021,.016,-.005,-.010,0.0,0.008,-.002,-.003,0,.002};

   x11lag={.002,0,-.003,-.002,.008,0,-.010,-.005,.016,.021,-.053,.012,.025,.038,
   -.097,.029,.034,.055,-.140,.05,.041,.051};


   xsa = zeros(160,1);
   it = 30;
   do while it<(130);
   xlead = x[it+1:it+22]; xlag = x[it-22:it-1];
   xsa[it]= x11lead'*xlead+x11lag'*xlag+0.856*x[it];
   it=it+1;
   endo;
   xsa=xsa[30:(129)];

   retp(xsa);
endp;


proc dif(x);
  local x1;
  x1=rotater(x',1)'; x=x-x1; x=x[2:rows(x)];
  retp(x);
endp ;


proc ar4ll(y);
  @ COMPUTE LOG-LIKELIHOOD OF LINEAR MODEL @
  @ TO COMPARE WITH MAXLIK, MULTIPLY F*ROWS(DATA) @
  local x,e,sigx,ll,b ;
  x = ONES(ROWS(Y),1)~lagn(y,1)~lagn(y,2)~lagn(y,3)~lagn(y,4);
  x = x[5:rows(x),.]; y= y[5:rows(y)];
  b=invpd(x'x)*x'y;
  e = y-x*b;
  sigx = SQRT(sumc(e'*e)/rows(e));
  ll = -(rows(e)/2)*ln(sigx^2)-(1/(2*sigx^2))*sumc(e.^2)-(rows(e)/2)*ln(2*pi);
  retp(ll);
endp;

#include BOC_Markov_Switch.prc; 
